/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.cosn.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.hadoop.fs.cosn.buffer.CosNByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.FileChannelImpl;

class CosNMappedBuffer
extends CosNByteBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(CosNMappedBuffer.class);
    private File file;
    private RandomAccessFile randomAccessFile;

    public CosNMappedBuffer(ByteBuffer byteBuffer, RandomAccessFile randomAccessFile, File file) {
        super(byteBuffer);
        this.randomAccessFile = randomAccessFile;
        this.file = file;
    }

    @Override
    protected boolean isDirect() {
        return true;
    }

    @Override
    protected boolean isMapped() {
        return true;
    }

    @Override
    public void close() throws IOException {
        IOException e = null;
        try {
            Method method = FileChannelImpl.class.getDeclaredMethod("unmap", MappedByteBuffer.class);
            method.setAccessible(true);
            method.invoke(FileChannelImpl.class, (MappedByteBuffer)this.byteBuffer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.error("Failed to get the reflect unmap method.", (Throwable)noSuchMethodException);
            e = new IOException("Failed to release the mapped buffer.", noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error("Failed to invoke the reflect unmap method.", (Throwable)invocationTargetException);
            throw new IOException("Failed to release the mapped buffer.", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("Failed to access the reflect unmap method.", (Throwable)illegalAccessException);
            throw new IOException("Failed to release the mapped buffer.", illegalAccessException);
        }
        try {
            if (null != this.randomAccessFile) {
                this.randomAccessFile.close();
            }
        }
        catch (IOException randomAccessFileClosedException) {
            LOG.error("Failed to close the random access file.", (Throwable)randomAccessFileClosedException);
            e = randomAccessFileClosedException;
        }
        if (null != this.file && this.file.exists() && !this.file.delete()) {
            LOG.warn("Failed to clean up the temporary file: [{}].", (Object)this.file);
        }
        try {
            super.close();
        }
        catch (IOException superClosedException) {
            e = superClosedException;
        }
        if (null != e) {
            throw e;
        }
    }
}

