package org.apache.hadoop.fs.auth;

import java.lang.reflect.Type;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.tencentcloudapi.common.AbstractClient;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.JsonResponseModel;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import org.apache.hadoop.fs.auth.model.DescribeLakeFsAccessRequest;
import org.apache.hadoop.fs.auth.model.DescribeLakeFsAccessResponse;
import org.apache.hadoop.fs.auth.model.LakeFileSystemToken;

public class DlcServiceClient extends AbstractClient {
    private static final String version = "2021-01-25";

    public DlcServiceClient(String endpoint, Credential credential, String region, ClientProfile profile) {
        super(endpoint, DlcServiceClient.version, credential, region, profile);
    }

    public static DlcServiceClient buildServiceClient(String endpoint, String region, Credential cred) {
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint(endpoint);
        ClientProfile clientProfile = new ClientProfile("", httpProfile);

        return new DlcServiceClient(endpoint, cred, region, clientProfile);
    }

    public DescribeLakeFsAccessResponse DescribeLakeFsAccess(DescribeLakeFsAccessRequest req) throws TencentCloudSDKException {
        JsonResponseModel<DescribeLakeFsAccessResponse> rsp = null;
        String rspStr = "";
        try {
            Type type = new TypeToken<JsonResponseModel<DescribeLakeFsAccessResponse>>() {
            }.getType();
            rspStr = this.internalRequest(req, "DescribeLakeFsAccess");
            rsp  = gson.fromJson(rspStr, type);
        } catch (JsonSyntaxException e) {
            throw new TencentCloudSDKException("response message: " + rspStr + ".\n Error message: " + e.getMessage());
        }
        return rsp.response;
    }
}
