package org.apache.hadoop.fs.auth.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tencentcloudapi.common.AbstractModel;

import java.util.HashMap;

public class DescribeLakeFsAccessRequest extends AbstractModel {
    /**
     * 请求路径
     */
    @SerializedName("FsPath")
    @Expose
    private String FsPath;

    /**
     * 有效期
     */
    @SerializedName("AvailablePeriod")
    @Expose
    private Long AvailablePeriod;

    /**
     * 请求者身份凭据
     */
    @SerializedName("Identity")
    @Expose
    private String Identity;

    public String getFsPath() {
        return FsPath;
    }

    public void setFsPath(String fsPath) {
        FsPath = fsPath;
    }

    public Long getAvailablePeriod() {
        return AvailablePeriod;
    }

    public void setAvailablePeriod(Long availablePeriod) {
        AvailablePeriod = availablePeriod;
    }

    public String getIdentity() {
        return Identity;
    }

    public void setIdentity(String identity) {
        Identity = identity;
    }

    public DescribeLakeFsAccessRequest() {
    }

    public DescribeLakeFsAccessRequest(DescribeLakeFsAccessRequest source) {
        if (source.FsPath != null) {
            this.FsPath = new String(source.FsPath);
        }
        if (source.AvailablePeriod != null) {
            this.AvailablePeriod = new Long(source.AvailablePeriod);
        }
        if (source.Identity != null) {
            this.Identity = new String(source.Identity);
        }
    }

    @Override
    protected void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "FsPath", this.FsPath);
        this.setParamSimple(map, prefix + "AvailablePeriod", this.AvailablePeriod);
        this.setParamSimple(map, prefix + "Identity", this.Identity);
    }
}
