package org.apache.hadoop.fs.auth.model;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.tencentcloudapi.common.AbstractModel;

import java.util.HashMap;

public class DescribeLakeFsAccessResponse extends AbstractModel {
    @SerializedName("AccessToken")
    @Expose
    private LakeFileSystemToken AccessToken;

    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    public LakeFileSystemToken getAccessToken() {
        return AccessToken;
    }

    public void setAccessToken(LakeFileSystemToken accessToken) {
        AccessToken = accessToken;
    }

    public String getRequestId() {
        return RequestId;
    }

    public void setRequestId(String requestId) {
        RequestId = requestId;
    }

    public DescribeLakeFsAccessResponse() {
    }

    public DescribeLakeFsAccessResponse(DescribeLakeFsAccessResponse source) {
        if (source.AccessToken != null) {
            this.AccessToken = new LakeFileSystemToken(source.AccessToken);
        }

        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }

    }

    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamObj(map, prefix + "AccessToken.", this.AccessToken);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);
    }
}
