/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.BasePutObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectBytesRequest;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.transfer.TransferTaskMetrics;
import com.tencent.cos.xml.utils.ThrowableUtils;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.track.QCloudTrackService;
import com.tencent.qcloud.track.cls.ClsLifecycleCredentialProvider;
import com.tencent.qcloud.track.service.ATrackService;
import com.tencent.qcloud.track.service.BeaconTrackService;
import com.tencent.qcloud.track.service.ClsTrackService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CosTrackService {
    private static final String TAG = "CosTrackService";
    private static final boolean IS_DEBUG = false;
    private static final String SDK_NAME = "cos";
    private static final String EVENT_CODE_QCLOUD_TRACK_COS_SDK = "qcloud_track_cos_sdk";
    private static final String EVENT_CODE_NEW_TRANSFER = "qcloud_track_cos_sdk_transfer";
    private static final String EVENT_PARAMS_SUCCESS = "Success";
    private static final String EVENT_PARAMS_FAILURE = "Failure";
    private static final String EVENT_PARAMS_SERVER = "Server";
    private static final String EVENT_PARAMS_CLIENT = "Client";
    private static CosTrackService instance;
    private String bridge;

    private CosTrackService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context applicationContext, boolean isCloseReport, String bridge) {
        Class<CosTrackService> clazz = CosTrackService.class;
        synchronized (CosTrackService.class) {
            if (instance == null) {
                instance = new CosTrackService();
                CosTrackService.instance.bridge = bridge;
                if (BeaconTrackService.isInclude()) {
                    BeaconTrackService beaconTrackService = new BeaconTrackService();
                    beaconTrackService.setContext(applicationContext);
                    beaconTrackService.init("0AND05O9HW5YY29Z");
                    QCloudTrackService.getInstance().addTrackService(EVENT_CODE_QCLOUD_TRACK_COS_SDK, (ATrackService)beaconTrackService);
                    BeaconTrackService newTransferBeaconTrackService = new BeaconTrackService();
                    newTransferBeaconTrackService.setContext(applicationContext);
                    newTransferBeaconTrackService.init("0AND05O9HW5YY29Z");
                    QCloudTrackService.getInstance().addTrackService(EVENT_CODE_NEW_TRANSFER, (ATrackService)newTransferBeaconTrackService);
                }
                QCloudTrackService.getInstance().init(applicationContext);
                QCloudTrackService.getInstance().setDebug(false);
                QCloudTrackService.getInstance().setIsCloseReport(isCloseReport);
                CosTrackService.getInstance().reportSdkStart();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void initCLs(Context applicationContext, String topicId, String endpoint, String secretId, String secretKey) {
        if (!ClsTrackService.isInclude()) {
            throw new IllegalStateException("Please quote the cls library first: com.tencentcloudapi.cls:tencentcloud-cls-sdk-android:x.x.x");
        }
        ClsTrackService clsTrackService = new ClsTrackService();
        clsTrackService.init(applicationContext, topicId, endpoint);
        clsTrackService.setSecurityCredential(secretId, secretKey);
        QCloudTrackService.getInstance().addTrackService(EVENT_CODE_QCLOUD_TRACK_COS_SDK, (ATrackService)clsTrackService);
    }

    public static void initCLs(Context applicationContext, String topicId, String endpoint, ClsLifecycleCredentialProvider lifecycleCredentialProvider) {
        if (!ClsTrackService.isInclude()) {
            throw new IllegalStateException("Please quote the cls library first: com.tencentcloudapi.cls:tencentcloud-cls-sdk-android:x.x.x");
        }
        ClsTrackService clsTrackService = new ClsTrackService();
        clsTrackService.init(applicationContext, topicId, endpoint);
        clsTrackService.setCredentialProvider(lifecycleCredentialProvider);
        QCloudTrackService.getInstance().addTrackService(EVENT_CODE_QCLOUD_TRACK_COS_SDK, (ATrackService)clsTrackService);
    }

    public static CosTrackService getInstance() {
        return instance;
    }

    public void reportSdkStart() {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put("sdk_name", SDK_NAME);
            params.putAll(this.getCommonParams());
            QCloudTrackService.getInstance().reportSimpleData("qcloud_track_sd_sdk_start", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reportError(String source, Exception e) {
        if (e == null) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            Throwable rootCause = ThrowableUtils.getRootCause(e);
            params.put("sdk_name", SDK_NAME);
            params.put("qcloud_error_source", source);
            params.put("qcloud_error_name", rootCause.getClass().getSimpleName());
            params.put("qcloud_error_message", rootCause.getMessage());
            params.putAll(this.getCommonParams());
            QCloudTrackService.getInstance().reportSimpleData("qcloud_track_sd_sdk_error", params);
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
    }

    public void reportRequestSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(request, false);
    }

    public void reportRequestSuccess(CosXmlRequest request, boolean internal) {
        Map<String, String> extra = null;
        if (request instanceof BasePutObjectRequest) {
            extra = Collections.singletonMap("request_name", "UploadTask");
        } else if (request instanceof GetObjectRequest || request instanceof GetObjectBytesRequest) {
            extra = Collections.singletonMap("request_name", "DownloadTask");
        } else if ("CopyObjectRequest".equalsIgnoreCase(request.getClass().getSimpleName())) {
            extra = Collections.singletonMap("request_name", "CopyTask");
        }
        this.reportRequestSuccess(request, extra, internal);
    }

    public CosXmlClientException reportRequestClientException(CosXmlRequest request, QCloudClientException clientException) {
        return this.reportRequestClientException(request, clientException, false);
    }

    public CosXmlClientException reportRequestClientException(CosXmlRequest request, QCloudClientException clientException, boolean internal) {
        Map<String, String> extra = null;
        if (request instanceof BasePutObjectRequest) {
            extra = Collections.singletonMap("request_name", "UploadTask");
        } else if (request instanceof GetObjectRequest || request instanceof GetObjectBytesRequest) {
            extra = Collections.singletonMap("request_name", "DownloadTask");
        } else if ("CopyObjectRequest".equalsIgnoreCase(request.getClass().getSimpleName())) {
            extra = Collections.singletonMap("request_name", "CopyTask");
        }
        return this.reportClientException(request, clientException, extra, internal);
    }

    public CosXmlServiceException reportRequestServiceException(CosXmlRequest request, QCloudServiceException serviceException) {
        return this.reportRequestServiceException(request, serviceException, false);
    }

    public CosXmlServiceException reportRequestServiceException(CosXmlRequest request, QCloudServiceException serviceException, boolean internal) {
        Map<String, String> extra = null;
        if (request instanceof BasePutObjectRequest) {
            extra = Collections.singletonMap("request_name", "UploadTask");
        } else if (request instanceof GetObjectRequest || request instanceof GetObjectBytesRequest) {
            extra = Collections.singletonMap("request_name", "DownloadTask");
        } else if ("CopyObjectRequest".equalsIgnoreCase(request.getClass().getSimpleName())) {
            extra = Collections.singletonMap("request_name", "CopyTask");
        }
        return this.reportServiceException(request, serviceException, extra, internal);
    }

    public void reportUploadTaskSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(request, Collections.singletonMap("request_name", "UploadTask"), false);
    }

    public void reportUploadTaskClientException(CosXmlRequest request, QCloudClientException clientException) {
        this.reportClientException(request, clientException, this.createTransferExtra("UploadTask", request), false);
    }

    public void reportUploadTaskServiceException(CosXmlRequest request, QCloudServiceException serviceException) {
        this.reportServiceException(request, serviceException, this.createTransferExtra("UploadTask", request), false);
    }

    public void reportDownloadTaskSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(request, Collections.singletonMap("request_name", "DownloadTask"), false);
    }

    public void reportDownloadTaskClientException(CosXmlRequest request, QCloudClientException clientException) {
        this.reportClientException(request, clientException, this.createTransferExtra("DownloadTask", request), false);
    }

    public void reportDownloadTaskServiceException(CosXmlRequest request, QCloudServiceException serviceException) {
        this.reportServiceException(request, serviceException, this.createTransferExtra("DownloadTask", request), false);
    }

    public void reportCopyTaskSuccess(CosXmlRequest request) {
        this.reportRequestSuccess(request, Collections.singletonMap("request_name", "CopyTask"), false);
    }

    public void reportCopyTaskClientException(CosXmlRequest request, CosXmlClientException clientException) {
        this.reportClientException(request, clientException, this.createTransferExtra("CopyTask", request), false);
    }

    public void reportCopyTaskServiceException(CosXmlRequest request, CosXmlServiceException serviceException) {
        this.reportServiceException(request, serviceException, this.createTransferExtra("CopyTask", request), false);
    }

    private void reportRequestSuccess(CosXmlRequest request, @Nullable Map<String, String> extra, boolean internal) {
        try {
            HttpTaskMetrics taskMetrics = request.getMetrics();
            Map<String, String> params = this.parseCosXmlRequestParams(request);
            params.putAll(this.getCommonParams());
            if (extra == null || !extra.containsKey("request_name")) {
                params.put("request_name", request.getClass().getSimpleName());
            }
            params.put("request_result", EVENT_PARAMS_SUCCESS);
            if (extra != null) {
                params.putAll(extra);
            }
            params.putAll(this.parseHttpTaskMetricsParams(taskMetrics, params.get("request_name")));
            if (!internal) {
                QCloudTrackService.getInstance().report(EVENT_CODE_QCLOUD_TRACK_COS_SDK, params);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CosXmlClientException reportClientException(CosXmlRequest request, QCloudClientException clientException, @Nullable Map<String, String> extra, boolean internal) {
        ReturnClientException returnClientException = this.getClientExceptionParams(clientException);
        try {
            if (this.isReport(returnClientException.exception)) {
                HttpTaskMetrics taskMetrics = request.getMetrics();
                Map<String, String> params = this.parseCosXmlRequestParams(request);
                params.putAll(this.getCommonParams());
                params.putAll(returnClientException.params);
                if (extra == null || !extra.containsKey("request_name")) {
                    params.put("request_name", request.getClass().getSimpleName());
                }
                params.put("request_result", EVENT_PARAMS_FAILURE);
                if (extra != null) {
                    params.putAll(extra);
                }
                params.putAll(this.parseHttpTaskMetricsParams(taskMetrics, params.get("request_name")));
                if (!internal) {
                    QCloudTrackService.getInstance().report(EVENT_CODE_QCLOUD_TRACK_COS_SDK, params);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnClientException.exception;
    }

    private CosXmlServiceException reportServiceException(CosXmlRequest request, QCloudServiceException serviceException, @Nullable Map<String, String> extra, boolean internal) {
        ReturnServiceException returnServiceException = this.getServiceExceptionParams(serviceException);
        try {
            if (this.isReport(returnServiceException.exception)) {
                Map<String, String> params = this.parseCosXmlRequestParams(request);
                params.putAll(this.getCommonParams());
                params.putAll(returnServiceException.params);
                if (extra == null || !extra.containsKey("request_name")) {
                    params.put("request_name", request.getClass().getSimpleName());
                }
                params.put("request_result", EVENT_PARAMS_FAILURE);
                if (extra != null) {
                    params.putAll(extra);
                }
                params.putAll(this.parseHttpTaskMetricsParams(request.getMetrics(), params.get("request_name")));
                if (!internal) {
                    QCloudTrackService.getInstance().report(EVENT_CODE_QCLOUD_TRACK_COS_SDK, params);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnServiceException.exception;
    }

    private Map<String, String> parseHttpTaskMetricsParams(@Nullable HttpTaskMetrics taskMetrics, String requestName) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (taskMetrics == null) {
            return params;
        }
        params.put("http_took_time", String.valueOf(taskMetrics.httpTaskFullTime()));
        params.put("http_dns", String.valueOf(taskMetrics.dnsLookupTookTime()));
        params.put("http_connect", String.valueOf(taskMetrics.connectTookTime()));
        params.put("http_secure_connect", String.valueOf(taskMetrics.secureConnectTookTime()));
        params.put("http_md5", String.valueOf(taskMetrics.calculateMD5STookTime()));
        params.put("http_sign", String.valueOf(taskMetrics.signRequestTookTime()));
        params.put("http_read_header", String.valueOf(taskMetrics.readResponseHeaderTookTime()));
        params.put("http_read_body", String.valueOf(taskMetrics.readResponseBodyTookTime()));
        params.put("http_write_header", String.valueOf(taskMetrics.writeRequestHeaderTookTime()));
        params.put("http_write_body", String.valueOf(taskMetrics.writeRequestBodyTookTime()));
        params.put("http_full_time", String.valueOf(taskMetrics.fullTaskTookTime()));
        if ("UploadTask".equalsIgnoreCase(requestName) || "CopyTask".equalsIgnoreCase(requestName)) {
            params.put("http_size", String.valueOf(taskMetrics.requestBodyByteCount()));
            params.put("http_speed", String.valueOf((double)taskMetrics.requestBodyByteCount() / 1024.0 / taskMetrics.httpTaskFullTime()));
        } else if ("DownloadTask".equalsIgnoreCase(requestName)) {
            params.put("http_size", String.valueOf(taskMetrics.responseBodyByteCount()));
            params.put("http_speed", String.valueOf((double)taskMetrics.responseBodyByteCount() / 1024.0 / taskMetrics.httpTaskFullTime()));
        } else {
            params.put("http_size", String.valueOf(taskMetrics.requestBodyByteCount() + taskMetrics.responseBodyByteCount()));
            params.put("http_speed", String.valueOf((double)(taskMetrics.requestBodyByteCount() + taskMetrics.responseBodyByteCount()) / 1024.0 / taskMetrics.httpTaskFullTime()));
        }
        params.put("http_retry_times", String.valueOf(taskMetrics.getRetryCount()));
        params.put("http_domain", taskMetrics.getDomainName() != null ? taskMetrics.getDomainName() : "null");
        params.put("http_connect_ip", taskMetrics.getConnectAddress() != null ? taskMetrics.getConnectAddress().getHostAddress() : "null");
        params.put("http_dns_ips", taskMetrics.getRemoteAddress() != null ? taskMetrics.getRemoteAddress().toString() : "null");
        return params;
    }

    private Map<String, String> parseCosXmlRequestParams(CosXmlRequest request) {
        String host;
        HashMap<String, String> params = new HashMap<String, String>();
        if (request == null) {
            return params;
        }
        params.put("bucket", request.getBucket());
        params.put("region", request.getRegion());
        if (request.getHttpTask() != null && request.getHttpTask().request() != null) {
            String ua = request.getHttpTask().request().header("User-Agent");
            String network_protocol = !TextUtils.isEmpty((CharSequence)ua) && ua.contains("android-quic-sdk") ? "quic" : request.getHttpTask().request().url().getProtocol();
            params.put("network_protocol", network_protocol);
            params.put("http_method", request.getHttpTask().request().method());
            if (request.getHttpTask().request().url() != null) {
                params.put("url", request.getHttpTask().request().url().toString());
            }
            if (!TextUtils.isEmpty((CharSequence)ua)) {
                params.put("user_agent", ua);
            }
        }
        if (request instanceof ObjectRequest && !TextUtils.isEmpty((CharSequence)((ObjectRequest)request).getCosPath())) {
            params.put("request_path", ((ObjectRequest)request).getCosPath());
        }
        if (!TextUtils.isEmpty((CharSequence)(host = this.parseHost(request)))) {
            params.put("host", host);
            try {
                String findRegion;
                Pattern pattern = Pattern.compile(".*\\.cos\\.(.*)\\.myqcloud.com");
                Matcher matcher = pattern.matcher(host);
                if (matcher.find() && !TextUtils.isEmpty((CharSequence)(findRegion = matcher.group(1))) && !"accelerate".equals(findRegion)) {
                    params.put("region", findRegion);
                }
            }
            catch (Exception pattern) {
                // empty catch block
            }
            try {
                params.put("accelerate", String.valueOf(host.endsWith("cos.accelerate.myqcloud.com")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return params;
    }

    private Map<String, String> getCommonParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sdk_version_name", "5.9.26");
        params.put("sdk_version_code", String.valueOf(50926));
        if (!TextUtils.isEmpty((CharSequence)this.bridge)) {
            params.put("sdk_bridge", this.bridge);
        }
        return params;
    }

    @Nullable
    private String parseHost(CosXmlRequest request) {
        HttpRequest httpRequest;
        HttpTask httpTask = request.getHttpTask();
        String host = null;
        if (httpTask != null && (httpRequest = httpTask.request()) != null) {
            host = httpRequest.host();
        }
        if (host == null && request.getMetrics() != null) {
            host = request.getMetrics().getDomainName();
        }
        return host;
    }

    private ReturnServiceException getServiceExceptionParams(QCloudServiceException e) {
        HashMap<String, String> params = new HashMap<String, String>();
        CosXmlServiceException serviceException = this.convertServerException(e);
        params.put("error_code", !TextUtils.isEmpty((CharSequence)serviceException.getErrorCode()) && !serviceException.getErrorCode().equals("null") ? serviceException.getErrorCode() : String.valueOf(serviceException.getStatusCode()));
        params.put("error_message", !TextUtils.isEmpty((CharSequence)serviceException.getErrorMessage()) && !serviceException.getErrorMessage().equals("null") ? serviceException.getErrorMessage() : String.valueOf(serviceException.getHttpMessage()));
        params.put("error_http_code", String.valueOf(serviceException.getStatusCode()));
        params.put("error_http_message", serviceException.getHttpMessage());
        params.put("error_service_name", serviceException.getServiceName());
        params.put("error_request_id", serviceException.getRequestId());
        params.put("error_type", EVENT_PARAMS_SERVER);
        return new ReturnServiceException(serviceException, params);
    }

    private ReturnClientException getClientExceptionParams(QCloudClientException e) {
        HashMap<String, String> params = new HashMap<String, String>();
        CosXmlClientException xmlClientException = this.convertClientException(e);
        Throwable rootCause = ThrowableUtils.getRootCause((Throwable)((Object)xmlClientException));
        params.put("error_code", String.valueOf(xmlClientException.errorCode));
        params.put("error_name", rootCause.getClass().getSimpleName());
        params.put("error_message", rootCause.getMessage());
        params.put("error_type", EVENT_PARAMS_CLIENT);
        return new ReturnClientException(xmlClientException, params);
    }

    private CosXmlServiceException convertServerException(QCloudServiceException e) {
        return e instanceof CosXmlServiceException ? (CosXmlServiceException)e : new CosXmlServiceException(e);
    }

    private CosXmlClientException convertClientException(QCloudClientException e) {
        Throwable causeException;
        CosXmlClientException xmlClientException = e instanceof CosXmlClientException ? (CosXmlClientException)e : ((causeException = ThrowableUtils.getRootCause((Throwable)e)) instanceof IllegalArgumentException ? new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), (Throwable)e) : (causeException instanceof QCloudAuthenticationException ? new CosXmlClientException(ClientErrorCode.INVALID_CREDENTIALS.getCode(), (Throwable)e) : (causeException instanceof IOException ? new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), (Throwable)e) : new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), (Throwable)e))));
        return xmlClientException;
    }

    private boolean isReport(CosXmlServiceException e) {
        return true;
    }

    private boolean isReport(CosXmlClientException e) {
        boolean notReport = e.getMessage() != null && e.getMessage().toLowerCase(Locale.ROOT).contains("canceled");
        return !notReport;
    }

    private Map<String, String> createTransferExtra(String name, CosXmlRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("request_name", name);
        params.put("error_node", request != null ? request.getClass().getSimpleName() : "null");
        return params;
    }

    public void reportTransferSuccess(CosXmlRequest request, TransferTaskMetrics taskMetrics, boolean encrypted) {
        this.reportTransferTask(request, taskMetrics, encrypted, true, null);
    }

    public void reportTransferClientException(CosXmlRequest request, TransferTaskMetrics taskMetrics, CosXmlClientException clientException, boolean encrypted) {
        if (this.isReport(clientException)) {
            this.reportTransferTask(request, taskMetrics, encrypted, false, this.parseClientExceptionParams(clientException));
        }
    }

    public void reportTransferServiceException(CosXmlRequest request, TransferTaskMetrics taskMetrics, CosXmlServiceException serviceException, boolean encrypted) {
        if (this.isReport(serviceException)) {
            this.reportTransferTask(request, taskMetrics, encrypted, false, this.parseServiceExceptionParams(serviceException));
        }
    }

    private void reportTransferTask(CosXmlRequest request, TransferTaskMetrics taskMetrics, boolean encrypted, boolean isSuccess, @Nullable Map<String, String> extras) {
        try {
            Map<String, String> params = this.parseCosXmlRequestParams(request);
            params.put("request_name", request.getClass().getSimpleName());
            params.putAll(this.getCommonParams());
            params.putAll(this.parseSimplePerfParams(taskMetrics));
            params.put("encrypted", String.valueOf(encrypted));
            params.put("request_result", isSuccess ? EVENT_PARAMS_SUCCESS : EVENT_PARAMS_FAILURE);
            if (extras != null) {
                params.putAll(extras);
            }
            QCloudTrackService.getInstance().report(EVENT_CODE_NEW_TRANSFER, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> parseSimplePerfParams(@Nullable TransferTaskMetrics taskMetrics) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (taskMetrics == null) {
            return params;
        }
        params.put("transfer_size", String.valueOf(taskMetrics.getSize()));
        params.put("ip", taskMetrics.getConnectAddress() != null ? taskMetrics.getConnectAddress().getHostAddress() : "");
        params.put("took_time", String.valueOf(taskMetrics.getTookTime()));
        params.put("wait_took_time", String.valueOf(taskMetrics.getWaitTookTime()));
        params.put("first_progress_took_time", String.valueOf(taskMetrics.getFirstProgressTookTime()));
        return params;
    }

    private Map<String, String> parseClientExceptionParams(CosXmlClientException clientException) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error_message", clientException.getMessage());
        params.put("error_code", String.valueOf(clientException.errorCode));
        params.put("error_type", EVENT_PARAMS_CLIENT);
        return params;
    }

    private Map<String, String> parseServiceExceptionParams(CosXmlServiceException serviceException) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("error_message", serviceException.getErrorMessage());
        params.put("error_code", serviceException.getErrorCode());
        params.put("request_id", serviceException.getRequestId());
        params.put("error_type", EVENT_PARAMS_SERVER);
        return params;
    }

    private static class ReturnClientException {
        private final CosXmlClientException exception;
        private final Map<String, String> params;

        public ReturnClientException(CosXmlClientException exception, Map<String, String> params) {
            this.exception = exception;
            this.params = params;
        }
    }

    private static class ReturnServiceException {
        private final CosXmlServiceException exception;
        private final Map<String, String> params;

        public ReturnServiceException(CosXmlServiceException exception, Map<String, String> params) {
            this.exception = exception;
            this.params = params;
        }
    }
}

