/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import java.net.InetAddress;

public class TransferTaskMetrics {
    String domain;
    InetAddress connectAddress;
    long size;
    private long tookTime;
    private long waitTookTime;
    private long firstProgressTookTime;
    private long startTime = 0L;
    private long progressTime = 0L;
    private long firstProgressCallbackTime = 0L;
    private long completeTime = 0L;

    void onStart() {
        this.startTime = System.nanoTime();
    }

    void onInProgress() {
        this.firstProgressCallbackTime = this.progressTime = System.nanoTime();
    }

    void onFirstProgressCallback() {
        if (this.firstProgressCallbackTime <= this.progressTime) {
            this.firstProgressCallbackTime = System.nanoTime();
        }
    }

    void onComplete() {
        this.completeTime = System.nanoTime();
        this.tookTime = this.tookTime(this.completeTime);
        this.waitTookTime = this.tookTime(this.progressTime);
        this.firstProgressTookTime = this.tookTime(this.firstProgressCallbackTime);
    }

    public String getDomain() {
        return this.domain;
    }

    public InetAddress getConnectAddress() {
        return this.connectAddress;
    }

    public long getSize() {
        return this.size;
    }

    public long getTookTime() {
        return this.tookTime;
    }

    public long getFirstProgressTookTime() {
        return this.firstProgressTookTime;
    }

    public long getWaitTookTime() {
        return this.waitTookTime;
    }

    private long tookTime(long time) {
        return Math.max(-1L, time - this.startTime) / 1000000L;
    }

    public String toString() {
        return "TransferTaskMetrics{domain='" + this.domain + '\'' + ", connectAddress=" + this.connectAddress + ", size=" + this.size + ", tookTime=" + this.tookTime + ", waitTookTime=" + this.waitTookTime + ", firstProgressTookTime=" + this.firstProgressTookTime + '}';
    }
}

