/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskExecutors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public class CosXmlServiceConfig
implements Parcelable {
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String ACCELERATE_ENDPOINT_SUFFIX = "cos.accelerate";
    public static final String DEFAULT_HOST_FORMAT = "${bucket}.cos.${region}.myqcloud.com";
    public static final String ACCELERATE_HOST_FORMAT = "${bucket}.cos.accelerate.myqcloud.com";
    public static final String PATH_STYLE_HOST_FORMAT = "cos.${region}.myqcloud.com";
    public static final String CI_HOST_FORMAT = "${bucket}.ci.${region}.myqcloud.com";
    public static final String CI_APPID_HOST_FORMAT = "${appid}.ci.${region}.myqcloud.com";
    public static final String CI_REGION_HOST_FORMAT = "ci.${region}.myqcloud.com";
    public static final String PIC_HOST_FORMAT = "${bucket}.pic.${region}.myqcloud.com";
    private final String protocol;
    private final String userAgentExtended;
    private final String region;
    private final String appid;
    private final String host;
    private final int port;
    private final String endpointSuffix;
    private final boolean isDebuggable;
    private final RetryStrategy retryStrategy;
    private final QCloudHttpRetryHandler qCloudHttpRetryHandler;
    private final int connectionTimeout;
    private final int socketTimeout;
    private final Executor executor;
    private final Executor observeExecutor;
    private final boolean isQuic;
    private List<String> prefetchHosts;
    private final Map<String, List<String>> commonHeaders;
    private final Set<String> noSignHeaders;
    private final boolean dnsCache;
    private String hostFormat = "${bucket}.cos.${region}.myqcloud.com";
    private String hostHeaderFormat = null;
    private final boolean bucketInPath;
    private final boolean accelerate;
    private final boolean signInUrl;
    private final boolean transferThreadControl;
    private final int uploadMaxThreadCount;
    private final int downloadMaxThreadCount;
    private final boolean domainSwitch;
    private final boolean verifySSLEnable;
    private final boolean redirectEnable;
    private final byte[] clientCertificateBytes;
    private final char[] clientCertificatePassword;
    private final NetworkClient customizeNetworkClient;
    public static final Parcelable.Creator<CosXmlServiceConfig> CREATOR = new Parcelable.Creator<CosXmlServiceConfig>(){

        public CosXmlServiceConfig createFromParcel(Parcel in) {
            return new CosXmlServiceConfig(in);
        }

        public CosXmlServiceConfig[] newArray(int size) {
            return new CosXmlServiceConfig[size];
        }
    };

    public CosXmlServiceConfig(Builder builder) {
        this.protocol = builder.protocol;
        this.userAgentExtended = builder.userAgentExtended;
        this.isDebuggable = builder.isDebuggable;
        this.appid = builder.appid;
        this.region = builder.region;
        this.host = builder.host;
        this.port = builder.port;
        this.endpointSuffix = builder.endpointSuffix;
        this.bucketInPath = builder.bucketInPath;
        this.commonHeaders = builder.commonHeaders;
        this.noSignHeaders = builder.noSignHeaders;
        if (TextUtils.isEmpty((CharSequence)this.hostFormat) && TextUtils.isEmpty((CharSequence)this.region) && TextUtils.isEmpty((CharSequence)this.host)) {
            throw new IllegalArgumentException("please set host or endpointSuffix or region !");
        }
        this.retryStrategy = builder.retryStrategy;
        this.qCloudHttpRetryHandler = builder.qCloudHttpRetryHandler;
        this.socketTimeout = builder.socketTimeout;
        this.connectionTimeout = builder.connectionTimeout;
        this.hostFormat = builder.hostFormat;
        this.hostHeaderFormat = builder.hostHeaderFormat;
        this.executor = builder.executor;
        this.observeExecutor = builder.observeExecutor;
        this.isQuic = builder.isQuic;
        this.accelerate = builder.accelerate;
        this.dnsCache = builder.dnsCache;
        this.signInUrl = builder.signInUrl;
        this.transferThreadControl = builder.transferThreadControl;
        this.uploadMaxThreadCount = builder.uploadMaxThreadCount;
        this.downloadMaxThreadCount = builder.downloadMaxThreadCount;
        this.domainSwitch = builder.domainSwitch;
        this.verifySSLEnable = builder.verifySSLEnable;
        this.clientCertificateBytes = builder.clientCertificateBytes;
        this.clientCertificatePassword = builder.clientCertificatePassword;
        this.redirectEnable = builder.redirectEnable;
        this.customizeNetworkClient = builder.customizeNetworkClient;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucket(String bucket) {
        return this.getBucket(bucket, this.appid);
    }

    public String getBucket(String bucket, String appid) {
        String myBucket = bucket;
        if (bucket != null && !bucket.endsWith("-" + appid) && !TextUtils.isEmpty((CharSequence)appid)) {
            myBucket = bucket + "-" + appid;
        }
        return myBucket;
    }

    public Set<String> getNoSignHeaders() {
        return this.noSignHeaders;
    }

    public String getAppid() {
        return this.appid;
    }

    public String getRequestHost(String bucket, boolean accelerate) {
        return this.getRequestHost(null, bucket, accelerate);
    }

    public String getRequestHost(String region, String bucket, boolean accelerate) {
        accelerate = accelerate || this.accelerate;
        boolean pathStyle = this.bucketInPath;
        return this.getRequestHost(region, bucket, this.getHostFormat(accelerate, pathStyle));
    }

    public String getRequestHost(String region, String bucket, String hostFormat) {
        if (!TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        region = TextUtils.isEmpty((CharSequence)region) ? this.region : region;
        bucket = this.getBucket(bucket, this.appid);
        return this.getFormatHost(hostFormat, region, bucket);
    }

    public String getRequestHostByAppId(String region, String appid, String hostFormat) {
        if (!TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        region = TextUtils.isEmpty((CharSequence)region) ? this.region : region;
        return this.getFormatHostByAppId(hostFormat, region, appid);
    }

    public String getRequestHost(String region, String hostFormat) {
        if (!TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        region = TextUtils.isEmpty((CharSequence)region) ? this.region : region;
        return this.getFormatHost(hostFormat, region);
    }

    public String getHeaderHost(String region, String bucket) {
        if (this.hostHeaderFormat != null) {
            return this.getFormatHost(this.hostHeaderFormat, region, bucket);
        }
        return "";
    }

    public boolean isSignInUrl() {
        return this.signInUrl;
    }

    @Deprecated
    public String getDefaultRequestHost(String region, String bucket, String appid) {
        return this.getDefaultRequestHost(region, this.getBucket(bucket, appid));
    }

    public String getDefaultRequestHost(String region, String bucket) {
        return this.getFormatHost(DEFAULT_HOST_FORMAT, region, bucket);
    }

    private String getFormatHost(String hostFormat, String region, String bucket) {
        if (region == null) {
            throw new IllegalArgumentException("please set request or config region !");
        }
        if (bucket == null) {
            throw new IllegalArgumentException("please set request bucket !");
        }
        return hostFormat.replace("${bucket}", bucket).replace("${region}", region);
    }

    private String getFormatHost(String hostFormat, String region) {
        if (region == null) {
            throw new IllegalArgumentException("please set request or config region !");
        }
        return hostFormat.replace("${region}", region);
    }

    private String getFormatHostByAppId(String hostFormat, String region, String appid) {
        if (region == null) {
            throw new IllegalArgumentException("please set request or config region !");
        }
        if (appid == null) {
            throw new IllegalArgumentException("please set request appid !");
        }
        return hostFormat.replace("${appid}", appid).replace("${region}", region);
    }

    private String getHostFormat(boolean accelerate, boolean pathStyle) {
        if (!TextUtils.isEmpty((CharSequence)this.hostFormat)) {
            return this.hostFormat;
        }
        String hostFormat = DEFAULT_HOST_FORMAT;
        if (accelerate) {
            hostFormat = ACCELERATE_HOST_FORMAT;
        } else if (pathStyle) {
            hostFormat = PATH_STYLE_HOST_FORMAT;
        }
        if (this.endpointSuffix != null) {
            String string = hostFormat = this.bucketInPath ? this.endpointSuffix : "${bucket}.".concat(this.endpointSuffix);
            if (accelerate) {
                hostFormat = hostFormat.replace("cos.${region}", ACCELERATE_ENDPOINT_SUFFIX);
            }
        }
        return hostFormat;
    }

    public int getPort() {
        return this.port;
    }

    @Deprecated
    public String getHost(String bucket, boolean isSupportAccelerate) {
        return this.getHost(bucket, null, isSupportAccelerate);
    }

    @Deprecated
    public String getHost(String bucket, String region, boolean isSupportAccelerate) {
        return this.getHost(bucket, region, this.appid, isSupportAccelerate);
    }

    @Deprecated
    public String getHost(String bucket, String region, boolean isSupportAccelerate, boolean isHeader) {
        return this.getHost(bucket, region, this.appid, isSupportAccelerate, isHeader);
    }

    @Deprecated
    public String getHost(String bucket, String region, String appId, boolean isSupportAccelerate, boolean isHeader) {
        if (!isHeader && !TextUtils.isEmpty((CharSequence)this.host)) {
            return this.host;
        }
        String myBucket = this.getBucket(bucket, appId);
        String hostBuilder = "";
        if (!this.bucketInPath) {
            hostBuilder = hostBuilder + myBucket + ".";
        }
        hostBuilder = hostBuilder + this.getEndpointSuffix(region, isSupportAccelerate);
        return hostBuilder;
    }

    @Deprecated
    public String getHost(String bucket, String region, String appId, boolean isSupportAccelerate) {
        return this.getHost(bucket, region, appId, isSupportAccelerate, false);
    }

    public boolean isDnsCache() {
        return this.dnsCache;
    }

    public Map<String, List<String>> getCommonHeaders() {
        return this.commonHeaders;
    }

    public boolean isTransferThreadControl() {
        return this.transferThreadControl;
    }

    public int getUploadMaxThreadCount() {
        return this.uploadMaxThreadCount;
    }

    public int getDownloadMaxThreadCount() {
        return this.downloadMaxThreadCount;
    }

    public boolean isDomainSwitch() {
        return this.domainSwitch;
    }

    public boolean isVerifySSLEnable() {
        return this.verifySSLEnable;
    }

    public byte[] getClientCertificateBytes() {
        return this.clientCertificateBytes;
    }

    public char[] getClientCertificatePassword() {
        return this.clientCertificatePassword;
    }

    public NetworkClient getCustomizeNetworkClient() {
        return this.customizeNetworkClient;
    }

    public boolean isRedirectEnable() {
        return this.redirectEnable;
    }

    @Deprecated
    public String getEndpointSuffix() {
        return this.getEndpointSuffix(this.region, false);
    }

    @Deprecated
    public String getEndpointSuffix(String region, boolean isSupportAccelerate) {
        String myRegion = TextUtils.isEmpty((CharSequence)region) ? this.getRegion() : region;
        String myEndpointSuffix = this.endpointSuffix;
        if (this.endpointSuffix == null && myRegion != null) {
            myEndpointSuffix = "cos." + myRegion + ".myqcloud.com";
        }
        if ((myEndpointSuffix = this.substituteEndpointSuffix(myEndpointSuffix, myRegion)) != null && isSupportAccelerate) {
            myEndpointSuffix = myEndpointSuffix.replace("cos." + myRegion, ACCELERATE_ENDPOINT_SUFFIX);
        }
        return myEndpointSuffix;
    }

    private String substituteEndpointSuffix(String formatString, String region) {
        if (!TextUtils.isEmpty((CharSequence)formatString) && region != null) {
            return formatString.replace("${region}", region);
        }
        return formatString;
    }

    public String getUrlPath(String bucket, String cosPath) {
        StringBuilder path = new StringBuilder();
        if (this.bucketInPath) {
            String myBucket = bucket;
            if (!bucket.endsWith("-" + this.appid) && !TextUtils.isEmpty((CharSequence)this.appid)) {
                myBucket = bucket + "-" + this.appid;
            }
            path.append("/").append(myBucket);
        }
        if (cosPath != null && !cosPath.startsWith("/")) {
            path.append("/").append(cosPath);
        } else {
            path.append(cosPath);
        }
        return path.toString();
    }

    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public QCloudHttpRetryHandler getQCloudHttpRetryHandler() {
        return this.qCloudHttpRetryHandler;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Executor getObserveExecutor() {
        return this.observeExecutor;
    }

    public boolean isEnableQuic() {
        return this.isQuic;
    }

    public String getUserAgentExtended() {
        return this.userAgentExtended;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.protocol);
        dest.writeString(this.region);
        dest.writeInt(this.isDebuggable ? 1 : 0);
    }

    private CosXmlServiceConfig(Parcel in) {
        this(new Builder().isHttps(HTTPS_PROTOCOL.equals(in.readString())).setRegion(in.readString()).setDebuggable(in.readInt() == 1));
    }

    public static final class Builder {
        private String protocol;
        private String userAgentExtended;
        private String region;
        private String appid;
        private String host;
        private int port = -1;
        private String endpointSuffix;
        private boolean bucketInPath;
        private boolean isDebuggable;
        private RetryStrategy retryStrategy;
        private QCloudHttpRetryHandler qCloudHttpRetryHandler;
        private int connectionTimeout = 15000;
        private int socketTimeout = 30000;
        private Executor executor;
        private Executor observeExecutor;
        private boolean isQuic = false;
        private boolean dnsCache = true;
        private Map<String, List<String>> commonHeaders = new HashMap<String, List<String>>();
        private Set<String> noSignHeaders = new HashSet<String>();
        private String hostFormat;
        private String hostHeaderFormat;
        private boolean accelerate;
        private boolean signInUrl;
        private boolean transferThreadControl = true;
        private int uploadMaxThreadCount;
        private int downloadMaxThreadCount;
        private boolean domainSwitch;
        private boolean verifySSLEnable;
        private boolean redirectEnable;
        private byte[] clientCertificateBytes;
        private char[] clientCertificatePassword;
        private NetworkClient customizeNetworkClient;

        public Builder() {
            this.protocol = CosXmlServiceConfig.HTTPS_PROTOCOL;
            this.isDebuggable = false;
            this.retryStrategy = RetryStrategy.DEFAULT;
            this.bucketInPath = false;
            this.uploadMaxThreadCount = TaskExecutors.UPLOAD_THREAD_COUNT;
            this.downloadMaxThreadCount = TaskExecutors.DOWNLOAD_THREAD_COUNT;
            this.domainSwitch = true;
            this.verifySSLEnable = true;
            this.clientCertificateBytes = null;
            this.clientCertificatePassword = null;
            this.redirectEnable = false;
            this.customizeNetworkClient = null;
        }

        public Builder(CosXmlServiceConfig config) {
            this.protocol = config.protocol;
            this.region = config.region;
            this.appid = config.appid;
            this.host = config.host;
            this.port = config.port;
            this.endpointSuffix = config.endpointSuffix;
            this.bucketInPath = config.bucketInPath;
            this.isDebuggable = config.isDebuggable;
            this.retryStrategy = config.retryStrategy;
            this.qCloudHttpRetryHandler = config.qCloudHttpRetryHandler;
            this.connectionTimeout = config.connectionTimeout;
            this.socketTimeout = config.socketTimeout;
            this.executor = config.executor;
            this.observeExecutor = config.observeExecutor;
            this.isQuic = config.isQuic;
            this.dnsCache = config.dnsCache;
            this.commonHeaders = config.commonHeaders;
            this.noSignHeaders = config.noSignHeaders;
            this.hostFormat = config.hostFormat;
            this.hostHeaderFormat = config.hostHeaderFormat;
            this.accelerate = config.accelerate;
            this.signInUrl = config.signInUrl;
            this.transferThreadControl = config.transferThreadControl;
            this.uploadMaxThreadCount = config.uploadMaxThreadCount;
            this.downloadMaxThreadCount = config.downloadMaxThreadCount;
            this.domainSwitch = config.domainSwitch;
            this.verifySSLEnable = config.verifySSLEnable;
            this.clientCertificateBytes = config.clientCertificateBytes;
            this.clientCertificatePassword = config.clientCertificatePassword;
            this.redirectEnable = config.redirectEnable;
            this.customizeNetworkClient = config.customizeNetworkClient;
        }

        public Builder setConnectionTimeout(int connectionTimeoutMills) {
            this.connectionTimeout = connectionTimeoutMills;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeoutMills) {
            this.socketTimeout = socketTimeoutMills;
            return this;
        }

        public Builder setTransferThreadControl(boolean transferThreadControl) {
            this.transferThreadControl = transferThreadControl;
            return this;
        }

        public Builder setUploadMaxThreadCount(int uploadMaxThreadCount) {
            this.uploadMaxThreadCount = uploadMaxThreadCount;
            return this;
        }

        public Builder setDownloadMaxThreadCount(int downloadMaxThreadCount) {
            this.downloadMaxThreadCount = downloadMaxThreadCount;
            return this;
        }

        public Builder setDomainSwitch(boolean domainSwitch) {
            this.domainSwitch = domainSwitch;
            return this;
        }

        public Builder setVerifySSLEnable(boolean verifySSLEnable) {
            this.verifySSLEnable = verifySSLEnable;
            return this;
        }

        public Builder setClientCertificate(byte[] certificateBytes, String password) {
            this.clientCertificateBytes = certificateBytes;
            this.clientCertificatePassword = password.toCharArray();
            return this;
        }

        public Builder setRedirectEnable(boolean redirectEnable) {
            this.redirectEnable = redirectEnable;
            return this;
        }

        public Builder setCustomizeNetworkClient(NetworkClient customizeNetworkClient) {
            this.customizeNetworkClient = customizeNetworkClient;
            return this;
        }

        public Builder isHttps(boolean isHttps) {
            this.protocol = isHttps ? CosXmlServiceConfig.HTTPS_PROTOCOL : CosXmlServiceConfig.HTTP_PROTOCOL;
            return this;
        }

        public Builder setHostFormat(String hostFormat) {
            this.hostFormat = hostFormat;
            return this;
        }

        @Deprecated
        public Builder setAppidAndRegion(String appid, String region) {
            this.appid = appid;
            this.region = region;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        @Deprecated
        public Builder setEndpointSuffix(String endpointSuffix) {
            this.endpointSuffix = endpointSuffix;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setHost(Uri uri) {
            this.host = uri.getHost();
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            this.protocol = uri.getScheme();
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setDebuggable(boolean isDebuggable) {
            this.isDebuggable = isDebuggable;
            return this;
        }

        public Builder setSignInUrl(boolean signInUrl) {
            this.signInUrl = signInUrl;
            return this;
        }

        public Builder setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder setRetryHandler(QCloudHttpRetryHandler qCloudHttpRetryHandler) {
            this.qCloudHttpRetryHandler = qCloudHttpRetryHandler;
            return this;
        }

        @Deprecated
        public Builder setBucketInPath(boolean bucketInPath) {
            this.bucketInPath = bucketInPath;
            return this;
        }

        public Builder setPathStyle(boolean pathStyle) {
            this.bucketInPath = pathStyle;
            return this;
        }

        public Builder setExecutor(Executor excutor) {
            this.executor = excutor;
            return this;
        }

        public Builder setObserveExecutor(Executor observeExecutor) {
            this.observeExecutor = observeExecutor;
            return this;
        }

        public Builder enableQuic(boolean isEnable) {
            this.isQuic = isEnable;
            return this;
        }

        public Builder setUserAgentExtended(String userAgentExtended) {
            this.userAgentExtended = userAgentExtended;
            return this;
        }

        public Builder dnsCache(boolean dnsCache) {
            this.dnsCache = dnsCache;
            return this;
        }

        public Builder setAccelerate(boolean accelerate) {
            this.accelerate = accelerate;
            return this;
        }

        public CosXmlServiceConfig builder() {
            return new CosXmlServiceConfig(this);
        }

        public Builder addHeader(String key, String value) {
            List<String> values = this.commonHeaders.get(key);
            if (values == null) {
                values = new LinkedList<String>();
            }
            values.add(value);
            this.commonHeaders.put(key, values);
            return this;
        }

        public Builder addNoSignHeaders(String key) {
            this.noSignHeaders.add(key);
            return this;
        }
    }
}

