/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.CosError;
import com.tencent.cos.xml.utils.BaseXmlSlimParser;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONException;
import org.xmlpull.v1.XmlPullParserException;

public class ResponseXmlS3BodySerializer<T>
extends ResponseBodyConverter<T> {
    private CosXmlResult cosXmlResult;

    public ResponseXmlS3BodySerializer(CosXmlResult cosXmlResult) {
        this.cosXmlResult = cosXmlResult;
    }

    public T convert(HttpResponse response) throws QCloudClientException, QCloudServiceException {
        this.parseCOSXMLError(response);
        this.cosXmlResult.parseResponseBody(response);
        return (T)this.cosXmlResult;
    }

    private void parseCOSXMLError(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        int httpCode = response.code();
        if (httpCode >= 200 && httpCode < 300) {
            return;
        }
        String message = response.message();
        CosXmlServiceException cosXmlServiceException = new CosXmlServiceException(message);
        cosXmlServiceException.setStatusCode(httpCode);
        cosXmlServiceException.setRequestId(response.header("x-cos-request-id"));
        String contentType = response.header("Content-Type");
        CosError cosError = new CosError();
        if ("application/json".equalsIgnoreCase(contentType)) {
            try {
                cosError = CosError.fromJson(response.string());
            }
            catch (JSONException e) {
                throw new CosXmlClientException(ClientErrorCode.SERVERERROR.getCode(), e);
            }
            catch (IOException e) {
                throw new CosXmlClientException(ClientErrorCode.POOR_NETWORK.getCode(), e);
            }
        }
        InputStream inputStream = response.byteStream();
        if (inputStream != null) {
            try {
                BaseXmlSlimParser.parseError(inputStream, cosError);
            }
            catch (XmlPullParserException e) {
                throw new CosXmlClientException(ClientErrorCode.SERVERERROR.getCode(), e);
            }
            catch (IOException e) {
                throw new CosXmlClientException(ClientErrorCode.POOR_NETWORK.getCode(), e);
            }
        }
        if (cosError.code != null) {
            cosXmlServiceException.setErrorCode(cosError.code);
        }
        if (cosError.message != null) {
            cosXmlServiceException.setErrorMessage(cosError.message);
        }
        if (cosError.requestId != null) {
            cosXmlServiceException.setRequestId(cosError.requestId);
        }
        if (cosError.resource != null) {
            cosXmlServiceException.setServiceName(cosError.resource);
        }
        throw cosXmlServiceException;
    }
}

