/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.BasicLifecycleCredentialProvider;
import com.tencent.qcloud.core.auth.BasicQCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.HttpConfiguration;

public class ShortTimeCredentialProvider
extends BasicLifecycleCredentialProvider {
    private String secretKey;
    private long duration;
    private String secretId;

    @Deprecated
    public ShortTimeCredentialProvider(String secretId, String secretKey, long keyDuration) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.duration = keyDuration;
    }

    @Override
    protected QCloudLifecycleCredentials fetchNewCredentials() throws QCloudClientException {
        long current = HttpConfiguration.getDeviceTimeWithOffset();
        long expired = current + this.duration;
        String keyTime = current + ";" + expired;
        String signKey = this.secretKey2SignKey(this.secretKey, keyTime);
        return new BasicQCloudCredentials(this.secretId, this.secretKey, signKey, keyTime);
    }

    private String secretKey2SignKey(String secretKey, String keyTime) {
        byte[] hmacSha1 = Utils.hmacSha1(keyTime, secretKey);
        if (hmacSha1 != null) {
            return new String(Utils.encodeHex(hmacSha1));
        }
        return null;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public long getDuration() {
        return this.duration;
    }
}

