/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class CallMetricsListener
extends EventListener {
    private long dnsStartTime;
    private long dnsLookupTookTime;
    private long connectStartTime;
    private long connectTookTime;
    private long secureConnectStartTime;
    private long secureConnectTookTime;
    private long writeRequestHeaderStartTime;
    private long writeRequestHeaderTookTime;
    private long writeRequestBodyStartTime;
    private long writeRequestBodyTookTime;
    private long readResponseHeaderStartTime;
    private long readResponseHeaderTookTime;
    private long readResponseBodyStartTime;
    private long readResponseBodyTookTime;
    private List<InetAddress> inetAddressList;
    private long requestBodyByteCount;
    private long responseBodyByteCount;

    public CallMetricsListener(Call call) {
    }

    public void dnsStart(Call call, String domainName) {
        super.dnsStart(call, domainName);
        this.dnsStartTime = System.nanoTime();
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        super.dnsEnd(call, domainName, inetAddressList);
        StringBuffer ipList = new StringBuffer("{");
        if (inetAddressList != null) {
            for (InetAddress inetAddress : inetAddressList) {
                ipList.append(inetAddress.getHostAddress()).append(",");
            }
        }
        ipList.append("}");
        QCloudLogger.i("QCloudHttp", "dns: " + domainName + ":" + ipList.toString(), new Object[0]);
        this.dnsLookupTookTime += System.nanoTime() - this.dnsStartTime;
        this.inetAddressList = inetAddressList;
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        this.connectStartTime = System.nanoTime();
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.connectTookTime += System.nanoTime() - this.connectStartTime;
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        this.connectTookTime += System.nanoTime() - this.connectStartTime;
    }

    public void secureConnectStart(Call call) {
        super.secureConnectStart(call);
        this.secureConnectStartTime = System.nanoTime();
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        super.secureConnectEnd(call, handshake);
        this.secureConnectTookTime += System.nanoTime() - this.secureConnectStartTime;
    }

    public void requestHeadersStart(Call call) {
        super.requestHeadersStart(call);
        this.writeRequestHeaderStartTime = System.nanoTime();
    }

    public void requestHeadersEnd(Call call, Request request) {
        super.requestHeadersEnd(call, request);
        this.writeRequestHeaderTookTime += System.nanoTime() - this.writeRequestHeaderStartTime;
    }

    public void requestBodyStart(Call call) {
        super.requestBodyStart(call);
        this.writeRequestBodyStartTime = System.nanoTime();
    }

    public void requestBodyEnd(Call call, long byteCount) {
        super.requestBodyEnd(call, byteCount);
        this.writeRequestBodyTookTime += System.nanoTime() - this.writeRequestBodyStartTime;
        this.requestBodyByteCount = byteCount;
    }

    public void responseHeadersStart(Call call) {
        super.responseHeadersStart(call);
        this.readResponseHeaderStartTime = System.nanoTime();
    }

    public void responseHeadersEnd(Call call, Response response) {
        super.responseHeadersEnd(call, response);
        this.readResponseHeaderTookTime += System.nanoTime() - this.readResponseHeaderStartTime;
    }

    public void responseBodyStart(Call call) {
        super.responseBodyStart(call);
        this.readResponseBodyStartTime = System.nanoTime();
    }

    public void responseBodyEnd(Call call, long byteCount) {
        super.responseBodyEnd(call, byteCount);
        this.readResponseBodyTookTime += System.nanoTime() - this.readResponseBodyStartTime;
        this.responseBodyByteCount = byteCount;
    }

    public void dumpMetrics(HttpTaskMetrics metrics) {
        metrics.remoteAddress = this.inetAddressList;
        metrics.dnsLookupTookTime += this.dnsLookupTookTime;
        metrics.connectTookTime += this.connectTookTime;
        metrics.secureConnectTookTime += this.secureConnectTookTime;
        metrics.writeRequestHeaderTookTime += this.writeRequestHeaderTookTime;
        metrics.writeRequestBodyTookTime += this.writeRequestBodyTookTime;
        metrics.readResponseHeaderTookTime += this.readResponseHeaderTookTime;
        metrics.readResponseBodyTookTime += this.readResponseBodyTookTime;
        metrics.requestBodyByteCount = this.requestBodyByteCount;
        metrics.responseBodyByteCount = this.responseBodyByteCount;
    }

    public List<InetAddress> dumpDns() {
        return this.inetAddressList;
    }
}

