/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.content.ContentResolver;
import android.net.Uri;
import com.tencent.qcloud.core.common.QCloudDigistListener;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.http.CountingSink;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.util.Base64Utils;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class StreamingRequestBody
extends RequestBody
implements ProgressBody,
QCloudDigistListener {
    protected File file;
    protected byte[] bytes;
    protected InputStream stream;
    protected URL url;
    protected Uri uri;
    protected ContentResolver contentResolver;
    protected long offset = 0L;
    protected long requiredLength = -1L;
    protected long contentRawLength = -1L;
    protected String contentType;
    protected QCloudProgressListener progressListener;
    protected CountingSink countingSink;
    private boolean deleteFileWhenComplete = false;

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    protected StreamingRequestBody() {
    }

    @Override
    public long getBytesTransferred() {
        return this.countingSink != null ? this.countingSink.getTotalTransferred() : 0L;
    }

    static StreamingRequestBody file(File file, String contentType) {
        return StreamingRequestBody.file(file, contentType, 0L, Long.MAX_VALUE);
    }

    static StreamingRequestBody file(File file, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.file = file;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    static StreamingRequestBody bytes(byte[] bytes, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.bytes = bytes;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    static StreamingRequestBody steam(InputStream inputStream, File tmpFile, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.stream = inputStream;
        requestBody.contentType = contentType;
        requestBody.file = tmpFile;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        requestBody.deleteFileWhenComplete = true;
        return requestBody;
    }

    static StreamingRequestBody url(URL url, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.url = url;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    static StreamingRequestBody uri(Uri uri, ContentResolver contentResolver, String contentType, long offset, long length) {
        StreamingRequestBody requestBody = new StreamingRequestBody();
        requestBody.uri = uri;
        requestBody.contentResolver = contentResolver;
        requestBody.contentType = contentType;
        requestBody.offset = offset < 0L ? 0L : offset;
        requestBody.requiredLength = length;
        return requestBody;
    }

    boolean isLargeData() {
        return this.file != null || this.stream != null;
    }

    public MediaType contentType() {
        if (this.contentType != null) {
            return MediaType.parse((String)this.contentType);
        }
        return null;
    }

    public long contentLength() throws IOException {
        long contentMaxLength = this.getContentRawLength();
        if (contentMaxLength <= 0L) {
            return Math.max(this.requiredLength, -1L);
        }
        if (this.requiredLength <= 0L) {
            return Math.max(contentMaxLength - this.offset, -1L);
        }
        return Math.min(contentMaxLength - this.offset, this.requiredLength);
    }

    protected long getContentRawLength() throws IOException {
        if (this.contentRawLength < 0L) {
            if (this.stream != null) {
                this.contentRawLength = this.stream.available();
            } else if (this.file != null) {
                this.contentRawLength = this.file.length();
            } else if (this.bytes != null) {
                this.contentRawLength = this.bytes.length;
            } else if (this.uri != null) {
                this.contentRawLength = QCloudUtils.getUriContentLength2(this.uri, this.contentResolver);
            }
        }
        return this.contentRawLength;
    }

    public InputStream getStream() throws IOException {
        long skiped;
        InputStream inputStream = null;
        if (this.bytes != null) {
            inputStream = new ByteArrayInputStream(this.bytes);
        } else if (this.stream != null) {
            try {
                this.saveInputStreamToTmpFile(this.stream, this.file);
            }
            finally {
                if (this.stream != null) {
                    Util.closeQuietly((Closeable)this.stream);
                }
                this.stream = null;
                this.offset = 0L;
            }
            inputStream = new FileInputStream(this.file);
        } else if (this.file != null) {
            inputStream = new FileInputStream(this.file);
        } else if (this.url != null) {
            URLConnection conn = this.url.openConnection();
            if (this.offset > 0L) {
                conn.setRequestProperty("Range", "bytes=" + this.offset + "-" + this.offset + this.requiredLength);
            }
            inputStream = this.url.openStream();
        } else if (this.uri != null) {
            inputStream = this.contentResolver.openInputStream(this.uri);
        }
        if (this.url == null && inputStream != null && this.offset > 0L && (skiped = ((InputStream)inputStream).skip(this.offset)) < this.offset) {
            QCloudLogger.w("QCloudHttp", "skip  %d is small than offset %d", skiped, this.offset);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveInputStreamToTmpFile(InputStream stream, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int bytesRead;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            long bytesTotal = 0L;
            long bytesLimit = this.contentLength();
            if (bytesLimit < 0L) {
                bytesLimit = Long.MAX_VALUE;
            }
            if (this.offset > 0L) {
                long l = stream.skip(this.offset);
            }
            while (bytesTotal < bytesLimit && (bytesRead = stream.read(buffer)) != -1) {
                fos.write(buffer, 0, (int)Math.min((long)bytesRead, bytesLimit - bytesTotal));
                bytesTotal += (long)bytesRead;
            }
            fos.flush();
        }
        finally {
            if (fos != null) {
                Util.closeQuietly((Closeable)fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        BufferedSource source;
        block10: {
            InputStream inputStream = null;
            source = null;
            try {
                inputStream = this.getStream();
                if (inputStream != null) {
                    source = Okio.buffer((Source)Okio.source((InputStream)inputStream));
                    long contentLength = this.contentLength();
                    this.countingSink = new CountingSink((Sink)sink, contentLength, this.progressListener);
                    BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
                    if (contentLength > 0L) {
                        bufferedSink.write((Source)source, contentLength);
                    } else {
                        bufferedSink.writeAll((Source)source);
                    }
                    bufferedSink.flush();
                }
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    Util.closeQuietly((Closeable)inputStream);
                }
                if (source != null) {
                    Util.closeQuietly(source);
                }
                if (this.countingSink != null) {
                    Util.closeQuietly((Closeable)((Object)this.countingSink));
                }
                throw throwable;
            }
            Util.closeQuietly((Closeable)inputStream);
        }
        if (source != null) {
            Util.closeQuietly((Closeable)source);
        }
        if (this.countingSink != null) {
            Util.closeQuietly((Closeable)((Object)this.countingSink));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String onGetMd5() throws IOException {
        String string;
        block10: {
            MessageDigest messageDigest;
            InputStream inputStream;
            block8: {
                String string2;
                block9: {
                    inputStream = null;
                    messageDigest = MessageDigest.getInstance("MD5");
                    if (this.bytes == null) break block8;
                    messageDigest.update(this.bytes, (int)this.offset, (int)this.contentLength());
                    string2 = Base64Utils.encode(messageDigest.digest());
                    if (inputStream == null) break block9;
                    Util.closeQuietly((Closeable)inputStream);
                }
                return string2;
            }
            try {
                int readLen;
                inputStream = this.getStream();
                byte[] buff = new byte[8192];
                for (long remainLength = this.contentLength(); remainLength > 0L && (readLen = inputStream.read(buff, 0, (long)buff.length > remainLength ? (int)remainLength : buff.length)) != -1; remainLength -= (long)readLen) {
                    messageDigest.update(buff, 0, readLen);
                }
                string = Base64Utils.encode(messageDigest.digest());
                if (inputStream == null) break block10;
            }
            catch (IOException e) {
                try {
                    throw e;
                    catch (NoSuchAlgorithmException e2) {
                        throw new IOException("unSupport Md5 algorithm", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        Util.closeQuietly(inputStream);
                    }
                    throw throwable;
                }
            }
            Util.closeQuietly((Closeable)inputStream);
        }
        return string;
    }

    public void release() {
        if (this.deleteFileWhenComplete && this.file != null) {
            this.file.delete();
        }
    }
}

