/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http.interceptor;

import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.TaskManager;
import java.io.IOException;
import java.net.Socket;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.RealInterceptorChain;

public class HttpMetricsInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        try {
            Connection connection;
            if (chain instanceof RealInterceptorChain && (connection = chain.connection()) instanceof RealConnection) {
                RealConnection realConnection = (RealConnection)connection;
                Socket socket = realConnection.socket();
                HttpTask task = (HttpTask)TaskManager.getInstance().get((String)request.tag());
                HttpTaskMetrics metrics = task.metrics();
                if (metrics != null) {
                    metrics.recordConnectAddress(socket.getInetAddress());
                }
            }
        }
        catch (Exception e) {
            QCloudLogger.d("HttpMetricsInterceptor", e.getMessage(), new Object[0]);
        }
        return chain.proceed(request);
    }
}

