/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import androidx.annotation.Nullable;
import com.tencent.qcloud.core.logger.LogAdapter;
import java.util.ArrayList;
import java.util.List;

public final class QCloudLogger {
    private static final List<LogAdapter> logAdapters = new ArrayList<LogAdapter>();
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;

    private QCloudLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addAdapter(LogAdapter adapter) {
        if (adapter == null) return;
        Class<LogAdapter> clazz = LogAdapter.class;
        synchronized (LogAdapter.class) {
            boolean addBefore = false;
            for (LogAdapter logAdapter : logAdapters) {
                if (!logAdapter.getClass().equals(adapter.getClass())) continue;
                return;
            }
            if (addBefore) return;
            logAdapters.add(adapter);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends LogAdapter> T getAdapter(Class<T> adapterClass) {
        Class<LogAdapter> clazz = LogAdapter.class;
        synchronized (LogAdapter.class) {
            for (LogAdapter logAdapter : logAdapters) {
                if (!logAdapter.getClass().equals(adapterClass)) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (T)logAdapter;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public static void v(String tag, String format, Object ... args) {
        QCloudLogger.print(2, tag, null, format, args);
    }

    public static void v(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(2, tag, tr, format, args);
    }

    public static void d(String tag, String format, Object ... args) {
        QCloudLogger.print(3, tag, null, format, args);
    }

    public static void d(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(3, tag, tr, format, args);
    }

    public static void i(String tag, String format, Object ... args) {
        QCloudLogger.print(4, tag, null, format, args);
    }

    public static void i(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(4, tag, tr, format, args);
    }

    public static void w(String tag, String format, Object ... args) {
        QCloudLogger.print(5, tag, null, format, args);
    }

    public static void w(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(5, tag, tr, format, args);
    }

    public static void e(String tag, String format, Object ... args) {
        QCloudLogger.print(6, tag, null, format, args);
    }

    public static void e(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(6, tag, tr, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(int priority, String tag, @Nullable Throwable tr, String format, Object ... args) {
        String message;
        try {
            message = args != null && args.length > 0 ? String.format(format, args) : format;
        }
        catch (Exception e) {
            message = format + ": !!!! Log format exception: ";
        }
        Class<LogAdapter> clazz = LogAdapter.class;
        synchronized (LogAdapter.class) {
            for (LogAdapter adapter : logAdapters) {
                if (!adapter.isLoggable(priority, tag)) continue;
                adapter.log(priority, tag, message, tr);
            }
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return;
        }
    }
}

