/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

import androidx.annotation.NonNull;
import bolts.CancellationToken;
import bolts.CancellationTokenSource;
import bolts.Continuation;
import bolts.ExecutorException;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.logger.QCloudLogger;
import com.tencent.qcloud.core.task.TaskManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class QCloudTask<T>
implements Callable<T> {
    public static final int STATE_QUEUEING = 1;
    public static final int STATE_EXECUTING = 2;
    public static final int STATE_COMPLETE = 3;
    public static final int PRIORITY_LOW = 1;
    protected static final int PRIORITY_NORMAL = 2;
    public static final int PRIORITY_HIGH = 3;
    public static final int WEIGHT_LOW = 0;
    public static final int WEIGHT_NORMAL = 1;
    public static final int WEIGHT_HIGH = 2;
    private final String identifier;
    private final Object tag;
    private TaskManager taskManager;
    private Task<T> mTask;
    private CancellationTokenSource mCancellationTokenSource;
    private int mState;
    private int weight = 0;
    private boolean enableTraffic = true;
    private int uploadMaxThreadCount;
    private int downloadMaxThreadCount;
    private OnRequestWeightListener onRequestWeightListener;
    private Executor observerExecutor;
    private Executor workerExecutor;
    private Set<QCloudResultListener<T>> mResultListeners = new HashSet<QCloudResultListener<T>>(2);
    private Set<QCloudProgressListener> mProgressListeners = new HashSet<QCloudProgressListener>(2);
    private Set<QCloudTaskStateListener> mStateListeners = new HashSet<QCloudTaskStateListener>(2);

    public QCloudTask(String identifier, Object tag) {
        this.identifier = identifier;
        this.tag = tag;
        this.taskManager = TaskManager.getInstance();
    }

    public final Task<T> cast() {
        return this.mTask;
    }

    public final T executeNow() throws QCloudClientException, QCloudServiceException {
        this.executeNowSilently();
        Exception exception = this.getException();
        if (exception != null) {
            if (exception instanceof QCloudClientException) {
                throw (QCloudClientException)exception;
            }
            if (exception instanceof QCloudServiceException) {
                throw (QCloudServiceException)exception;
            }
            throw new QCloudClientException(exception);
        }
        return this.getResult();
    }

    public final void executeNowSilently() {
        this.taskManager.add(this);
        this.onStateChanged(1);
        this.mTask = Task.call((Callable)this);
    }

    protected QCloudTask<T> scheduleOn(Executor executor, CancellationTokenSource cancellationTokenSource) {
        return this.scheduleOn(executor, cancellationTokenSource, 2);
    }

    protected QCloudTask<T> scheduleOn(Executor executor, CancellationTokenSource cancellationTokenSource, int priority) {
        this.taskManager.add(this);
        this.onStateChanged(1);
        this.workerExecutor = executor;
        this.mCancellationTokenSource = cancellationTokenSource;
        if (priority <= 0) {
            priority = 2;
        }
        this.mTask = QCloudTask.callTask(this, executor, this.mCancellationTokenSource != null ? this.mCancellationTokenSource.getToken() : null, priority);
        this.mTask.continueWithTask(new Continuation<T, Task<Void>>(){

            public Task<Void> then(Task<T> task) throws Exception {
                if (task.isFaulted() || task.isCancelled()) {
                    if (QCloudTask.this.observerExecutor == null) {
                        try {
                            QCloudTask.this.onFailure();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new Error(e);
                        }
                        return null;
                    }
                    return Task.call((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                QCloudTask.this.onFailure();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new Error(e);
                            }
                            return null;
                        }
                    }, (Executor)QCloudTask.this.observerExecutor);
                }
                if (QCloudTask.this.observerExecutor == null) {
                    try {
                        QCloudTask.this.onSuccess();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Error(e);
                    }
                    return null;
                }
                return Task.call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        try {
                            QCloudTask.this.onSuccess();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new Error(e);
                        }
                        return null;
                    }
                }, (Executor)QCloudTask.this.observerExecutor);
            }
        });
        return this;
    }

    private static <TResult> Task<TResult> callTask(Callable<TResult> callable, Executor executor, CancellationToken ct, int priority) {
        TaskCompletionSource tcs = new TaskCompletionSource();
        try {
            executor.execute(new AtomTask<TResult>(tcs, ct, callable, priority));
        }
        catch (Exception e) {
            tcs.setError((Exception)new ExecutorException(e));
        }
        return tcs.getTask();
    }

    public void cancel() {
        QCloudLogger.d("QCloudTask", "[Call] %s cancel", this);
        if (this.mCancellationTokenSource != null) {
            this.mCancellationTokenSource.cancel();
        }
    }

    public void setTransferThreadControl(boolean enableTraffic) {
        this.enableTraffic = enableTraffic;
    }

    public boolean isEnableTraffic() {
        return this.enableTraffic;
    }

    public int getUploadMaxThreadCount() {
        return this.uploadMaxThreadCount;
    }

    public void setUploadMaxThreadCount(int uploadMaxThreadCount) {
        this.uploadMaxThreadCount = uploadMaxThreadCount;
    }

    public int getDownloadMaxThreadCount() {
        return this.downloadMaxThreadCount;
    }

    public void setDownloadMaxThreadCount(int downloadMaxThreadCount) {
        this.downloadMaxThreadCount = downloadMaxThreadCount;
    }

    public final boolean isCanceled() {
        return this.mCancellationTokenSource != null && this.mCancellationTokenSource.isCancellationRequested();
    }

    public final boolean isExecuting() {
        return this.getState() == 2;
    }

    public final boolean isCompleted() {
        return this.getState() == 3;
    }

    public final synchronized int getState() {
        return this.mState;
    }

    @Override
    public T call() throws Exception {
        T t;
        try {
            QCloudLogger.d("QCloudTask", "[Task] %s start testExecute", this.getIdentifier());
            this.onStateChanged(2);
            t = this.execute();
        }
        catch (Throwable throwable) {
            QCloudLogger.d("QCloudTask", "[Task] %s complete", this.getIdentifier());
            this.onStateChanged(3);
            this.taskManager.remove(this);
            throw throwable;
        }
        QCloudLogger.d("QCloudTask", "[Task] %s complete", this.getIdentifier());
        this.onStateChanged(3);
        this.taskManager.remove(this);
        return t;
    }

    protected abstract T execute() throws QCloudClientException, QCloudServiceException;

    public final QCloudTask<T> observeOn(Executor executor) {
        this.observerExecutor = executor;
        return this;
    }

    public final QCloudTask<T> addResultListener(QCloudResultListener<T> resultListener) {
        if (resultListener != null) {
            this.mResultListeners.add(resultListener);
        }
        return this;
    }

    public final QCloudTask<T> addResultListeners(List<QCloudResultListener<T>> resultListeners) {
        if (resultListeners != null) {
            this.mResultListeners.addAll(resultListeners);
        }
        return this;
    }

    public final QCloudTask<T> removeResultListener(QCloudResultListener<T> resultListener) {
        if (resultListener != null) {
            this.mResultListeners.remove(resultListener);
        }
        return this;
    }

    public final void removeAllListeners() {
        this.mResultListeners.clear();
        this.mProgressListeners.clear();
    }

    public final List<QCloudResultListener<T>> getAllResultListeners() {
        return new ArrayList<QCloudResultListener<T>>(this.mResultListeners);
    }

    public final List<QCloudProgressListener> getAllProgressListeners() {
        return new ArrayList<QCloudProgressListener>(this.mProgressListeners);
    }

    public final List<QCloudTaskStateListener> getAllStateListeners() {
        return new ArrayList<QCloudTaskStateListener>(this.mStateListeners);
    }

    public final QCloudTask<T> addProgressListener(QCloudProgressListener progressListener) {
        if (progressListener != null) {
            this.mProgressListeners.add(progressListener);
        }
        return this;
    }

    public final QCloudTask<T> addProgressListeners(List<QCloudProgressListener> progressListeners) {
        if (progressListeners != null) {
            this.mProgressListeners.addAll(progressListeners);
        }
        return this;
    }

    public final QCloudTask<T> removeProgressListener(QCloudProgressListener progressListener) {
        if (progressListener != null) {
            this.mProgressListeners.remove(progressListener);
        }
        return this;
    }

    public final QCloudTask<T> addStateListener(QCloudTaskStateListener stateListener) {
        if (stateListener != null) {
            this.mStateListeners.add(stateListener);
        }
        return this;
    }

    public final QCloudTask<T> addStateListeners(List<QCloudTaskStateListener> stateListeners) {
        if (stateListeners != null) {
            this.mStateListeners.addAll(stateListeners);
        }
        return this;
    }

    public final QCloudTask<T> removeStateListener(QCloudTaskStateListener stateListener) {
        if (stateListener != null) {
            this.mStateListeners.remove(stateListener);
        }
        return this;
    }

    public T getResult() {
        return (T)this.mTask.getResult();
    }

    public Exception getException() {
        return this.mTask.isFaulted() ? this.mTask.getError() : (this.mTask.isCancelled() ? new QCloudClientException("canceled") : null);
    }

    protected void onSuccess() {
        if (this.mResultListeners.size() > 0) {
            ArrayList<QCloudResultListener<T>> listeners = new ArrayList<QCloudResultListener<T>>(this.mResultListeners);
            for (QCloudResultListener qCloudResultListener : listeners) {
                qCloudResultListener.onSuccess(this.getResult());
            }
        }
    }

    protected void onFailure() {
        Exception exception = this.getException();
        if (exception != null && this.mResultListeners.size() > 0) {
            ArrayList<QCloudResultListener<T>> listeners = new ArrayList<QCloudResultListener<T>>(this.mResultListeners);
            for (QCloudResultListener qCloudResultListener : listeners) {
                if (exception instanceof QCloudClientException) {
                    qCloudResultListener.onFailure((QCloudClientException)exception, null);
                    continue;
                }
                if (exception instanceof QCloudServiceException) {
                    qCloudResultListener.onFailure(null, (QCloudServiceException)exception);
                    continue;
                }
                qCloudResultListener.onFailure(new QCloudClientException(exception.getCause() == null ? exception : exception.getCause()), null);
            }
        }
    }

    protected void onProgress(final long complete, final long target) {
        if (this.mProgressListeners.size() > 0) {
            this.executeListener(new Runnable(){

                @Override
                public void run() {
                    ArrayList listeners = new ArrayList(QCloudTask.this.mProgressListeners);
                    for (QCloudProgressListener progressListener : listeners) {
                        progressListener.onProgress(complete, target);
                    }
                }
            });
        }
    }

    protected void onStateChanged(int newState) {
        this.setState(newState);
        if (this.mStateListeners.size() > 0) {
            this.executeListener(new Runnable(){

                @Override
                public void run() {
                    ArrayList listeners = new ArrayList(QCloudTask.this.mStateListeners);
                    for (QCloudTaskStateListener listener : listeners) {
                        listener.onStateChanged(QCloudTask.this.identifier, QCloudTask.this.mState);
                    }
                }
            });
        }
    }

    private synchronized void setState(int newState) {
        this.mState = newState;
    }

    private void executeListener(Runnable callback) {
        if (this.observerExecutor != null) {
            this.observerExecutor.execute(callback);
        } else {
            callback.run();
        }
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public final Object getTag() {
        return this.tag;
    }

    public int getWeight() {
        return this.onRequestWeightListener != null ? this.onRequestWeightListener.onWeight() : 0;
    }

    public void setOnRequestWeightListener(OnRequestWeightListener onRequestWeightListener) {
        this.onRequestWeightListener = onRequestWeightListener;
    }

    public static interface OnRequestWeightListener {
        public int onWeight();
    }

    private static class AtomTask<TResult>
    implements Runnable,
    Comparable<Runnable> {
        private TaskCompletionSource<TResult> tcs;
        private CancellationToken ct;
        private Callable<TResult> callable;
        private int priority;
        private static AtomicInteger increment = new AtomicInteger(0);
        private int taskIdentifier;

        public AtomTask(TaskCompletionSource<TResult> tcs, CancellationToken ct, Callable<TResult> callable, int priority) {
            this.tcs = tcs;
            this.ct = ct;
            this.callable = callable;
            this.priority = priority;
            this.taskIdentifier = increment.addAndGet(1);
        }

        @Override
        public void run() {
            if (this.ct != null && this.ct.isCancellationRequested()) {
                this.tcs.setCancelled();
                return;
            }
            try {
                this.tcs.setResult(this.callable.call());
            }
            catch (CancellationException e) {
                this.tcs.setCancelled();
            }
            catch (Exception e) {
                this.tcs.setError(e);
            }
        }

        @Override
        public int compareTo(@NonNull Runnable o) {
            if (o instanceof AtomTask) {
                int priorityDelta = ((AtomTask)o).priority - this.priority;
                if (priorityDelta != 0) {
                    return priorityDelta;
                }
                return this.taskIdentifier - ((AtomTask)o).taskIdentifier;
            }
            return 0;
        }
    }
}

