/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import android.text.TextUtils;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.http.HttpConfiguration;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import com.tencent.qcloud.core.util.QCloudStringUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class COSXmlSignSourceProvider
implements QCloudSignSourceProvider {
    private Set<String> parametersRequiredToSign;
    private Set<String> parametersSigned;
    private Set<String> headerKeysRequiredToSign;
    private Set<String> headerKeysSigned;
    private Map<String, List<String>> headerPairs;
    private String signTime;
    private final List<String> needToSignHeaders = Arrays.asList("cache-control", "content-disposition", "content-encoding", "content-length", "content-md5", "content-type", "expect", "expires", "host", "if-match", "if-modified-since", "if-none-match", "if-unmodified-since", "origin", "range", "transfer-encoding", "pic-operations");

    public COSXmlSignSourceProvider() {
        this.headerKeysRequiredToSign = new HashSet<String>();
        this.parametersRequiredToSign = new HashSet<String>();
        this.headerKeysSigned = new HashSet<String>();
        this.parametersSigned = new HashSet<String>();
    }

    public void parameter(String key) {
        this.parametersRequiredToSign.add(key);
    }

    public void parameters(Set<String> keys) {
        if (keys != null) {
            this.parametersRequiredToSign.addAll(keys);
        }
    }

    public void header(String key) {
        this.headerKeysRequiredToSign.add(key);
    }

    public void headers(Set<String> keys) {
        if (keys != null) {
            this.headerKeysRequiredToSign.addAll(keys);
        }
    }

    public void setHeaderPairsForSign(Map<String, List<String>> headerPairs) {
        this.headerPairs = headerPairs;
    }

    void setSignTime(String signTime) {
        this.signTime = signTime;
    }

    @Override
    public <T> void onSignRequestSuccess(HttpRequest<T> request, QCloudCredentials credentials, String authorization) {
    }

    @Override
    public <T> String source(HttpRequest<T> request) throws QCloudClientException {
        if (request == null) {
            return null;
        }
        HashSet<String> signHeaders = new HashSet<String>();
        signHeaders.add("Content-Type");
        signHeaders.add("Content-Length");
        for (String string : request.headers().keySet()) {
            String lowerKey = string.toLowerCase(Locale.ROOT);
            if (!this.needToSignHeaders.contains(lowerKey) && !lowerKey.startsWith("x-cos-")) continue;
            signHeaders.add(string);
        }
        if (request.getNoSignHeaders() != null) {
            for (String string : request.getNoSignHeaders()) {
                signHeaders.remove(string);
            }
        }
        if (this.headerKeysRequiredToSign.size() < 1) {
            this.headerKeysRequiredToSign.addAll(signHeaders);
        }
        if (this.parametersRequiredToSign.size() < 1) {
            Map<String, List<String>> queryNameValues = QCloudHttpUtils.getQueryPair(request.url());
            for (String noSignParam : request.getNoSignParams()) {
                queryNameValues.remove(QCloudHttpUtils.urlDecodeString(noSignParam));
            }
            this.parametersRequiredToSign.addAll(queryNameValues.keySet());
        }
        if (this.headerKeysRequiredToSign.size() > 0) {
            String string;
            Set<String> lowerCaseHeaders = this.toLowerCase(this.headerKeysRequiredToSign);
            if (lowerCaseHeaders != null && lowerCaseHeaders.contains("Content-Type".toLowerCase(Locale.ROOT)) && request.getRequestBody() != null && !request.headers().containsKey("Content-Type") && (string = request.contentType()) != null) {
                request.addHeader("Content-Type", string);
            }
            if (lowerCaseHeaders != null && lowerCaseHeaders.contains("Content-Length".toLowerCase(Locale.ROOT)) && request.getRequestBody() != null) {
                long l;
                try {
                    l = request.contentLength();
                }
                catch (IOException e) {
                    throw new QCloudClientException("read content length fails", e);
                }
                if (l != -1L) {
                    request.addHeader("Content-Length", Long.toString(l));
                    request.removeHeader("Transfer-Encoding");
                } else {
                    request.addHeader("Transfer-Encoding", "chunked");
                    request.removeHeader("Content-Length");
                }
            }
            if (lowerCaseHeaders != null && lowerCaseHeaders.contains("Date".toLowerCase(Locale.ROOT))) {
                request.addHeader("Date", HttpConfiguration.getGMTDate(new Date()));
            }
        }
        StringBuilder formatString = new StringBuilder(request.method().toLowerCase(Locale.ROOT));
        formatString.append("\n");
        String string = QCloudHttpUtils.urlDecodeString(request.url().getPath());
        formatString.append(string);
        formatString.append("\n");
        String paraString = this.queryStringForKeys(request.url(), this.parametersRequiredToSign, this.parametersSigned);
        formatString.append(paraString);
        formatString.append("\n");
        String headerString = "";
        Map<String, List<String>> map = this.headerPairs = this.headerPairs != null ? this.headerPairs : request.headers();
        if (this.headerPairs != null) {
            headerString = this.headersStringForKeys(this.headerPairs, this.headerKeysRequiredToSign, this.headerKeysSigned);
        }
        formatString.append(headerString);
        formatString.append("\n");
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append("sha1");
        stringToSign.append("\n");
        stringToSign.append(this.signTime);
        stringToSign.append("\n");
        String formatStringSha1 = Utils.encodeHexString(Utils.sha1(formatString.toString()));
        stringToSign.append(formatStringSha1);
        stringToSign.append("\n");
        return stringToSign.toString();
    }

    String getRealHeaderList() {
        return this.sortAndJoinSemicolon(this.headerKeysSigned);
    }

    String getRealParameterList() {
        return this.sortAndJoinSemicolon(this.parametersSigned);
    }

    private String sortAndJoinSemicolon(Set<String> values) {
        if (values == null) {
            return "";
        }
        TreeSet<String> set = new TreeSet<String>(values);
        StringBuilder str = new StringBuilder();
        for (String value : set) {
            if (!QCloudStringUtils.isEmpty(str.toString())) {
                str.append(";");
            }
            str.append(value);
        }
        return str.toString();
    }

    private Set<String> toLowerCase(Set<String> set) {
        if (set != null && set.size() > 0) {
            HashSet<String> lowerSet = new HashSet<String>();
            for (String key : set) {
                if (key == null) continue;
                lowerSet.add(key.toLowerCase(Locale.ROOT));
            }
            return lowerSet;
        }
        return null;
    }

    private String queryStringForKeys(URL httpUrl, Set<String> keys, Set<String> realKeys) {
        StringBuilder out = new StringBuilder();
        boolean isFirst = true;
        LinkedList<String> orderKeys = new LinkedList<String>();
        for (String key : keys) {
            orderKeys.add(key.toLowerCase(Locale.ROOT));
        }
        Collections.sort(orderKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        Map<String, List<String>> queryNameValues = QCloudHttpUtils.getDecodedQueryPair(httpUrl);
        Set<String> queryNames = queryNameValues.keySet();
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String name : queryNames) {
            maps.put(name.toLowerCase(Locale.ROOT), name);
        }
        for (String key : orderKeys) {
            List<String> values = queryNameValues.get(maps.get(key));
            if (values == null) continue;
            for (String value : values) {
                if (!isFirst) {
                    out.append('&');
                }
                isFirst = false;
                realKeys.add(key.toLowerCase(Locale.ROOT));
                out.append(key.toLowerCase(Locale.ROOT)).append('=');
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                out.append(QCloudHttpUtils.urlEncodeString(value));
            }
        }
        return out.toString();
    }

    private String headersStringForKeys(Map<String, List<String>> headers, Set<String> keys, Set<String> realKeys) {
        StringBuilder out = new StringBuilder();
        boolean isFirst = true;
        LinkedList<String> orderKeys = new LinkedList<String>();
        for (String key : keys) {
            orderKeys.add(QCloudHttpUtils.urlEncodeString(key).toLowerCase(Locale.ROOT));
        }
        Collections.sort(orderKeys, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        Set<String> headerNames = headers.keySet();
        HashMap<String, String> maps = new HashMap<String, String>();
        for (String name : headerNames) {
            maps.put(name.toLowerCase(Locale.ROOT), name);
        }
        for (String key : orderKeys) {
            List<String> values = headers.get(maps.get(key));
            if (values == null) continue;
            for (String value : values) {
                if (!isFirst) {
                    out.append('&');
                }
                isFirst = false;
                realKeys.add(key.toLowerCase(Locale.ROOT));
                out.append(key.toLowerCase(Locale.ROOT)).append('=');
                if (TextUtils.isEmpty((CharSequence)value)) continue;
                out.append(QCloudHttpUtils.urlEncodeString(value));
            }
        }
        return out.toString();
    }
}

