/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.QCloudRawCredentials;
import com.tencent.qcloud.core.auth.Utils;
import com.tencent.qcloud.core.http.HttpConfiguration;

public class SessionQCloudCredentials
implements QCloudLifecycleCredentials,
QCloudRawCredentials {
    private final String secretId;
    private final String secretKey;
    private final String token;
    private final long startTime;
    private final long expiredTime;

    public SessionQCloudCredentials(String secretId, String secretKey, String token, long expiredTime) {
        this(secretId, secretKey, token, HttpConfiguration.getDeviceTimeWithOffset(), expiredTime);
    }

    public SessionQCloudCredentials(String secretId, String secretKey, String token, long startTime, long expiredTime) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secretKey cannot be null.");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        if (startTime >= expiredTime) {
            throw new IllegalArgumentException("beginTime must be less than expiredTime.");
        }
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.startTime = startTime;
        this.expiredTime = expiredTime;
        this.token = token;
    }

    public SessionQCloudCredentials(String secretId, String secretKey, String token, String keyTime) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secretKey cannot be null.");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        if (keyTime == null) {
            throw new IllegalArgumentException("keyTime cannot be null.");
        }
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.token = token;
        long[] times = Utils.parseKeyTimes(keyTime);
        this.startTime = times[0];
        this.expiredTime = times[1];
    }

    private String getKeyTime(long beginTime, long expiredTime) {
        return Utils.handleTimeAccuracy(beginTime) + ";" + Utils.handleTimeAccuracy(expiredTime);
    }

    private String getSignKey(String secretKey, String keyTime) {
        byte[] hmacSha1 = Utils.hmacSha1(keyTime, secretKey);
        if (hmacSha1 != null) {
            return new String(Utils.encodeHex(hmacSha1));
        }
        return null;
    }

    @Override
    public boolean isValid() {
        long current = HttpConfiguration.getDeviceTimeWithOffset();
        return current <= this.expiredTime - 60L;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public String getKeyTime() {
        return Utils.handleTimeAccuracy(this.startTime) + ";" + Utils.handleTimeAccuracy(this.expiredTime);
    }

    @Override
    public String getSecretId() {
        return this.secretId;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public String getSignKey() {
        return this.getSignKey(this.secretKey, this.getKeyTime());
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getExpiredTime() {
        return this.expiredTime;
    }
}

