/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.Response;

public final class HttpResponse<T> {
    final HttpRequest<T> request;
    final Response response;

    public HttpResponse(HttpRequest<T> request, Response response) {
        this.request = request;
        this.response = response;
    }

    public HttpRequest<T> request() {
        return this.request;
    }

    public int code() {
        return this.response.code();
    }

    public String message() {
        return this.response.message();
    }

    public String header(String name) {
        return this.response.header(name);
    }

    public Map<String, List<String>> headers() {
        return this.response.headers().toMultimap();
    }

    public final long contentLength() {
        return this.response.body() == null ? 0L : this.response.body().contentLength();
    }

    public final InputStream byteStream() {
        return this.response.body() == null ? null : this.response.body().byteStream();
    }

    public final byte[] bytes() throws IOException {
        return this.response.body() == null ? null : this.response.body().bytes();
    }

    public final String string() throws IOException {
        return this.response.body() == null ? null : this.response.body().string();
    }

    public final boolean isSuccessful() {
        return this.response != null && this.response.isSuccessful();
    }

    public static void checkResponseSuccessful(HttpResponse response) throws QCloudServiceException {
        if (response == null) {
            throw new QCloudServiceException("response is null");
        }
        if (!response.isSuccessful()) {
            QCloudServiceException exception = new QCloudServiceException(response.message());
            exception.setStatusCode(response.code());
            if (response.header("x-cos-request-id") != null) {
                exception.setRequestId(response.header("x-cos-request-id"));
            }
            throw exception;
        }
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "http code = %d, http message = %s %nheader is %s", this.code(), this.message(), this.response.headers().toMultimap());
    }
}

