/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import bolts.CancellationTokenSource;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudCredentials;
import com.tencent.qcloud.core.auth.QCloudSelfSigner;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.ScopeLimitCredentialProvider;
import com.tencent.qcloud.core.common.DomainSwitchException;
import com.tencent.qcloud.core.common.QCloudAuthenticationException;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudDigistListener;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.http.MultipartStreamRequestBody;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.NetworkProxy;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.ReactiveBody;
import com.tencent.qcloud.core.http.ResponseFileConverter;
import com.tencent.qcloud.core.http.StreamingRequestBody;
import com.tencent.qcloud.core.task.QCloudTask;
import com.tencent.qcloud.core.task.TaskExecutors;
import com.tencent.qcloud.core.util.DomainSwitchUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public final class HttpTask<T>
extends QCloudTask<HttpResult<T>> {
    private static AtomicInteger increments = new AtomicInteger(1);
    protected final HttpRequest<T> httpRequest;
    protected final QCloudCredentialProvider credentialProvider;
    protected HttpResult<T> httpResult;
    protected HttpTaskMetrics metrics;
    private NetworkProxy<T> networkProxy;
    private QCloudProgressListener mProgressListener = new QCloudProgressListener(){

        @Override
        public void onProgress(long complete, long target) {
            HttpTask.this.onProgress(complete, target);
        }
    };

    HttpTask(HttpRequest<T> httpRequest, QCloudCredentialProvider credentialProvider, NetworkClient networkClient) {
        super("HttpTask-" + httpRequest.tag() + "-" + increments.getAndIncrement(), httpRequest.tag());
        this.httpRequest = httpRequest;
        this.credentialProvider = credentialProvider;
        this.networkProxy = networkClient.getNetworkProxy();
        this.networkProxy.identifier = this.getIdentifier();
        this.networkProxy.mProgressListener = this.mProgressListener;
    }

    public HttpTask<T> scheduleOn(Executor executor) {
        this.scheduleOn(executor, 2);
        return this;
    }

    public HttpTask<T> scheduleOn(Executor executor, int priority) {
        this.scheduleOn(executor, new CancellationTokenSource(), priority);
        return this;
    }

    public HttpTask<T> schedule() {
        this.schedule(2);
        return this;
    }

    public HttpTask<T> schedule(int priority) {
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            this.scheduleOn((Executor)TaskExecutors.UPLOAD_EXECUTOR, priority);
        } else if (this.httpRequest.getResponseBodyConverter() instanceof ProgressBody) {
            this.scheduleOn((Executor)TaskExecutors.DOWNLOAD_EXECUTOR, priority);
        } else {
            this.scheduleOn((Executor)TaskExecutors.COMMAND_EXECUTOR, priority);
        }
        return this;
    }

    public boolean isSuccessful() {
        return this.httpResult != null && this.httpResult.isSuccessful();
    }

    @Override
    public HttpResult<T> getResult() {
        return this.httpResult;
    }

    public HttpTask<T> attachMetric(HttpTaskMetrics httpMetric) {
        this.metrics = httpMetric;
        return this;
    }

    public HttpTaskMetrics metrics() {
        return this.metrics;
    }

    public boolean isUploadTask() {
        if (this.httpRequest.getRequestBody() instanceof StreamingRequestBody) {
            return ((StreamingRequestBody)this.httpRequest.getRequestBody()).isLargeData();
        }
        return false;
    }

    public boolean isDownloadTask() {
        return this.httpRequest.getResponseBodyConverter() instanceof ProgressBody;
    }

    public boolean isResponseFilePathConverter() {
        return this.httpRequest.getResponseBodyConverter() instanceof ResponseFileConverter && ((ResponseFileConverter)this.httpRequest.getResponseBodyConverter()).isFilePathConverter();
    }

    public HttpRequest<T> request() {
        return this.httpRequest;
    }

    public long getTransferBodySize() {
        ProgressBody body = null;
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            body = (ProgressBody)this.httpRequest.getRequestBody();
        } else if (this.httpRequest.getResponseBodyConverter() instanceof ProgressBody) {
            body = (ProgressBody)((Object)this.httpRequest.getResponseBodyConverter());
        }
        if (body != null) {
            return body.getBytesTransferred();
        }
        return 0L;
    }

    public double getAverageStreamingSpeed(long networkMillsTook) {
        ProgressBody body = null;
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            body = (ProgressBody)this.httpRequest.getRequestBody();
        } else if (this.httpRequest.getResponseBodyConverter() instanceof ProgressBody) {
            body = (ProgressBody)((Object)this.httpRequest.getResponseBodyConverter());
        }
        if (body != null) {
            return (double)body.getBytesTransferred() / 1024.0 / ((double)networkMillsTook / 1000.0);
        }
        return 0.0;
    }

    public boolean isSelfSigner() {
        return this.httpRequest.getQCloudSelfSigner() != null;
    }

    @Override
    public void cancel() {
        this.networkProxy.cancel();
        super.cancel();
    }

    @Override
    public void cancel(boolean now) {
        this.networkProxy.cancel();
        super.cancel(now);
    }

    private boolean isCompleteMultipartRequest(HttpRequest httpRequest) {
        Set<String> queryKeys = httpRequest.queries.keySet();
        return queryKeys != null && queryKeys.size() == 1 && queryKeys.contains("uploadId");
    }

    @Override
    protected HttpResult<T> execute() throws QCloudClientException, QCloudServiceException {
        QCloudSelfSigner selfSigner;
        QCloudSigner signer;
        if (this.metrics == null) {
            this.metrics = new HttpTaskMetrics();
        }
        this.networkProxy.metrics = this.metrics;
        this.metrics.onTaskStart();
        if (this.httpRequest.shouldCalculateContentMD5()) {
            this.metrics.onCalculateMD5Start();
            this.calculateContentMD5();
            this.metrics.onCalculateMD5End();
        }
        if (this.httpRequest.getRequestBody() instanceof ReactiveBody) {
            try {
                ((ReactiveBody)this.httpRequest.getRequestBody()).prepare();
            }
            catch (IOException e) {
                throw new QCloudClientException(e);
            }
        }
        if ((signer = this.httpRequest.getQCloudSigner()) != null) {
            this.metrics.onSignRequestStart();
            this.signRequest(signer, (QCloudHttpRequest)this.httpRequest);
            this.metrics.onSignRequestEnd();
        }
        if ((selfSigner = this.httpRequest.getQCloudSelfSigner()) != null) {
            this.metrics.onSignRequestStart();
            selfSigner.sign((QCloudHttpRequest)this.httpRequest);
            this.metrics.onSignRequestEnd();
        }
        if (this.httpRequest.getRequestBody() instanceof ProgressBody) {
            ((ProgressBody)this.httpRequest.getRequestBody()).setProgressListener(this.mProgressListener);
        }
        try {
            this.metrics.onHttpTaskStart();
            this.httpResult = this.networkProxy.executeHttpRequest(this.httpRequest);
            this.metrics.onHttpTaskEnd();
            HttpResult<T> httpResult = this.httpResult;
            return httpResult;
        }
        catch (QCloudServiceException serviceException) {
            if (this.isClockSkewedError(serviceException)) {
                this.metrics.setClockSkewedRetry(true);
                if (signer != null) {
                    this.metrics.onSignRequestStart();
                    this.signRequest(signer, (QCloudHttpRequest)this.httpRequest);
                    this.metrics.onSignRequestEnd();
                }
                this.metrics.onHttpTaskStart();
                this.httpResult = this.networkProxy.executeHttpRequest(this.httpRequest);
                this.metrics.onHttpTaskEnd();
                HttpResult<T> e = this.httpResult;
                return e;
            }
            throw serviceException;
        }
        catch (QCloudClientException clientException) {
            if (clientException.getCause() instanceof DomainSwitchException && this.isDomainSwitch() && signer != null && selfSigner == null) {
                String urlString = this.httpRequest.url.toString().replace(DomainSwitchUtils.DOMAIN_MYQCLOUD, DomainSwitchUtils.DOMAIN_TENCENTCOS);
                this.httpRequest.setUrl(urlString);
                try {
                    URL url = new URL(urlString);
                    this.httpRequest.addOrReplaceHeader("Host", url.getHost());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.metrics.onSignRequestStart();
                this.signRequest(signer, (QCloudHttpRequest)this.httpRequest);
                this.metrics.onSignRequestEnd();
                this.metrics.onHttpTaskStart();
                this.httpResult = this.networkProxy.executeHttpRequest(this.httpRequest);
                this.metrics.onHttpTaskEnd();
                HttpResult<T> httpResult = this.httpResult;
                return httpResult;
            }
            throw clientException;
        }
        finally {
            if (this.httpRequest.getRequestBody() instanceof ReactiveBody) {
                try {
                    ((ReactiveBody)this.httpRequest.getRequestBody()).end(this.httpResult);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.httpRequest.getRequestBody() instanceof StreamingRequestBody) {
                ((StreamingRequestBody)this.httpRequest.getRequestBody()).release();
            }
            this.metrics.onTaskEnd();
        }
    }

    private boolean isClockSkewedError(QCloudServiceException serviceException) {
        return "RequestIsExpired".equals(serviceException.getErrorCode()) || "RequestTimeTooSkewed".equals(serviceException.getErrorCode());
    }

    private void signRequest(QCloudSigner signer, QCloudHttpRequest request) throws QCloudClientException {
        if (this.credentialProvider == null) {
            throw new QCloudClientException(new QCloudAuthenticationException("no credentials provider"));
        }
        QCloudCredentials credentials = this.credentialProvider instanceof ScopeLimitCredentialProvider ? ((ScopeLimitCredentialProvider)this.credentialProvider).getCredentials(request.getCredentialScope()) : this.credentialProvider.getCredentials();
        signer.sign(request, credentials);
    }

    private void calculateContentMD5() throws QCloudClientException {
        RequestBody requestBody = this.httpRequest.getRequestBody();
        if (requestBody == null) {
            throw new QCloudClientException(new IllegalArgumentException("get md5 canceled, request body is null."));
        }
        if (requestBody instanceof QCloudDigistListener) {
            try {
                if (this.httpRequest.getRequestBody() instanceof MultipartStreamRequestBody) {
                    ((MultipartStreamRequestBody)this.httpRequest.getRequestBody()).addMd5();
                }
                this.httpRequest.addHeader("Content-MD5", ((QCloudDigistListener)requestBody).onGetMd5());
            }
            catch (IOException e) {
                throw new QCloudClientException("calculate md5 error: " + e.getMessage(), e);
            }
        } else {
            Buffer sink = new Buffer();
            try {
                requestBody.writeTo((BufferedSink)sink);
            }
            catch (IOException e) {
                throw new QCloudClientException("calculate md5 error" + e.getMessage(), e);
            }
            String md5 = sink.md5().base64();
            this.httpRequest.addHeader("Content-MD5", md5);
            sink.close();
        }
    }

    public void convertResponse(Response response) throws QCloudClientException, QCloudServiceException {
        this.httpResult = this.networkProxy.convertResponse(this.httpRequest, response);
    }
}

