/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.net.InetAddress;
import java.util.List;

public class HttpTaskMetrics {
    private long fullTaskStartTime;
    private long fullTaskTookTime;
    private long httpTaskStartTime;
    private long httpTaskTookTime;
    private long calculateMD5StartTime;
    private long calculateMD5STookTime;
    private long signRequestStartTime;
    private long signRequestTookTime;
    long dnsStartTimestamp;
    long dnsLookupTookTime;
    long connectStartTimestamp;
    long connectTookTime;
    long secureConnectStartTimestamp;
    long secureConnectTookTime;
    long writeRequestHeaderStartTimestamp;
    long writeRequestHeaderTookTime;
    long writeRequestBodyStartTimestamp;
    long writeRequestBodyTookTime;
    long readResponseHeaderStartTimestamp;
    long readResponseHeaderTookTime;
    long readResponseBodyStartTimestamp;
    long readResponseBodyTookTime;
    long requestBodyByteCount;
    long responseBodyByteCount;
    @Nullable
    String domainName;
    @Nullable
    List<InetAddress> remoteAddress;
    @Nullable
    InetAddress connectAddress;
    private int retryCount;
    private boolean isClockSkewedRetry;

    void onTaskStart() {
        this.fullTaskStartTime = System.nanoTime();
    }

    void onTaskEnd() {
        this.fullTaskTookTime = System.nanoTime() - this.fullTaskStartTime;
        this.onDataReady();
    }

    void onHttpTaskStart() {
        this.httpTaskStartTime = System.nanoTime();
    }

    void onHttpTaskEnd() {
        this.httpTaskTookTime = System.nanoTime() - this.httpTaskStartTime;
    }

    void onCalculateMD5Start() {
        this.calculateMD5StartTime = System.nanoTime();
    }

    void onCalculateMD5End() {
        this.calculateMD5STookTime += System.nanoTime() - this.calculateMD5StartTime;
    }

    void onSignRequestStart() {
        this.signRequestStartTime = System.nanoTime();
    }

    void onSignRequestEnd() {
        this.signRequestTookTime += System.nanoTime() - this.signRequestStartTime;
    }

    public long requestBodyByteCount() {
        return this.requestBodyByteCount;
    }

    public long responseBodyByteCount() {
        return this.responseBodyByteCount;
    }

    public double httpTaskFullTime() {
        return this.toSeconds(this.httpTaskTookTime);
    }

    public double dnsLookupTookTime() {
        return this.toSeconds(this.dnsLookupTookTime);
    }

    public double connectTookTime() {
        return this.toSeconds(this.connectTookTime);
    }

    public double secureConnectTookTime() {
        return this.toSeconds(this.secureConnectTookTime);
    }

    public double calculateMD5STookTime() {
        return this.toSeconds(this.calculateMD5STookTime);
    }

    public double signRequestTookTime() {
        return this.toSeconds(this.signRequestTookTime);
    }

    public double readResponseHeaderTookTime() {
        return this.toSeconds(this.readResponseHeaderTookTime);
    }

    public double readResponseBodyTookTime() {
        return this.toSeconds(this.readResponseBodyTookTime);
    }

    public double writeRequestBodyTookTime() {
        return this.toSeconds(this.writeRequestBodyTookTime);
    }

    public double writeRequestHeaderTookTime() {
        return this.toSeconds(this.writeRequestHeaderTookTime);
    }

    public double fullTaskTookTime() {
        return this.toSeconds(this.fullTaskTookTime);
    }

    @Nullable
    public List<InetAddress> getRemoteAddress() {
        return this.remoteAddress;
    }

    @Nullable
    public InetAddress getConnectAddress() {
        return this.connectAddress;
    }

    @Nullable
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(@Nullable String domainName) {
        this.domainName = domainName;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean isClockSkewedRetry() {
        return this.isClockSkewedRetry;
    }

    public void setClockSkewedRetry(boolean clockSkewedRetry) {
        this.isClockSkewedRetry = clockSkewedRetry;
    }

    private double toSeconds(long nanotime) {
        return (double)nanotime / 1.0E9;
    }

    public static HttpTaskMetrics createMetricsWithHost(String host) {
        HttpTaskMetrics taskMetrics = new HttpTaskMetrics();
        taskMetrics.domainName = host;
        return taskMetrics;
    }

    public void recordConnectAddress(InetAddress address) {
        if (address != null) {
            this.domainName = address.getHostName();
            this.connectAddress = address;
        }
    }

    public void onDataReady() {
    }

    public synchronized HttpTaskMetrics merge(HttpTaskMetrics taskMetrics) {
        if (!(TextUtils.isEmpty((CharSequence)this.domainName) || TextUtils.isEmpty((CharSequence)taskMetrics.domainName) || this.domainName.equals(taskMetrics.domainName))) {
            return this;
        }
        if (TextUtils.isEmpty((CharSequence)this.domainName) && taskMetrics.domainName != null) {
            this.domainName = taskMetrics.domainName;
        }
        this.dnsLookupTookTime = Math.max(taskMetrics.dnsLookupTookTime, this.dnsLookupTookTime);
        this.connectTookTime = Math.max(taskMetrics.connectTookTime, this.connectTookTime);
        this.secureConnectTookTime = Math.max(taskMetrics.secureConnectTookTime, this.secureConnectTookTime);
        this.writeRequestHeaderTookTime += taskMetrics.writeRequestHeaderTookTime;
        this.writeRequestBodyTookTime += taskMetrics.writeRequestBodyTookTime;
        this.readResponseHeaderTookTime += taskMetrics.readResponseHeaderTookTime;
        this.readResponseBodyTookTime += taskMetrics.readResponseBodyTookTime;
        this.requestBodyByteCount += taskMetrics.requestBodyByteCount;
        this.responseBodyByteCount += taskMetrics.responseBodyByteCount;
        this.fullTaskTookTime += taskMetrics.fullTaskTookTime;
        this.httpTaskTookTime += taskMetrics.httpTaskTookTime;
        this.calculateMD5STookTime += taskMetrics.calculateMD5STookTime;
        this.signRequestTookTime += taskMetrics.signRequestTookTime;
        if (taskMetrics.getRemoteAddress() != null) {
            this.remoteAddress = taskMetrics.getRemoteAddress();
        }
        if (taskMetrics.connectAddress != null) {
            this.connectAddress = taskMetrics.getConnectAddress();
        }
        this.retryCount += taskMetrics.retryCount;
        if (!this.isClockSkewedRetry) {
            this.isClockSkewedRetry = taskMetrics.isClockSkewedRetry;
        }
        return this;
    }

    public String toString() {
        return "Http Metrics: \n" + "domain : " + this.domainName + "\n" + "connectAddress : " + (this.connectAddress != null ? this.connectAddress.getHostAddress() : "null") + "\n" + "retryCount : " + this.retryCount + "\n" + "isClockSkewedRetry : " + this.isClockSkewedRetry + "\n" + "dns : " + (this.remoteAddress != null ? this.remoteAddress : "null") + "\n" + "fullTaskTookTime : " + this.fullTaskTookTime() + "\n" + "httpTaskTookTime : " + this.httpTaskFullTime() + "\n" + "calculateMD5STookTime : " + this.calculateMD5STookTime() + "\n" + "signRequestTookTime : " + this.signRequestTookTime() + "\n" + "dnsStartTimestamp : " + this.dnsStartTimestamp + "\n" + "dnsLookupTookTime : " + this.dnsLookupTookTime() + "\n" + "connectStartTimestamp : " + this.connectStartTimestamp + "\n" + "connectTookTime : " + this.connectTookTime() + "\n" + "secureConnectStartTimestamp : " + this.secureConnectStartTimestamp + "\n" + "secureConnectTookTime : " + this.secureConnectTookTime() + "\n" + "writeRequestHeaderStartTimestamp : " + this.writeRequestHeaderStartTimestamp + "\n" + "writeRequestHeaderTookTime : " + this.writeRequestHeaderTookTime() + "\n" + "writeRequestBodyStartTimestamp : " + this.writeRequestBodyStartTimestamp + "\n" + "writeRequestBodyTookTime : " + this.writeRequestBodyTookTime() + "\n" + "readResponseHeaderStartTimestamp : " + this.readResponseHeaderStartTimestamp + "\n" + "readResponseHeaderTookTime : " + this.readResponseHeaderTookTime() + "\n" + "readResponseBodyStartTimestamp : " + this.readResponseBodyStartTimestamp + "readResponseBodyTookTime : " + this.readResponseBodyTookTime();
    }
}

