/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.content.ContentResolver;
import android.net.Uri;
import android.text.TextUtils;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.CountingSink;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.util.OkhttpInternalUtils;
import com.tencent.qcloud.core.util.QCloudHttpUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.Sink;

public class ResponseFileConverter<T>
extends ResponseBodyConverter<T>
implements ProgressBody {
    private String filePath;
    private Uri contentUri;
    private ContentResolver contentResolver;
    private long offset;
    protected boolean isQuic = false;
    protected QCloudProgressListener progressListener;
    private CountingSink countingSink;
    private InputStream inputStream;

    public ResponseFileConverter(String filePath, long offset) {
        this.filePath = filePath;
        this.offset = offset;
    }

    public ResponseFileConverter(Uri contentUri, ContentResolver contentResolver, long offset) {
        this.contentUri = contentUri;
        this.contentResolver = contentResolver;
        this.offset = offset;
    }

    public ResponseFileConverter() {
    }

    @Override
    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void enableQuic(boolean isQuic) {
        this.isQuic = isQuic;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    public T convert(HttpResponse<T> response) throws QCloudClientException, QCloudServiceException {
        if (this.isQuic) {
            return null;
        }
        HttpResponse.checkResponseSuccessful(response);
        String contentRangeString = response.header("Content-Range");
        long[] contentRange = QCloudHttpUtils.parseContentRange(contentRangeString);
        long contentLength = contentRange != null ? contentRange[1] - contentRange[0] + 1L : response.contentLength();
        if (!TextUtils.isEmpty((CharSequence)this.filePath)) {
            return this.downloadToAbsolutePath(response, contentLength);
        }
        if (this.contentUri != null) {
            return this.pipeToContentUri(response, contentLength);
        }
        throw new QCloudClientException(new IllegalArgumentException("filePath or ContentUri are both null"));
    }

    private T pipeToContentUri(HttpResponse<T> response, long contentLength) throws QCloudClientException, QCloudServiceException {
        OutputStream output = this.getOutputStream();
        InputStream input = response.byteStream();
        byte[] buffer = new byte[8192];
        this.countingSink = new CountingSink((Sink)new Buffer(), contentLength, this.progressListener);
        try {
            int len;
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
                this.countingSink.writeBytesInternal(len);
            }
            T t = null;
            return t;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QCloudClientException("write local uri error for " + e.toString(), e);
        }
        finally {
            if (output != null) {
                OkhttpInternalUtils.closeQuietly(output);
            }
        }
    }

    private T downloadToAbsolutePath(HttpResponse<T> response, long contentLength) throws QCloudClientException, QCloudServiceException {
        File downloadFilePath = new File(this.filePath);
        File parentDir = downloadFilePath.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new QCloudClientException(new IOException("local file directory can not create."));
        }
        ResponseBody body = response.response.body();
        if (body == null) {
            throw new QCloudServiceException("response body is empty !");
        }
        try {
            this.writeRandomAccessFile(downloadFilePath, response.byteStream(), contentLength);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new QCloudClientException("write local file error for " + e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRandomAccessFile(File downloadFilePath, InputStream inputStream, long contentLength) throws IOException, QCloudClientException {
        FileOutputStream fos;
        RandomAccessFile randomAccessFile;
        block11: {
            if (inputStream == null) {
                throw new QCloudClientException(new IOException("response body stream is null"));
            }
            randomAccessFile = null;
            fos = null;
            BufferedOutputStream bos = null;
            try {
                int len;
                long lastTimeBytes = this.getBytesTransferred();
                if (this.offset + lastTimeBytes > 0L) {
                    randomAccessFile = new RandomAccessFile(downloadFilePath, "rws");
                    randomAccessFile.seek(this.offset + lastTimeBytes);
                    fos = new FileOutputStream(randomAccessFile.getFD());
                } else {
                    fos = new FileOutputStream(downloadFilePath);
                }
                bos = new BufferedOutputStream(fos);
                byte[] buffer = new byte[0x100000];
                this.countingSink = new CountingSink((Sink)new Buffer(), contentLength, lastTimeBytes, this.progressListener);
                while ((len = inputStream.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                    this.countingSink.writeBytesInternal(len);
                }
                if (bos == null) break block11;
            }
            catch (Throwable throwable) {
                if (bos != null) {
                    OkhttpInternalUtils.closeQuietly(bos);
                }
                if (fos != null) {
                    OkhttpInternalUtils.closeQuietly(fos);
                }
                if (randomAccessFile != null) {
                    OkhttpInternalUtils.closeQuietly(randomAccessFile);
                }
                throw throwable;
            }
            OkhttpInternalUtils.closeQuietly(bos);
        }
        if (fos != null) {
            OkhttpInternalUtils.closeQuietly(fos);
        }
        if (randomAccessFile != null) {
            OkhttpInternalUtils.closeQuietly(randomAccessFile);
        }
    }

    public OutputStream getOutputStream() throws QCloudClientException {
        if (!TextUtils.isEmpty((CharSequence)this.filePath)) {
            File downloadFilePath = new File(this.filePath);
            File parentDir = downloadFilePath.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                throw new QCloudClientException(new IOException("local file directory can not create."));
            }
            try {
                return new FileOutputStream(downloadFilePath);
            }
            catch (FileNotFoundException e) {
                throw new QCloudClientException(e);
            }
        }
        if (this.contentUri != null) {
            try {
                return this.contentResolver.openOutputStream(this.contentUri);
            }
            catch (FileNotFoundException e) {
                throw new QCloudClientException(e);
            }
        }
        throw new QCloudClientException(new IllegalArgumentException("filePath or ContentUri are both null"));
    }

    @Override
    public long getBytesTransferred() {
        return this.countingSink != null ? this.countingSink.getTotalTransferred() : 0L;
    }

    public boolean isFilePathConverter() {
        return !TextUtils.isEmpty((CharSequence)this.filePath);
    }
}

