/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http.interceptor;

import android.text.TextUtils;
import com.tencent.qcloud.core.common.DomainSwitchException;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.task.TaskManager;
import com.tencent.qcloud.core.util.DomainSwitchUtils;
import com.tencent.qcloud.core.util.OkhttpInternalUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RedirectInterceptor
implements Interceptor {
    private static final int MAX_FOLLOW_UPS = 20;
    private OkHttpClient client;

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpTask task = (HttpTask)TaskManager.getInstance().get((String)request.tag());
        int followUpCount = 0;
        Response priorResponse = null;
        while (true) {
            Request followUp;
            if (task == null || task.isCanceled()) {
                throw new IOException("CANCELED");
            }
            Response response = chain.proceed(request);
            if (priorResponse != null) {
                response = response.newBuilder().priorResponse(priorResponse.newBuilder().body(null).build()).build();
            }
            if ((followUp = this.followUpRequest(response, task.isDomainSwitch(), task.isSelfSigner())) == null) {
                return response;
            }
            OkhttpInternalUtils.closeQuietly((Closeable)response.body());
            if (++followUpCount > 20) {
                throw new ProtocolException("Too many follow-up requests: " + followUpCount);
            }
            request = followUp;
            priorResponse = response;
        }
    }

    private Request followUpRequest(Response userResponse, boolean isDomainSwitch, boolean isSelfSigner) throws DomainSwitchException {
        if (userResponse == null) {
            throw new IllegalStateException();
        }
        int responseCode = userResponse.code();
        String method = userResponse.request().method();
        switch (responseCode) {
            case 307: 
            case 308: {
                if (!method.equals("GET") && !method.equals("HEAD")) {
                    return null;
                }
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                if (isDomainSwitch && !isSelfSigner && DomainSwitchUtils.isMyqcloudUrl(userResponse.request().url().host()) && TextUtils.isEmpty((CharSequence)userResponse.header("x-cos-request-id"))) {
                    throw new DomainSwitchException();
                }
                String location = userResponse.header("Location");
                if (location == null) {
                    return null;
                }
                HttpUrl url = userResponse.request().url().resolve(location);
                if (url == null) {
                    return null;
                }
                boolean sameScheme = url.scheme().equals(userResponse.request().url().scheme());
                if (!sameScheme && !this.client.followSslRedirects()) {
                    return null;
                }
                Request.Builder requestBuilder = userResponse.request().newBuilder();
                if (OkhttpInternalUtils.permitsRequestBody(method)) {
                    boolean maintainBody = OkhttpInternalUtils.redirectsWithBody(method);
                    if (OkhttpInternalUtils.redirectsToGet(method)) {
                        requestBuilder.method("GET", null);
                    } else {
                        RequestBody requestBody = maintainBody ? userResponse.request().body() : null;
                        requestBuilder.method(method, requestBody);
                    }
                    if (!maintainBody) {
                        requestBuilder.removeHeader("Transfer-Encoding");
                        requestBuilder.removeHeader("Content-Length");
                        requestBuilder.removeHeader("Content-Type");
                    }
                }
                if (!this.sameConnection(userResponse, url)) {
                    requestBuilder.removeHeader("Authorization");
                }
                requestBuilder.removeHeader("Host");
                return requestBuilder.url(url).build();
            }
        }
        return null;
    }

    private boolean sameConnection(Response response, HttpUrl followUp) {
        HttpUrl url = response.request().url();
        return url.host().equals(followUp.host()) && url.port() == followUp.port() && url.scheme().equals(followUp.scheme());
    }
}

