/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.task;

import com.tencent.qcloud.core.task.RetryStrategy;
import java.util.concurrent.atomic.AtomicLong;

public abstract class SelfConstraintRetryStrategy
extends RetryStrategy {
    private AtomicLong nextDelay = new AtomicLong(0L);

    public SelfConstraintRetryStrategy(int initBackoff, int maxBackoff, int baseAttempts) {
        super(initBackoff, maxBackoff, baseAttempts);
    }

    @Override
    public long getNextDelay(int attempts) {
        return this.nextDelay.get();
    }

    @Override
    public void onTaskEnd(boolean isTaskSuccess, Exception e) {
        if (isTaskSuccess) {
            this.nextDelay.set(0L);
        } else if (this.shouldIncreaseDelay(e)) {
            this.nextDelay.set(Math.max(Math.min((long)this.maxBackoff, this.nextDelay.get() * 2L), (long)this.initBackoff));
        }
    }

    protected abstract boolean shouldIncreaseDelay(Exception var1);
}

