/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.tencent.beacon.event.open.BeaconConfig;
import com.tencent.beacon.event.open.BeaconReport;
import com.tencent.qcloud.track.service.ATrackService;
import com.tencent.qcloud.track.service.BeaconTrackService;
import com.tencent.qcloud.track.service.ClsTrackService;
import com.tencent.qcloud.track.utils.NetworkUtils;
import com.tencent.qimei.sdk.IQimeiSDK;
import com.tencent.qimei.sdk.QimeiSDK;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QCloudTrackService {
    private static final String TAG = "TrackService";
    private static final String EVENT_KEY_CLS_REPORT = "cls_report";
    private Context context;
    private final Map<String, List<ATrackService>> trackServiceMap = new HashMap<String, List<ATrackService>>();
    private BeaconTrackService simpleDataTrackService;
    private static volatile QCloudTrackService instance;
    private boolean isInitialized = false;
    private Map<String, String> businessParams;
    private Map<String, String> commonParams;

    private QCloudTrackService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QCloudTrackService getInstance() {
        if (instance != null) return instance;
        Class<QCloudTrackService> clazz = QCloudTrackService.class;
        synchronized (QCloudTrackService.class) {
            if (instance != null) return instance;
            instance = new QCloudTrackService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void addTrackService(String eventCode, ATrackService trackService) {
        if (this.trackServiceMap.get(eventCode) == null) {
            this.trackServiceMap.put(eventCode, new ArrayList());
        }
        this.trackServiceMap.get(eventCode).add(trackService);
    }

    public synchronized void init(Context context) {
        try {
            if (!this.isInitialized) {
                this.context = context.getApplicationContext();
                this.commonParams = this.getCommonParams();
                if (BeaconTrackService.isInclude()) {
                    this.initBeaconAndQimei();
                    this.simpleDataTrackService = new BeaconTrackService();
                    this.simpleDataTrackService.setContext(context);
                    this.simpleDataTrackService.init("0AND05KOZX0E3L2H");
                } else {
                    Log.i((String)TAG, (String)"The beacon library is not referenced, cancel the beacon initialization");
                }
                this.isInitialized = true;
            } else {
                Log.d((String)TAG, (String)"init has been called and the initialization code will not be executed again.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void report(String eventCode, Map<String, String> params) {
        try {
            if (this.commonParams != null && this.commonParams.size() > 0) {
                params.putAll(this.commonParams);
            }
            if (this.businessParams != null && this.businessParams.size() > 0) {
                params.putAll(this.businessParams);
            }
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry.getValue() != null) continue;
                params.put(entry.getKey(), "null");
            }
            List<ATrackService> list = this.trackServiceMap.get(eventCode);
            if (list != null) {
                for (ATrackService trackService : list) {
                    trackService.report(eventCode, params);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reportSimpleData(String eventCode, Map<String, String> params) {
        if (this.simpleDataTrackService == null) {
            return;
        }
        try {
            if (this.commonParams != null && this.commonParams.size() > 0) {
                params.putAll(this.commonParams);
            }
            if (this.businessParams != null && this.businessParams.size() > 0) {
                params.putAll(this.businessParams);
            }
            params.put(EVENT_KEY_CLS_REPORT, String.valueOf(ClsTrackService.isInclude()));
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry.getValue() != null) continue;
                params.put(entry.getKey(), "null");
            }
            this.simpleDataTrackService.report(eventCode, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBusinessParams(Map<String, String> businessParamsArg) {
        this.businessParams = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : businessParamsArg.entrySet()) {
            this.businessParams.put("business_" + entry.getKey(), entry.getValue());
        }
    }

    public void setIsCloseReport(boolean isCloseReport) {
        if (this.simpleDataTrackService != null) {
            this.simpleDataTrackService.setIsCloseReport(isCloseReport);
        }
        for (String eventCode : this.trackServiceMap.keySet()) {
            List<ATrackService> list = this.trackServiceMap.get(eventCode);
            if (list == null) continue;
            for (ATrackService trackService : list) {
                trackService.setIsCloseReport(isCloseReport);
            }
        }
    }

    public void setDebug(boolean debug) {
        if (this.simpleDataTrackService != null) {
            this.simpleDataTrackService.setDebug(debug);
        }
        for (String eventCode : this.trackServiceMap.keySet()) {
            List<ATrackService> list = this.trackServiceMap.get(eventCode);
            if (list == null) continue;
            for (ATrackService trackService : list) {
                trackService.setDebug(debug);
            }
        }
    }

    private void initBeaconAndQimei() {
        BeaconConfig.Builder builder = BeaconConfig.builder().auditEnable(false).bidEnable(false).qmspEnable(false).pagePathEnable(false).setNormalPollingTime(30000L);
        BeaconConfig config = builder.build();
        BeaconReport beaconReport = BeaconReport.getInstance();
        try {
            beaconReport.setCollectProcessInfo(false);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            IQimeiSDK qimeiSDK = QimeiSDK.getInstance((String)"0AND05KOZX0E3L2H");
            qimeiSDK.getStrategy().enableOAID(false).enableIMEI(false).enableIMSI(false).enableAndroidId(false).enableMAC(false).enableCid(false).enableProcessInfo(false).enableBuildModel(false);
            beaconReport.start(this.context, "0AND05KOZX0E3L2H", config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            beaconReport.setCollectProcessInfo(false);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    private Map<String, String> getCommonParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        String hostPackageName = this.context.getPackageName();
        params.put("boundle_id", hostPackageName);
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(hostPackageName, 0);
            String hostVersionName = packageInfo.versionName;
            long hostVersionCode = Build.VERSION.SDK_INT >= 28 ? packageInfo.getLongVersionCode() : (long)packageInfo.versionCode;
            params.put("app_version_code", String.valueOf(hostVersionCode));
            params.put("app_version_name", hostVersionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        params.put("os_name", "Android");
        params.put("os_version", Build.VERSION.RELEASE);
        params.put("client_local_ip", NetworkUtils.getLocalMachineIP());
        params.put("client_proxy", String.valueOf(NetworkUtils.isProxy()));
        params.put("network_type", NetworkUtils.getNetworkType(this.context));
        return params;
    }
}

