/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TrackExecutors {
    public static final ThreadPoolExecutor COMMAND_EXECUTOR = new ThreadPoolExecutor(5, 5, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new TaskThreadFactory("Command-", 5));

    static {
        COMMAND_EXECUTOR.allowCoreThreadTimeOut(true);
    }

    static final class TaskThreadFactory
    implements ThreadFactory {
        private final AtomicInteger increment = new AtomicInteger(1);
        private final String tag;
        private final int priority;

        TaskThreadFactory(String tag, int priority) {
            this.tag = tag;
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread newThread = new Thread(runnable, "Track-" + this.tag + this.increment.getAndIncrement());
            newThread.setDaemon(false);
            newThread.setPriority(this.priority);
            return newThread;
        }
    }
}

