/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track.service;

import android.content.Context;
import android.util.Log;
import com.tencent.beacon.event.open.BeaconEvent;
import com.tencent.beacon.event.open.BeaconReport;
import com.tencent.beacon.event.open.EventResult;
import com.tencent.beacon.event.open.EventType;
import com.tencent.qcloud.track.TrackExecutors;
import com.tencent.qcloud.track.service.ATrackService;
import com.tencent.qcloud.track.utils.EventFileUtils;
import java.util.ArrayList;
import java.util.Map;

public class BeaconTrackService
extends ATrackService {
    private static final String TAG = "BeaconTrackService";
    private Context context;
    private String beaconKey;

    public void init(String beaconKey) {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.beaconKey = beaconKey;
        if (BeaconTrackService.isInclude()) {
            BeaconReport.getInstance().setLogAble(this.isDebug());
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }

    private boolean isSimpleDataTrackService() {
        return "0AND05KOZX0E3L2H".equals(this.beaconKey);
    }

    @Override
    public void report(String eventCode, Map<String, String> params) {
        if (!this.isInit && !this.isSimpleDataTrackService()) {
            TrackExecutors.COMMAND_EXECUTOR.execute(() -> EventFileUtils.appendEventToFile(this.context, eventCode, params));
        }
        if (this.isCloseReport() || !this.isInit || !BeaconTrackService.isInclude()) {
            return;
        }
        if (!this.isSimpleDataTrackService() && EventFileUtils.eventFileExists(this.context)) {
            TrackExecutors.COMMAND_EXECUTOR.execute(() -> {
                ArrayList<String> eventCodes = new ArrayList<String>();
                ArrayList<Map<String, String>> paramsList = new ArrayList<Map<String, String>>();
                EventFileUtils.readEventFromFile(this.context, eventCodes, paramsList);
                for (int i = 0; i < eventCodes.size(); ++i) {
                    this.directReport((String)eventCodes.get(i), (Map)paramsList.get(i));
                }
            });
        }
        this.directReport(eventCode, params);
    }

    private void directReport(String eventCode, Map<String, String> params) {
        BeaconEvent.Builder builder = BeaconEvent.builder().withAppKey(this.beaconKey).withCode(eventCode).withType(EventType.NORMAL).withParams(params);
        EventResult result = BeaconReport.getInstance().report(builder.build());
        if (this.isDebug()) {
            StringBuilder mapAsString = new StringBuilder("{");
            for (String key : params.keySet()) {
                mapAsString.append(key + "=" + params.get(key) + ", ");
            }
            mapAsString.delete(mapAsString.length() - 2, mapAsString.length()).append("}");
            Log.i((String)TAG, (String)String.format("beaconKey: %s, eventCode: %s, params: %s => result{ eventID: %s, errorCode: %d, errorMsg: %s}", this.beaconKey, eventCode, mapAsString, result.eventID, result.errorCode, result.errMsg));
        }
    }

    @Override
    public void setDebug(boolean debug) {
        super.setDebug(debug);
        if (BeaconTrackService.isInclude()) {
            BeaconReport.getInstance().setLogAble(debug);
        }
    }

    public static boolean isInclude() {
        try {
            Class.forName("com.tencent.beacon.event.open.BeaconReport");
            Class.forName("com.tencent.qimei.sdk.QimeiSDK");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

