/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.queue.MediaListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaQueueRequest;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class PicProcessJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        PicProcessJobDemo.describePicProcessQueues(client);
    }

    public static void createPicProcessJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-1234567890");
        request.setTag("PicProcess");
        request.getInput().setObject("1.png");
        request.getOperation().getOutput().setBucket("demo-1234567890");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("2.png");
        request.getOperation().getPicProcess().setProcessRule("imageMogr2/rotate/90");
        request.getOperation().getPicProcess().setIsPicInfo("true");
        request.setQueueId("p86ede0188f844ac99d50f5fa63005237");
        request.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponse response = client.createPicProcessJob(request);
        System.out.println(response);
    }

    public static void describeJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("cabd41ea0355b11ed847a618901112dcf");
        MediaJobResponse response = client.describeMediaJob(request);
        System.out.println(Jackson.toJsonString(response.getJobsDetail().getOperation()));
    }

    public static void describeJobs(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-1234567890");
        request.setQueueId("p9900025e4ec44b5e8225e70a5217****");
        request.setTag("PicProcess");
        MediaListJobResponse response = client.describeMediaJobs(request);
        List<MediaJobObject> jobsDetail = response.getJobsDetailList();
        for (MediaJobObject mediaJobObject : jobsDetail) {
            System.out.println(mediaJobObject.getOperation().getTranscode());
        }
    }

    public static void describePicProcessQueues(COSClient client) {
        MediaQueueRequest request = new MediaQueueRequest();
        request.setBucketName("demo-1234567890");
        MediaListQueueResponse response = client.describePicProcessQueues(request);
        System.out.println(response);
    }
}

