/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.http.DefaultCosHttpClient;
import com.qcloud.cos.thirdparty.org.apache.http.HttpResponse;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpRequestBase;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.qcloud.cos.thirdparty.org.apache.http.protocol.HttpContext;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOutCosHttpClient
extends DefaultCosHttpClient {
    private ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 5);
    private static final Logger log = LoggerFactory.getLogger(TimeOutCosHttpClient.class);

    public TimeOutCosHttpClient(ClientConfig clientConfig) {
        super(clientConfig);
    }

    @Override
    protected HttpResponse executeOneRequest(HttpContext context, HttpRequestBase httpRequest) throws Exception {
        HttpRequestTask httpRequestTask = new HttpRequestTask(httpRequest, context);
        Future<HttpResponse> future = this.threadPool.submit(httpRequestTask);
        return future.get(this.clientConfig.getRequestTimeout(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.threadPool.shutdown();
        try {
            int shutdown_timeout = this.clientConfig.getShutdownTimeout();
            if (!this.threadPool.awaitTermination(shutdown_timeout, TimeUnit.MILLISECONDS)) {
                log.warn("The threadPool has not shutdown successfully during the last " + shutdown_timeout / 1000 + " seconds");
                this.threadPool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.threadPool.shutdownNow();
        }
        super.shutdown();
    }

    class HttpRequestTask
    implements Callable<HttpResponse> {
        private HttpRequestBase httpRequest;
        private HttpContext httpContext;

        public HttpRequestTask(HttpRequestBase httpRequest, HttpContext httpContext) {
            this.httpRequest = httpRequest;
            this.httpContext = httpContext;
        }

        @Override
        public HttpResponse call() throws Exception {
            return TimeOutCosHttpClient.this.httpClient.execute((HttpUriRequest)this.httpRequest, this.httpContext);
        }
    }
}

