/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.AbortedException;
import com.qcloud.cos.internal.Releasable;
import com.qcloud.cos.thirdparty.org.apache.commons.logging.LogFactory;
import com.qcloud.cos.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;

public abstract class SdkInputStream
extends InputStream
implements Releasable {
    protected abstract InputStream getWrappedInputStream();

    protected static boolean shouldAbort() {
        return Thread.interrupted();
    }

    protected final void abortIfNeeded() {
        if (SdkInputStream.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug("FYI", e);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }

    @Override
    public void release() {
        IOUtils.closeQuietly(this, null);
        InputStream in = this.getWrappedInputStream();
        if (in instanceof Releasable) {
            Releasable r = (Releasable)((Object)in);
            r.release();
        }
    }
}

