/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.dh;

import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.generators.DHParametersGenerator;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.params.DHParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.util.BaseAlgorithmParameterGeneratorSpi;
import com.qcloud.cos.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class AlgorithmParameterGeneratorSpi
extends BaseAlgorithmParameterGeneratorSpi {
    protected SecureRandom random;
    protected int strength = 2048;
    private int l = 0;

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("DH parameter generator requires a DHGenParameterSpec for initialisation");
        }
        DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        this.strength = dHGenParameterSpec.getPrimeSize();
        this.l = dHGenParameterSpec.getExponentSize();
        this.random = secureRandom;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algorithmParameters;
        DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
        int n = PrimeCertaintyCalculator.getDefaultCertainty(this.strength);
        dHParametersGenerator.init(this.strength, n, CryptoServicesRegistrar.getSecureRandom(this.random));
        DHParameters dHParameters = dHParametersGenerator.generateParameters();
        try {
            algorithmParameters = this.createParametersInstance("DH");
            algorithmParameters.init(new DHParameterSpec(dHParameters.getP(), dHParameters.getG(), this.l));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return algorithmParameters;
    }
}

