/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.provider.sphincs;

import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.qcloud.cos.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.digests.SHA3Digest;
import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.digests.SHA512tDigest;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyGenerationParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.sphincs.SPHINCS256KeyPairGenerator;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPrivateKeyParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.spec.SPHINCS256KeyGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class Sphincs256KeyPairGeneratorSpi
extends KeyPairGenerator {
    ASN1ObjectIdentifier treeDigest = NISTObjectIdentifiers.id_sha512_256;
    SPHINCS256KeyGenerationParameters param;
    SPHINCS256KeyPairGenerator engine = new SPHINCS256KeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public Sphincs256KeyPairGeneratorSpi() {
        super("SPHINCS256");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof SPHINCS256KeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a SPHINCS256KeyGenParameterSpec");
        }
        SPHINCS256KeyGenParameterSpec sPHINCS256KeyGenParameterSpec = (SPHINCS256KeyGenParameterSpec)algorithmParameterSpec;
        if (sPHINCS256KeyGenParameterSpec.getTreeDigest().equals("SHA512-256")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha512_256;
            this.param = new SPHINCS256KeyGenerationParameters(secureRandom, new SHA512tDigest(256));
        } else if (sPHINCS256KeyGenParameterSpec.getTreeDigest().equals("SHA3-256")) {
            this.treeDigest = NISTObjectIdentifiers.id_sha3_256;
            this.param = new SPHINCS256KeyGenerationParameters(secureRandom, new SHA3Digest(256));
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new SPHINCS256KeyGenerationParameters(this.random, new SHA512tDigest(256));
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        SPHINCSPublicKeyParameters sPHINCSPublicKeyParameters = (SPHINCSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        SPHINCSPrivateKeyParameters sPHINCSPrivateKeyParameters = (SPHINCSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCSphincs256PublicKey(this.treeDigest, sPHINCSPublicKeyParameters), new BCSphincs256PrivateKey(this.treeDigest, sPHINCSPrivateKeyParameters));
    }
}

