/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.provider.rainbow;

import com.qcloud.cos.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowKeyGenerationParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowKeyPairGenerator;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPrivateKey;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.provider.rainbow.BCRainbowPublicKey;
import com.qcloud.cos.thirdparty.org.bouncycastle.pqc.jcajce.spec.RainbowParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class RainbowKeyPairGeneratorSpi
extends KeyPairGenerator {
    RainbowKeyGenerationParameters param;
    RainbowKeyPairGenerator engine = new RainbowKeyPairGenerator();
    int strength = 1024;
    SecureRandom random = new SecureRandom();
    boolean initialised = false;

    public RainbowKeyPairGeneratorSpi() {
        super("Rainbow");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RainbowParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a RainbowParameterSpec");
        }
        RainbowParameterSpec rainbowParameterSpec = (RainbowParameterSpec)algorithmParameterSpec;
        this.param = new RainbowKeyGenerationParameters(secureRandom, new RainbowParameters(rainbowParameterSpec.getVi()));
        this.engine.init(this.param);
        this.initialised = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new RainbowKeyGenerationParameters(this.random, new RainbowParameters(new RainbowParameterSpec().getVi()));
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        RainbowPublicKeyParameters rainbowPublicKeyParameters = (RainbowPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        RainbowPrivateKeyParameters rainbowPrivateKeyParameters = (RainbowPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCRainbowPublicKey(rainbowPublicKeyParameters), new BCRainbowPrivateKey(rainbowPrivateKeyParameters));
    }
}

