/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.event.ProgressInputStream;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.ResponseNotCompleteException;
import com.qcloud.cos.http.CosHttpClient;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.http.IdleConnectionMonitorThread;
import com.qcloud.cos.internal.CosErrorResponseHandler;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.SdkBufferedInputStream;
import com.qcloud.cos.retry.BackoffStrategy;
import com.qcloud.cos.retry.RetryPolicy;
import com.qcloud.cos.thirdparty.org.apache.commons.codec.binary.Base64;
import com.qcloud.cos.thirdparty.org.apache.http.Header;
import com.qcloud.cos.thirdparty.org.apache.http.HttpHost;
import com.qcloud.cos.thirdparty.org.apache.http.HttpResponse;
import com.qcloud.cos.thirdparty.org.apache.http.StatusLine;
import com.qcloud.cos.thirdparty.org.apache.http.client.HttpClient;
import com.qcloud.cos.thirdparty.org.apache.http.client.config.RequestConfig;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpDelete;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpGet;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpHead;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpPost;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpPut;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpRequestBase;
import com.qcloud.cos.thirdparty.org.apache.http.client.methods.HttpUriRequest;
import com.qcloud.cos.thirdparty.org.apache.http.client.protocol.HttpClientContext;
import com.qcloud.cos.thirdparty.org.apache.http.entity.InputStreamEntity;
import com.qcloud.cos.thirdparty.org.apache.http.impl.client.HttpClientBuilder;
import com.qcloud.cos.thirdparty.org.apache.http.impl.client.HttpClients;
import com.qcloud.cos.thirdparty.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.qcloud.cos.thirdparty.org.apache.http.protocol.HttpContext;
import com.qcloud.cos.utils.CodecUtils;
import com.qcloud.cos.utils.ExceptionUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import com.qcloud.cos.utils.ValidationUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosHttpClient
implements CosHttpClient {
    private ClientConfig clientConfig;
    private RequestConfig requestConfig;
    private HttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;
    private IdleConnectionMonitorThread idleConnectionMonitor;
    private int maxErrorRetry;
    private RetryPolicy retryPolicy;
    private BackoffStrategy backoffStrategy;
    private CosErrorResponseHandler errorResponseHandler = new CosErrorResponseHandler();
    private static final Logger log = LoggerFactory.getLogger(DefaultCosHttpClient.class);

    public DefaultCosHttpClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.maxErrorRetry = clientConfig.getMaxErrorRetry();
        this.retryPolicy = ValidationUtils.assertNotNull(clientConfig.getRetryPolicy(), "retry policy");
        this.backoffStrategy = ValidationUtils.assertNotNull(clientConfig.getBackoffStrategy(), "backoff strategy");
        this.initHttpClient();
    }

    private void initHttpClient() {
        this.connectionManager.setMaxTotal(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setValidateAfterInactivity(1);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(this.connectionManager);
        if (this.clientConfig.getHttpProxyIp() != null && this.clientConfig.getHttpProxyPort() != 0) {
            HttpHost proxy = new HttpHost(this.clientConfig.getHttpProxyIp(), this.clientConfig.getHttpProxyPort());
            httpClientBuilder.setProxy(proxy);
        }
        this.httpClient = httpClientBuilder.build();
        this.requestConfig = RequestConfig.custom().setContentCompressionEnabled(false).setConnectionRequestTimeout(this.clientConfig.getConnectionRequestTimeout()).setConnectTimeout(this.clientConfig.getConnectionTimeout()).setSocketTimeout(this.clientConfig.getSocketTimeout()).build();
        this.idleConnectionMonitor = new IdleConnectionMonitorThread(this.connectionManager);
        this.idleConnectionMonitor.setIdleAliveMS(this.clientConfig.getIdleConnectionAlive());
        this.idleConnectionMonitor.setDaemon(true);
        this.idleConnectionMonitor.start();
    }

    @Override
    public void shutdown() {
        this.idleConnectionMonitor.shutdown();
    }

    private <X extends CosServiceRequest> URI buildUri(CosHttpRequest<X> request) {
        String paramKey;
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append(request.getProtocol().toString()).append("://").append(request.getEndpoint());
        String encodedPath = UrlEncoderUtils.encodeUrlPath(request.getResourcePath());
        urlBuffer.append(encodedPath);
        StringBuffer paramBuffer = new StringBuffer();
        boolean seeOne = false;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.putAll(request.getParameters());
        Map<String, List<String>> customParamsList = ((CosServiceRequest)request.getOriginalRequest()).getCustomQueryParameters();
        if (customParamsList != null) {
            for (Map.Entry<String, List<String>> entry : customParamsList.entrySet()) {
                paramKey = entry.getKey();
                List<String> paramValueList = entry.getValue();
                int paramValueNum = paramValueList.size();
                for (int paramValueIndex = 0; paramValueIndex < paramValueNum; ++paramValueIndex) {
                    requestParams.put(paramKey, paramValueList.get(paramValueIndex));
                }
            }
        }
        for (Map.Entry<String, List<String>> entry : requestParams.entrySet()) {
            String paramValue;
            paramKey = entry.getKey();
            if (paramKey == null) continue;
            if (seeOne) {
                paramBuffer.append("&");
            }
            paramBuffer.append(UrlEncoderUtils.encode(paramKey));
            if (!seeOne) {
                seeOne = true;
            }
            if ((paramValue = (String)((Object)entry.getValue())) == null) continue;
            paramBuffer.append("=");
            paramBuffer.append(UrlEncoderUtils.encode(paramValue));
        }
        String paramStr = paramBuffer.toString();
        if (!paramStr.isEmpty()) {
            urlBuffer.append("?").append(paramStr);
        }
        try {
            URI uRI = new URI(urlBuffer.toString());
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CosClientException("build uri error! url: " + urlBuffer.toString() + ", CosHttpRequest: " + request.toString(), uRISyntaxException);
        }
    }

    private <X extends CosServiceRequest> HttpRequestBase buildHttpRequest(CosHttpRequest<X> request) throws CosClientException {
        HttpRequestBase httpRequestBase = null;
        HttpMethodName httpMethodName = request.getHttpMethod();
        if (httpMethodName.equals((Object)HttpMethodName.PUT)) {
            httpRequestBase = new HttpPut();
        } else if (httpMethodName.equals((Object)HttpMethodName.GET)) {
            httpRequestBase = new HttpGet();
        } else if (httpMethodName.equals((Object)HttpMethodName.DELETE)) {
            httpRequestBase = new HttpDelete();
        } else if (httpMethodName.equals((Object)HttpMethodName.POST)) {
            httpRequestBase = new HttpPost();
        } else if (httpMethodName.equals((Object)HttpMethodName.HEAD)) {
            httpRequestBase = new HttpHead();
        } else {
            throw new CosClientException("unsupported http method " + (Object)((Object)httpMethodName));
        }
        httpRequestBase.setURI(this.buildUri(request));
        long contentLength = -1L;
        Map<String, String> requestHeaders = request.getHeaders();
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            String string = entry.getKey();
            String headerValue = entry.getValue();
            if (string.equals("Content-Length")) {
                contentLength = Long.parseLong(headerValue);
                continue;
            }
            headerValue = CodecUtils.convertFromUtf8ToIso88591(headerValue);
            httpRequestBase.addHeader(string, headerValue);
        }
        Map<String, String> customRequestHeaders = ((CosServiceRequest)request.getOriginalRequest()).getCustomRequestHeaders();
        if (customRequestHeaders != null) {
            for (Map.Entry<String, String> entry : customRequestHeaders.entrySet()) {
                String headerKey = entry.getKey();
                String headerValue = entry.getValue();
                if (headerKey.equals("Content-Length")) {
                    contentLength = Long.parseLong(headerValue);
                    continue;
                }
                headerValue = CodecUtils.convertFromUtf8ToIso88591(headerValue);
                httpRequestBase.addHeader(headerKey, headerValue);
            }
        }
        if (log.isDebugEnabled()) {
            httpRequestBase.addHeader("x-cos-sdk-log-debug", "on");
        } else {
            httpRequestBase.addHeader("x-cos-sdk-log-debug", "off");
        }
        if (request.getContent() != null) {
            InputStreamEntity inputStreamEntity = new InputStreamEntity(request.getContent(), contentLength);
            if (httpMethodName.equals((Object)HttpMethodName.PUT) || httpMethodName.equals((Object)HttpMethodName.POST)) {
                HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = (HttpEntityEnclosingRequestBase)httpRequestBase;
                httpEntityEnclosingRequestBase.setEntity(inputStreamEntity);
            }
        }
        httpRequestBase.setConfig(this.requestConfig);
        if (this.clientConfig.useBasicAuth()) {
            this.setBasicProxyAuthorization(httpRequestBase);
        }
        return httpRequestBase;
    }

    private boolean isRequestSuccessful(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = -1;
        if (statusLine != null) {
            statusCode = statusLine.getStatusCode();
        }
        return statusCode / 100 == 2;
    }

    private <X extends CosServiceRequest> CosHttpResponse createResponse(HttpRequestBase httpRequestBase, CosHttpRequest<X> request, HttpResponse apacheHttpResponse) throws IOException {
        ProgressListener progressListener = request.getProgressListener();
        CosHttpResponse httpResponse = new CosHttpResponse(request, httpRequestBase);
        if (apacheHttpResponse.getEntity() != null) {
            InputStream oriIn = apacheHttpResponse.getEntity().getContent();
            InputStream progressIn = null;
            if (oriIn != null) {
                progressIn = ProgressInputStream.inputStreamForResponse(oriIn, progressListener);
                httpResponse.setContent(progressIn);
            }
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            String value = CodecUtils.convertFromIso88591ToUtf8(header.getValue());
            httpResponse.addHeader(header.getName(), value);
        }
        return httpResponse;
    }

    private <X extends CosServiceRequest> CosServiceException handlerErrorMessage(CosHttpRequest<X> request, HttpRequestBase httpRequestBase, HttpResponse apacheHttpResponse) throws IOException {
        String reasonPhrase;
        int statusCode;
        StatusLine statusLine = apacheHttpResponse.getStatusLine();
        if (statusLine == null) {
            statusCode = -1;
            reasonPhrase = null;
        } else {
            statusCode = statusLine.getStatusCode();
            reasonPhrase = statusLine.getReasonPhrase();
        }
        CosHttpResponse response = this.createResponse(httpRequestBase, request, apacheHttpResponse);
        CosServiceException exception = null;
        try {
            exception = this.errorResponseHandler.handle(response);
            log.debug("Received error response: " + exception);
        }
        catch (Exception e) {
            if (statusCode == 413) {
                exception = new CosServiceException("Request entity too large");
                exception.setStatusCode(statusCode);
                exception.setErrorType(CosServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (statusCode == 503 && "Service Unavailable".equalsIgnoreCase(reasonPhrase)) {
                exception = new CosServiceException("Service unavailable");
                exception.setStatusCode(statusCode);
                exception.setErrorType(CosServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + "). Response Code: " + (statusLine == null ? "None" : Integer.valueOf(statusCode)) + ", Response Text: " + reasonPhrase;
            throw new CosClientException(errorMessage, e);
        }
        exception.setStatusCode(statusCode);
        exception.fillInStackTrace();
        return exception;
    }

    private <X extends CosServiceRequest> void bufferAndResetAbleContent(CosHttpRequest<X> request) {
        InputStream origContent = request.getContent();
        if (origContent != null) {
            InputStream toBeClosed = this.buffer(this.makeResettable(origContent));
            InputStream notCloseable = toBeClosed == null ? null : (InputStream)ReleasableInputStream.wrap(toBeClosed).disableClose();
            request.setContent(notCloseable);
        }
    }

    private InputStream monitorStreamProgress(ProgressListener listener, InputStream content) {
        return ProgressInputStream.inputStreamForRequest(content, listener);
    }

    private void setBasicProxyAuthorization(HttpRequestBase httpRequest) {
        String auth = this.clientConfig.getProxyUsername() + ":" + this.clientConfig.getProxyPassword();
        String authHeader = "Basic " + new String(Base64.encodeBase64(auth.getBytes()));
        httpRequest.addHeader("Proxy-Authorization", authHeader);
    }

    private <X extends CosServiceRequest> void checkResponse(CosHttpRequest<X> request, HttpRequestBase httpRequest, HttpResponse httpResponse) {
        if (!this.isRequestSuccessful(httpResponse)) {
            try {
                try {
                    throw this.handlerErrorMessage(request, httpRequest, httpResponse);
                }
                catch (IOException ioe) {
                    String errorMsg = "Unable to execute HTTP request: " + ioe.getMessage();
                    log.error(errorMsg, (Throwable)ioe);
                    CosServiceException cse = new CosServiceException(errorMsg, ioe);
                    throw cse;
                }
            }
            catch (Throwable throwable) {
                httpRequest.abort();
                throw throwable;
            }
        }
    }

    private <X extends CosServiceRequest> boolean isRetryableRequest(CosHttpRequest<X> request) {
        return request.getContent() == null || request.getContent().markSupported();
    }

    private <X extends CosServiceRequest> boolean shouldRetry(CosHttpRequest<X> request, HttpResponse response, Exception exception, int retryIndex, RetryPolicy retryPolicy) {
        if (retryIndex >= this.maxErrorRetry) {
            return false;
        }
        if (!this.isRetryableRequest(request)) {
            return false;
        }
        return retryPolicy.shouldRetry(request, response, exception, retryIndex);
    }

    private HttpResponse executeOneRequest(HttpContext context, HttpRequestBase httpRequest) {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, context);
        }
        catch (IOException e) {
            httpRequest.abort();
            throw ExceptionUtils.createClientException(e);
        }
        return httpResponse;
    }

    private void closeHttpResponseStream(HttpResponse httpResponse) {
        try {
            if (httpResponse != null && httpResponse.getEntity() != null && httpResponse.getEntity().getContent() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
        catch (IOException e) {
            log.error("exception occur:", (Throwable)e);
        }
    }

    @Override
    public <X, Y extends CosServiceRequest> X exeute(CosHttpRequest<Y> request, HttpResponseHandler<CosServiceResponse<X>> responseHandler) throws CosClientException, CosServiceException {
        String errorMsg;
        HttpResponse httpResponse = null;
        HttpRequestBase httpRequest = null;
        this.bufferAndResetAbleContent(request);
        ProgressListener progressListener = request.getProgressListener();
        InputStream originalContent = request.getContent();
        if (originalContent != null) {
            request.setContent(this.monitorStreamProgress(progressListener, originalContent));
        }
        if (originalContent != null && originalContent.markSupported() && !(originalContent instanceof BufferedInputStream)) {
            int readLimit = this.clientConfig.getReadLimit();
            originalContent.mark(readLimit);
        }
        int retryIndex = 0;
        while (true) {
            try {
                this.checkInterrupted();
                if (originalContent instanceof BufferedInputStream && originalContent.markSupported()) {
                    int readLimit = this.clientConfig.getReadLimit();
                    originalContent.mark(readLimit);
                }
                if (retryIndex != 0 && originalContent != null) {
                    originalContent.reset();
                }
                if (retryIndex != 0) {
                    long delay = this.backoffStrategy.computeDelayBeforeNextRetry(retryIndex);
                    Thread.sleep(delay);
                }
                HttpClientContext context = HttpClientContext.create();
                httpRequest = this.buildHttpRequest(request);
                httpResponse = null;
                httpResponse = this.executeOneRequest(context, httpRequest);
                this.checkResponse(request, httpRequest, httpResponse);
            }
            catch (CosServiceException cse) {
                if (cse.getStatusCode() >= 500) {
                    errorMsg = String.format("failed to execute http request, due to service exception, httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", request.toString(), retryIndex, this.maxErrorRetry);
                    log.error(errorMsg, (Throwable)cse);
                }
                this.closeHttpResponseStream(httpResponse);
                if (this.shouldRetry(request, httpResponse, cse, retryIndex, this.retryPolicy)) continue;
                throw cse;
            }
            catch (CosClientException cce) {
                errorMsg = String.format("failed to execute http request, due to client exception, httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", request.toString(), retryIndex, this.maxErrorRetry);
                log.info(errorMsg, (Throwable)cce);
                this.closeHttpResponseStream(httpResponse);
                if (this.shouldRetry(request, httpResponse, cce, retryIndex, this.retryPolicy)) continue;
                log.error(errorMsg, (Throwable)cce);
                throw cce;
            }
            catch (Exception exp) {
                errorMsg = String.format("httpClient execute occur a unknow exception, httpRequest: %s", request.toString());
                this.closeHttpResponseStream(httpResponse);
                log.error(errorMsg, (Throwable)exp);
                throw new CosClientException(errorMsg, exp);
            }
            finally {
                ++retryIndex;
                continue;
            }
            break;
        }
        try {
            CosHttpResponse cosHttpResponse = this.createResponse(httpRequest, request, httpResponse);
            errorMsg = responseHandler.handle(cosHttpResponse).getResult();
            return (X)errorMsg;
        }
        catch (Exception e) {
            if (e.getMessage().equals("Premature end of chunk coded message body: closing chunk expected")) {
                throw new ResponseNotCompleteException("response chunk not complete", e);
            }
            errorMsg = "Unable to execute response handle: " + e.getMessage();
            log.info(errorMsg, (Throwable)e);
            CosClientException cce = new CosClientException(errorMsg, e);
            throw cce;
        }
        finally {
            if (!responseHandler.needsConnectionLeftOpen()) {
                httpRequest.releaseConnection();
            }
        }
    }

    private InputStream makeResettable(InputStream content) {
        block3: {
            if (!content.markSupported() && content instanceof FileInputStream) {
                try {
                    return new ResettableInputStream((FileInputStream)content);
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("For the record; ignore otherwise", (Throwable)e);
                }
            }
        }
        return content;
    }

    private InputStream buffer(InputStream content) {
        if (!content.markSupported()) {
            content = new SdkBufferedInputStream(content);
        }
        return content;
    }

    private void checkInterrupted() throws CosClientException {
        if (Thread.interrupted()) {
            throw new CosClientException("operation has been interrupted!");
        }
    }
}

