/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.thirdparty.org.bouncycastle.jce.spec;

import com.qcloud.cos.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.ECAlgorithms;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.ECCurve;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.field.FiniteField;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.field.Polynomial;
import com.qcloud.cos.thirdparty.org.bouncycastle.math.field.PolynomialExtensionField;
import com.qcloud.cos.thirdparty.org.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECNamedCurveSpec
extends ECParameterSpec {
    private String name;

    private static EllipticCurve convertCurve(ECCurve eCCurve, byte[] byArray) {
        ECField eCField = ECNamedCurveSpec.convertField(eCCurve.getField());
        BigInteger bigInteger = eCCurve.getA().toBigInteger();
        BigInteger bigInteger2 = eCCurve.getB().toBigInteger();
        return new EllipticCurve(eCField, bigInteger, bigInteger2, byArray);
    }

    private static ECField convertField(FiniteField finiteField) {
        if (ECAlgorithms.isFpField(finiteField)) {
            return new ECFieldFp(finiteField.getCharacteristic());
        }
        Polynomial polynomial = ((PolynomialExtensionField)finiteField).getMinimalPolynomial();
        int[] nArray = polynomial.getExponentsPresent();
        int[] nArray2 = Arrays.reverse(Arrays.copyOfRange(nArray, 1, nArray.length - 1));
        return new ECFieldF2m(polynomial.getDegree(), nArray2);
    }

    public ECNamedCurveSpec(String string, ECCurve eCCurve, com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.ECPoint eCPoint, BigInteger bigInteger) {
        super(ECNamedCurveSpec.convertCurve(eCCurve, null), EC5Util.convertPoint(eCPoint), bigInteger, 1);
        this.name = string;
    }

    public ECNamedCurveSpec(String string, EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger) {
        super(ellipticCurve, eCPoint, bigInteger, 1);
        this.name = string;
    }

    public ECNamedCurveSpec(String string, ECCurve eCCurve, com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        super(ECNamedCurveSpec.convertCurve(eCCurve, null), EC5Util.convertPoint(eCPoint), bigInteger, bigInteger2.intValue());
        this.name = string;
    }

    public ECNamedCurveSpec(String string, EllipticCurve ellipticCurve, ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        super(ellipticCurve, eCPoint, bigInteger, bigInteger2.intValue());
        this.name = string;
    }

    public ECNamedCurveSpec(String string, ECCurve eCCurve, com.qcloud.cos.thirdparty.org.bouncycastle.math.ec.ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        super(ECNamedCurveSpec.convertCurve(eCCurve, byArray), EC5Util.convertPoint(eCPoint), bigInteger, bigInteger2.intValue());
        this.name = string;
    }

    public String getName() {
        return this.name;
    }
}

