/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.common_utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonFileUtils {
    private static Logger LOG = LoggerFactory.getLogger(CommonFileUtils.class);

    public static boolean isLegalFile(String filePath) {
        File file = new File(filePath);
        return file.exists() && !file.isDirectory() && file.canRead();
    }

    public static long getFileLength(String filePath) throws Exception {
        File file = new File(filePath);
        return file.length();
    }

    public static FileInputStream getFileInputStream(String filePath) throws Exception {
        FileInputStream localFileInputStream = new FileInputStream(filePath);
        return localFileInputStream;
    }

    public static void closeFileStream(InputStream inputStream, String filePath) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOG.error("close file {} occur an IOExcpetion {}", (Object)filePath, (Object)e);
        }
    }

    public static String getFileContent(String filePath) throws Exception {
        int fileLength = Long.valueOf(CommonFileUtils.getFileLength(filePath)).intValue();
        return CommonFileUtils.getFileContent(filePath, 0L, fileLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String filePath, long offset, int length) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = CommonFileUtils.getFileInputStream(filePath);
            String string = CommonFileUtils.getFileContent(fileInputStream, offset, length);
            return string;
        }
        finally {
            CommonFileUtils.closeFileStream(fileInputStream, filePath);
        }
    }

    public static String getFileContent(InputStream inputStream, long offset, int length) throws Exception {
        byte[] fileContent = CommonFileUtils.getFileContentByte(inputStream, offset, length);
        return new String(fileContent, Charset.forName("ISO-8859-1"));
    }

    public static byte[] getFileContentByte(InputStream inputStream, long offset, int length) throws Exception {
        if (offset < 0L || length < 0) {
            throw new Exception("getFileContent param error");
        }
        byte[] fileContent = null;
        byte[] tempBuf = new byte[length];
        inputStream.skip(offset);
        int readLen = inputStream.read(tempBuf);
        if (readLen < 0) {
            fileContent = new byte[]{};
            return fileContent;
        }
        if (readLen < length) {
            fileContent = new byte[readLen];
            System.arraycopy(tempBuf, 0, fileContent, 0, readLen);
        } else {
            fileContent = tempBuf;
        }
        return fileContent;
    }

    public static void remove(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }
}

