/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.NetworkException;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.exception.ServerException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.HttpContentType;
import com.qcloud.cos.http.HttpRequest;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosHttpClient
extends AbstractCosHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCosHttpClient.class);

    public DefaultCosHttpClient(ClientConfig config) {
        super(config);
    }

    private String getErrorHttpResponseMsg(HttpRequest httpRequest, StatusLine responseStatus) {
        StringBuilder sb = new StringBuilder("HttpRequest:").append(httpRequest.toString());
        sb.append("\nHttpResponse:");
        if (responseStatus.getProtocolVersion() != null) {
            sb.append(" protocol:").append(responseStatus.getProtocolVersion().toString());
        }
        sb.append(", code:").append(responseStatus.getStatusCode());
        if (responseStatus.getReasonPhrase() != null) {
            sb.append(", reasonPhrase:").append(responseStatus.getReasonPhrase());
        }
        LOG.error(sb.toString());
        return sb.toString();
    }

    private String getExceptionMsg(HttpRequest httpRequest, String exceptionStr) {
        String errMsg = "HttpRequest:" + httpRequest.toString() + "\nException:" + exceptionStr;
        LOG.error(errMsg);
        return errMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String sendGetRequest(HttpRequest httpRequest) throws AbstractCosException {
        String url = httpRequest.getUrl();
        HttpGet httpGet = null;
        String responseStr = "";
        int retry = 0;
        int maxRetryCount = this.config.getMaxFailedRetry();
        while (retry < maxRetryCount) {
            HttpResponse httpResponse;
            String errMsg;
            block10: {
                String paramKey2;
                try {
                    URIBuilder urlBuilder = new URIBuilder(url);
                    for (String paramKey2 : httpRequest.getParams().keySet()) {
                        urlBuilder.addParameter(paramKey2, httpRequest.getParams().get(paramKey2));
                    }
                    httpGet = new HttpGet(urlBuilder.build());
                }
                catch (URISyntaxException e) {
                    errMsg = "Invalid url:" + url;
                    LOG.error(errMsg);
                    throw new ParamException(errMsg);
                }
                httpGet.setConfig(this.requestConfig);
                this.setHeaders((HttpMessage)httpGet, httpRequest.getHeaders());
                httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
                int responseStatusCode = httpResponse.getStatusLine().getStatusCode();
                if (responseStatusCode != 200 && responseStatusCode != 400) break block10;
                paramKey2 = responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                httpGet.releaseConnection();
                return paramKey2;
            }
            try {
                try {
                    String errMsg2 = this.getErrorHttpResponseMsg(httpRequest, httpResponse.getStatusLine());
                    throw new NetworkException(errMsg2);
                }
                catch (IOException | ParseException e) {
                    if (++retry == maxRetryCount) {
                        errMsg = this.getExceptionMsg(httpRequest, e.toString());
                        throw new ServerException(errMsg);
                    }
                    httpGet.releaseConnection();
                }
            }
            catch (Throwable throwable) {
                httpGet.releaseConnection();
                throw throwable;
            }
        }
        return responseStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String sendPostRequest(HttpRequest httpRequest) throws AbstractCosException {
        String url = httpRequest.getUrl();
        String responseStr = "";
        int retry = 0;
        int maxRetryCount = this.config.getMaxFailedRetry();
        while (retry < maxRetryCount) {
            HttpResponse httpResponse;
            HttpPost httpPost;
            block12: {
                httpPost = new HttpPost(url);
                httpPost.setConfig(this.requestConfig);
                Map<String, String> params = httpRequest.getParams();
                this.setHeaders((HttpMessage)httpPost, httpRequest.getHeaders());
                if (httpRequest.getContentType() == HttpContentType.APPLICATION_JSON) {
                    this.setJsonEntity(httpPost, params);
                } else if (httpRequest.getContentType() == HttpContentType.MULTIPART_FORM_DATA) {
                    try {
                        this.setMultiPartEntity(httpPost, params);
                    }
                    catch (Exception e) {
                        throw new UnknownException(e.toString());
                    }
                }
                httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
                int responseStatusCode = httpResponse.getStatusLine().getStatusCode();
                if (responseStatusCode != 200 && responseStatusCode != 400) break block12;
                String string = responseStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                httpPost.releaseConnection();
                return string;
            }
            try {
                try {
                    String errMsg = this.getErrorHttpResponseMsg(httpRequest, httpResponse.getStatusLine());
                    throw new NetworkException(errMsg);
                }
                catch (IOException | ParseException e) {
                    if (++retry == maxRetryCount) {
                        String errMsg = this.getExceptionMsg(httpRequest, e.toString());
                        throw new ServerException(errMsg);
                    }
                    httpPost.releaseConnection();
                }
            }
            catch (Throwable throwable) {
                httpPost.releaseConnection();
                throw throwable;
            }
        }
        return responseStr;
    }

    private void setJsonEntity(HttpPost httpPost, Map<String, String> params) {
        ContentType utf8TextPlain = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
        String postJsonStr = new JSONObject(params).toString();
        StringEntity stringEntity = new StringEntity(postJsonStr, utf8TextPlain);
        httpPost.setEntity((HttpEntity)stringEntity);
    }

    private void setMultiPartEntity(HttpPost httpPost, Map<String, String> params) throws Exception {
        ContentType utf8TextPlain = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (String paramKey : params.keySet()) {
            if (paramKey.equals("fileContent")) {
                entityBuilder.addBinaryBody("fileContent", params.get("fileContent").getBytes(Charset.forName("ISO-8859-1")));
                continue;
            }
            entityBuilder.addTextBody(paramKey, params.get(paramKey), utf8TextPlain);
        }
        httpPost.setEntity(entityBuilder.build());
    }

    private void setHeaders(HttpMessage message, Map<String, String> headers) {
        message.setHeader("Accept", "*/*");
        message.setHeader("Connection", "Keep-Alive");
        message.setHeader("User-Agent", this.config.getUserAgent());
        if (headers != null) {
            for (String headerKey : headers.keySet()) {
                message.setHeader(headerKey, headers.get(headerKey));
            }
        }
    }
}

