/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.op;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.common_utils.CommonPathUtils;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.HttpContentType;
import com.qcloud.cos.http.HttpMethod;
import com.qcloud.cos.http.HttpRequest;
import com.qcloud.cos.request.AbstractBaseRequest;
import com.qcloud.cos.request.AbstractDelRequest;
import com.qcloud.cos.request.AbstractStatRequest;
import com.qcloud.cos.sign.Credentials;
import com.qcloud.cos.sign.Sign;

public abstract class BaseOp {
    protected ClientConfig config;
    protected Credentials cred;
    protected AbstractCosHttpClient httpClient;

    public BaseOp(ClientConfig config, Credentials cred, AbstractCosHttpClient httpClient) {
        this.config = config;
        this.cred = cred;
        this.httpClient = httpClient;
    }

    public void setConfig(ClientConfig config) {
        this.config = config;
    }

    public void setCred(Credentials cred) {
        this.cred = cred;
    }

    public void setHttpClient(AbstractCosHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected String buildUrl(AbstractBaseRequest request) throws AbstractCosException {
        String endPoint = this.config.getCosEndPoint();
        int appId = this.cred.getAppId();
        String bucketName = request.getBucketName();
        String cosPath = request.getCosPath();
        cosPath = CommonPathUtils.encodeRemotePath(cosPath);
        return String.format("%s/%s/%s%s", endPoint, appId, bucketName, cosPath);
    }

    protected String delBase(AbstractDelRequest request) throws AbstractCosException {
        request.check_param();
        String url = this.buildUrl(request);
        String sign = Sign.getOneEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("Content-Type", "application/json");
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "delete");
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    protected String statBase(AbstractStatRequest request) throws AbstractCosException {
        request.check_param();
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "stat");
        httpRequest.setMethod(HttpMethod.GET);
        return this.httpClient.sendHttpRequest(httpRequest);
    }
}

