/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.op;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.common_utils.CommonCodecUtils;
import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.HttpContentType;
import com.qcloud.cos.http.HttpMethod;
import com.qcloud.cos.http.HttpRequest;
import com.qcloud.cos.op.BaseOp;
import com.qcloud.cos.request.DelFileRequest;
import com.qcloud.cos.request.MoveFileRequest;
import com.qcloud.cos.request.StatFileRequest;
import com.qcloud.cos.request.UpdateFileRequest;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.request.UploadSliceFileRequest;
import com.qcloud.cos.sign.Credentials;
import com.qcloud.cos.sign.Sign;
import org.json.JSONObject;

public class FileOp
extends BaseOp {
    public FileOp(ClientConfig config, Credentials cred, AbstractCosHttpClient client) {
        super(config, cred, client);
    }

    public String updateFile(UpdateFileRequest request) throws AbstractCosException {
        request.check_param();
        String url = this.buildUrl(request);
        String sign = Sign.getOneEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("Content-Type", "application/json");
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "update");
        int updateFlag = request.getUpdateFlag();
        httpRequest.addParam("flag", String.valueOf(updateFlag));
        if ((updateFlag & 1) != 0) {
            httpRequest.addParam("biz_attr", request.getBizAttr());
        }
        if ((updateFlag & 0x40) != 0) {
            String customHeaderStr = new JSONObject(request.getCustomHeaders()).toString();
            httpRequest.addParam("custom_headers", customHeaderStr);
        }
        if ((updateFlag & 0x80) != 0) {
            httpRequest.addParam("authority", request.getAuthority().toString());
        }
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String delFile(DelFileRequest request) throws AbstractCosException {
        return super.delBase(request);
    }

    public String moveFile(MoveFileRequest request) throws AbstractCosException {
        request.check_param();
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("Content-Type", "application/json");
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "move");
        httpRequest.addParam("dest_fileid", request.getDstCosPath());
        httpRequest.addParam("to_over_write", String.valueOf(request.getOverWrite().ordinal()));
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String statFile(StatFileRequest request) throws AbstractCosException {
        return super.statBase(request);
    }

    public String uploadFile(UploadFileRequest request) throws AbstractCosException {
        request.check_param();
        String localPath = request.getLocalPath();
        long fileSize = 0L;
        try {
            fileSize = CommonFileUtils.getFileLength(localPath);
        }
        catch (Exception e) {
            throw new UnknownException(e.toString());
        }
        long suitSingleFileSize = 0x800000L;
        if (fileSize < suitSingleFileSize) {
            return this.uploadSingleFile(request);
        }
        UploadSliceFileRequest sliceRequest = new UploadSliceFileRequest(request);
        sliceRequest.setInsertOnly(request.getInsertOnly());
        return this.uploadSliceFile(sliceRequest);
    }

    public String uploadSingleFile(UploadFileRequest request) throws AbstractCosException {
        request.check_param();
        String localPath = request.getLocalPath();
        long fileSize = 0L;
        try {
            fileSize = CommonFileUtils.getFileLength(localPath);
        }
        catch (Exception e) {
            throw new UnknownException(e.toString());
        }
        if (fileSize > 0x1400000L) {
            throw new ParamException("file is to big, please use uploadFile interface!");
        }
        String fileContent = "";
        String shaDigest = "";
        try {
            fileContent = CommonFileUtils.getFileContent(localPath);
            shaDigest = CommonCodecUtils.getEntireFileSha1(localPath);
        }
        catch (Exception e) {
            throw new UnknownException(e.toString());
        }
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "upload");
        httpRequest.addParam("sha", shaDigest);
        httpRequest.addParam("biz_attr", request.getBizAttr());
        httpRequest.addParam("fileContent", fileContent);
        httpRequest.addParam("insertOnly", String.valueOf(request.getInsertOnly().ordinal()));
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String uploadSliceFile(UploadSliceFileRequest request) throws AbstractCosException {
        block10: {
            request.check_param();
            controlRet = this.uploadSliceControl(request);
            controlRetJson = new JSONObject(controlRet);
            if (controlRetJson.getInt("code") != 0) {
                return controlRet;
            }
            if (controlRetJson.getJSONObject("data").has("access_url")) {
                return controlRet;
            }
            sliceSize = controlRetJson.getJSONObject("data").getInt("slice_size");
            offset = controlRetJson.getJSONObject("data").getLong("offset");
            session = controlRetJson.getJSONObject("data").getString("session");
            localPath = request.getLocalPath();
            inputStream = null;
            try {
                fileSize = CommonFileUtils.getFileLength(localPath);
                inputStream = CommonFileUtils.getFileInputStream(localPath);
                inputStream.skip(offset);
                uploadDataRet = "";
lbl19:
                // 2 sources

                while (offset < fileSize) {
                    sliceContent = CommonFileUtils.getFileContent(inputStream, 0L, sliceSize);
                    uploadDataRet = this.uploadSliceData(request, sliceContent, session, offset);
                    dataRetJson = new JSONObject(uploadDataRet);
                    if (dataRetJson.getInt("code") != 0) {
                        var15_14 = uploadDataRet;
                        break block10;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl43
            }
            catch (Exception e) {
                try {
                    throw new UnknownException(e.getMessage());
                }
                catch (Throwable var16_16) {
                    CommonFileUtils.closeFileStream(inputStream, localPath);
                    throw var16_16;
                }
            }
        }
        CommonFileUtils.closeFileStream(inputStream, localPath);
        return var15_14;
lbl-1000:
        // 1 sources

        {
            if (!dataRetJson.getJSONObject("data").has("access_url")) ** GOTO lbl-1000
            var15_15 = uploadDataRet;
        }
        CommonFileUtils.closeFileStream(inputStream, localPath);
        return var15_15;
lbl-1000:
        // 1 sources

        {
            offset += (long)sliceSize;
            ** GOTO lbl19
lbl43:
            // 1 sources

            var13_12 = uploadDataRet;
        }
        CommonFileUtils.closeFileStream(inputStream, localPath);
        return var13_12;
    }

    private String uploadSliceControl(UploadSliceFileRequest request) throws AbstractCosException {
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        long fileSize = 0L;
        String shaDigest = "";
        try {
            String localPath = request.getLocalPath();
            fileSize = CommonFileUtils.getFileLength(localPath);
            shaDigest = CommonCodecUtils.getEntireFileSha1(localPath);
        }
        catch (Exception e) {
            throw new UnknownException(e.toString());
        }
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "upload_slice");
        httpRequest.addParam("sha", shaDigest);
        httpRequest.addParam("filesize", String.valueOf(fileSize));
        httpRequest.addParam("slice_size", String.valueOf(request.getSliceSize()));
        httpRequest.addParam("biz_attr", request.getBizAttr());
        httpRequest.addParam("insertOnly", String.valueOf(request.getInsertOnly().ordinal()));
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    private String uploadSliceData(UploadSliceFileRequest request, String sliceContent, String session, long offset) throws AbstractCosException {
        String url = this.buildUrl(request);
        long signExpired = System.currentTimeMillis() / 1000L + (long)this.config.getSignExpired();
        String sign = Sign.getPeriodEffectiveSign(request.getBucketName(), request.getCosPath(), this.cred, signExpired);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("op", "upload_slice");
        httpRequest.addParam("fileContent", sliceContent);
        httpRequest.addParam("session", session);
        httpRequest.addParam("offset", String.valueOf(offset));
        return this.httpClient.sendHttpRequest(httpRequest);
    }
}

