/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.sign;

import com.qcloud.cos.common_utils.CommonCodecUtils;
import com.qcloud.cos.common_utils.CommonPathUtils;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.sign.Credentials;
import java.util.Random;

public class Sign {
    private static String appSignatureBase(Credentials cred, String bucketName, String cosPath, long expired, boolean uploadFlag) throws AbstractCosException {
        byte[] hmacDigest;
        int appId = cred.getAppId();
        String secretId = cred.getSecretId();
        String secretKey = cred.getSecretKey();
        long now = System.currentTimeMillis() / 1000L;
        int rdm = Math.abs(new Random().nextInt());
        String fileId = null;
        fileId = uploadFlag ? String.format("/%s/%s%s", appId, bucketName, cosPath) : cosPath;
        fileId = CommonPathUtils.encodeRemotePath(fileId);
        String plainText = String.format("a=%s&k=%s&e=%d&t=%d&r=%d&f=%s&b=%s", appId, secretId, expired, now, rdm, fileId, bucketName);
        try {
            hmacDigest = CommonCodecUtils.HmacSha1(plainText, secretKey);
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
        byte[] signContent = new byte[hmacDigest.length + plainText.getBytes().length];
        System.arraycopy(hmacDigest, 0, signContent, 0, hmacDigest.length);
        System.arraycopy(plainText.getBytes(), 0, signContent, hmacDigest.length, plainText.getBytes().length);
        return CommonCodecUtils.Base64Encode(signContent);
    }

    public static String getPeriodEffectiveSign(String bucketName, String cosPath, Credentials cred, long expired) throws AbstractCosException {
        return Sign.appSignatureBase(cred, bucketName, cosPath, expired, true);
    }

    public static String getOneEffectiveSign(String bucketName, String cosPath, Credentials cred) throws AbstractCosException {
        return Sign.appSignatureBase(cred, bucketName, cosPath, 0L, true);
    }

    public static String getDownLoadSign(String bucketName, String cosPath, Credentials cred, long expired) throws AbstractCosException {
        return Sign.appSignatureBase(cred, bucketName, cosPath, expired, false);
    }
}

