/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos;

import com.qcloud.cos.COS;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSSigner;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.exception.Throwables;
import com.qcloud.cos.http.CosHttpClient;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.DefaultCosHttpClient;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.internal.BucketNameUtils;
import com.qcloud.cos.internal.COSObjectResponseHandler;
import com.qcloud.cos.internal.COSStringResponseHandler;
import com.qcloud.cos.internal.COSVersionHeaderHandler;
import com.qcloud.cos.internal.COSXmlResponseHandler;
import com.qcloud.cos.internal.CosMetadataResponseHandler;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.DeleteObjectsResponse;
import com.qcloud.cos.internal.DigestValidationInputStream;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.InputSubstream;
import com.qcloud.cos.internal.LengthCheckInputStream;
import com.qcloud.cos.internal.MD5DigestCalculatingInputStream;
import com.qcloud.cos.internal.MultiObjectDeleteXmlFactory;
import com.qcloud.cos.internal.ObjectExpirationHeaderHandler;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.RequestXmlFactory;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.ResponseHeaderHandlerChain;
import com.qcloud.cos.internal.ServerSideEncryptionHeaderHandler;
import com.qcloud.cos.internal.ServiceClientHolderInputStream;
import com.qcloud.cos.internal.SkipMd5CheckStrategy;
import com.qcloud.cos.internal.Unmarshaller;
import com.qcloud.cos.internal.Unmarshallers;
import com.qcloud.cos.internal.UrlComponentUtils;
import com.qcloud.cos.internal.VIDResultHandler;
import com.qcloud.cos.internal.VoidCosResponseHandler;
import com.qcloud.cos.internal.XmlResponsesSaxParser;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.AclXmlFactory;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.BucketConfigurationXmlFactory;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketPolicy;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.CosDataSource;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.DeleteBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketPolicyRequest;
import com.qcloud.cos.model.DeleteBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketRequest;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.model.DeleteVersionRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.GenericBucketRequest;
import com.qcloud.cos.model.GetBucketAclRequest;
import com.qcloud.cos.model.GetBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.GetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.GetBucketLocationRequest;
import com.qcloud.cos.model.GetBucketPolicyRequest;
import com.qcloud.cos.model.GetBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.GetBucketVersioningConfigurationRequest;
import com.qcloud.cos.model.GetObjectAclRequest;
import com.qcloud.cos.model.GetObjectMetadataRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.HeadBucketRequest;
import com.qcloud.cos.model.HeadBucketResult;
import com.qcloud.cos.model.HeadBucketResultHandler;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListBucketsRequest;
import com.qcloud.cos.model.ListMultipartUploadsRequest;
import com.qcloud.cos.model.ListNextBatchOfObjectsRequest;
import com.qcloud.cos.model.ListNextBatchOfVersionsRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ListVersionsRequest;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.Permission;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.ResponseHeaderOverrides;
import com.qcloud.cos.model.RestoreObjectRequest;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.SetBucketAclRequest;
import com.qcloud.cos.model.SetBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.SetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.SetBucketPolicyRequest;
import com.qcloud.cos.model.SetBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.SetBucketVersioningConfigurationRequest;
import com.qcloud.cos.model.SetObjectAclRequest;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.BinaryUtils;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.Md5Utils;
import com.qcloud.cos.utils.ServiceUtils;
import com.qcloud.cos.utils.StringUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSClient
implements COS {
    private static final Logger log = LoggerFactory.getLogger(COSClient.class);
    private final SkipMd5CheckStrategy skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
    private final VoidCosResponseHandler voidCosResponseHandler = new VoidCosResponseHandler();
    private COSCredentials cred;
    protected ClientConfig clientConfig;
    private CosHttpClient cosHttpClient;

    public COSClient(COSCredentials cred, ClientConfig clientConfig) {
        this.cred = cred;
        this.clientConfig = clientConfig;
        this.cosHttpClient = new DefaultCosHttpClient(clientConfig);
    }

    public void shutdown() {
        this.cosHttpClient.shutdown();
    }

    @Override
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    private void rejectNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    protected <X extends CosServiceRequest> CosHttpRequest<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod) {
        CosHttpRequest<X> httpRequest = new CosHttpRequest<X>(originalRequest);
        httpRequest.setHttpMethod(httpMethod);
        httpRequest.addHeader("User-Agent", this.clientConfig.getUserAgent());
        if (originalRequest instanceof ListBucketsRequest) {
            this.buildUrlAndHost(httpRequest, bucketName, key, true);
        } else {
            this.buildUrlAndHost(httpRequest, bucketName, key, false);
        }
        httpRequest.setProgressListener(originalRequest.getGeneralProgressListener());
        return httpRequest;
    }

    private void addAclHeaders(CosHttpRequest<? extends CosServiceRequest> request, AccessControlList acl) {
        List<Grant> grants = acl.getGrantsAsList();
        HashMap grantsByPermission = new HashMap();
        for (Grant grant : grants) {
            if (!grantsByPermission.containsKey((Object)grant.getPermission())) {
                grantsByPermission.put(grant.getPermission(), new LinkedList());
            }
            ((Collection)grantsByPermission.get((Object)grant.getPermission())).add(grant.getGrantee());
        }
        for (Permission permission : Permission.values()) {
            if (!grantsByPermission.containsKey((Object)permission)) continue;
            Collection grantees = (Collection)grantsByPermission.get((Object)permission);
            boolean seenOne = false;
            StringBuilder granteeString = new StringBuilder();
            for (Grantee grantee : grantees) {
                if (!seenOne) {
                    seenOne = true;
                } else {
                    granteeString.append(", ");
                }
                granteeString.append(grantee.getTypeIdentifier()).append("=").append("\"").append(grantee.getIdentifier()).append("\"");
            }
            request.addHeader(permission.getHeaderName(), granteeString.toString());
        }
    }

    protected static void populateRequestMetadata(CosHttpRequest<?> request, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Date httpExpiresDate;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((httpExpiresDate = metadata.getHttpExpiresDate()) != null) {
            request.addHeader("Expires", DateUtils.formatRFC822Date(httpExpiresDate));
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                request.addHeader("x-cos-meta-" + key, value);
            }
        }
    }

    private void populateRequestWithCopyObjectParameters(CosHttpRequest<? extends CosServiceRequest> request, CopyObjectRequest copyObjectRequest) {
        ObjectMetadata newObjectMetadata;
        Region sourceRegion = copyObjectRequest.getSourceBucketRegion();
        if (sourceRegion == null) {
            sourceRegion = this.clientConfig.getRegion();
        }
        String sourceKey = this.formatKey(copyObjectRequest.getSourceKey());
        String sourceBucket = this.formatBucket(copyObjectRequest.getSourceBucketName(), copyObjectRequest.getSourceAppid() != null ? copyObjectRequest.getSourceAppid() : this.cred.getCOSAppId());
        String srcEndpointSuffix = copyObjectRequest.getSourceEndpointSuffix();
        if (srcEndpointSuffix == null) {
            srcEndpointSuffix = String.format(".%s.myqcloud.com", this.formatRegion(sourceRegion.getRegionName()));
        } else {
            UrlComponentUtils.validateSrcEndPointSuffix(srcEndpointSuffix);
        }
        if (!srcEndpointSuffix.startsWith(".")) {
            srcEndpointSuffix = "." + srcEndpointSuffix;
        }
        String copySourceHeader = String.format("%s%s%s", sourceBucket, srcEndpointSuffix.trim(), UrlEncoderUtils.encodeEscapeDelimiter(sourceKey));
        if (copyObjectRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-cos-copy-source", copySourceHeader);
        COSClient.addDateHeader(request, "x-cos-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(request, "x-cos-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            this.addAclHeaders(request, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-cos-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-cos-storage-class", copyObjectRequest.getStorageClass());
        }
        if (copyObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-cos-website-redirect-location", copyObjectRequest.getRedirectLocation());
        }
        if ((newObjectMetadata = copyObjectRequest.getNewObjectMetadata()) != null) {
            request.addHeader("x-cos-metadata-directive", "REPLACE");
            COSClient.populateRequestMetadata(request, newObjectMetadata);
        }
        COSClient.populateSSE_C(request, copyObjectRequest.getDestinationSSECustomerKey());
        COSClient.populateSourceSSE_C(request, copyObjectRequest.getSourceSSECustomerKey());
    }

    private void populateRequestWithCopyPartParameters(CosHttpRequest<? extends CosServiceRequest> request, CopyPartRequest copyPartRequest) {
        Region sourceRegion = copyPartRequest.getSourceBucketRegion();
        if (sourceRegion == null) {
            sourceRegion = this.clientConfig.getRegion();
        }
        String sourceKey = this.formatKey(copyPartRequest.getSourceKey());
        String sourceBucket = this.formatBucket(copyPartRequest.getSourceBucketName(), copyPartRequest.getSourceAppid() != null ? copyPartRequest.getSourceAppid() : this.cred.getCOSAppId());
        String srcEndpointSuffix = copyPartRequest.getSourceEndpointSuffix();
        if (srcEndpointSuffix == null) {
            srcEndpointSuffix = String.format(".%s.myqcloud.com", this.formatRegion(sourceRegion.getRegionName()));
        } else {
            UrlComponentUtils.validateSrcEndPointSuffix(srcEndpointSuffix);
        }
        if (!srcEndpointSuffix.startsWith(".")) {
            srcEndpointSuffix = "." + srcEndpointSuffix;
        }
        String copySourceHeader = String.format("%s%s%s", sourceBucket, srcEndpointSuffix.trim(), UrlEncoderUtils.encodeEscapeDelimiter(sourceKey));
        if (copyPartRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyPartRequest.getSourceVersionId();
        }
        request.addHeader("x-cos-copy-source", copySourceHeader);
        COSClient.addDateHeader(request, "x-cos-copy-source-if-modified-since", copyPartRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(request, "x-cos-copy-source-if-unmodified-since", copyPartRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-match", copyPartRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-none-match", copyPartRequest.getNonmatchingETagConstraints());
        if (copyPartRequest.getFirstByte() != null && copyPartRequest.getLastByte() != null) {
            String range = "bytes=" + copyPartRequest.getFirstByte() + "-" + copyPartRequest.getLastByte();
            request.addHeader("x-cos-copy-source-range", range);
        }
        COSClient.populateSSE_C(request, copyPartRequest.getDestinationSSECustomerKey());
        COSClient.populateSourceSSE_C(request, copyPartRequest.getSourceSSECustomerKey());
    }

    private String formatKey(String key) {
        if (key == null) {
            return "/";
        }
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        return key;
    }

    private String formatRegion(String regionName) throws CosClientException {
        UrlComponentUtils.validateRegionName(regionName);
        if (regionName.startsWith("cos.")) {
            return regionName;
        }
        if (regionName.equals("cn-east") || regionName.equals("cn-south") || regionName.equals("cn-north") || regionName.equals("cn-south-2") || regionName.equals("cn-southwest") || regionName.equals("sg")) {
            return regionName;
        }
        return "cos." + regionName;
    }

    private String leftStripPathDelimiter(String path) {
        if (path == null) {
            return path;
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private String formatBucket(String bucketName, String appid) throws CosClientException {
        BucketNameUtils.validateBucketName(bucketName);
        if (appid == null) {
            String parrtern = ".*-(125|100|20)[0-9]{3,}$";
            if (Pattern.matches(parrtern, bucketName)) {
                return bucketName;
            }
            throw new CosClientException("please make sure bucket name must contain legal appid when appid is missing. example: music-1251122334");
        }
        String appidSuffix = "-" + appid;
        if (bucketName.endsWith(appidSuffix)) {
            return bucketName;
        }
        return bucketName + appidSuffix;
    }

    private <X extends CosServiceRequest> void buildUrlAndHost(CosHttpRequest<X> request, String bucket, String key, boolean isServiceRequest) throws CosClientException {
        key = this.formatKey(key);
        request.setResourcePath(key);
        String host = "";
        String endPointSuffix = this.clientConfig.getEndPointSuffix();
        if (endPointSuffix == null) {
            endPointSuffix = isServiceRequest ? "service.cos.myqcloud.com" : String.format(".%s.myqcloud.com", this.formatRegion(this.clientConfig.getRegion().getRegionName()));
        } else {
            UrlComponentUtils.validateEndPointSuffix(endPointSuffix);
        }
        if (isServiceRequest) {
            host = endPointSuffix;
        } else {
            bucket = this.formatBucket(bucket, this.cred.getCOSAppId());
            host = bucket + endPointSuffix;
        }
        request.addHeader("Host", host);
        request.setProtocol(this.clientConfig.getHttpProtocol());
        request.setEndpoint(host);
        request.setResourcePath(key);
    }

    private <X, Y extends CosServiceRequest> X invoke(CosHttpRequest<Y> request, Unmarshaller<X, InputStream> unmarshaller) throws CosClientException, CosServiceException {
        return this.invoke(request, new COSXmlResponseHandler<X>(unmarshaller));
    }

    private <X, Y extends CosServiceRequest> X invoke(CosHttpRequest<Y> request, HttpResponseHandler<CosServiceResponse<X>> responseHandler) throws CosClientException, CosServiceException {
        COSSigner cosSigner = new COSSigner();
        cosSigner.setSignExpiredTime(this.clientConfig.getSignExpired());
        cosSigner.sign(request, this.cred);
        return this.cosHttpClient.exeute(request, responseHandler);
    }

    private static PutObjectResult createPutObjectResult(ObjectMetadata metadata) {
        PutObjectResult result = new PutObjectResult();
        result.setRequestId((String)metadata.getRawMetadataValue("x-cos-request-id"));
        result.setDateStr((String)metadata.getRawMetadataValue("Date"));
        result.setVersionId(metadata.getVersionId());
        result.setETag(metadata.getETag());
        result.setExpirationTime(metadata.getExpirationTime());
        result.setSSEAlgorithm(metadata.getSSEAlgorithm());
        result.setSSECustomerAlgorithm(metadata.getSSECustomerAlgorithm());
        result.setSSECustomerKeyMd5(metadata.getSSECustomerKeyMd5());
        result.setMetadata(metadata);
        return result;
    }

    private static void addParameterIfNotNull(CosHttpRequest<?> request, String paramName, String paramValue) {
        if (paramValue != null) {
            request.addParameter(paramName, paramValue);
        }
    }

    private static void addHeaderIfNotNull(CosHttpRequest<?> request, String header, String value) {
        if (value != null) {
            request.addHeader(header, value);
        }
    }

    private static void addDateHeader(CosHttpRequest<?> request, String header, Date value) {
        if (value != null) {
            request.addHeader(header, DateUtils.formatRFC822Date(value));
        }
    }

    private static void addStringListHeader(CosHttpRequest<?> request, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            request.addHeader(header, StringUtils.join(values));
        }
    }

    private void setZeroContentLength(CosHttpRequest<?> req) {
        req.addHeader("Content-Length", String.valueOf(0));
    }

    private boolean shouldRetryCompleteMultipartUpload(CosServiceRequest originalRequest, CosClientException exception, int retriesAttempted) {
        return false;
    }

    private static void addResponseHeaderParameters(CosHttpRequest<?> request, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaders.getContentLanguage());
            }
            if (responseHeaders.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                request.addParameter("response-expires", responseHeaders.getExpires());
            }
        }
    }

    private static void populateSSE_C(CosHttpRequest<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-customer-key", sseKey.getKey());
        COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode(encryptionKey_b64);
            request.addHeader("x-cos-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(encryptionKey));
        }
    }

    private static void populateSourceSSE_C(CosHttpRequest<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        COSClient.addHeaderIfNotNull(request, "x-cos-copy-source-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        COSClient.addHeaderIfNotNull(request, "x-cos-copy-source-server-side-encryption-customer-key", sseKey.getKey());
        COSClient.addHeaderIfNotNull(request, "x-cos-copy-source-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode(encryptionKey_b64);
            request.addHeader("x-cos-copy-source-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(encryptionKey));
        }
    }

    private static void populateSSE_KMS(CosHttpRequest<?> request, SSECOSKeyManagementParams sseParams) {
        if (sseParams != null) {
            COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption", sseParams.getEncryption());
            COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-customer-key", sseParams.getCOSKmsKeyId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws CosClientException, CosServiceException {
        ObjectMetadata returnedMetadata;
        this.rejectNull(putObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        File file = putObjectRequest.getFile();
        InputStream isOrig = putObjectRequest.getInputStream();
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        InputStream input = isOrig;
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.rejectNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        this.rejectNull(key, "The key parameter must be specified when uploading an object");
        if (file == null) {
            if (input != null) {
                input = ReleasableInputStream.wrap(input);
            }
        } else {
            boolean calculateMD5;
            metadata.setContentLength(file.length());
            long maxAllowdSingleFileSize = 0x140000000L;
            if (file.length() > 0x140000000L) {
                throw new CosClientException("max size 5GB is allowed by putObject Method, your filesize is " + file.length() + ", please use transferManager to upload big file!");
            }
            boolean bl = calculateMD5 = metadata.getContentMD5() == null;
            if (calculateMD5 && !this.skipMd5CheckStrategy.skipServerSideValidation(putObjectRequest)) {
                try {
                    String contentMd5_b64 = Md5Utils.md5AsBase64(file);
                    metadata.setContentMD5(contentMd5_b64);
                }
                catch (Exception e) {
                    throw new CosClientException("Unable to calculate MD5 hash: " + e.getMessage(), e);
                }
            }
            input = ResettableInputStream.newResettableInputStream(file, "Unable to find file to upload");
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        try {
            CosHttpRequest<PutObjectRequest> request = this.createRequest(bucketName, key, putObjectRequest, HttpMethodName.PUT);
            if (putObjectRequest.getAccessControlList() != null) {
                this.addAclHeaders(request, putObjectRequest.getAccessControlList());
            } else if (putObjectRequest.getCannedAcl() != null) {
                request.addHeader("x-cos-acl", putObjectRequest.getCannedAcl().toString());
            }
            if (putObjectRequest.getStorageClass() != null) {
                request.addHeader("x-cos-storage-class", putObjectRequest.getStorageClass());
            }
            if (putObjectRequest.getRedirectLocation() != null) {
                request.addHeader("x-cos-website-redirect-location", putObjectRequest.getRedirectLocation());
                if (input == null) {
                    input = new ByteArrayInputStream(new byte[0]);
                }
            }
            COSClient.populateSSE_C(request, putObjectRequest.getSSECustomerKey());
            COSClient.populateSSE_KMS(request, putObjectRequest.getSSECOSKeyManagementParams());
            Long contentLength = (Long)metadata.getRawMetadataValue("Content-Length");
            if (contentLength == null) {
                log.warn("No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
            } else {
                long expectedLength = contentLength;
                long maxAllowdSingleFileSize = 0x140000000L;
                if (expectedLength > 0x140000000L) {
                    throw new CosClientException("max size 5GB is allowed by putObject Method, your filesize is " + expectedLength + ", please use transferManager to upload big file!");
                }
                if (expectedLength >= 0L) {
                    LengthCheckInputStream lcis = new LengthCheckInputStream(input, expectedLength, false);
                    input = lcis;
                }
            }
            if (metadata.getContentMD5() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(putObjectRequest)) {
                md5DigestStream = new MD5DigestCalculatingInputStream(input);
                input = md5DigestStream;
            }
            COSClient.populateRequestMetadata(request, metadata);
            request.setContent(input);
            try {
                returnedMetadata = this.invoke(request, new CosMetadataResponseHandler());
            }
            catch (Throwable t) {
                throw Throwables.failure(t);
            }
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(putObjectRequest, file, isOrig, input, log);
        }
        String contentMd5 = metadata.getContentMD5();
        if (md5DigestStream != null) {
            contentMd5 = Base64.encodeAsString(md5DigestStream.getMd5Digest());
        }
        String etag = returnedMetadata.getETag();
        if (contentMd5 != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerPutResponse(returnedMetadata)) {
            byte[] clientSideHash = BinaryUtils.fromBase64(contentMd5);
            byte[] serverSideHash = null;
            try {
                serverSideHash = BinaryUtils.fromHex(etag);
            }
            catch (DecoderException e) {
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + contentMd5 + " in base 64) didn't match hash (etag: " + etag + " in hex) calculated by COS .  " + "You may need to delete the data stored in COS . (metadata.contentMD5: " + metadata.getContentMD5() + ", bucketName: " + bucketName + ", key: " + key + ")");
            }
            if (!Arrays.equals(clientSideHash, serverSideHash)) {
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + contentMd5 + " in base 64) didn't match hash (etag: " + etag + " in hex) calculated by COS .  " + "You may need to delete the data stored in COS . (metadata.contentMD5: " + metadata.getContentMD5() + ", bucketName: " + bucketName + ", key: " + key + ")");
            }
        }
        PutObjectResult result = COSClient.createPutObjectResult(returnedMetadata);
        result.setContentMd5(contentMd5);
        return result;
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) throws CosClientException, CosServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws CosClientException, CosServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    @Override
    public COSObject getObject(String bucketName, String key) throws CosClientException, CosServiceException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public COSObject getObject(GetObjectRequest getObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.rejectNull(getObjectRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object");
        this.rejectNull(getObjectRequest.getKey(), "The key parameter must be specified when requesting an object");
        CosHttpRequest<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "versionId", getObjectRequest.getVersionId());
        long[] range = getObjectRequest.getRange();
        if (range != null) {
            request.addHeader("Range", "bytes=" + Long.toString(range[0]) + "-" + Long.toString(range[1]));
        }
        COSClient.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        COSClient.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        COSClient.populateSSE_C(request, getObjectRequest.getSSECustomerKey());
        try {
            COSObject cosObject = this.invoke(request, new COSObjectResponseHandler());
            cosObject.setBucketName(getObjectRequest.getBucketName());
            cosObject.setKey(getObjectRequest.getKey());
            FilterInputStream is = cosObject.getObjectContent();
            HttpRequestBase httpRequest = cosObject.getObjectContent().getHttpRequest();
            is = new ServiceClientHolderInputStream(is, this);
            if (!this.skipMd5CheckStrategy.skipClientSideValidation(getObjectRequest, cosObject.getObjectMetadata())) {
                try {
                    byte[] serverSideHash = BinaryUtils.fromHex(cosObject.getObjectMetadata().getETag());
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    is = new DigestValidationInputStream(is, digest, serverSideHash);
                }
                catch (NoSuchAlgorithmException e) {
                    log.warn("No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
                }
                catch (DecoderException e) {
                    log.warn("BinaryUtils.fromHex error. Unable to calculate checksum and verify data integrity. etag:" + cosObject.getObjectMetadata().getETag(), (Throwable)e);
                }
            } else {
                is = new LengthCheckInputStream(is, cosObject.getObjectMetadata().getContentLength(), true);
            }
            cosObject.setObjectContent(new COSObjectInputStream(is, httpRequest));
            return cosObject;
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 412 || cse.getStatusCode() == 304) {
                return null;
            }
            throw cse;
        }
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File destinationFile) throws CosClientException, CosServiceException {
        this.rejectNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        COSObject cosObject = ServiceUtils.retryableDownloadCOSObjectToFile(destinationFile, new ServiceUtils.RetryableCOSDownloadTask(){

            @Override
            public boolean needIntegrityCheck() {
                return !COSClient.this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(getObjectRequest);
            }

            @Override
            public COSObject getCOSObjectStream() {
                return COSClient.this.getObject(getObjectRequest);
            }
        }, false);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getObjectMetadata();
    }

    @Override
    public boolean doesObjectExist(String bucketName, String objectName) throws CosClientException, CosServiceException {
        try {
            this.getObjectMetadata(bucketName, objectName);
            return true;
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 404) {
                return false;
            }
            throw cse;
        }
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws CosClientException, CosServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String bucketName = getObjectMetadataRequest.getBucketName();
        String key = getObjectMetadataRequest.getKey();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(key, "The key parameter must be specified when requesting an object's metadata");
        CosHttpRequest<GetObjectMetadataRequest> request = this.createRequest(bucketName, key, getObjectMetadataRequest, HttpMethodName.HEAD);
        COSClient.addParameterIfNotNull(request, "versionId", getObjectMetadataRequest.getVersionId());
        COSClient.populateSSE_C(request, getObjectMetadataRequest.getSSECustomerKey());
        return this.invoke(request, new CosMetadataResponseHandler());
    }

    @Override
    public void deleteObject(String bucketName, String key) throws CosClientException, CosServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        CosHttpRequest<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws MultiObjectDeleteException, CosClientException, CosServiceException {
        CosHttpRequest<DeleteObjectsRequest> request = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        request.addParameter("delete", null);
        byte[] content = new MultiObjectDeleteXmlFactory().convertToXmlByteArray(deleteObjectsRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        ResponseHeaderHandlerChain<DeleteObjectsResponse> responseHandler = new ResponseHeaderHandlerChain<DeleteObjectsResponse>(new Unmarshallers.DeleteObjectsResultUnmarshaller(), new HeaderHandler[0]);
        DeleteObjectsResponse response = (DeleteObjectsResponse)this.invoke(request, responseHandler);
        if (!response.getErrors().isEmpty()) {
            Map<String, String> headers = responseHandler.getResponseHeaders();
            MultiObjectDeleteException ex = new MultiObjectDeleteException(response.getErrors(), response.getDeletedObjects());
            ex.setStatusCode(200);
            ex.setRequestId(headers.get("x-cos-request-id"));
            throw ex;
        }
        DeleteObjectsResult result = new DeleteObjectsResult(response.getDeletedObjects());
        return result;
    }

    @Override
    public void deleteVersion(String bucketName, String key, String versionId) throws CosClientException, CosServiceException {
        this.deleteVersion(new DeleteVersionRequest(bucketName, key, versionId));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteVersionRequest, "The delete version request object must be specified when deleting a version");
        String bucketName = deleteVersionRequest.getBucketName();
        String key = deleteVersionRequest.getKey();
        String versionId = deleteVersionRequest.getVersionId();
        this.rejectNull(bucketName, "The bucket name must be specified when deleting a version");
        this.rejectNull(key, "The key must be specified when deleting a version");
        this.rejectNull(versionId, "The version ID must be specified when deleting a version");
        CosHttpRequest<DeleteVersionRequest> request = this.createRequest(bucketName, key, deleteVersionRequest, HttpMethodName.DELETE);
        request.addParameter("versionId", versionId);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public Bucket createBucket(String bucketName) throws CosClientException, CosServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when creating a bucket");
        bucketName = bucketName.trim();
        BucketNameUtils.validateBucketName(bucketName);
        CosHttpRequest<CreateBucketRequest> request = this.createRequest(bucketName, "/", createBucketRequest, HttpMethodName.PUT);
        if (createBucketRequest.getAccessControlList() != null) {
            this.addAclHeaders(request, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-cos-acl", createBucketRequest.getCannedAcl().toString());
        }
        this.invoke(request, this.voidCosResponseHandler);
        return new Bucket(bucketName);
    }

    @Override
    public void deleteBucket(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String bucketName = deleteBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting a bucket");
        CosHttpRequest<DeleteBucketRequest> request = this.createRequest(bucketName, "/", deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws CosClientException, CosServiceException {
        try {
            this.getBucketAcl(bucketName);
            return true;
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 301 || "AccessDenied".equals(cse.getErrorCode())) {
                return true;
            }
            if (cse.getStatusCode() == 404) {
                return false;
            }
            throw cse;
        }
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest headBucketRequest) throws CosClientException, CosServiceException {
        String bucketName = headBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucketName parameter must be specified.");
        CosHttpRequest<HeadBucketRequest> request = this.createRequest(bucketName, null, headBucketRequest, HttpMethodName.HEAD);
        return this.invoke(request, new HeadBucketResultHandler());
    }

    @Override
    public List<Bucket> listBuckets() throws CosClientException, CosServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listBucketsRequest, "The request object parameter listBucketsRequest must be specified.");
        CosHttpRequest<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsUnmarshaller());
    }

    @Override
    public String getBucketLocation(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(bucketName));
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketLocationRequest, "The request parameter must be specified when requesting a bucket's location");
        String bucketName = getBucketLocationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's location");
        CosHttpRequest<GetBucketLocationRequest> request = this.createRequest(bucketName, null, getBucketLocationRequest, HttpMethodName.GET);
        request.addParameter("location", null);
        return this.invoke(request, new Unmarshallers.BucketLocationUnmarshaller());
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws CosClientException, CosServiceException {
        this.rejectNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        CosHttpRequest<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            request.addHeader("x-cos-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getRedirectLocation() != null) {
            request.addHeader("x-cos-website-redirect-location", initiateMultipartUploadRequest.getRedirectLocation());
        }
        if (initiateMultipartUploadRequest.getAccessControlList() != null) {
            this.addAclHeaders(request, initiateMultipartUploadRequest.getAccessControlList());
        } else if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-cos-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            COSClient.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        COSClient.populateSSE_C(request, initiateMultipartUploadRequest.getSSECustomerKey());
        COSClient.populateSSE_KMS(request, initiateMultipartUploadRequest.getSSECOSKeyManagementParams());
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHandler = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler());
        return (InitiateMultipartUploadResult)this.invoke(request, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws CosClientException, CosServiceException {
        this.rejectNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        File fileOrig = uploadPartRequest.getFile();
        InputStream isOrig = uploadPartRequest.getInputStream();
        String bucketName = uploadPartRequest.getBucketName();
        String key = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        int partNumber = uploadPartRequest.getPartNumber();
        long partSize = uploadPartRequest.getPartSize();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when uploading a part");
        this.rejectNull(key, "The key parameter must be specified when uploading a part");
        this.rejectNull(uploadId, "The upload ID parameter must be specified when uploading a part");
        this.rejectNull(partNumber, "The part number parameter must be specified when uploading a part");
        this.rejectNull(partSize, "The part size parameter must be specified when uploading a part");
        CosHttpRequest<UploadPartRequest> request = this.createRequest(bucketName, key, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", uploadId);
        request.addParameter("partNumber", Integer.toString(partNumber));
        ObjectMetadata objectMetadata = uploadPartRequest.getObjectMetadata();
        if (objectMetadata != null) {
            COSClient.populateRequestMetadata(request, objectMetadata);
        }
        COSClient.addHeaderIfNotNull(request, "Content-MD5", uploadPartRequest.getMd5Digest());
        request.addHeader("Content-Length", Long.toString(partSize));
        COSClient.populateSSE_C(request, uploadPartRequest.getSSECustomerKey());
        InputStream isCurr = isOrig;
        try {
            if (fileOrig == null) {
                if (isOrig == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                isCurr = ReleasableInputStream.wrap(isCurr);
            } else {
                try {
                    isCurr = new ResettableInputStream(fileOrig);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to open file " + fileOrig, e);
                }
            }
            isCurr = new InputSubstream(isCurr, uploadPartRequest.getFileOffset(), partSize, uploadPartRequest.isLastPart());
            MD5DigestCalculatingInputStream md5DigestStream = null;
            if (uploadPartRequest.getMd5Digest() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(uploadPartRequest)) {
                md5DigestStream = new MD5DigestCalculatingInputStream(isCurr);
                isCurr = md5DigestStream;
            }
            UploadPartResult uploadPartResult = this.doUploadPart(bucketName, key, uploadId, partNumber, partSize, request, isCurr, md5DigestStream);
            return uploadPartResult;
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(uploadPartRequest, fileOrig, isOrig, isCurr, log);
        }
    }

    private UploadPartResult doUploadPart(String bucketName, String key, String uploadId, int partNumber, long partSize, CosHttpRequest<UploadPartRequest> request, InputStream inputStream, MD5DigestCalculatingInputStream md5DigestStream) {
        try {
            byte[] serverSideHash;
            byte[] clientSideHash;
            request.setContent(inputStream);
            ObjectMetadata metadata = this.invoke(request, new CosMetadataResponseHandler());
            String etag = metadata.getETag();
            if (md5DigestStream != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerUploadPartResponse(metadata) && !Arrays.equals(clientSideHash = md5DigestStream.getMd5Digest(), serverSideHash = BinaryUtils.fromHex(etag))) {
                String info = "bucketName: " + bucketName + ", key: " + key + ", uploadId: " + uploadId + ", partNumber: " + partNumber + ", partSize: " + partSize;
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + BinaryUtils.toHex(clientSideHash) + " in hex) didn't match hash (etag: " + etag + " in hex) calculated by Qcloud COS.  " + "You may need to delete the data stored in Qcloud COS. " + "(" + info + ")");
            }
            UploadPartResult result = new UploadPartResult();
            result.setETag(etag);
            result.setPartNumber(partNumber);
            result.setSSEAlgorithm(metadata.getSSEAlgorithm());
            result.setSSECustomerAlgorithm(metadata.getSSECustomerAlgorithm());
            result.setSSECustomerKeyMd5(metadata.getSSECustomerKeyMd5());
            return result;
        }
        catch (Throwable t) {
            throw Throwables.failure(t);
        }
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listPartsRequest, "The request parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        CosHttpRequest<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listPartsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListPartsResultUnmarshaller());
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws CosClientException, CosServiceException {
        this.rejectNull(abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String key = abortMultipartUploadRequest.getKey();
        CosHttpRequest<AbortMultipartUploadRequest> request = this.createRequest(bucketName, key, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws CosClientException, CosServiceException {
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler;
        this.rejectNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String key = completeMultipartUploadRequest.getKey();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when completing a multipart upload");
        this.rejectNull(key, "The key parameter must be specified when completing a multipart upload");
        this.rejectNull(uploadId, "The upload ID parameter must be specified when completing a multipart upload");
        this.rejectNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        int retries = 0;
        do {
            CosHttpRequest<CompleteMultipartUploadRequest> request = this.createRequest(bucketName, key, completeMultipartUploadRequest, HttpMethodName.POST);
            request.addParameter("uploadId", uploadId);
            byte[] xml = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
            request.addHeader("Content-Type", "text/plain");
            request.addHeader("Content-Length", String.valueOf(xml.length));
            request.setContent(new ByteArrayInputStream(xml));
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHandler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new VIDResultHandler());
            handler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(request, responseHandler);
            if (handler.getCompleteMultipartUploadResult() == null) continue;
            String versionId = responseHandler.getResponseHeaders().get("x-cos-version-id");
            handler.getCompleteMultipartUploadResult().setVersionId(versionId);
            return handler.getCompleteMultipartUploadResult();
        } while (this.shouldRetryCompleteMultipartUpload(completeMultipartUploadRequest, handler.getCOSException(), retries++));
        throw handler.getCOSException();
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        this.rejectNull(listMultipartUploadsRequest.getBucketName(), "The bucket name parameter must be specified when listing multipart uploads");
        CosHttpRequest<ListMultipartUploadsRequest> request = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            request.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            request.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListMultipartUploadsResultUnmarshaller());
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws CosClientException, CosServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) throws CosClientException, CosServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        boolean shouldSDKDecodeResponse = listObjectsRequest.getEncodingType() == null;
        CosHttpRequest<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), "/", listObjectsRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "prefix", this.leftStripPathDelimiter(listObjectsRequest.getPrefix()));
        COSClient.addParameterIfNotNull(request, "marker", listObjectsRequest.getMarker());
        COSClient.addParameterIfNotNull(request, "delimiter", listObjectsRequest.getDelimiter());
        request.addParameter("encoding-type", shouldSDKDecodeResponse ? "url" : listObjectsRequest.getEncodingType());
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        return this.invoke(request, new Unmarshallers.ListObjectsUnmarshaller(shouldSDKDecodeResponse));
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws CosClientException, CosServiceException {
        return this.listNextBatchOfObjects(new ListNextBatchOfObjectsRequest(previousObjectListing));
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listNextBatchOfObjectsRequest, "The request object parameter must be specified when listing the next batch of objects in a bucket");
        ObjectListing previousObjectListing = listNextBatchOfObjectsRequest.getPreviousObjectListing();
        if (!previousObjectListing.isTruncated()) {
            ObjectListing emptyListing = new ObjectListing();
            emptyListing.setBucketName(previousObjectListing.getBucketName());
            emptyListing.setDelimiter(previousObjectListing.getDelimiter());
            emptyListing.setMarker(previousObjectListing.getNextMarker());
            emptyListing.setMaxKeys(previousObjectListing.getMaxKeys());
            emptyListing.setPrefix(previousObjectListing.getPrefix());
            emptyListing.setEncodingType(previousObjectListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listObjects(listNextBatchOfObjectsRequest.toListObjectsRequest());
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix) throws CosClientException, CosServiceException {
        return this.listVersions(new ListVersionsRequest(bucketName, prefix, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxResults) throws CosClientException, CosServiceException {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(bucketName).withPrefix(prefix).withDelimiter(delimiter).withKeyMarker(keyMarker).withVersionIdMarker(versionIdMarker).withMaxResults(maxResults);
        return this.listVersions(request);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listVersionsRequest.getBucketName(), "The bucket name parameter must be specified when listing versions in a bucket");
        boolean shouldSDKDecodeResponse = listVersionsRequest.getEncodingType() == null;
        CosHttpRequest<ListVersionsRequest> request = this.createRequest(listVersionsRequest.getBucketName(), null, listVersionsRequest, HttpMethodName.GET);
        request.addParameter("versions", null);
        COSClient.addParameterIfNotNull(request, "prefix", listVersionsRequest.getPrefix());
        COSClient.addParameterIfNotNull(request, "key-marker", listVersionsRequest.getKeyMarker());
        COSClient.addParameterIfNotNull(request, "version-id-marker", listVersionsRequest.getVersionIdMarker());
        COSClient.addParameterIfNotNull(request, "delimiter", listVersionsRequest.getDelimiter());
        request.addParameter("encoding-type", shouldSDKDecodeResponse ? "url" : listVersionsRequest.getEncodingType());
        if (listVersionsRequest.getMaxResults() != null && listVersionsRequest.getMaxResults() >= 0) {
            request.addParameter("max-keys", listVersionsRequest.getMaxResults().toString());
        }
        return this.invoke(request, new Unmarshallers.VersionListUnmarshaller(shouldSDKDecodeResponse));
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) throws CosClientException, CosServiceException {
        return this.listNextBatchOfVersions(new ListNextBatchOfVersionsRequest(previousVersionListing));
    }

    @Override
    public VersionListing listNextBatchOfVersions(ListNextBatchOfVersionsRequest listNextBatchOfVersionsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listNextBatchOfVersionsRequest, "The request object parameter must be specified when listing the next batch of versions in a bucket");
        VersionListing previousVersionListing = listNextBatchOfVersionsRequest.getPreviousVersionListing();
        if (!previousVersionListing.isTruncated()) {
            VersionListing emptyListing = new VersionListing();
            emptyListing.setBucketName(previousVersionListing.getBucketName());
            emptyListing.setDelimiter(previousVersionListing.getDelimiter());
            emptyListing.setKeyMarker(previousVersionListing.getNextKeyMarker());
            emptyListing.setVersionIdMarker(previousVersionListing.getNextVersionIdMarker());
            emptyListing.setMaxKeys(previousVersionListing.getMaxKeys());
            emptyListing.setPrefix(previousVersionListing.getPrefix());
            emptyListing.setEncodingType(previousVersionListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listVersions(listNextBatchOfVersionsRequest.toListVersionsRequest());
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws CosClientException, CosServiceException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String destinationKey = copyObjectRequest.getDestinationKey();
        String destinationBucketName = copyObjectRequest.getDestinationBucketName();
        CosHttpRequest<CopyObjectRequest> request = this.createRequest(destinationBucketName, destinationKey, copyObjectRequest, HttpMethodName.PUT);
        this.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new COSVersionHeaderHandler(), new ObjectExpirationHeaderHandler(), new VIDResultHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler);
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 412) {
                return null;
            }
            throw cse;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            String errorCode = copyObjectResultHandler.getErrorCode();
            String errorMessage = copyObjectResultHandler.getErrorMessage();
            String requestId = copyObjectResultHandler.getErrorRequestId();
            CosServiceException cse = new CosServiceException(errorMessage);
            cse.setErrorCode(errorCode);
            cse.setRequestId(requestId);
            cse.setStatusCode(200);
            throw cse;
        }
        CopyObjectResult copyObjectResult = new CopyObjectResult();
        copyObjectResult.setETag(copyObjectResultHandler.getETag());
        copyObjectResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyObjectResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyObjectResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyObjectResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyObjectResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        copyObjectResult.setExpirationTime(copyObjectResultHandler.getExpirationTime());
        copyObjectResult.setExpirationTimeRuleId(copyObjectResultHandler.getExpirationTimeRuleId());
        copyObjectResult.setDateStr(copyObjectResultHandler.getDateStr());
        copyObjectResult.setRequestId(copyObjectResultHandler.getRequestId());
        return copyObjectResult;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) throws CosClientException, CosServiceException {
        this.rejectNull(copyPartRequest.getSourceBucketName(), "The source bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getSourceKey(), "The source object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getUploadId(), "The upload id must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationKey(), "The destination object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getPartNumber(), "The part number must be specified when copying a part");
        String destinationKey = copyPartRequest.getDestinationKey();
        String destinationBucketName = copyPartRequest.getDestinationBucketName();
        CosHttpRequest<CopyPartRequest> request = this.createRequest(destinationBucketName, destinationKey, copyPartRequest, HttpMethodName.PUT);
        this.populateRequestWithCopyPartParameters(request, copyPartRequest);
        request.addParameter("uploadId", copyPartRequest.getUploadId());
        request.addParameter("partNumber", Integer.toString(copyPartRequest.getPartNumber()));
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new COSVersionHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler);
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 412) {
                return null;
            }
            throw cse;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            String errorCode = copyObjectResultHandler.getErrorCode();
            String errorMessage = copyObjectResultHandler.getErrorMessage();
            String requestId = copyObjectResultHandler.getErrorRequestId();
            CosServiceException cse = new CosServiceException(errorMessage);
            cse.setErrorCode(errorCode);
            cse.setErrorType(CosServiceException.ErrorType.Service);
            cse.setRequestId(requestId);
            cse.setStatusCode(200);
            throw cse;
        }
        CopyPartResult copyPartResult = new CopyPartResult();
        copyPartResult.setETag(copyObjectResultHandler.getETag());
        copyPartResult.setPartNumber(copyPartRequest.getPartNumber());
        copyPartResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyPartResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyPartResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyPartResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyPartResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        return copyPartResult;
    }

    @Override
    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration bucketLifecycleConfiguration) throws CosClientException, CosServiceException {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(bucketName, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketLifecycleConfigurationRequest, "The set bucket lifecycle configuration request object must be specified.");
        String bucketName = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        this.rejectNull(bucketLifecycleConfiguration, "The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        CosHttpRequest<SetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("lifecycle", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLifecycleConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketLifecycleConfiguration(new GetBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        this.rejectNull(getBucketLifecycleConfigurationRequest, "The request object pamameter getBucketLifecycleConfigurationRequest must be specified.");
        String bucketName = getBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specifed when retrieving the bucket lifecycle configuration.");
        CosHttpRequest<GetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, getBucketLifecycleConfigurationRequest, HttpMethodName.GET);
        request.addParameter("lifecycle", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketLifecycleConfiguration(new DeleteBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketLifecycleConfigurationRequest, "The delete bucket lifecycle configuration request object must be specified.");
        String bucketName = deleteBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        CosHttpRequest<DeleteBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketLifecycleConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("lifecycle", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketVersioningConfigurationRequest, "The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String bucketName = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration versioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting versioning configuration");
        this.rejectNull(versioningConfiguration, "The bucket versioning parameter must be specified when setting versioning configuration");
        CosHttpRequest<SetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("versioning", null);
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(versioningConfiguration);
        request.setContent(new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketVersioningConfiguration(new GetBucketVersioningConfigurationRequest(bucketName));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest getBucketVersioningConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketVersioningConfigurationRequest, "The request object parameter getBucketVersioningConfigurationRequest must be specified.");
        String bucketName = getBucketVersioningConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when querying versioning configuration");
        CosHttpRequest<GetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, getBucketVersioningConfigurationRequest, HttpMethodName.GET);
        request.addParameter("versioning", null);
        return this.invoke(request, new Unmarshallers.BucketVersioningConfigurationUnmarshaller());
    }

    @Override
    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws CosClientException, CosServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, acl));
    }

    @Override
    public void setObjectAcl(String bucketName, String key, CannedAccessControlList acl) throws CosClientException, CosServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, acl));
    }

    @Override
    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setObjectAclRequest, "The request must not be null.");
        this.rejectNull(setObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when setting an object's ACL");
        this.rejectNull(setObjectAclRequest.getKey(), "The key parameter must be specified when setting an object's ACL");
        if (setObjectAclRequest.getAcl() != null && setObjectAclRequest.getCannedAcl() != null) {
            throw new IllegalArgumentException("Only one of the ACL and CannedACL parameters can be specified, not both.");
        }
        if (setObjectAclRequest.getAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), null, setObjectAclRequest.getAcl(), (CosServiceRequest)setObjectAclRequest);
        } else if (setObjectAclRequest.getCannedAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getCannedAcl(), (CosServiceRequest)setObjectAclRequest);
        } else {
            throw new IllegalArgumentException("At least one of the ACL and CannedACL parameters should be specified");
        }
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key) throws CosClientException, CosServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, key));
    }

    @Override
    public AccessControlList getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectAclRequest, "The request parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getKey(), "The key parameter must be specified when requesting an object's ACL");
        return this.getAcl(getObjectAclRequest.getBucketName(), getObjectAclRequest.getKey(), getObjectAclRequest.getVersionId(), getObjectAclRequest);
    }

    @Override
    public void setBucketAcl(String bucketName, AccessControlList acl) throws CosClientException, CosServiceException {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws CosClientException, CosServiceException {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws CosClientException, CosServiceException {
        String bucketName = setBucketAclRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        AccessControlList acl = setBucketAclRequest.getAcl();
        CannedAccessControlList cannedAcl = setBucketAclRequest.getCannedAcl();
        if (acl == null && cannedAcl == null) {
            throw new IllegalArgumentException("The ACL parameter must be specified when setting a bucket's ACL");
        }
        if (acl != null && cannedAcl != null) {
            throw new IllegalArgumentException("Only one of the acl and cannedAcl parameter can be specified, not both.");
        }
        if (acl != null) {
            this.setAcl(bucketName, null, null, acl, (CosServiceRequest)setBucketAclRequest);
        } else {
            this.setAcl(bucketName, null, null, cannedAcl, (CosServiceRequest)setBucketAclRequest);
        }
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketAcl(new GetBucketAclRequest(bucketName));
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws CosClientException, CosServiceException {
        String bucketName = getBucketAclRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(bucketName, null, null, getBucketAclRequest);
    }

    private AccessControlList getAcl(String bucketName, String key, String versionId, CosServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        ResponseHeaderHandlerChain<AccessControlList> responseHandler = new ResponseHeaderHandlerChain<AccessControlList>(new Unmarshallers.AccessControlListUnmarshaller(), new HeaderHandler[0]);
        return (AccessControlList)this.invoke(request, responseHandler);
    }

    private void setAcl(String bucketName, String key, String versionId, AccessControlList acl, CosServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        byte[] aclAsXml = new AclXmlFactory().convertToXmlByteArray(acl);
        request.addHeader("Content-Type", "application/xml");
        request.addHeader("Content-Length", String.valueOf(aclAsXml.length));
        request.setContent(new ByteArrayInputStream(aclAsXml));
        this.invoke(request, this.voidCosResponseHandler);
    }

    private void setAcl(String bucketName, String key, String versionId, CannedAccessControlList cannedAcl, CosServiceRequest originalRequest) throws CosClientException, CosServiceException {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        request.addHeader("x-cos-acl", cannedAcl.toString());
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketCrossOriginConfiguration(new GetBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(GetBucketCrossOriginConfigurationRequest getBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketCrossOriginConfigurationRequest, "The request object parameter getBucketCrossOriginConfigurationRequest must be specified.");
        String bucketName = getBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket cross origin configuration.");
        CosHttpRequest<GetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, getBucketCrossOriginConfigurationRequest, HttpMethodName.GET);
        request.addParameter("cors", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketCrossOriginConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public void setBucketCrossOriginConfiguration(String bucketName, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) throws CosClientException, CosServiceException {
        this.setBucketCrossOriginConfiguration(new SetBucketCrossOriginConfigurationRequest(bucketName, bucketCrossOriginConfiguration));
    }

    @Override
    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketCrossOriginConfigurationRequest, "The set bucket cross origin configuration request object must be specified.");
        String bucketName = setBucketCrossOriginConfigurationRequest.getBucketName();
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = setBucketCrossOriginConfigurationRequest.getCrossOriginConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket cross origin configuration.");
        this.rejectNull(bucketCrossOriginConfiguration, "The cross origin configuration parameter must be specified when setting bucket cross origin configuration.");
        CosHttpRequest<SetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, setBucketCrossOriginConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("cors", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketCrossOriginConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketCrossOriginConfiguration(new DeleteBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketCrossOriginConfigurationRequest, "The delete bucket cross origin configuration request object must be specified.");
        String bucketName = deleteBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket cross origin configuration.");
        CosHttpRequest<DeleteBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketCrossOriginConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("cors", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketReplicationConfiguration(String bucketName, BucketReplicationConfiguration configuration) throws CosClientException, CosServiceException {
        this.setBucketReplicationConfiguration(new SetBucketReplicationConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketReplicationConfiguration(SetBucketReplicationConfigurationRequest setBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketReplicationConfigurationRequest, "The set bucket replication configuration request object must be specified.");
        String bucketName = setBucketReplicationConfigurationRequest.getBucketName();
        BucketReplicationConfiguration bucketReplicationConfiguration = setBucketReplicationConfigurationRequest.getReplicationConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting replication configuration.");
        this.rejectNull(bucketReplicationConfiguration, "The replication configuration parameter must be specified when setting replication configuration.");
        CosHttpRequest<SetBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, setBucketReplicationConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("replication", null);
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketReplicationConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(bytes));
        try {
            request.addHeader("Content-MD5", BinaryUtils.toBase64(Md5Utils.computeMD5Hash(bytes)));
        }
        catch (Exception e) {
            throw new CosClientException("Not able to compute MD5 of the replication rule configuration. Exception Message : " + e.getMessage(), e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketReplicationConfiguration(new GetBucketReplicationConfigurationRequest(bucketName));
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(GetBucketReplicationConfigurationRequest getBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketReplicationConfigurationRequest, "The bucket request parameter must be specified when retrieving replication configuration");
        String bucketName = getBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket request must specify a bucket name when retrieving replication configuration");
        CosHttpRequest<GetBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, getBucketReplicationConfigurationRequest, HttpMethodName.GET);
        request.addParameter("replication", null);
        return this.invoke(request, new Unmarshallers.BucketReplicationConfigurationUnmarshaller());
    }

    @Override
    public void deleteBucketReplicationConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketReplicationConfiguration(new DeleteBucketReplicationConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketReplicationConfiguration(DeleteBucketReplicationConfigurationRequest deleteBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        String bucketName = deleteBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting replication configuration");
        CosHttpRequest<DeleteBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketReplicationConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("replication", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws CosClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethodName.GET);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethodName method) throws CosClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expiration);
        return this.generatePresignedUrl(request);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest req) throws CosClientException {
        this.rejectNull(req, "The request parameter must be specified when generating a pre-signed URL");
        req.rejectIllegalArguments();
        String bucketName = req.getBucketName();
        String key = req.getKey();
        if (req.getExpiration() == null) {
            req.setExpiration(new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L));
        }
        HttpMethodName httpMethod = req.getMethod();
        CosHttpRequest<GeneratePresignedUrlRequest> request = this.createRequest(bucketName, key, req, httpMethod);
        COSClient.addParameterIfNotNull(request, "versionId", req.getVersionId());
        for (Map.Entry<String, String> entry : req.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        COSClient.addHeaderIfNotNull(request, "Content-Type", req.getContentType());
        COSClient.addHeaderIfNotNull(request, "Content-MD5", req.getContentMd5());
        Map<String, String> customHeaders = req.getCustomRequestHeaders();
        if (customHeaders != null) {
            for (Map.Entry<String, String> e : customHeaders.entrySet()) {
                request.addHeader(e.getKey(), e.getValue());
            }
        }
        COSClient.addResponseHeaderParameters(request, req.getResponseHeaders());
        COSSigner cosSigner = new COSSigner();
        String authStr = cosSigner.buildAuthorizationStr(request.getHttpMethod(), request.getResourcePath(), request.getHeaders(), request.getParameters(), this.cred, req.getExpiration());
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("http://").append(this.formatBucket(bucketName, this.cred.getCOSAppId()));
        String endpointSuffix = this.clientConfig.getEndPointSuffix();
        if (endpointSuffix == null) {
            endpointSuffix = String.format(".%s.myqcloud.com", this.formatRegion(this.clientConfig.getRegion().getRegionName()));
        }
        if (!endpointSuffix.startsWith(".")) {
            endpointSuffix = "." + endpointSuffix;
        }
        strBuilder.append(endpointSuffix).append(UrlEncoderUtils.encodeEscapeDelimiter(this.formatKey(key)));
        boolean hasAppendFirstParameter = false;
        if (authStr != null) {
            strBuilder.append("?sign=").append(UrlEncoderUtils.encode(authStr));
            hasAppendFirstParameter = true;
        }
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            String paramKey = entry.getKey();
            String paramValue = entry.getValue();
            if (!hasAppendFirstParameter) {
                strBuilder.append("?");
                hasAppendFirstParameter = true;
            } else {
                strBuilder.append("&");
            }
            strBuilder.append(UrlEncoderUtils.encode(paramKey));
            if (paramValue == null) continue;
            strBuilder.append("=").append(UrlEncoderUtils.encode(paramValue));
        }
        try {
            return new URL(strBuilder.toString());
        }
        catch (MalformedURLException e) {
            throw new CosClientException(e.toString());
        }
    }

    @Override
    public void restoreObject(String bucketName, String key, int expirationInDays) throws CosClientException, CosServiceException {
        this.restoreObject(new RestoreObjectRequest(bucketName, key, expirationInDays));
    }

    @Override
    public void restoreObject(RestoreObjectRequest restoreObjectRequest) throws CosClientException, CosServiceException {
        String bucketName = restoreObjectRequest.getBucketName();
        String key = restoreObjectRequest.getKey();
        String versionId = restoreObjectRequest.getVersionId();
        int expirationIndays = restoreObjectRequest.getExpirationInDays();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when copying a cas object");
        this.rejectNull(key, "The key parameter must be specified when copying a cas object");
        if (expirationIndays == -1) {
            throw new IllegalArgumentException("The expiration in days parameter must be specified when copying a cas object");
        }
        CosHttpRequest<RestoreObjectRequest> request = this.createRequest(bucketName, key, restoreObjectRequest, HttpMethodName.POST);
        request.addParameter("restore", null);
        COSClient.addParameterIfNotNull(request, "versionId", versionId);
        byte[] content = RequestXmlFactory.convertToXmlByteArray(restoreObjectRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void updateObjectMetaData(String bucketName, String key, ObjectMetadata objectMetadata) throws CosClientException, CosServiceException {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(bucketName, key, bucketName, key);
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        this.copyObject(copyObjectRequest);
    }

    @Override
    public void setBucketPolicy(String bucketName, String policyText) throws CosClientException, CosServiceException {
        this.setBucketPolicy(new SetBucketPolicyRequest(bucketName, policyText));
    }

    @Override
    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketPolicyRequest, "The request object must be specified when setting a bucket policy");
        String bucketName = setBucketPolicyRequest.getBucketName();
        String policyText = setBucketPolicyRequest.getPolicyText();
        this.rejectNull(bucketName, "The bucket name must be specified when setting a bucket policy");
        this.rejectNull(policyText, "The policy text must be specified when setting a bucket policy");
        CosHttpRequest<SetBucketPolicyRequest> request = this.createRequest(bucketName, null, setBucketPolicyRequest, HttpMethodName.PUT);
        request.addParameter("policy", null);
        request.setContent(new ByteArrayInputStream(policyText.getBytes(StringUtils.UTF8)));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketPolicy getBucketPolicy(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketPolicy(new GetBucketPolicyRequest(bucketName));
    }

    @Override
    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketPolicyRequest, "The request object must be specified when getting a bucket policy");
        String bucketName = getBucketPolicyRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when getting a bucket policy");
        CosHttpRequest<GetBucketPolicyRequest> request = this.createRequest(bucketName, null, getBucketPolicyRequest, HttpMethodName.GET);
        request.addParameter("policy", null);
        BucketPolicy result = new BucketPolicy();
        try {
            String policyText = this.invoke(request, new COSStringResponseHandler());
            result.setPolicyText(policyText);
            return result;
        }
        catch (CosServiceException cse) {
            if (cse.getErrorCode().equals("NoSuchBucketPolicy")) {
                return result;
            }
            throw cse;
        }
    }

    @Override
    public void deleteBucketPolicy(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketPolicy(new DeleteBucketPolicyRequest(bucketName));
    }

    @Override
    public void deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketPolicyRequest, "The request object must be specified when deleting a bucket policy");
        String bucketName = deleteBucketPolicyRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when deleting a bucket policy");
        CosHttpRequest<DeleteBucketPolicyRequest> request = this.createRequest(bucketName, null, deleteBucketPolicyRequest, HttpMethodName.DELETE);
        request.addParameter("policy", null);
        this.invoke(request, this.voidCosResponseHandler);
    }
}

