/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.event.COSProgressPublisher;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.TransferStateChangeListener;
import com.qcloud.cos.internal.CIServiceRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.transfer.AbstractTransfer;
import com.qcloud.cos.transfer.CIPostJob;
import com.qcloud.cos.transfer.PersistableDownload;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferProgress;
import java.io.File;
import java.io.IOException;

public class CIPostJobImpl
extends AbstractTransfer
implements CIPostJob {
    private COSObject cosObject;
    private CIServiceRequest request;
    private final PersistableDownload persistableDownload;

    public CIPostJobImpl(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, COSObject cosObject, TransferStateChangeListener listener, GetObjectRequest getObjectRequest, File file) {
        super(description, transferProgress, progressListenerChain, listener);
        this.cosObject = cosObject;
        this.persistableDownload = this.captureDownloadState(getObjectRequest, file);
        COSProgressPublisher.publishTransferPersistable(progressListenerChain, this.persistableDownload);
    }

    public ObjectMetadata getObjectMetadata() {
        return this.cosObject.getObjectMetadata();
    }

    public String getBucketName() {
        return this.cosObject.getBucketName();
    }

    public String getKey() {
        return this.cosObject.getKey();
    }

    @Override
    public synchronized void abort() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.cosObject != null) {
            this.cosObject.getObjectContent().abort();
        }
        this.setState(Transfer.TransferState.Canceled);
    }

    public synchronized void abortWithoutNotifyingStateChangeListener() throws IOException {
        this.monitor.getFuture().cancel(true);
        this.state = Transfer.TransferState.Canceled;
    }

    @Override
    public void setState(Transfer.TransferState state) {
        super.setState(state);
        if (state == Transfer.TransferState.Completed) {
            this.fireProgressEvent(ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }

    private PersistableDownload captureDownloadState(GetObjectRequest getObjectRequest, File file) {
        if (getObjectRequest.getSSECustomerKey() == null) {
            return new PersistableDownload(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest.getVersionId(), getObjectRequest.getRange(), getObjectRequest.getResponseHeaders(), file.getAbsolutePath());
        }
        return null;
    }

    public CIServiceRequest getRequest() {
        return this.request;
    }

    public void setRequest(CIServiceRequest request) {
        this.request = request;
    }
}

