/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.auth;

import com.qcloud.cos.auth.AnonymousCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSSessionCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacUtils;

public class COSSigner {
    private static Set<String> needSignedHeaderSet = new HashSet<String>();
    private Boolean isCIWorkflowRequest = false;
    private int localTimeDelta = 0;

    private boolean isAnonymous(COSCredentials cred) {
        return cred instanceof AnonymousCOSCredentials;
    }

    public <X extends CosServiceRequest> void sign(CosHttpRequest<X> request, COSCredentials cred, Date expiredTime) {
        if (this.isAnonymous(cred)) {
            return;
        }
        String authoriationStr = this.buildAuthorizationStr(request.getHttpMethod(), request.getResourcePath(), request.getHeaders(), request.getParameters(), cred, expiredTime, true);
        request.addHeader("Authorization", authoriationStr);
        if (cred instanceof COSSessionCredentials) {
            request.addHeader("x-cos-security-token", ((COSSessionCredentials)cred).getSessionToken());
        }
    }

    public String buildPostObjectSignature(String secretKey, String keyTime, String policy) {
        String signKey = HmacUtils.hmacSha1Hex((String)secretKey, (String)keyTime);
        String stringToSign = DigestUtils.sha1Hex((String)policy);
        return HmacUtils.hmacSha1Hex((String)signKey, (String)stringToSign);
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, COSCredentials cred, Date expiredTime) {
        Date startTime = new Date();
        return this.buildAuthorizationStr(methodName, resouce_path, new HashMap<String, String>(), new HashMap<String, String>(), cred, startTime, expiredTime, true);
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, Map<String, String> headerMap, Map<String, String> paramMap, COSCredentials cred, Date expiredTime) {
        Date startTime = new Date();
        return this.buildAuthorizationStr(methodName, resouce_path, headerMap, paramMap, cred, startTime, expiredTime, true);
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, Map<String, String> headerMap, Map<String, String> paramMap, COSCredentials cred, Date expiredTime, Boolean signHost) {
        Date startTime = new Date();
        return this.buildAuthorizationStr(methodName, resouce_path, headerMap, paramMap, cred, startTime, expiredTime, signHost);
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, Map<String, String> headerMap, Map<String, String> paramMap, COSCredentials cred, Date startTime, Date expiredTime, Boolean signHost) {
        String qSignTimeStr;
        if (this.isAnonymous(cred)) {
            return null;
        }
        if (this.isCIWorkflowRequest.booleanValue()) {
            resouce_path = resouce_path.split("\\?")[0];
        }
        Map<String, String> signHeaders = this.buildSignHeaders(headerMap, signHost);
        TreeMap<String, String> encodedSortedSignHeaders = this.buildEncodeSortedMemberMap(signHeaders);
        TreeMap<String, String> encodedSortedParams = this.buildEncodeSortedMemberMap(paramMap);
        String qHeaderListStr = this.buildSignMemberStr(encodedSortedSignHeaders);
        String qUrlParamListStr = this.buildSignMemberStr(encodedSortedParams);
        String qKeyTimeStr = qSignTimeStr = this.buildTimeStr(startTime, expiredTime);
        String signKey = HmacUtils.hmacSha1Hex((String)cred.getCOSSecretKey(), (String)qKeyTimeStr);
        String formatMethod = methodName.toString().toLowerCase();
        String formatUri = resouce_path;
        String formatParameters = this.formatMapToStr(encodedSortedParams);
        String formatHeaders = this.formatMapToStr(encodedSortedSignHeaders);
        String formatStr = formatMethod + "\n" + formatUri + "\n" + formatParameters + "\n" + formatHeaders + "\n";
        String hashFormatStr = DigestUtils.sha1Hex((String)formatStr);
        String stringToSign = "sha1" + "\n" + qSignTimeStr + "\n" + hashFormatStr + "\n";
        String signature = HmacUtils.hmacSha1Hex((String)signKey, (String)stringToSign);
        String authoriationStr = "q-sign-algorithm" + "=" + "sha1" + "&" + "q-ak" + "=" + cred.getCOSAccessKeyId() + "&" + "q-sign-time" + "=" + qSignTimeStr + "&" + "q-key-time" + "=" + qKeyTimeStr + "&" + "q-header-list" + "=" + qHeaderListStr + "&" + "q-url-param-list" + "=" + qUrlParamListStr + "&" + "q-signature" + "=" + signature;
        return authoriationStr;
    }

    public boolean needSignedHeader(String header) {
        return needSignedHeaderSet.contains(header) || header.startsWith("x-cos-");
    }

    private Map<String, String> buildSignHeaders(Map<String, String> originHeaders, Boolean signHost) {
        Boolean hasHost = false;
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> headerEntry : originHeaders.entrySet()) {
            String key = headerEntry.getKey().toLowerCase();
            if (key.equals("host")) {
                hasHost = true;
            }
            if (!this.needSignedHeader(key)) continue;
            String value = headerEntry.getValue();
            signHeaders.put(key, value);
        }
        if (!hasHost.booleanValue() && signHost.booleanValue()) {
            String msg = String.format("buildAuthorization missing header: host. %s", originHeaders);
            throw new CosClientException(msg);
        }
        return signHeaders;
    }

    private TreeMap<String, String> buildEncodeSortedMemberMap(Map<String, String> signElements) {
        TreeMap<String, String> encodeSortedSignElements = new TreeMap<String, String>();
        for (Map.Entry<String, String> header : signElements.entrySet()) {
            if (header.getKey() == null) continue;
            String encodeLowerKey = UrlEncoderUtils.encode(header.getKey().trim()).toLowerCase();
            String value = "";
            if (header.getValue() != null) {
                value = header.getValue().trim();
            }
            String encodeValue = UrlEncoderUtils.encode(value);
            encodeSortedSignElements.put(encodeLowerKey, encodeValue);
        }
        return encodeSortedSignElements;
    }

    private String buildSignMemberStr(Map<String, String> signHeaders) {
        StringBuilder strBuilder = new StringBuilder();
        boolean seenOne = false;
        for (String key : signHeaders.keySet()) {
            if (!seenOne) {
                seenOne = true;
            } else {
                strBuilder.append(";");
            }
            strBuilder.append(key);
        }
        return strBuilder.toString();
    }

    private String formatMapToStr(Map<String, String> kVMap) {
        StringBuilder strBuilder = new StringBuilder();
        boolean seeOne = false;
        for (Map.Entry<String, String> entry : kVMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!seeOne) {
                seeOne = true;
            } else {
                strBuilder.append("&");
            }
            strBuilder.append(key).append("=").append(value);
        }
        return strBuilder.toString();
    }

    private String buildTimeStr(Date startTime, Date endTime) {
        StringBuilder strBuilder = new StringBuilder();
        long startTimestamp = startTime.getTime() / 1000L + (long)this.localTimeDelta;
        long endTimestamp = endTime.getTime() / 1000L + (long)this.localTimeDelta;
        strBuilder.append(startTimestamp).append(";").append(endTimestamp);
        return strBuilder.toString();
    }

    public static Set<String> getNeedSignedHeaderSet() {
        return needSignedHeaderSet;
    }

    public static void setNeedSignedHeaderSet(Set<String> needSignedHeaderSet) {
        COSSigner.needSignedHeaderSet = needSignedHeaderSet;
    }

    public void setCIWorkflowRequest(Boolean CIRequest) {
        this.isCIWorkflowRequest = CIRequest;
    }

    public int getLocalTimeDelta() {
        return this.localTimeDelta;
    }

    public void setLocalTimeDelta(int localTimeDelta) {
        this.localTimeDelta = localTimeDelta;
    }

    static {
        needSignedHeaderSet.add("cache-control");
        needSignedHeaderSet.add("content-disposition");
        needSignedHeaderSet.add("content-encoding");
        needSignedHeaderSet.add("content-length");
        needSignedHeaderSet.add("content-md5");
        needSignedHeaderSet.add("content-type");
        needSignedHeaderSet.add("expect");
        needSignedHeaderSet.add("expires");
        needSignedHeaderSet.add("host");
        needSignedHeaderSet.add("if-match");
        needSignedHeaderSet.add("if-modified-since");
        needSignedHeaderSet.add("if-none-match");
        needSignedHeaderSet.add("if-unmodified-since");
        needSignedHeaderSet.add("origin");
        needSignedHeaderSet.add("range");
        needSignedHeaderSet.add("transfer-encoding");
    }
}

