/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.internal.AbstractHandler;
import com.qcloud.cos.internal.AbstractSSEHandler;
import com.qcloud.cos.internal.DeleteObjectsResponse;
import com.qcloud.cos.internal.ObjectExpirationResult;
import com.qcloud.cos.internal.ParserMediaInfoUtils;
import com.qcloud.cos.internal.ServerSideEncryptionResult;
import com.qcloud.cos.internal.VIDResult;
import com.qcloud.cos.internal.cihandler.AIGameRecResponseHandler;
import com.qcloud.cos.internal.cihandler.AutoTranslationBlockResponseHandler;
import com.qcloud.cos.internal.cihandler.BatchJobResponseHandler;
import com.qcloud.cos.internal.cihandler.CIXmlResponsesSaxParser;
import com.qcloud.cos.internal.cihandler.DetectCarHandler;
import com.qcloud.cos.internal.cihandler.DetectFaceResponseHandler;
import com.qcloud.cos.internal.cihandler.FileProcessResponseHandler;
import com.qcloud.cos.internal.cihandler.GenerateQrcodeHandler;
import com.qcloud.cos.internal.cihandler.GetImageStyleHandler;
import com.qcloud.cos.internal.cihandler.MediaJobResponseHandler;
import com.qcloud.cos.internal.cihandler.ReportBadCaseHandler;
import com.qcloud.cos.internal.cihandler.SearchImageHandler;
import com.qcloud.cos.internal.cihandler.TriggerWorkflowListHandler;
import com.qcloud.cos.internal.cihandler.WebpageAuditingDescribeJobHandler;
import com.qcloud.cos.model.AbortIncompleteMultipartUpload;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.BucketIntelligentTierConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.BucketWebsiteConfiguration;
import com.qcloud.cos.model.CORSRule;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.COSVersionSummary;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.DecompressionResult;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.model.DomainRule;
import com.qcloud.cos.model.GetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.GetObjectTaggingResult;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.GroupGrantee;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsResult;
import com.qcloud.cos.model.ListJobsResult;
import com.qcloud.cos.model.MultipartUpload;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.Owner;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.Permission;
import com.qcloud.cos.model.RedirectRule;
import com.qcloud.cos.model.ReplicationDestinationConfig;
import com.qcloud.cos.model.ReplicationRule;
import com.qcloud.cos.model.RoutingRule;
import com.qcloud.cos.model.RoutingRuleCondition;
import com.qcloud.cos.model.Tag.LifecycleTagPredicate;
import com.qcloud.cos.model.Tag.Tag;
import com.qcloud.cos.model.TagSet;
import com.qcloud.cos.model.UinGrantee;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.model.bucketcertificate.BucketGetDomainCertificate;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.AudioSectionInfo;
import com.qcloud.cos.model.ciModel.auditing.AuditingJobsDetail;
import com.qcloud.cos.model.ciModel.auditing.AudtingCommonInfo;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.BatchImageJobDetail;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingJobsDetail;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.DocumentResultInfo;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.LanguageResult;
import com.qcloud.cos.model.ciModel.auditing.LibResult;
import com.qcloud.cos.model.ciModel.auditing.ListResult;
import com.qcloud.cos.model.ciModel.auditing.ObjectResults;
import com.qcloud.cos.model.ciModel.auditing.OcrResults;
import com.qcloud.cos.model.ciModel.auditing.SectionInfo;
import com.qcloud.cos.model.ciModel.auditing.SnapshotInfo;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingJobsDetail;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingResponse;
import com.qcloud.cos.model.ciModel.bucket.DocBucketObject;
import com.qcloud.cos.model.ciModel.bucket.DocBucketResponse;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketObject;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketResponse;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.image.ImageLabelResponse;
import com.qcloud.cos.model.ciModel.image.ImageLabelV2Response;
import com.qcloud.cos.model.ciModel.image.Label;
import com.qcloud.cos.model.ciModel.image.LabelV2;
import com.qcloud.cos.model.ciModel.image.LocationLabel;
import com.qcloud.cos.model.ciModel.job.DocJobDetail;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.DocProcessObject;
import com.qcloud.cos.model.ciModel.job.DocProcessPageInfo;
import com.qcloud.cos.model.ciModel.job.DocProcessResult;
import com.qcloud.cos.model.ciModel.job.ExtractDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.Md5Info;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaPicProcessTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.job.OutputFile;
import com.qcloud.cos.model.ciModel.job.ProcessResult;
import com.qcloud.cos.model.ciModel.job.VideoTargetRec;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaFormat;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoAudio;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoResponse;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoStream;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoSubtitle;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoVideo;
import com.qcloud.cos.model.ciModel.persistence.CIObject;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.ImageInfo;
import com.qcloud.cos.model.ciModel.persistence.OriginalInfo;
import com.qcloud.cos.model.ciModel.persistence.ProcessResults;
import com.qcloud.cos.model.ciModel.queue.DocListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaNotifyConfig;
import com.qcloud.cos.model.ciModel.queue.MediaQueueObject;
import com.qcloud.cos.model.ciModel.queue.MediaQueueResponse;
import com.qcloud.cos.model.ciModel.recognition.CodeLocation;
import com.qcloud.cos.model.ciModel.recognition.QRcodeInfo;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotResponse;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaSegmentObject;
import com.qcloud.cos.model.ciModel.template.MediaSnapshotObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateTransTplObject;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import com.qcloud.cos.model.ciModel.template.SpriteSnapshotConfig;
import com.qcloud.cos.model.ciModel.workflow.MediaTasks;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowDependency;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionObject;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionsResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowInput;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowListResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowNode;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowObject;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowResponse;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.inventory.InventoryCosBucketDestination;
import com.qcloud.cos.model.inventory.InventoryDestination;
import com.qcloud.cos.model.inventory.InventoryFilter;
import com.qcloud.cos.model.inventory.InventoryPrefixPredicate;
import com.qcloud.cos.model.inventory.InventorySchedule;
import com.qcloud.cos.model.inventory.ServerSideEncryptionCOS;
import com.qcloud.cos.model.lifecycle.LifecycleAndOperator;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import com.qcloud.cos.model.lifecycle.LifecycleFilterPredicate;
import com.qcloud.cos.model.lifecycle.LifecyclePrefixPredicate;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.StringUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Logger log = LoggerFactory.getLogger(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private boolean sanitizeXmlDocument = true;

    public XmlResponsesSaxParser() throws CosClientException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new CosClientException("Couldn't initialize a SAX driver to create an XMLReader", e);
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws IOException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Parsing XML response document with handler: " + handler.getClass());
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, StringUtils.UTF8));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            block6: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error("Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new CosClientException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler handler, InputStream inputStream) throws IOException {
        if (!this.sanitizeXmlDocument) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug("Sanitizing XML document destined for handler " + handler.getClass());
        }
        ByteArrayInputStream sanitizedInputStream = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StringUtils.UTF8));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            br.close();
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            sanitizedInputStream = new ByteArrayInputStream(listingDoc.getBytes(StringUtils.UTF8));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            block8: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error("Unable to close response InputStream after failure sanitizing XML document", (Throwable)e);
                }
            }
            throw new CosClientException("Failed to sanitize XML document destined for handler " + handler.getClass(), t);
        }
        return sanitizedInputStream;
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            log.error("Unable to parse integer value '" + s + "'", (Throwable)nfe);
            return -1;
        }
    }

    private static long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            log.error("Unable to parse long value '" + s + "'", (Throwable)nfe);
            return -1L;
        }
    }

    private static String checkForEmptyString(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    private static String decodeIfSpecified(String value, boolean decode) {
        return decode ? UrlEncoderUtils.urlDecode(value) : value;
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream, boolean shouldSDKDecodeResponse) throws IOException {
        ListBucketHandler handler = new ListBucketHandler(shouldSDKDecodeResponse);
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListVersionsHandler parseListVersionsResponse(InputStream inputStream, boolean shouldSDKDecodeResponse) throws IOException {
        ListVersionsHandler handler = new ListVersionsHandler(shouldSDKDecodeResponse);
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ReportBadCaseHandler parseReportBadCase(InputStream inputStream) throws IOException {
        ReportBadCaseHandler handler = new ReportBadCaseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws IOException {
        ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws IOException {
        AccessControlListHandler handler = new AccessControlListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ImagePersistenceHandler parseImagePersistenceResponse(InputStream inputStream) throws IOException {
        ImagePersistenceHandler handler = new ImagePersistenceHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLifecycleConfigurationHandler parseBucketLifecycleConfigurationResponse(InputStream inputStream) throws IOException {
        BucketLifecycleConfigurationHandler handler = new BucketLifecycleConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketCrossOriginConfigurationHandler parseBucketCrossOriginConfigurationResponse(InputStream inputStream) throws IOException {
        BucketCrossOriginConfigurationHandler handler = new BucketCrossOriginConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketDomainConfigurationHandler parseBucketDomainConfigurationResponse(InputStream inputStream) throws IOException {
        BucketDomainConfigurationHandler handler = new BucketDomainConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketDomainCertificateHandler parseBucketDomainCertificateResponse(InputStream inputStream) throws IOException {
        BucketDomainCertificateHandler handler = new BucketDomainCertificateHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketRefererConfigurationHandler parseBucketRefererConfigurationResponse(InputStream inputStream) throws IOException {
        BucketRefererConfigurationHandler handler = new BucketRefererConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) throws IOException {
        BucketLocationHandler handler = new BucketLocationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getLocation();
    }

    public BucketVersioningConfigurationHandler parseVersioningConfigurationResponse(InputStream inputStream) throws IOException {
        BucketVersioningConfigurationHandler handler = new BucketVersioningConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketReplicationConfigurationHandler parseReplicationConfigurationResponse(InputStream inputStream) throws IOException {
        BucketReplicationConfigurationHandler handler = new BucketReplicationConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketTaggingConfigurationHandler parseTaggingConfigurationResponse(InputStream inputStream) throws IOException {
        BucketTaggingConfigurationHandler handler = new BucketTaggingConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public DeleteObjectsHandler parseDeletedObjectsResult(InputStream inputStream) throws IOException {
        DeleteObjectsHandler handler = new DeleteObjectsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) throws IOException {
        CopyObjectResultHandler handler = new CopyObjectResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CompleteMultipartUploadHandler parseCompleteMultipartUploadResponse(InputStream inputStream) throws IOException {
        CompleteMultipartUploadHandler handler = new CompleteMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public InitiateMultipartUploadHandler parseInitiateMultipartUploadResponse(InputStream inputStream) throws IOException {
        InitiateMultipartUploadHandler handler = new InitiateMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListMultipartUploadsHandler parseListMultipartUploadsResponse(InputStream inputStream) throws IOException {
        ListMultipartUploadsHandler handler = new ListMultipartUploadsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListPartsHandler parseListPartsResponse(InputStream inputStream) throws IOException {
        ListPartsHandler handler = new ListPartsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketWebsiteConfigurationHandler parseWebsiteConfigurationResponse(InputStream inputStream) throws IOException {
        BucketWebsiteConfigurationHandler handler = new BucketWebsiteConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLoggingConfigurationHandler parseLoggingStatusResponse(InputStream inputStream) throws IOException {
        BucketLoggingConfigurationHandler handler = new BucketLoggingConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetBucketInventoryConfigurationHandler parseGetBucketInventoryConfigurationResponse(InputStream inputStream) throws IOException {
        GetBucketInventoryConfigurationHandler handler = new GetBucketInventoryConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListBucketInventoryConfigurationsHandler parseBucketListInventoryConfigurationsResponse(InputStream inputStream) throws IOException {
        ListBucketInventoryConfigurationsHandler handler = new ListBucketInventoryConfigurationsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetObjectTaggingHandler parseObjectTaggingResponse(InputStream inputStream) throws IOException {
        GetObjectTaggingHandler handler = new GetObjectTaggingHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public GetBucketIntelligentTierConfigurationHandler parseBucketIntelligentTierConfigurationsResponse(InputStream inputStream) throws IOException {
        GetBucketIntelligentTierConfigurationHandler handler = new GetBucketIntelligentTierConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListQueueHandler parseListQueueResponse(InputStream inputStream) throws IOException {
        ListQueueHandler handler = new ListQueueHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DocListQueueHandler parseDocListQueueResponse(InputStream inputStream) throws IOException {
        DocListQueueHandler handler = new DocListQueueHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public MediaQueueResponseHandler parseUpdateMediaQueueResponse(InputStream inputStream) throws IOException {
        MediaQueueResponseHandler handler = new MediaQueueResponseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public MediaTemplateHandler parseMediaTemplateResponse(InputStream inputStream) throws IOException {
        MediaTemplateHandler handler = new MediaTemplateHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public SnapshotHandler parseSnapshotResponse(InputStream inputStream) throws IOException {
        SnapshotHandler handler = new SnapshotHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public GenerateMediainfoHandler parseGenerateMediainfoResponse(InputStream inputStream) throws IOException {
        GenerateMediainfoHandler handler = new GenerateMediainfoHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public WorkflowExecutionsHandler parseMediaWorkflowExecutionsResponse(InputStream inputStream) throws IOException {
        WorkflowExecutionsHandler handler = new WorkflowExecutionsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public MediaTemplatesHandler parseDescribeMediaTemplatesResponse(InputStream inputStream) throws IOException {
        MediaTemplatesHandler handler = new MediaTemplatesHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListMediaBucketHandler parseListBucketResponse(InputStream inputStream) throws IOException {
        ListMediaBucketHandler handler = new ListMediaBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListDocBucketHandler parseDocListBucketResponse(InputStream inputStream) throws IOException {
        ListDocBucketHandler handler = new ListDocBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public WorkflowListHandler parseWorkflowListResponse(InputStream inputStream) throws IOException {
        WorkflowListHandler handler = new WorkflowListHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public WorkflowHandler parseWorkflowResponse(InputStream inputStream) throws IOException {
        WorkflowHandler handler = new WorkflowHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public WorkflowExecutionHandler parseWorkflowExecutionResponse(InputStream inputStream) throws IOException {
        WorkflowExecutionHandler handler = new WorkflowExecutionHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public MediaJobCreatHandler parseJobCreatResponse(InputStream inputStream) throws IOException {
        MediaJobCreatHandler handler = new MediaJobCreatHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public MediaJobResponseHandler parseMediaJobRespones(InputStream inputStream) throws IOException {
        MediaJobResponseHandler handler = new MediaJobResponseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public BatchJobResponseHandler parseBatchJobResponse(InputStream inputStream) throws IOException {
        BatchJobResponseHandler handler = new BatchJobResponseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DescribeMediaJobsHandler parseMediaJobsRespones(InputStream inputStream) throws IOException {
        DescribeMediaJobsHandler handler = new DescribeMediaJobsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DocJobHandler parseDocJobResponse(InputStream inputStream) throws IOException {
        DocJobHandler handler = new DocJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DescribeDocProcessJobHandler parseDescribeDocJobResponse(InputStream inputStream) throws IOException {
        DescribeDocProcessJobHandler handler = new DescribeDocProcessJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DescribeDocProcessJobsHandler parseDocJobListResponse(InputStream inputStream) throws IOException {
        DescribeDocProcessJobsHandler handler = new DescribeDocProcessJobsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ImageAuditingHandler parseImageAuditingResponse(InputStream inputStream) throws IOException {
        ImageAuditingHandler handler = new ImageAuditingHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public CreateVideoAuditingJobHandler parseVideoAuditingJobResponse(InputStream inputStream) throws IOException {
        CreateVideoAuditingJobHandler handler = new CreateVideoAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public CreateAudioAuditingJobHandler parseAudioAuditingJobResponse(InputStream inputStream) throws IOException {
        CreateAudioAuditingJobHandler handler = new CreateAudioAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DescribeVideoAuditingJobHandler parseDescribeVideoAuditingJobResponse(InputStream inputStream) throws IOException {
        DescribeVideoAuditingJobHandler handler = new DescribeVideoAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DescribeAudioAuditingJobHandler parseDescribeAudioAuditingJobResponse(InputStream inputStream) throws IOException {
        DescribeAudioAuditingJobHandler handler = new DescribeAudioAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ImageLabelHandler parseImageLabelResponse(InputStream inputStream) throws IOException {
        ImageLabelHandler handler = new ImageLabelHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ImageLabelV2Handler parseImageLabelV2Response(InputStream inputStream) throws IOException {
        ImageLabelV2Handler handler = new ImageLabelV2Handler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public TextAuditingJobHandler parseTextAuditingResponse(InputStream inputStream) throws IOException {
        TextAuditingJobHandler handler = new TextAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public TextAuditingDescribeJobHandler parseTextAuditingDescribeResponse(InputStream inputStream) throws IOException {
        TextAuditingDescribeJobHandler handler = new TextAuditingDescribeJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DocumentAuditingJobHandler parseDocumentAuditingResponse(InputStream inputStream) throws IOException {
        DocumentAuditingJobHandler handler = new DocumentAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DocumentAuditingDescribeJobHandler parseDocumentAuditingDescribeResponse(InputStream inputStream) throws IOException {
        DocumentAuditingDescribeJobHandler handler = new DocumentAuditingDescribeJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public BatchImageAuditingHandler parseBatchImageAuditingResponse(InputStream inputStream) throws IOException {
        BatchImageAuditingHandler handler = new BatchImageAuditingHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public WebpageAuditingJobHandler parseWebpageAuditingJobResponse(InputStream inputStream) throws IOException {
        WebpageAuditingJobHandler handler = new WebpageAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public WebpageAuditingDescribeJobHandler parseDWebpageAuditingDescribeResponse(InputStream inputStream) throws IOException {
        WebpageAuditingDescribeJobHandler handler = new WebpageAuditingDescribeJobHandler();
        CIXmlResponsesSaxParser pxis = new CIXmlResponsesSaxParser();
        pxis.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DescribeImageAuditingJobHandler parseImageAuditingDescribeResponse(InputStream inputStream) throws IOException {
        DescribeImageAuditingJobHandler handler = new DescribeImageAuditingJobHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DetectCarHandler parseDetectCarResponse(InputStream inputStream) throws IOException {
        DetectCarHandler handler = new DetectCarHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public SearchImageHandler parseSearchImagesResponse(InputStream inputStream) throws IOException {
        SearchImageHandler handler = new SearchImageHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public TriggerWorkflowListHandler parsetriggerWorkflowListResponse(InputStream inputStream) throws IOException {
        TriggerWorkflowListHandler handler = new TriggerWorkflowListHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public GenerateQrcodeHandler parseGenerateQrcodeResponse(InputStream inputStream) throws IOException {
        GenerateQrcodeHandler handler = new GenerateQrcodeHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public GenerateQrcodeHandler parseImageStyleResponse(InputStream inputStream) throws IOException {
        GenerateQrcodeHandler handler = new GenerateQrcodeHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public GetImageStyleHandler parseGetImageStyleResponse(InputStream inputStream) throws IOException {
        GetImageStyleHandler handler = new GetImageStyleHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DecompressionHandler parseDecompressionResult(InputStream inputStream) throws IOException {
        DecompressionHandler handler = new DecompressionHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListJobsResultHandler parseListJobsResult(InputStream inputStream) throws IOException {
        ListJobsResultHandler handler = new ListJobsResultHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public FileProcessResponseHandler parseFileProcessResponse(InputStream inputStream) throws IOException {
        FileProcessResponseHandler handler = new FileProcessResponseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public AutoTranslationBlockResponseHandler parseAutoTranslationBlockResponse(InputStream inputStream) throws IOException {
        AutoTranslationBlockResponseHandler handler = new AutoTranslationBlockResponseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public DetectFaceResponseHandler parseDetectFaceResponse(InputStream inputStream) throws IOException {
        DetectFaceResponseHandler handler = new DetectFaceResponseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public AIGameRecResponseHandler parseAIGameRecResponse(InputStream inputStream) throws IOException {
        AIGameRecResponseHandler handler = new AIGameRecResponseHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    private static String findAttributeValue(String qnameToFind, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            if (!qname.trim().equalsIgnoreCase(qnameToFind.trim())) continue;
            return attrs.getValue(i);
        }
        return null;
    }

    public static class ListJobsResultHandler
    extends AbstractHandler {
        private final ListJobsResult listJobsResult = new ListJobsResult();
        private final List<ListJobsResult.DecompressionJob> jobList = new ArrayList<ListJobsResult.DecompressionJob>();
        private ListJobsResult.DecompressionJob job;

        public ListJobsResultHandler() {
            this.listJobsResult.setJobs(this.jobList);
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListJobsResult", "Jobs") && name.equals("Job")) {
                this.job = new ListJobsResult.DecompressionJob();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListJobsResult", "Jobs", "Job")) {
                switch (name) {
                    case "Key": {
                        this.job.setKey(this.getText());
                        break;
                    }
                    case "DecompressionPrefix": {
                        this.job.setDecompressionPrefix(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        this.job.setCreationTime(this.getText());
                        break;
                    }
                    case "TerminationTime": {
                        this.job.setTerminationTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        this.job.setJobId(this.getText());
                        break;
                    }
                    case "Status": {
                        this.job.setStatus(this.getText());
                    }
                }
            } else if (this.in("ListJobsResult", "Jobs")) {
                if (name.equals("Job")) {
                    this.jobList.add(this.job);
                }
            } else if (this.in("ListJobsResult") && name.equals("NextToken")) {
                this.listJobsResult.setNextToken(this.getText());
            }
        }

        public ListJobsResult getResult() {
            return this.listJobsResult;
        }
    }

    public static class DecompressionHandler
    extends AbstractHandler {
        private final DecompressionResult decompressionResult = new DecompressionResult();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("DecompressionResult")) {
                switch (name) {
                    case "JobId": {
                        this.decompressionResult.setJobId(this.getText());
                        break;
                    }
                    case "Status": {
                        this.decompressionResult.setStatus(this.getText());
                        break;
                    }
                    case "Msg": {
                        this.decompressionResult.setMsg(this.getText());
                    }
                }
            }
        }

        public DecompressionResult getDecompressionResult() {
            return this.decompressionResult;
        }
    }

    public static class DescribeImageAuditingJobHandler
    extends AbstractHandler {
        private ImageAuditingResponse response = new ImageAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(name)) {
                this.response.getListInfo().getListResults().add(new ListResult());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<ListResult> listResults;
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(name)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "JobsDetail")) {
                switch (name) {
                    case "JobId": {
                        this.response.setJobId(this.getText());
                        break;
                    }
                    case "Label": {
                        this.response.setLabel(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        this.response.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        this.response.setObject(this.getText());
                        break;
                    }
                    case "Result": {
                        this.response.setResult(this.getText());
                        break;
                    }
                    case "Code": {
                        this.response.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        this.response.setMessage(this.getText());
                        break;
                    }
                    case "DataId": {
                        this.response.setDataId(this.getText());
                        break;
                    }
                    case "Url": {
                        this.response.setUrl(this.getText());
                        break;
                    }
                    case "State": {
                        this.response.setState(this.getText());
                        break;
                    }
                    case "Text": {
                        this.response.setText(this.getText());
                        break;
                    }
                    case "Category": {
                        this.response.setCategory(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        this.response.setForbidState(this.getText());
                        break;
                    }
                    case "Score": {
                        this.response.setScore(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getTeenagerInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getUserInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPornInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPoliticsInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getTerroristInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getAdsInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults") && !(listResults = this.response.getListInfo().getListResults()).isEmpty()) {
                ParserMediaInfoUtils.parsingAuditingListResultInfo(listResults.get(listResults.size() - 1), name, this.getText());
            }
        }

        public ImageAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(ImageAuditingResponse response) {
            this.response = response;
        }
    }

    public static class WebpageAuditingJobHandler
    extends AbstractHandler {
        private WebpageAuditingResponse response = new WebpageAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response", "JobsDetail")) {
                WebpageAuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response") && "RequestId".equalsIgnoreCase(name)) {
                this.response.setRequestId(this.getText());
            }
        }

        public WebpageAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(WebpageAuditingResponse response) {
            this.response = response;
        }
    }

    public static class BatchImageAuditingHandler
    extends AbstractHandler {
        private BatchImageAuditingResponse response = new BatchImageAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            List<BatchImageJobDetail> jobList = this.response.getJobList();
            if (this.in("Response") && "JobsDetail".equals(name)) {
                jobList.add(new BatchImageJobDetail());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(name)) {
                if (!jobList.isEmpty()) {
                    List<ListResult> listResults = jobList.get(jobList.size() - 1).getListInfo().getListResults();
                    listResults.add(new ListResult());
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo") && "LibResults".equals(name)) {
                jobList.get(jobList.size() - 1).getPornInfo().getLibResults().add(new LibResult());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo") && "LibResults".equals(name)) {
                jobList.get(jobList.size() - 1).getPoliticsInfo().getLibResults().add(new LibResult());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo") && "LibResults".equals(name) || this.in("Response", "JobsDetail", "TerrorismInfo") && "LibResults".equals(name)) {
                jobList.get(jobList.size() - 1).getTerroristInfo().getLibResults().add(new LibResult());
            } else if (this.in("Response", "JobsDetail", "AdsInfo") && "LibResults".equals(name)) {
                jobList.get(jobList.size() - 1).getAdsInfo().getLibResults().add(new LibResult());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo") && "LibResults".equals(name)) {
                jobList.get(jobList.size() - 1).getTeenagerInfo().getLibResults().add(new LibResult());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<BatchImageJobDetail> jobList = this.response.getJobList();
            BatchImageJobDetail jobsDetail = null;
            jobsDetail = jobList != null && jobList.size() > 0 ? jobList.get(jobList.size() - 1) : new BatchImageJobDetail();
            if (this.in("Response", "JobsDetail")) {
                ParserMediaInfoUtils.ParsingAuditingBatchImageJobDetail(jobsDetail, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                this.parseInfo(jobsDetail.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                this.parseInfo(jobsDetail.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo") || this.in("Response", "JobsDetail", "TerrorismInfo")) {
                this.parseInfo(jobsDetail.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                this.parseInfo(jobsDetail.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo")) {
                this.parseInfo(jobsDetail.getTeenagerInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo", "LibResults")) {
                List<LibResult> libResults = jobsDetail.getPornInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(libResults, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "LibResults")) {
                List<LibResult> libResults = jobsDetail.getPoliticsInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(libResults, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo", "LibResults") || this.in("Response", "JobsDetail", "TerrorismInfo", "LibResults")) {
                List<LibResult> libResults = jobsDetail.getTerroristInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(libResults, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo", "LibResults")) {
                List<LibResult> libResults = jobsDetail.getAdsInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(libResults, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo", "LibResults")) {
                List<LibResult> libResults = jobsDetail.getTeenagerInfo().getLibResults();
                ParserMediaInfoUtils.parsingLastLibResult(libResults, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(jobsDetail.getUserInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> listResults = jobsDetail.getListInfo().getListResults();
                if (listResults.isEmpty()) {
                    return;
                }
                ParserMediaInfoUtils.parsingAuditingListResultInfo(listResults.get(listResults.size() - 1), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PornInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(jobsDetail.getPornInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(jobsDetail.getPoliticsInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo", "ObjectResults")) {
                ParserMediaInfoUtils.parseObjectResultsInfo(jobsDetail.getPoliticsInfo().getPoliticsInfoObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerroristInfo", "OcrResults") || this.in("Response", "JobsDetail", "TerrorismInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(jobsDetail.getTerroristInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(jobsDetail.getAdsInfo().getOcrResults(), name, this.getText());
            }
        }

        public BatchImageAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(BatchImageAuditingResponse response) {
            this.response = response;
        }

        private void parseInfo(AudtingCommonInfo obj, String name, String value) {
            switch (name) {
                case "Code": {
                    obj.setCode(value);
                    break;
                }
                case "Msg": {
                    obj.setMsg(this.getText());
                    break;
                }
                case "HitFlag": {
                    obj.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    obj.setScore(this.getText());
                    break;
                }
                case "Label": {
                    obj.setLabel(this.getText());
                    break;
                }
            }
        }
    }

    public static class DocumentAuditingDescribeJobHandler
    extends AbstractHandler {
        private DocumentAuditingResponse response = new DocumentAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            List<DocumentResultInfo> pageSegment = this.response.getJobsDetail().getPageSegment();
            if (this.in("Response", "JobsDetail", "PageSegment") && "Results".equals(name)) {
                pageSegment.add(new DocumentResultInfo());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo") && "ObjectResults".equals(name)) {
                pageSegment.get(pageSegment.size() - 1).getPoliticsInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo") && "ObjectResults".equals(name)) {
                pageSegment.get(pageSegment.size() - 1).getPornInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo") && "ObjectResults".equals(name)) {
                pageSegment.get(pageSegment.size() - 1).getAdsInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerroristInfo") && "ObjectResults".equals(name)) {
                pageSegment.get(pageSegment.size() - 1).getTerroristInfo().getObjectResults().add(new ObjectResults());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(name)) {
                this.response.getJobsDetail().getListInfo().getListResults().add(new ListResult());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<ListResult> listResults;
            DocumentAuditingJobsDetail jobsDetail = this.response.getJobsDetail();
            List<DocumentResultInfo> pageSegment = jobsDetail.getPageSegment();
            DocumentResultInfo resultDetail = new DocumentResultInfo();
            if (pageSegment.size() != 0) {
                resultDetail = pageSegment.get(pageSegment.size() - 1);
            }
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(name)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "JobsDetail")) {
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Suggestion": {
                        jobsDetail.setSuggestion(this.getText());
                        break;
                    }
                    case "PageCount": {
                        jobsDetail.setPageCount(this.getText());
                        break;
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                        break;
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        jobsDetail.setForbidState(this.getText());
                        break;
                    }
                    case "Label": {
                        jobsDetail.setLabel(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Labels", "AdsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "PoliticsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "PornInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Labels", "TerrorismInfo")) {
                this.parseInfo(this.response.getJobsDetail().getLabels().getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo")) {
                this.parseInfo(resultDetail.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo")) {
                this.parseInfo(resultDetail.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo")) {
                this.parseInfo(resultDetail.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo")) {
                this.parseInfo(resultDetail.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results")) {
                if ("Text".equalsIgnoreCase(name)) {
                    resultDetail.setText(this.getText());
                } else if ("Url".equalsIgnoreCase(name)) {
                    resultDetail.setUrl(this.getText());
                } else if ("Label".equalsIgnoreCase(name)) {
                    resultDetail.setLabel(this.getText());
                } else if ("Suggestion".equalsIgnoreCase(name)) {
                    resultDetail.setSuggestion(this.getText());
                } else if ("PageNumber".equalsIgnoreCase(name)) {
                    resultDetail.setPageNumber(this.getText());
                } else if ("SheetNumber".equalsIgnoreCase(name)) {
                    resultDetail.setSheetNumber(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo", "OcrResults")) {
                this.parseResultInfo(resultDetail.getPornInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo", "OcrResults")) {
                this.parseResultInfo(resultDetail.getPoliticsInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo", "OcrResults")) {
                this.parseResultInfo(resultDetail.getTerroristInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo", "OcrResults")) {
                this.parseResultInfo(resultDetail.getAdsInfo().getOcrResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo", "ObjectResults")) {
                this.parseResultInfo(resultDetail.getPornInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo", "ObjectResults")) {
                this.parseResultInfo(resultDetail.getPoliticsInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo", "ObjectResults")) {
                this.parseResultInfo(resultDetail.getTerroristInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo", "ObjectResults")) {
                this.parseResultInfo(resultDetail.getAdsInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PornInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(resultDetail.getPornInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "PoliticsInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(resultDetail.getPoliticsInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "TerrorismInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(resultDetail.getTerroristInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PageSegment", "Results", "AdsInfo", "ObjectResults", "Location")) {
                this.parseResultInfo(resultDetail.getAdsInfo().getObjectResults(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults") && !(listResults = this.response.getJobsDetail().getListInfo().getListResults()).isEmpty()) {
                ParserMediaInfoUtils.parsingAuditingListResultInfo(listResults.get(listResults.size() - 1), name, this.getText());
            }
        }

        public DocumentAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(DocumentAuditingResponse response) {
            this.response = response;
        }

        private void parseInfo(AudtingCommonInfo obj, String name, String value) {
            switch (name) {
                case "Code": {
                    obj.setCode(value);
                    break;
                }
                case "HitFlag": {
                    obj.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    obj.setScore(this.getText());
                    break;
                }
                case "Keywords": {
                    obj.setKeywords(this.getText());
                    break;
                }
                case "Count": {
                    obj.setCount(this.getText());
                    break;
                }
                case "Label": {
                    obj.setLabel(this.getText());
                    break;
                }
                case "Category": {
                    obj.setCategory(this.getText());
                    break;
                }
                case "SubLabel": {
                    obj.setSubLabel(this.getText());
                    break;
                }
            }
        }

        private void parseResultInfo(List<ObjectResults> obj, String name, String value) {
            if (!obj.isEmpty()) {
                ObjectResults objectResult = obj.get(obj.size() - 1);
                ObjectResults.Location location = objectResult.getLocation();
                switch (name) {
                    case "Name": {
                        objectResult.setName(value);
                        break;
                    }
                    case "Height": {
                        location.setHeight(value);
                        break;
                    }
                    case "Rotate": {
                        location.setRotate(value);
                        break;
                    }
                    case "Width": {
                        location.setWidth(value);
                        break;
                    }
                    case "X": {
                        location.setX(value);
                        break;
                    }
                    case "Y": {
                        location.setY(value);
                        break;
                    }
                }
            }
        }

        private void parseResultInfo(OcrResults obj, String name, String value) {
            switch (name) {
                case "Text": {
                    obj.setText(value);
                    break;
                }
                case "Keywords": {
                    obj.setKeywords(this.getText());
                    break;
                }
            }
        }
    }

    public static class DocumentAuditingJobHandler
    extends AbstractHandler {
        private DocumentAuditingResponse response = new DocumentAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response", "JobsDetail")) {
                DocumentAuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response") && "RequestId".equalsIgnoreCase(name)) {
                this.response.setRequestId(this.getText());
            }
        }

        public DocumentAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(DocumentAuditingResponse response) {
            this.response = response;
        }
    }

    public static class TextAuditingDescribeJobHandler
    extends AbstractHandler {
        private TextAuditingResponse response = new TextAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            AuditingJobsDetail jobsDetail = this.response.getJobsDetail();
            List<SectionInfo> sectionList = jobsDetail.getSectionList();
            if ((this.in("Response", "Detail") || this.in("Response", "JobsDetail")) && "Section".equals(name)) {
                sectionList.add(new SectionInfo());
            } else if (this.in("Response", "JobsDetail", "Section", "PornInfo") && "LibResults".equals(name) && !sectionList.isEmpty()) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                List<LibResult> libResults = sectionInfo.getPornInfo().getLibResults();
                libResults.add(new LibResult());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<SectionInfo> sectionList = this.response.getJobsDetail().getSectionList();
            if (this.in("Response", "Detail") || this.in("Response", "JobsDetail")) {
                AuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                        break;
                    }
                    case "SectionCount": {
                        jobsDetail.setSectionCount(this.getText());
                        break;
                    }
                    case "Result": {
                        jobsDetail.setResult(this.getText());
                        break;
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Label": {
                        jobsDetail.setLabel(this.getText());
                        break;
                    }
                    case "SubLabel": {
                        jobsDetail.setSubLabel(this.getText());
                        break;
                    }
                    case "Content": {
                        jobsDetail.setContent(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        jobsDetail.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "Detail", "PornInfo") || this.in("Response", "JobsDetail", "PornInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPornInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "PoliticsInfo") || this.in("Response", "JobsDetail", "PoliticsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "TerrorismInfo") || this.in("Response", "JobsDetail", "TerrorismInfo")) {
                this.parseInfo(this.response.getJobsDetail().getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "AdsInfo") || this.in("Response", "JobsDetail", "AdsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "AbuseInfo") || this.in("Response", "JobsDetail", "AbuseInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAbuseInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "IllegalInfo") || this.in("Response", "JobsDetail", "IllegalInfo")) {
                this.parseInfo(this.response.getJobsDetail().getIllegalInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> listResults = this.response.getJobsDetail().getListInfo().getListResults();
                if (!listResults.isEmpty()) {
                    ParserMediaInfoUtils.parsingAuditingListResultInfo(listResults.get(listResults.size() - 1), name, this.getText());
                }
            } else if (this.in("Response", "Detail", "Section") || this.in("Response", "JobsDetail", "Section")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                ParserMediaInfoUtils.parseSectionInfo(sectionInfo, name, this.getText());
            } else if (this.in("Response", "Detail", "Section", "PornInfo") || this.in("Response", "JobsDetail", "Section", "PornInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "Section", "PoliticsInfo") || this.in("Response", "JobsDetail", "Section", "PoliticsInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "Section", "TerrorismInfo") || this.in("Response", "JobsDetail", "Section", "TerrorismInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "Section", "AdsInfo") || this.in("Response", "JobsDetail", "Section", "AdsInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "Section", "AbuseInfo") || this.in("Response", "JobsDetail", "Section", "AbuseInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getAbuseInfo(), name, this.getText());
            } else if (this.in("Response", "Detail", "Section", "IllegalInfo") || this.in("Response", "JobsDetail", "Section", "IllegalInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getIllegalInfo(), name, this.getText());
            }
        }

        public TextAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(TextAuditingResponse response) {
            this.response = response;
        }

        private void parseInfo(AudtingCommonInfo obj, String name, String value) {
            ParserMediaInfoUtils.ParsingAuditingCommonInfo(obj, name, value);
        }
    }

    public static class TextAuditingJobHandler
    extends AbstractHandler {
        private TextAuditingResponse response = new TextAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            List<SectionInfo> sectionList = this.response.getJobsDetail().getSectionList();
            if ((this.in("Response", "Detail") || this.in("Response", "JobsDetail")) && "Section".equals(name)) {
                sectionList.add(new SectionInfo());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<SectionInfo> sectionList = this.response.getJobsDetail().getSectionList();
            if (this.in("Response", "Detail") || this.in("Response", "JobsDetail")) {
                AuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                        break;
                    }
                    case "SectionCount": {
                        jobsDetail.setSectionCount(this.getText());
                        break;
                    }
                    case "Result": {
                        jobsDetail.setResult(this.getText());
                        break;
                    }
                    case "Content": {
                        jobsDetail.setContent(this.getText());
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Label": {
                        jobsDetail.setLabel(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerrorismInfo")) {
                this.parseInfo(this.response.getJobsDetail().getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AbuseInfo")) {
                this.parseInfo(this.response.getJobsDetail().getAbuseInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "IllegalInfo")) {
                this.parseInfo(this.response.getJobsDetail().getIllegalInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                ParserMediaInfoUtils.parseSectionInfo(sectionInfo, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PornInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PoliticsInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "TerrorismInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "AdsInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "AbuseInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getAbuseInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "IllegalInfo")) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                this.parseInfo(sectionInfo.getIllegalInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), name, this.getText());
            }
        }

        public TextAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(TextAuditingResponse response) {
            this.response = response;
        }

        private void parseInfo(AudtingCommonInfo obj, String name, String value) {
            ParserMediaInfoUtils.ParsingAuditingCommonInfo(obj, name, value);
        }
    }

    public static class ImageLabelV2Handler
    extends AbstractHandler {
        private ImageLabelV2Response response = new ImageLabelV2Response();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("RecognitionResult", "AlbumLabels") && "Label".equalsIgnoreCase(name)) {
                this.response.getAlbumLabels().add(new LabelV2());
            } else if (this.in("RecognitionResult", "CameraLabels") && "Label".equalsIgnoreCase(name)) {
                this.response.getCameraLabels().add(new LabelV2());
            } else if (this.in("RecognitionResult", "WebLabels") && "Label".equalsIgnoreCase(name)) {
                this.response.getWebLabels().add(new LabelV2());
            } else if (this.in("RecognitionResult", "NewsLabels") && "Label".equalsIgnoreCase(name)) {
                this.response.getNewsLabels().add(new LabelV2());
            } else if (this.in("RecognitionResult", "NoneCamLabels") && "Label".equalsIgnoreCase(name)) {
                this.response.getNoneCamLabels().add(new LabelV2());
            } else if (this.in("RecognitionResult", "ProductLabels") && "Label".equalsIgnoreCase(name)) {
                this.response.getProductLabels().add(new LocationLabel());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            LabelV2 lobel = null;
            if (this.in("RecognitionResult", "AlbumLabels", "Label")) {
                List<LabelV2> lobels = this.response.getAlbumLabels();
                lobel = this.getListLast(lobels);
            } else if (this.in("RecognitionResult", "CameraLabels", "Label")) {
                List<LabelV2> lobels = this.response.getCameraLabels();
                lobel = this.getListLast(lobels);
            } else if (this.in("RecognitionResult", "WebLabels", "Label")) {
                List<LabelV2> lobels = this.response.getWebLabels();
                lobel = this.getListLast(lobels);
            } else if (this.in("RecognitionResult", "ProductLabels", "Label")) {
                List<LocationLabel> ProductLabels = this.response.getProductLabels();
                LocationLabel locationLabel = ProductLabels.get(ProductLabels.size() - 1);
                this.addLocationLabel(locationLabel, name, this.getText());
            } else if (this.in("RecognitionResult", "NewsLabels", "Label")) {
                List<LabelV2> lobels = this.response.getNewsLabels();
                lobel = this.getListLast(lobels);
            } else if (this.in("RecognitionResult", "NoneCamLabels", "Label")) {
                List<LabelV2> lobels = this.response.getNoneCamLabels();
                lobel = this.getListLast(lobels);
            }
            if (lobel != null) {
                this.addLabel(lobel, name, this.getText());
            }
        }

        public ImageLabelV2Response getResponse() {
            return this.response;
        }

        public void setResponse(ImageLabelV2Response response) {
            this.response = response;
        }

        private void addLabel(LabelV2 lobel, String name, String value) {
            switch (name) {
                case "Confidence": {
                    lobel.setConfidence(value);
                    break;
                }
                case "Name": {
                    lobel.setName(value);
                    break;
                }
                case "FirstCategory": {
                    lobel.setFirstCategory(value);
                    break;
                }
                case "SecondCategory": {
                    lobel.setSecondCategory(value);
                    break;
                }
            }
        }

        private void addLocationLabel(LocationLabel lobel, String name, String value) {
            switch (name) {
                case "Confidence": {
                    lobel.setConfidence(value);
                    break;
                }
                case "Name": {
                    lobel.setName(value);
                    break;
                }
                case "Parents": {
                    lobel.setParents(value);
                    break;
                }
                case "XMax": {
                    lobel.setxMax(value);
                    break;
                }
                case "XMin": {
                    lobel.setxMin(value);
                    break;
                }
                case "YMax": {
                    lobel.setyMax(value);
                    break;
                }
                case "YMin": {
                    lobel.setyMin(value);
                    break;
                }
            }
        }

        private LabelV2 getListLast(List<LabelV2> list) {
            return list.get(list.size() - 1);
        }
    }

    public static class ImageLabelHandler
    extends AbstractHandler {
        private ImageLabelResponse response = new ImageLabelResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("Labels".equalsIgnoreCase(name)) {
                this.response.getRecognitionResult().add(new Label());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<Label> list = this.response.getRecognitionResult();
            if (list.isEmpty()) {
                return;
            }
            Label label = list.get(list.size() - 1);
            if (this.in("RecognitionResult", "Labels")) {
                this.addLabel(label, name, this.getText());
            } else if (this.in("RecognitionResult", "AlbumLabels", "Labels")) {
                label.setLabelName("AlbumLabels");
                this.addLabel(label, name, this.getText());
            } else if (this.in("RecognitionResult", "WebLabels", "Labels")) {
                label.setLabelName("WebLabels");
                this.addLabel(label, name, this.getText());
            } else if (this.in("RecognitionResult", "CameraLabels", "Labels")) {
                label.setLabelName("CameraLabels");
                this.addLabel(label, name, this.getText());
            } else if (this.in("RecognitionResult", "NewsLabels", "Labels")) {
                label.setLabelName("NewsLabels");
                this.addLabel(label, name, this.getText());
            }
        }

        private void addLabel(Label label, String name, String value) {
            switch (name) {
                case "Confidence": {
                    label.setConfidence(value);
                    break;
                }
                case "Name": {
                    label.setName(value);
                    break;
                }
                case "FirstCategory": {
                    label.setFirstCategory(value);
                    break;
                }
                case "SecondCategory": {
                    label.setSecondCategory(value);
                    break;
                }
            }
        }

        public ImageLabelResponse getResponse() {
            return this.response;
        }

        public void setResponse(ImageLabelResponse response) {
            this.response = response;
        }
    }

    public static class CreateAudioAuditingJobHandler
    extends AbstractHandler {
        private AudioAuditingResponse response = new AudioAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                }
            }
        }

        public AudioAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(AudioAuditingResponse response) {
            this.response = response;
        }
    }

    public static class DescribeAudioAuditingJobHandler
    extends AbstractHandler {
        private AudioAuditingResponse response = new AudioAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            List<SectionInfo> sectionList = this.response.getJobsDetail().getSectionList();
            if (this.in("Response", "JobsDetail") && "Section".equals(name)) {
                sectionList.add(new SectionInfo());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(name)) {
                this.response.getJobsDetail().getListInfo().getListResults().add(new ListResult());
            } else if (this.in("Response", "JobsDetail", "Section") && "LanguageResults".equals(name) && !sectionList.isEmpty()) {
                SectionInfo sectionInfo = sectionList.get(sectionList.size() - 1);
                List<LanguageResult> languageResult = sectionInfo.getLanguageResult();
                languageResult.add(new LanguageResult());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<SectionInfo> sectionList;
            SectionInfo sectionInfo;
            List<LanguageResult> languageResults;
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                        break;
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "Result": {
                        jobsDetail.setResult(this.getText());
                        break;
                    }
                    case "AudioText": {
                        jobsDetail.setAudioText(this.getText());
                        break;
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Label": {
                        jobsDetail.setLabel(this.getText());
                        break;
                    }
                    case "SubLabel": {
                        jobsDetail.setSubLabel(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        jobsDetail.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTeenagerInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PornInfo")) {
                List<SectionInfo> sectionList2 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo2 = sectionList2.get(sectionList2.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo2.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "PoliticsInfo")) {
                List<SectionInfo> sectionList3 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo3 = sectionList3.get(sectionList3.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo3.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "TerrorismInfo")) {
                List<SectionInfo> sectionList4 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo4 = sectionList4.get(sectionList4.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo4.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "AdsInfo")) {
                List<SectionInfo> sectionList5 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo5 = sectionList5.get(sectionList5.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo5.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section", "TeenagerInfo")) {
                List<SectionInfo> sectionList6 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo6 = sectionList6.get(sectionList6.size() - 1);
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(sectionInfo6.getTeenagerInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Section")) {
                List<SectionInfo> sectionList7 = this.response.getJobsDetail().getSectionList();
                SectionInfo sectionInfo7 = sectionList7.get(sectionList7.size() - 1);
                ParserMediaInfoUtils.parseSectionInfo(sectionInfo7, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> listResults = this.response.getJobsDetail().getListInfo().getListResults();
                if (!listResults.isEmpty()) {
                    ParserMediaInfoUtils.parsingAuditingListResultInfo(listResults.get(listResults.size() - 1), name, this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Section", "LanguageResults") && !(languageResults = (sectionInfo = (sectionList = this.response.getJobsDetail().getSectionList()).get(sectionList.size() - 1)).getLanguageResult()).isEmpty()) {
                LanguageResult result = languageResults.get(languageResults.size() - 1);
                ParserMediaInfoUtils.parseLanguageResult(result, name, this.getText());
            }
        }

        public AudioAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(AudioAuditingResponse response) {
            this.response = response;
        }
    }

    public static class CreateVideoAuditingJobHandler
    extends AbstractHandler {
        private VideoAuditingResponse response = new VideoAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                }
            }
        }

        public VideoAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(VideoAuditingResponse response) {
            this.response = response;
        }
    }

    public static class DescribeVideoAuditingJobHandler
    extends AbstractHandler {
        private VideoAuditingResponse response = new VideoAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            List<SnapshotInfo> snapshotList = this.response.getJobsDetail().getSnapshotList();
            List<AudioSectionInfo> audioSectionList = this.response.getJobsDetail().getAudioSectionList();
            if (this.in("Response", "JobsDetail") && "Snapshot".equals(name)) {
                snapshotList.add(new SnapshotInfo());
            }
            if (this.in("Response", "JobsDetail") && "AudioSection".equals(name)) {
                audioSectionList.add(new AudioSectionInfo());
            } else if (this.in("Response", "JobsDetail", "ListInfo") && "ListResults".equals(name)) {
                this.response.getJobsDetail().getListInfo().getListResults().add(new ListResult());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<SnapshotInfo> snapshotList = this.response.getJobsDetail().getSnapshotList();
            List<AudioSectionInfo> audioSectionList = this.response.getJobsDetail().getAudioSectionList();
            SnapshotInfo snapshotInfo = new SnapshotInfo();
            AudioSectionInfo audioSectionInfo = new AudioSectionInfo();
            if (snapshotList == null || !snapshotList.isEmpty()) {
                snapshotInfo = snapshotList.get(snapshotList.size() - 1);
            }
            if (audioSectionList == null || !audioSectionList.isEmpty()) {
                audioSectionInfo = audioSectionList.get(audioSectionList.size() - 1);
            }
            if (this.in("Response", "JobsDetail")) {
                AuditingJobsDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "Object": {
                        jobsDetail.setObject(this.getText());
                        break;
                    }
                    case "SnapshotCount": {
                        jobsDetail.setSnapshotCount(this.getText());
                        break;
                    }
                    case "Result": {
                        jobsDetail.setResult(this.getText());
                        break;
                    }
                    case "Url": {
                        jobsDetail.setUrl(this.getText());
                        break;
                    }
                    case "DataId": {
                        jobsDetail.setDataId(this.getText());
                        break;
                    }
                    case "Label": {
                        jobsDetail.setLabel(this.getText());
                        break;
                    }
                    case "ForbidState": {
                        jobsDetail.setForbidState(this.getText());
                        break;
                    }
                    case "Type": {
                        jobsDetail.setType(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(this.response.getJobsDetail().getTeenagerInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot", "TeenagerInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(snapshotInfo.getTeenagerInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "TerrorismInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getTerroristInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "PornInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getPornInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "PoliticsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getPoliticsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection", "AdsInfo")) {
                ParserMediaInfoUtils.ParsingAuditingCommonInfo(audioSectionInfo.getAdsInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Snapshot")) {
                ParserMediaInfoUtils.parseSnapshotInfo(snapshotInfo, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "AudioSection")) {
                ParserMediaInfoUtils.parseAudioSection(audioSectionInfo, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getJobsDetail().getUserInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "ListInfo", "ListResults")) {
                List<ListResult> listResults = this.response.getJobsDetail().getListInfo().getListResults();
                if (!listResults.isEmpty()) {
                    ParserMediaInfoUtils.parsingAuditingListResultInfo(listResults.get(listResults.size() - 1), name, this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "MaskInfo", "LiveInfo")) {
                ParserMediaInfoUtils.ParsingAuditingLiveInfo(this.response.getJobsDetail().getMaskInfo().getAuditingLiveInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "MaskInfo", "RecordInfo")) {
                ParserMediaInfoUtils.ParsingAuditingRecordInfo(this.response.getJobsDetail().getMaskInfo().getRecordInfo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "MaskInfo", "RecordInfo", "Output")) {
                ParserMediaInfoUtils.ParsingAuditingOutput(this.response.getJobsDetail().getMaskInfo().getRecordInfo().getOutput(), name, this.getText());
            }
        }

        public VideoAuditingResponse getResponse() {
            return this.response;
        }

        public void setResponse(VideoAuditingResponse response) {
            this.response = response;
        }
    }

    public static class ImageAuditingHandler
    extends AbstractHandler {
        private ImageAuditingResponse response = new ImageAuditingResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("RecognitionResult")) {
                switch (name) {
                    case "JobId": {
                        this.response.setJobId(this.getText());
                        break;
                    }
                    case "CompressionResult": {
                        this.response.setCompressionResult(this.getText());
                        break;
                    }
                    case "Result": {
                        this.response.setResult(this.getText());
                        break;
                    }
                    case "Label": {
                        this.response.setLabel(this.getText());
                        break;
                    }
                    case "Category": {
                        this.response.setCategory(this.getText());
                        break;
                    }
                    case "SubLabel": {
                        this.response.setSubLabel(this.getText());
                        break;
                    }
                    case "Score": {
                        this.response.setScore(this.getText());
                        break;
                    }
                    case "Text": {
                        this.response.setText(this.getText());
                        break;
                    }
                    case "DataId": {
                        this.response.setDataId(this.getText());
                        break;
                    }
                    case "Object": {
                        this.response.setObject(this.getText());
                        break;
                    }
                    case "State": {
                        this.response.setState(this.getText());
                        break;
                    }
                    case "forbidState": {
                        this.response.setForbidState(this.getText());
                        break;
                    }
                }
            } else if (this.in("RecognitionResult", "PornInfo")) {
                this.parseInfo(this.response.getPornInfo(), name, this.getText());
            } else if (this.in("RecognitionResult", "PoliticsInfo")) {
                this.parseInfo(this.response.getPoliticsInfo(), name, this.getText());
            } else if (this.in("RecognitionResult", "TerroristInfo") || this.in("RecognitionResult", "TerrorismInfo")) {
                this.parseInfo(this.response.getTerroristInfo(), name, this.getText());
            } else if (this.in("RecognitionResult", "AdsInfo")) {
                this.parseInfo(this.response.getAdsInfo(), name, this.getText());
            } else if (this.in("RecognitionResult", "TeenagerInfo")) {
                this.parseInfo(this.response.getTeenagerInfo(), name, this.getText());
            } else if (this.in("RecognitionResult", "UserInfo")) {
                ParserMediaInfoUtils.ParsingAuditingUserInfo(this.response.getUserInfo(), name, this.getText());
            } else if (this.in("RecognitionResult", "PornInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPornInfo().getOcrResults(), name, this.getText());
            } else if (this.in("RecognitionResult", "PoliticsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getPoliticsInfo().getOcrResults(), name, this.getText());
            } else if (this.in("RecognitionResult", "TerroristInfo", "OcrResults") || this.in("RecognitionResult", "TerrorismInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getTerroristInfo().getOcrResults(), name, this.getText());
            } else if (this.in("RecognitionResult", "AdsInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getAdsInfo().getOcrResults(), name, this.getText());
            } else if (this.in("RecognitionResult", "TeenagerInfo", "OcrResults")) {
                ParserMediaInfoUtils.parseOrcInfo(this.response.getTeenagerInfo().getOcrResults(), name, this.getText());
            }
        }

        private void parseInfo(AudtingCommonInfo obj, String name, String value) {
            switch (name) {
                case "Code": {
                    obj.setCode(value);
                    break;
                }
                case "Msg": {
                    obj.setMsg(this.getText());
                    break;
                }
                case "HitFlag": {
                    obj.setHitFlag(this.getText());
                    break;
                }
                case "Score": {
                    obj.setScore(this.getText());
                    break;
                }
                case "Label": {
                    obj.setLabel(this.getText());
                    break;
                }
            }
        }

        public ImageAuditingResponse getResponse() {
            return this.response;
        }
    }

    public static class ListDocBucketHandler
    extends AbstractHandler {
        private DocBucketResponse response = new DocBucketResponse();
        boolean isNew = true;
        DocBucketObject bucketObject;

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("DocBucketList".equals(name)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.bucketObject = new DocBucketObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                switch (name) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "DocBucketList")) {
                switch (name) {
                    case "BucketId": {
                        this.bucketObject.setBucketId(this.getText());
                        break;
                    }
                    case "Region": {
                        this.bucketObject.setRegion(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.bucketObject.setCreateTime(this.getText());
                        break;
                    }
                    case "AliasBucketId": {
                        this.bucketObject.setAliasBucketId(this.getText());
                        break;
                    }
                    case "Name": {
                        this.bucketObject.setName(this.getText());
                        break;
                    }
                }
            }
            if ("DocBucketList".equals(name) && !this.isNew) {
                this.response.getDocBucketObjectList().add(this.bucketObject);
                this.bucketObject = null;
            }
        }

        public DocBucketResponse getResponse() {
            return this.response;
        }
    }

    public static class DescribeDocProcessJobsHandler
    extends AbstractHandler {
        DocJobListResponse response = new DocJobListResponse();
        DocJobDetail jobsDetail;
        DocProcessPageInfo pageInfo;

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("PageInfo".equalsIgnoreCase(name)) {
                this.pageInfo = new DocProcessPageInfo();
            } else if ("JobsDetail".equalsIgnoreCase(name)) {
                this.jobsDetail = new DocJobDetail();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response", "NextToken")) {
                this.response.setNextToken(this.getText());
            } else if (this.in("Response", "JobsDetail")) {
                switch (name) {
                    case "Code": {
                        this.jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        this.jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        this.jobsDetail.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        this.jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        this.jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        this.jobsDetail.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        this.jobsDetail.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        this.jobsDetail.setTag(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                if ("Object".equalsIgnoreCase(name)) {
                    this.jobsDetail.getInput().setObject(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcess")) {
                DocProcessObject docProcess = this.jobsDetail.getOperation().getDocProcessObject();
                switch (name) {
                    case "Comments": {
                        docProcess.setComments(this.getText());
                        break;
                    }
                    case "DocPassword": {
                        docProcess.setDocPassword(this.getText());
                        break;
                    }
                    case "EndPage": {
                        docProcess.setEndPage(this.getText());
                        break;
                    }
                    case "ImageParams": {
                        docProcess.setImageParams(this.getText());
                        break;
                    }
                    case "PaperDirection": {
                        docProcess.setPaperDirection(this.getText());
                        break;
                    }
                    case "Quality": {
                        docProcess.setQuality(this.getText());
                        break;
                    }
                    case "SrcType": {
                        docProcess.setSrcType(this.getText());
                        break;
                    }
                    case "StartPage": {
                        docProcess.setStartPage(this.getText());
                        break;
                    }
                    case "TgtType": {
                        docProcess.setTgtType(this.getText());
                        break;
                    }
                    case "Zoom": {
                        docProcess.setZoom(this.getText());
                        break;
                    }
                    case "SheetId": {
                        docProcess.setSheetId(this.getText());
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult")) {
                DocProcessResult docProcessResult = this.jobsDetail.getOperation().getDocProcessResult();
                switch (name) {
                    case "FailPageCount": {
                        docProcessResult.setFailPageCount(this.getText());
                        break;
                    }
                    case "SuccPageCount": {
                        docProcessResult.setSuccPageCount(this.getText());
                        break;
                    }
                    case "TgtType": {
                        docProcessResult.setTgtType(this.getText());
                        break;
                    }
                    case "TotalPageCount": {
                        docProcessResult.setTotalPageCount(this.getText());
                        break;
                    }
                    case "TotalSheetCount": {
                        docProcessResult.setTotalSheetCount(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                Object output = this.jobsDetail.getOperation().getOutput();
                switch (name) {
                    case "Bucket": {
                        ((MediaOutputObject)output).setBucket(this.getText());
                        break;
                    }
                    case "Object": {
                        ((MediaOutputObject)output).setObject(this.getText());
                        break;
                    }
                    case "Region": {
                        ((MediaOutputObject)output).setRegion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult", "PageInfo")) {
                switch (name) {
                    case "PageNo": {
                        this.pageInfo.setPageNo(this.getText());
                        break;
                    }
                    case "PicIndex": {
                        this.pageInfo.setPicIndex(this.getText());
                        break;
                    }
                    case "PicNum": {
                        this.pageInfo.setPicNum(this.getText());
                        break;
                    }
                    case "TgtUri": {
                        this.pageInfo.setTgtUri(this.getText());
                        break;
                    }
                    case "X-SheetPics": {
                        this.pageInfo.setxSheetPics(this.getText());
                        break;
                    }
                }
            }
            if ("PageInfo".equalsIgnoreCase(name)) {
                List<DocProcessPageInfo> pageInfoList = this.jobsDetail.getOperation().getDocProcessResult().getDocProcessPageInfoList();
                pageInfoList.add(this.pageInfo);
            } else if ("JobsDetail".equalsIgnoreCase(name)) {
                this.response.getDocJobDetailList().add(this.jobsDetail);
            }
        }

        public DocJobListResponse getResponse() {
            return this.response;
        }
    }

    public static class DescribeDocProcessJobHandler
    extends AbstractHandler {
        DocJobResponse response = new DocJobResponse();
        DocProcessPageInfo pageInfo = new DocProcessPageInfo();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("PageInfo".equalsIgnoreCase(name)) {
                this.pageInfo = new DocProcessPageInfo();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                if (name.equals("NonExistJobIds")) {
                    this.response.setNonExistJobIds(this.getText());
                }
            } else if (this.in("Response", "JobsDetail")) {
                DocJobDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        jobsDetail.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        jobsDetail.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        jobsDetail.setTag(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                if ("Object".equalsIgnoreCase(name)) {
                    this.response.getJobsDetail().getInput().setObject(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcess")) {
                DocProcessObject docProcess = this.response.getJobsDetail().getOperation().getDocProcessObject();
                switch (name) {
                    case "Comments": {
                        docProcess.setComments(this.getText());
                        break;
                    }
                    case "DocPassword": {
                        docProcess.setDocPassword(this.getText());
                        break;
                    }
                    case "EndPage": {
                        docProcess.setEndPage(this.getText());
                        break;
                    }
                    case "ImageParams": {
                        docProcess.setImageParams(this.getText());
                        break;
                    }
                    case "PaperDirection": {
                        docProcess.setPaperDirection(this.getText());
                        break;
                    }
                    case "Quality": {
                        docProcess.setQuality(this.getText());
                        break;
                    }
                    case "SrcType": {
                        docProcess.setSrcType(this.getText());
                        break;
                    }
                    case "StartPage": {
                        docProcess.setStartPage(this.getText());
                        break;
                    }
                    case "TgtType": {
                        docProcess.setTgtType(this.getText());
                        break;
                    }
                    case "Zoom": {
                        docProcess.setZoom(this.getText());
                        break;
                    }
                    case "SheetId": {
                        docProcess.setSheetId(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult")) {
                DocProcessResult docProcessResult = this.response.getJobsDetail().getOperation().getDocProcessResult();
                switch (name) {
                    case "FailPageCount": {
                        docProcessResult.setFailPageCount(this.getText());
                        break;
                    }
                    case "SuccPageCount": {
                        docProcessResult.setSuccPageCount(this.getText());
                        break;
                    }
                    case "TgtType": {
                        docProcessResult.setTgtType(this.getText());
                        break;
                    }
                    case "TotalPageCount": {
                        docProcessResult.setTotalPageCount(this.getText());
                        break;
                    }
                    case "TotalSheetCount": {
                        docProcessResult.setTotalSheetCount(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                Object output = this.response.getJobsDetail().getOperation().getOutput();
                switch (name) {
                    case "Bucket": {
                        ((MediaOutputObject)output).setBucket(this.getText());
                        break;
                    }
                    case "Object": {
                        ((MediaOutputObject)output).setObject(this.getText());
                        break;
                    }
                    case "Region": {
                        ((MediaOutputObject)output).setRegion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcessResult", "PageInfo")) {
                switch (name) {
                    case "PageNo": {
                        this.pageInfo.setPageNo(this.getText());
                        break;
                    }
                    case "PicIndex": {
                        this.pageInfo.setPicIndex(this.getText());
                        break;
                    }
                    case "PicNum": {
                        this.pageInfo.setPicNum(this.getText());
                        break;
                    }
                    case "TgtUri": {
                        this.pageInfo.setTgtUri(this.getText());
                        break;
                    }
                    case "X-SheetPics": {
                        this.pageInfo.setxSheetPics(this.getText());
                        break;
                    }
                }
            }
            if ("PageInfo".equalsIgnoreCase(name)) {
                List<DocProcessPageInfo> pageInfoList = this.response.getJobsDetail().getOperation().getDocProcessResult().getDocProcessPageInfoList();
                pageInfoList.add(this.pageInfo);
            }
        }

        public DocJobResponse getResponse() {
            return this.response;
        }
    }

    public static class DocJobHandler
    extends AbstractHandler {
        DocJobResponse response = new DocJobResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response", "JobsDetail")) {
                DocJobDetail jobsDetail = this.response.getJobsDetail();
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        jobsDetail.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        jobsDetail.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        jobsDetail.setTag(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                if ("Object".equalsIgnoreCase(name)) {
                    this.response.getJobsDetail().getInput().setObject(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                MediaOutputObject output = this.response.getJobsDetail().getOperation().getOutput();
                switch (name) {
                    case "Bucket": {
                        output.setBucket(this.getText());
                        break;
                    }
                    case "Object": {
                        output.setObject(this.getText());
                        break;
                    }
                    case "Region": {
                        output.setRegion(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DocProcess")) {
                DocProcessObject docProcess = this.response.getJobsDetail().getOperation().getDocProcessObject();
                switch (name) {
                    case "Comments": {
                        docProcess.setComments(this.getText());
                        break;
                    }
                    case "DocPassword": {
                        docProcess.setDocPassword(this.getText());
                        break;
                    }
                    case "EndPage": {
                        docProcess.setEndPage(this.getText());
                        break;
                    }
                    case "ImageParams": {
                        docProcess.setImageParams(this.getText());
                        break;
                    }
                    case "PaperDirection": {
                        docProcess.setPaperDirection(this.getText());
                        break;
                    }
                    case "Quality": {
                        docProcess.setQuality(this.getText());
                        break;
                    }
                    case "SrcType": {
                        docProcess.setSrcType(this.getText());
                        break;
                    }
                    case "StartPage": {
                        docProcess.setStartPage(this.getText());
                        break;
                    }
                    case "TgtType": {
                        docProcess.setTgtType(this.getText());
                        break;
                    }
                    case "Zoom": {
                        docProcess.setZoom(this.getText());
                        break;
                    }
                    case "SheetId": {
                        docProcess.setSheetId(this.getText());
                        break;
                    }
                }
            }
        }

        public DocJobResponse getResponse() {
            return this.response;
        }
    }

    public static class WorkflowExecutionsHandler
    extends AbstractHandler {
        MediaWorkflowExecutionsResponse response = new MediaWorkflowExecutionsResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("WorkflowExecutionList".equalsIgnoreCase(name)) {
                List<MediaWorkflowExecutionObject> list = this.response.getWorkflowExecutionList();
                list.add(new MediaWorkflowExecutionObject());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(name)) {
                    this.response.setRequestId(this.getText());
                } else if ("NextToken".equalsIgnoreCase(name)) {
                    this.response.setNextToken(this.getText());
                }
            } else if (this.in("Response", "WorkflowExecutionList")) {
                List<MediaWorkflowExecutionObject> list = this.response.getWorkflowExecutionList();
                MediaWorkflowExecutionObject mediaWorkflowExecutionObject = list.size() != 0 ? list.get(list.size() - 1) : new MediaWorkflowExecutionObject();
                switch (name) {
                    case "RunId": {
                        mediaWorkflowExecutionObject.setRunId(this.getText());
                        break;
                    }
                    case "WorkflowId": {
                        mediaWorkflowExecutionObject.setWorkflowId(this.getText());
                        break;
                    }
                    case "Object": {
                        mediaWorkflowExecutionObject.setObject(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        mediaWorkflowExecutionObject.setCreateTime(this.getText());
                        break;
                    }
                    case "State": {
                        mediaWorkflowExecutionObject.setState(this.getText());
                    }
                }
            }
        }

        public MediaWorkflowExecutionsResponse getResponse() {
            return this.response;
        }
    }

    public static class GenerateMediainfoHandler
    extends AbstractHandler {
        MediaInfoResponse response = new MediaInfoResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("Response", "MediaInfo", "Stream") && "Video".equalsIgnoreCase(name)) {
                List<MediaInfoVideo> mediaInfoVideoList = this.response.getMediaInfo().getStream().getMediaInfoVideoList();
                mediaInfoVideoList.add(new MediaInfoVideo());
            }
            if (this.in("Response", "MediaInfo", "Stream") && "Audio".equalsIgnoreCase(name)) {
                List<MediaInfoAudio> mediaInfoAudioList = this.response.getMediaInfo().getStream().getMediaInfoAudioList();
                mediaInfoAudioList.add(new MediaInfoAudio());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<MediaInfoVideo> mediaInfoVideoList;
            MediaInfoStream stream = this.response.getMediaInfo().getStream();
            if (this.in("Response", "MediaInfo", "Format")) {
                MediaFormat format = this.response.getMediaInfo().getFormat();
                ParserMediaInfoUtils.ParsingMediaFormat(format, name, this.getText());
            } else if (this.in("Response", "MediaInfo", "Stream", "Audio")) {
                List<MediaInfoAudio> mediaInfoAudioList = stream.getMediaInfoAudioList();
                if (!mediaInfoAudioList.isEmpty()) {
                    MediaInfoAudio audio = stream.getMediaInfoAudioList().get(mediaInfoAudioList.size() - 1);
                    ParserMediaInfoUtils.ParsingStreamAudio(audio, name, this.getText());
                }
            } else if (this.in("Response", "MediaInfo", "Stream", "Subtitle")) {
                MediaInfoSubtitle subtitle = stream.getSubtitle();
                ParserMediaInfoUtils.ParsingSubtitle(subtitle, name, this.getText());
            } else if (this.in("Response", "MediaInfo", "Stream", "Video") && !(mediaInfoVideoList = stream.getMediaInfoVideoList()).isEmpty()) {
                MediaInfoVideo video = stream.getMediaInfoVideoList().get(mediaInfoVideoList.size() - 1);
                ParserMediaInfoUtils.ParsingMediaVideo(video, name, this.getText());
            }
        }

        public MediaInfoResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaTemplatesHandler
    extends AbstractHandler {
        MediaListTemplateResponse response = new MediaListTemplateResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            List<MediaTemplateObject> templateList;
            if ("TemplateList".equalsIgnoreCase(name)) {
                List<MediaTemplateObject> templateList2 = this.response.getTemplateList();
                templateList2.add(new MediaTemplateObject());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate") && "ConcatFragment".equalsIgnoreCase(name) && (templateList = this.response.getTemplateList()) != null && !templateList.isEmpty()) {
                MediaTemplateObject mediaTemplateObject = templateList.get(templateList.size() - 1);
                List<MediaConcatFragmentObject> concatFragmentList = mediaTemplateObject.getConcatTemplate().getConcatFragmentList();
                concatFragmentList.add(new MediaConcatFragmentObject());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            List<MediaTemplateObject> templateList;
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(name)) {
                    this.response.setRequestId(this.getText());
                }
                if ("TotalCount".equalsIgnoreCase(name)) {
                    this.response.setTotalCount(this.getText());
                }
                if ("PageNumber".equalsIgnoreCase(name)) {
                    this.response.setPageNumber(this.getText());
                }
                if ("PageSize".equalsIgnoreCase(name)) {
                    this.response.setPageSize(this.getText());
                }
            }
            MediaTemplateObject template = (templateList = this.response.getTemplateList()).size() != 0 ? templateList.get(templateList.size() - 1) : new MediaTemplateObject();
            if (this.in("Response", "TemplateList")) {
                switch (name) {
                    case "TemplateId": {
                        template.setTemplateId(this.getText());
                        break;
                    }
                    case "Name": {
                        template.setName(this.getText());
                        break;
                    }
                    case "Tag": {
                        template.setTag(this.getText());
                        break;
                    }
                    case "State": {
                        template.setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        template.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        template.setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        template.setBucketId(this.getText());
                        break;
                    }
                    case "Category": {
                        template.setCategory(this.getText());
                    }
                }
            }
            MediaTemplateTransTplObject transTpl = template.getTransTpl();
            if (this.in("Response", "TemplateList", "TransTpl", "Container")) {
                MediaContainerObject container = transTpl.getContainer();
                if ("Format".equalsIgnoreCase(name)) {
                    container.setFormat(this.getText());
                }
            } else if (this.in("Response", "TemplateList", "TransTpl", "Video")) {
                MediaVideoObject video = transTpl.getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo(video, name, this.getText());
            } else if (this.in("Response", "TemplateList", "TransTpl", "TimeInterval")) {
                MediaTimeIntervalObject timeInterval = transTpl.getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval(timeInterval, name, this.getText());
            } else if (this.in("Response", "TemplateList", "TransTpl", "Audio")) {
                MediaAudioObject audio = transTpl.getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio(audio, name, this.getText());
            } else if (this.in("Response", "TemplateList", "TransTpl", "TransConfig")) {
                MediaTransConfigObject transConfig = transTpl.getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig(transConfig, name, this.getText());
            } else if (this.in("Response", "TemplateList", "Snapshot")) {
                MediaSnapshotObject snapshot = template.getSnapshot();
                ParserMediaInfoUtils.ParsingSnapshot(snapshot, name, this.getText());
            } else if (this.in("Response", "TemplateList", "Watermark")) {
                MediaWatermark watermark = template.getWatermark();
                ParserMediaInfoUtils.ParsingWatermark(watermark, name, this.getText());
            } else if (this.in("Response", "TemplateList", "Watermark", "Text")) {
                MediaWaterMarkText text = template.getWatermark().getText();
                ParserMediaInfoUtils.ParsingWatermarkText(text, name, this.getText());
            } else if (this.in("Response", "TemplateList", "Watermark", "Image")) {
                MediaWaterMarkImage image = template.getWatermark().getImage();
                ParserMediaInfoUtils.ParsingWatermarkImage(image, name, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "ConcatFragment")) {
                ParserMediaInfoUtils.ParseConcatFragment(this.getConcatFragment(template), name, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "Audio")) {
                ParserMediaInfoUtils.ParsingMediaAudio(template.getConcatTemplate().getAudio(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "Video")) {
                ParserMediaInfoUtils.ParsingMediaVideo(template.getConcatTemplate().getVideo(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "Container")) {
                if (name.equalsIgnoreCase("Format")) {
                    template.getConcatTemplate().getContainer().setFormat(this.getText());
                }
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "AudioMix")) {
                ParserMediaInfoUtils.ParseAudioMix(template.getConcatTemplate().getAudioMix(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "ConcatTemplate", "VideoTargetRec")) {
                ParserMediaInfoUtils.ParsingVideoTargetRec(template.getVideoTargetRec(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "TtsTpl")) {
                ParserMediaInfoUtils.ParseTtsTpl(template.getTtsTpl(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "Transcode", "Container")) {
                ParserMediaInfoUtils.ParseContainer(template.getVideoEnhance().getTrascode().getContainer(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "Transcode", "Video")) {
                ParserMediaInfoUtils.ParsingMediaVideo(template.getVideoEnhance().getTrascode().getVideo(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "Transcode", "Audio")) {
                ParserMediaInfoUtils.ParsingMediaAudio(template.getVideoEnhance().getTrascode().getAudio(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "SuperResolution")) {
                ParserMediaInfoUtils.ParsingSuperResolution(template.getVideoEnhance().getSuperResolution(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "ColorEnhance")) {
                ParserMediaInfoUtils.ParsingColorEnhance(template.getVideoEnhance().getColorEnhance(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "MsSharpen")) {
                ParserMediaInfoUtils.ParsingMsSharpen(template.getVideoEnhance().getMsSharpen(), name, this.getText());
            } else if (this.in("Response", "TemplateList", "VideoEnhance", "SDRtoHDR")) {
                ParserMediaInfoUtils.ParsingSDRtoHDR(template.getVideoEnhance().getSdrToHDR(), name, this.getText());
            }
        }

        public MediaConcatFragmentObject getConcatFragment(MediaTemplateObject template) {
            List<MediaConcatFragmentObject> concatFragmentList = template.getConcatTemplate().getConcatFragmentList();
            if (concatFragmentList != null && !concatFragmentList.isEmpty()) {
                return concatFragmentList.get(concatFragmentList.size() - 1);
            }
            return new MediaConcatFragmentObject();
        }

        public MediaListTemplateResponse getResponse() {
            return this.response;
        }
    }

    public static class SnapshotHandler
    extends AbstractHandler {
        SnapshotResponse response = new SnapshotResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response", "Output")) {
                MediaOutputObject output = this.response.getOutput();
                if ("Bucket".equalsIgnoreCase(name)) {
                    output.setBucket(this.getText());
                } else if ("Object".equalsIgnoreCase(name)) {
                    output.setObject(this.getText());
                } else if ("Region".equalsIgnoreCase(name)) {
                    output.setRegion(this.getText());
                }
            }
        }

        public SnapshotResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaTemplateHandler
    extends AbstractHandler {
        MediaTemplateResponse response = new MediaTemplateResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(name)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "Template")) {
                MediaTemplateObject template = this.response.getTemplate();
                switch (name) {
                    case "TemplateId": {
                        template.setTemplateId(this.getText());
                        break;
                    }
                    case "Name": {
                        template.setName(this.getText());
                        break;
                    }
                    case "Tag": {
                        template.setTag(this.getText());
                        break;
                    }
                    case "State": {
                        template.setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        template.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        template.setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        template.setBucketId(this.getText());
                        break;
                    }
                    case "Category": {
                        template.setCategory(this.getText());
                    }
                }
            }
            MediaTemplateTransTplObject transTpl = this.response.getTemplate().getTransTpl();
            if (this.in("Response", "Template", "TransTpl", "Container")) {
                MediaContainerObject container = transTpl.getContainer();
                if ("Format".equalsIgnoreCase(name)) {
                    container.setFormat(this.getText());
                }
            } else if (this.in("Response", "Template", "TransTpl", "Video")) {
                MediaVideoObject video = transTpl.getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo(video, name, this.getText());
            } else if (this.in("Response", "Template", "TransTpl", "TimeInterval")) {
                MediaTimeIntervalObject timeInterval = transTpl.getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval(timeInterval, name, this.getText());
            } else if (this.in("Response", "Template", "TransTpl", "Audio")) {
                MediaAudioObject audio = transTpl.getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio(audio, name, this.getText());
            } else if (this.in("Response", "Template", "TransTpl", "TransConfig")) {
                MediaTransConfigObject transConfig = transTpl.getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig(transConfig, name, this.getText());
            } else if (this.in("Response", "Template", "Snapshot")) {
                MediaSnapshotObject snapshot = this.response.getTemplate().getSnapshot();
                ParserMediaInfoUtils.ParsingSnapshot(snapshot, name, this.getText());
            } else if (this.in("Response", "Template", "Watermark")) {
                MediaWatermark watermark = this.response.getTemplate().getWatermark();
                ParserMediaInfoUtils.ParsingWatermark(watermark, name, this.getText());
            } else if (this.in("Response", "Template", "Watermark", "Text")) {
                MediaWaterMarkText text = this.response.getTemplate().getWatermark().getText();
                ParserMediaInfoUtils.ParsingWatermarkText(text, name, this.getText());
            } else if (this.in("Response", "Template", "Watermark", "Image")) {
                MediaWaterMarkImage image = this.response.getTemplate().getWatermark().getImage();
                ParserMediaInfoUtils.ParsingWatermarkImage(image, name, this.getText());
            } else if (this.in("Response", "Template", "VideoTargetRec")) {
                VideoTargetRec videoTargetRec = this.response.getTemplate().getVideoTargetRec();
                ParserMediaInfoUtils.ParsingVideoTargetRec(videoTargetRec, name, this.getText());
            }
        }

        public MediaTemplateResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaQueueResponseHandler
    extends AbstractHandler {
        MediaQueueResponse response = new MediaQueueResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                if ("RequestId".equalsIgnoreCase(name)) {
                    this.response.setRequestId(this.getText());
                }
            } else if (this.in("Response", "Queue")) {
                MediaQueueObject queue = this.response.getQueue();
                switch (name) {
                    case "QueueId": {
                        queue.setQueueId(this.getText());
                        break;
                    }
                    case "Name": {
                        queue.setName(this.getText());
                        break;
                    }
                    case "State": {
                        queue.setState(this.getText());
                        break;
                    }
                    case "MaxSize": {
                        queue.setMaxSize(this.getText());
                        break;
                    }
                    case "MaxConcurrent": {
                        queue.setMaxConcurrent(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        queue.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        queue.setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        queue.setBucketId(this.getText());
                        break;
                    }
                    case "Category": {
                        queue.setCategory(this.getText());
                    }
                }
            } else if (this.in("Response", "Queue", "NotifyConfig")) {
                MediaNotifyConfig notifyConfig = this.response.getQueue().getNotifyConfig();
                switch (name) {
                    case "Url": {
                        notifyConfig.setUrl(this.getText());
                        break;
                    }
                    case "Event": {
                        notifyConfig.setEvent(this.getText());
                        break;
                    }
                    case "Type": {
                        notifyConfig.setType(this.getText());
                        break;
                    }
                    case "State": {
                        notifyConfig.setState(this.getText());
                    }
                }
            }
        }

        public MediaQueueResponse getResponse() {
            return this.response;
        }
    }

    public static class DescribeMediaJobsHandler
    extends AbstractHandler {
        MediaListJobResponse response = new MediaListJobResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            List<MediaJobObject> jobsDetailList = this.response.getJobsDetailList();
            if ("JobsDetail".equalsIgnoreCase(name)) {
                List<MediaJobObject> jobsDetail = jobsDetailList;
                jobsDetail.add(new MediaJobObject());
            }
            if ("ConcatFragment".equals(name)) {
                List<MediaConcatFragmentObject> concatFragmentList = jobsDetailList.get(jobsDetailList.size() - 1).getOperation().getMediaConcatTemplate().getConcatFragmentList();
                concatFragmentList.add(new MediaConcatFragmentObject());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            Object video;
            Object audio;
            List<MediaJobObject> jobsDetailList = this.response.getJobsDetailList();
            MediaJobObject jobsDetail = jobsDetailList.isEmpty() ? new MediaJobObject() : jobsDetailList.get(jobsDetailList.size() - 1);
            if (this.in("Response", "JobsDetail")) {
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        jobsDetail.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        jobsDetail.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        jobsDetail.setTag(this.getText());
                        break;
                    }
                    case "BucketName": {
                        jobsDetail.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                jobsDetail.getInput().setObject(this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation")) {
                MediaJobOperation operation = jobsDetail.getOperation();
                switch (name) {
                    case "TemplateId": {
                        operation.setTemplateId(this.getText());
                        break;
                    }
                    case "WatermarkTemplateId": {
                        operation.getWatermarkTemplateId().add(this.getText());
                        break;
                    }
                    case "UserData": {
                        operation.setUserData(this.getText());
                        break;
                    }
                    case "JobLevel": {
                        operation.setJobLevel(this.getText());
                        break;
                    }
                    case "TemplateName": {
                        operation.setTemplateName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Format")) {
                MediaFormat format = jobsDetail.getOperation().getMediaInfo().getFormat();
                ParserMediaInfoUtils.ParsingMediaFormat(format, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Audio")) {
                audio = jobsDetail.getOperation().getMediaInfo().getStream().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaInfoAudio)audio, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Subtitle")) {
                MediaInfoSubtitle subtitle = jobsDetail.getOperation().getMediaInfo().getStream().getSubtitle();
                ParserMediaInfoUtils.ParsingSubtitle(subtitle, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Video")) {
                video = jobsDetail.getOperation().getMediaInfo().getStream().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaInfoVideo)video, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "RemoveWatermark")) {
                MediaRemoveWaterMark removeWatermark = jobsDetail.getOperation().getRemoveWatermark();
                ParserMediaInfoUtils.ParsingRemoveWatermark(removeWatermark, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Container")) {
                if ("Format".equalsIgnoreCase(name)) {
                    jobsDetail.getOperation().getTranscode().getContainer().setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Video")) {
                audio = jobsDetail.getOperation().getTranscode().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaAudioObject)audio, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Audio")) {
                video = jobsDetail.getOperation().getTranscode().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaTranscodeVideoObject)video, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TransConfig")) {
                MediaTransConfigObject transConfig = jobsDetail.getOperation().getTranscode().getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig(transConfig, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TimeInterval")) {
                MediaTimeIntervalObject timeInterval = jobsDetail.getOperation().getTranscode().getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval(timeInterval, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Snapshot")) {
                MediaSnapshotObject snapshot = jobsDetail.getOperation().getSnapshot();
                ParserMediaInfoUtils.ParsingSnapshot(snapshot, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Segment")) {
                MediaSegmentObject segment = jobsDetail.getOperation().getSegment();
                ParserMediaInfoUtils.ParsingSegment(segment, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Snapshot", "SpriteSnapshotConfig")) {
                SpriteSnapshotConfig snapshotConfig = jobsDetail.getOperation().getSnapshot().getSnapshotConfig();
                ParserMediaInfoUtils.ParsingSnapshotConfig(snapshotConfig, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                MediaOutputObject output = jobsDetail.getOperation().getOutput();
                ParserMediaInfoUtils.ParsingOutput(output, name, this.getText());
            }
            MediaConcatTemplateObject mediaConcatTemplate = jobsDetail.getOperation().getMediaConcatTemplate();
            if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "ConcatFragment")) {
                List<MediaConcatFragmentObject> concatFragmentList = mediaConcatTemplate.getConcatFragmentList();
                MediaConcatFragmentObject mediaConcatFragmentObject = concatFragmentList.get(concatFragmentList.size() - 1);
                switch (name) {
                    case "Mode": {
                        mediaConcatFragmentObject.setMode(this.getText());
                        break;
                    }
                    case "Url": {
                        mediaConcatFragmentObject.setUrl(this.getText());
                        break;
                    }
                    case "StartTime": {
                        mediaConcatFragmentObject.setStartTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        mediaConcatFragmentObject.setEndTime(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Audio")) {
                MediaAudioObject audio2 = mediaConcatTemplate.getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio(audio2, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Video")) {
                MediaVideoObject video2 = mediaConcatTemplate.getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo(video2, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Container")) {
                MediaContainerObject container = mediaConcatTemplate.getContainer();
                if ("Format".equals(name)) {
                    container.setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate")) {
                if ("Index".equals(name)) {
                    mediaConcatTemplate.setIndex(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DigitalWatermark")) {
                MediaDigitalWatermark digitalWatermark = jobsDetail.getOperation().getDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(digitalWatermark, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ExtractDigitalWatermark")) {
                ExtractDigitalWatermark digitalWatermark = jobsDetail.getOperation().getExtractDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(digitalWatermark, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaResult", "OutputFile")) {
                OutputFile outputFile = jobsDetail.getOperation().getMediaResult().getOutputFile();
                ParserMediaInfoUtils.ParsingMediaResult(outputFile, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaResult", "OutputFile", "Md5Info")) {
                Md5Info md5Info = jobsDetail.getOperation().getMediaResult().getOutputFile().getMd5Info();
                ParserMediaInfoUtils.ParsingMd5Info(md5Info, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcess")) {
                MediaPicProcessTemplateObject picProcess = jobsDetail.getOperation().getPicProcess();
                if ("IsPicInfo".equalsIgnoreCase(name)) {
                    picProcess.setIsPicInfo(this.getText());
                } else if ("ProcessRule".equalsIgnoreCase(name)) {
                    picProcess.setProcessRule(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcess")) {
                MediaPicProcessTemplateObject picProcess = jobsDetail.getOperation().getPicProcess();
                if ("IsPicInfo".equalsIgnoreCase(name)) {
                    picProcess.setIsPicInfo(this.getText());
                } else if ("ProcessRule".equalsIgnoreCase(name)) {
                    picProcess.setProcessRule(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult")) {
                if ("ObjectName".equalsIgnoreCase(name)) {
                    jobsDetail.getOperation().getPicProcessResult().setObjectName(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult", "OriginalInfo")) {
                if ("Etag".equalsIgnoreCase(name)) {
                    jobsDetail.getOperation().getPicProcessResult().getOriginalInfo().setEtag(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult", "OriginalInfo", "ImageInfo")) {
                ImageInfo imageInfo = jobsDetail.getOperation().getPicProcessResult().getOriginalInfo().getImageInfo();
                ParserMediaInfoUtils.ParsingImageInfo(imageInfo, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcessResult", "ProcessResult")) {
                ProcessResult processResult = jobsDetail.getOperation().getPicProcessResult().getProcessResult();
                ParserMediaInfoUtils.ParsingProcessResult(processResult, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoTargetRec")) {
                VideoTargetRec videoTargetRec = jobsDetail.getOperation().getVideoTargetRec();
                ParserMediaInfoUtils.ParsingVideoTargetRec(videoTargetRec, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsConfig")) {
                ParserMediaInfoUtils.ParseTtsConfig(jobsDetail.getOperation().getTtsConfig(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsTpl")) {
                ParserMediaInfoUtils.ParseTtsTpl(jobsDetail.getOperation().getTtsTpl(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "Transcode", "Container")) {
                ParserMediaInfoUtils.ParseContainer(jobsDetail.getOperation().getVideoEnhance().getTrascode().getContainer(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "Transcode", "Video")) {
                ParserMediaInfoUtils.ParsingMediaVideo(jobsDetail.getOperation().getVideoEnhance().getTrascode().getVideo(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "Transcode", "Audio")) {
                ParserMediaInfoUtils.ParsingMediaAudio(jobsDetail.getOperation().getVideoEnhance().getTrascode().getAudio(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "SuperResolution")) {
                ParserMediaInfoUtils.ParsingSuperResolution(jobsDetail.getOperation().getVideoEnhance().getSuperResolution(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "ColorEnhance")) {
                ParserMediaInfoUtils.ParsingColorEnhance(jobsDetail.getOperation().getVideoEnhance().getColorEnhance(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "MsSharpen")) {
                ParserMediaInfoUtils.ParsingMsSharpen(jobsDetail.getOperation().getVideoEnhance().getMsSharpen(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "SDRtoHDR")) {
                ParserMediaInfoUtils.ParsingSDRtoHDR(jobsDetail.getOperation().getVideoEnhance().getSdrToHDR(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoEnhance", "FrameEnhance")) {
                ParserMediaInfoUtils.ParsingFrameEnhance(jobsDetail.getOperation().getVideoEnhance().getFrameEnhance(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "AudioMixArray")) {
                ParserMediaInfoUtils.ParsingAudioMixArray(jobsDetail.getOperation().getTranscode().getAudioMixArray(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "AudioMixArray", "EffectConfig")) {
                ParserMediaInfoUtils.ParsingEffectConfig(jobsDetail.getOperation().getTranscode().getAudioMixArray(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Subtitles", "Subtitle")) {
                ParserMediaInfoUtils.ParsingSubtitles(jobsDetail.getOperation().getSubtitles(), name, this.getText());
            }
        }

        public MediaListJobResponse getResponse() {
            return this.response;
        }
    }

    public static class MediaJobCreatHandler
    extends AbstractHandler {
        MediaJobResponse response = new MediaJobResponse();
        List<MediaConcatFragmentObject> concatFragmentList = this.response.getJobsDetail().getOperation().getMediaConcatTemplate().getConcatFragmentList();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("ConcatFragment".equals(name)) {
                this.concatFragmentList.add(new MediaConcatFragmentObject());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            Object video;
            Object audio;
            MediaJobObject jobsDetail = this.response.getJobsDetail();
            if (this.in("Response", "JobsDetail")) {
                switch (name) {
                    case "Code": {
                        jobsDetail.setCode(this.getText());
                        break;
                    }
                    case "CreationTime": {
                        jobsDetail.setCreationTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        jobsDetail.setEndTime(this.getText());
                        break;
                    }
                    case "JobId": {
                        jobsDetail.setJobId(this.getText());
                        break;
                    }
                    case "Message": {
                        jobsDetail.setMessage(this.getText());
                        break;
                    }
                    case "QueueId": {
                        jobsDetail.setQueueId(this.getText());
                        break;
                    }
                    case "State": {
                        jobsDetail.setState(this.getText());
                        break;
                    }
                    case "Tag": {
                        jobsDetail.setTag(this.getText());
                        break;
                    }
                    case "BucketName": {
                        jobsDetail.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Input")) {
                jobsDetail.getInput().setObject(this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation")) {
                MediaJobOperation operation = jobsDetail.getOperation();
                switch (name) {
                    case "TemplateId": {
                        operation.setTemplateId(this.getText());
                        break;
                    }
                    case "WatermarkTemplateId": {
                        operation.getWatermarkTemplateId().add(this.getText());
                        break;
                    }
                    case "UserData": {
                        operation.setUserData(this.getText());
                        break;
                    }
                    case "JobLevel": {
                        operation.setJobLevel(this.getText());
                        break;
                    }
                    case "TemplateName": {
                        operation.setTemplateName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Format")) {
                MediaFormat format = jobsDetail.getOperation().getMediaInfo().getFormat();
                ParserMediaInfoUtils.ParsingMediaFormat(format, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Audio")) {
                audio = jobsDetail.getOperation().getMediaInfo().getStream().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaInfoAudio)audio, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Subtitle")) {
                MediaInfoSubtitle subtitle = jobsDetail.getOperation().getMediaInfo().getStream().getSubtitle();
                ParserMediaInfoUtils.ParsingSubtitle(subtitle, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Video")) {
                video = jobsDetail.getOperation().getMediaInfo().getStream().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaInfoVideo)video, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Watermark")) {
                MediaWatermark watermark = jobsDetail.getOperation().getWatermark();
                ParserMediaInfoUtils.ParsingWatermark(watermark, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "RemoveWatermark")) {
                MediaRemoveWaterMark removeWatermark = jobsDetail.getOperation().getRemoveWatermark();
                ParserMediaInfoUtils.ParsingRemoveWatermark(removeWatermark, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Watermark", "Text")) {
                MediaWaterMarkText text = jobsDetail.getOperation().getWatermark().getText();
                ParserMediaInfoUtils.ParsingWatermarkText(text, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Watermark", "Image")) {
                MediaWaterMarkImage image = jobsDetail.getOperation().getWatermark().getImage();
                ParserMediaInfoUtils.ParsingWatermarkImage(image, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Container")) {
                if ("Format".equalsIgnoreCase(name)) {
                    this.response.getJobsDetail().getOperation().getTranscode().getContainer().setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Video")) {
                audio = jobsDetail.getOperation().getTranscode().getAudio();
                ParserMediaInfoUtils.ParsingStreamAudio((MediaAudioObject)audio, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Audio")) {
                video = jobsDetail.getOperation().getTranscode().getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo((MediaTranscodeVideoObject)video, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TransConfig")) {
                MediaTransConfigObject transConfig = jobsDetail.getOperation().getTranscode().getTransConfig();
                ParserMediaInfoUtils.ParsingTransConfig(transConfig, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TimeInterval")) {
                MediaTimeIntervalObject timeInterval = jobsDetail.getOperation().getTranscode().getTimeInterval();
                ParserMediaInfoUtils.ParsingMediaTimeInterval(timeInterval, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
                ParserMediaInfoUtils.ParsingOutput(jobsDetail.getOperation().getOutput(), name, this.getText());
            }
            MediaConcatTemplateObject mediaConcatTemplate = this.response.getJobsDetail().getOperation().getMediaConcatTemplate();
            if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "ConcatFragment")) {
                MediaConcatFragmentObject mediaConcatFragmentObject = this.concatFragmentList.get(this.concatFragmentList.size() - 1);
                switch (name) {
                    case "Mode": {
                        mediaConcatFragmentObject.setMode(this.getText());
                        break;
                    }
                    case "Url": {
                        mediaConcatFragmentObject.setUrl(this.getText());
                        break;
                    }
                    case "StartTime": {
                        mediaConcatFragmentObject.setStartTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        mediaConcatFragmentObject.setEndTime(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Audio")) {
                MediaAudioObject audio2 = mediaConcatTemplate.getAudio();
                ParserMediaInfoUtils.ParsingMediaAudio(audio2, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Video")) {
                MediaVideoObject video2 = mediaConcatTemplate.getVideo();
                ParserMediaInfoUtils.ParsingMediaVideo(video2, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Container")) {
                MediaContainerObject container = mediaConcatTemplate.getContainer();
                if ("Format".equals(name)) {
                    container.setFormat(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate")) {
                if ("Index".equals(name)) {
                    mediaConcatTemplate.setIndex(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "DigitalWatermark")) {
                MediaDigitalWatermark digitalWatermark = this.response.getJobsDetail().getOperation().getDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(digitalWatermark, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "ExtractDigitalWatermark")) {
                ExtractDigitalWatermark digitalWatermark = this.response.getJobsDetail().getOperation().getExtractDigitalWatermark();
                ParserMediaInfoUtils.ParsingDigitalWatermark(digitalWatermark, name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "PicProcess")) {
                MediaJobOperation operation = this.response.getJobsDetail().getOperation();
                if ("IsPicInfo".equalsIgnoreCase(name)) {
                    operation.getPicProcess().setIsPicInfo(this.getText());
                } else if ("ProcessRule".equalsIgnoreCase(name)) {
                    operation.getPicProcess().setProcessRule(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "VoiceSeparate")) {
                if ("AudioMode".equalsIgnoreCase(name)) {
                    jobsDetail.getOperation().getVoiceSeparate().setAudioMode(this.getText());
                }
            } else if (this.in("Response", "JobsDetail", "Operation", "VoiceSeparate", "AudioConfig")) {
                ParserMediaInfoUtils.ParseAudioConfig(jobsDetail.getOperation().getVoiceSeparate().getAudioConfig(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsConfig")) {
                ParserMediaInfoUtils.ParseTtsConfig(jobsDetail.getOperation().getTtsConfig(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "TtsTpl")) {
                ParserMediaInfoUtils.ParseTtsTpl(jobsDetail.getOperation().getTtsTpl(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "VideoTag")) {
                ParserMediaInfoUtils.ParseVideoTag(jobsDetail.getOperation().getVideoTag(), name, this.getText());
            } else if (this.in("Response", "JobsDetail", "Operation", "QualityEstimateConfig")) {
                ParserMediaInfoUtils.ParseQualityEstimateConfig(jobsDetail.getOperation().getQualityEstimateConfig(), name, this.getText());
            }
        }

        public MediaJobResponse getResponse() {
            return this.response;
        }
    }

    public static class WorkflowExecutionHandler
    extends AbstractHandler {
        private MediaWorkflowExecutionResponse response = new MediaWorkflowExecutionResponse();
        MediaWorkflowExecutionObject workflowObject = this.response.getWorkflowExecution();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("Tasks".equals(name)) {
                this.workflowObject.getTasks().addLast(new MediaTasks());
            }
            if (this.in("Response", "WorkflowExecution", "Topology", "Nodes")) {
                Map<String, MediaWorkflowNode> workflowNodes = this.workflowObject.getTopology().getMediaWorkflowNodes();
                workflowNodes.put(name, new MediaWorkflowNode());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                switch (name) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "WorkflowExecution")) {
                switch (name) {
                    case "Object": {
                        this.workflowObject.setObject(this.getText());
                        break;
                    }
                    case "WorkflowId": {
                        this.workflowObject.setWorkflowId(this.getText());
                        break;
                    }
                    case "State": {
                        this.workflowObject.setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.workflowObject.setCreateTime(this.getText());
                        break;
                    }
                    case "RunId": {
                        this.workflowObject.setRunId(this.getText());
                        break;
                    }
                    case "WorkflowName": {
                        this.workflowObject.setWorkflowName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "WorkflowExecution", "Tasks")) {
                MediaTasks tasks = this.workflowObject.getTasks().getLast();
                switch (name) {
                    case "Type": {
                        tasks.setType(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        tasks.setCreateTime(this.getText());
                        break;
                    }
                    case "EndTime": {
                        tasks.setEndTime(this.getText());
                        break;
                    }
                    case "State": {
                        tasks.setState(this.getText());
                        break;
                    }
                    case "JobId": {
                        tasks.setJobId(this.getText());
                        break;
                    }
                    case "Name": {
                        tasks.setName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "WorkflowExecution", "Topology", "Dependencies")) {
                Map<String, MediaWorkflowDependency> dependencyMap = this.workflowObject.getTopology().getMediaWorkflowDependency();
                MediaWorkflowDependency dependency = dependencyMap.get(name);
                if (dependency == null) {
                    dependency = new MediaWorkflowDependency();
                }
                dependency.setValue(this.getText());
                dependencyMap.put(name, dependency);
            }
            Map<String, MediaWorkflowNode> nodesMap = this.workflowObject.getTopology().getMediaWorkflowNodes();
            for (String key : nodesMap.keySet()) {
                MediaWorkflowNode workflowNode = nodesMap.get(key);
                if (this.in("Response", "WorkflowExecution", "Topology", "Nodes", key, "Operation")) {
                    if (!"TemplateId".equals(name)) continue;
                    workflowNode.getOperation().setTemplateId(this.getText());
                    continue;
                }
                if (this.in("Response", "WorkflowExecution", "Topology", "Nodes", key, "Operation", "Output")) {
                    MediaOutputObject output = workflowNode.getOperation().getOutput();
                    switch (name) {
                        case "Bucket": {
                            output.setBucket(this.getText());
                            return;
                        }
                        case "Object": {
                            output.setObject(this.getText());
                            return;
                        }
                        case "Region": {
                            output.setRegion(this.getText());
                            return;
                        }
                    }
                    return;
                }
                if (this.in("Response", "WorkflowExecution", "Topology", "Nodes", key)) {
                    if (!"Type".equals(name)) continue;
                    workflowNode.setType(this.getText());
                    continue;
                }
                if (!this.in("Response", "WorkflowExecution", "Topology", "Nodes", key, "Input")) continue;
                MediaWorkflowInput input = workflowNode.getInput();
                switch (name) {
                    case "ObjectPrefix": {
                        input.setObjectPrefix(this.getText());
                        return;
                    }
                    case "QueueId": {
                        input.setQueueId(this.getText());
                        return;
                    }
                }
                return;
            }
        }

        public MediaWorkflowExecutionResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaWorkflowExecutionResponse response) {
            this.response = response;
        }
    }

    public static class WorkflowHandler
    extends AbstractHandler {
        private MediaWorkflowResponse response = new MediaWorkflowResponse();

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            switch (name) {
                case "Name": {
                    this.response.setName(this.getText());
                    break;
                }
                case "WorkflowId": {
                    this.response.setWorkflowId(this.getText());
                    break;
                }
                case "State": {
                    this.response.setState(this.getText());
                    break;
                }
                case "CreateTime": {
                    this.response.setCreateTime(this.getText());
                    break;
                }
                case "UpdateTime": {
                    this.response.setUpdateTime(this.getText());
                    break;
                }
                case "BucketId": {
                    this.response.setBucketId(this.getText());
                    break;
                }
            }
        }

        public MediaWorkflowResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaWorkflowResponse response) {
            this.response = response;
        }
    }

    public static class WorkflowListHandler
    extends AbstractHandler {
        private MediaWorkflowListResponse response = new MediaWorkflowListResponse();
        MediaWorkflowObject workflowObject;

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("MediaWorkflowList".equals(name)) {
                this.workflowObject = new MediaWorkflowObject();
            }
            if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes")) {
                Map<String, MediaWorkflowNode> workflowNodes = this.workflowObject.getTopology().getMediaWorkflowNodes();
                workflowNodes.put(name, new MediaWorkflowNode());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                switch (name) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "MediaWorkflowList")) {
                switch (name) {
                    case "Name": {
                        this.workflowObject.setName(this.getText());
                        break;
                    }
                    case "WorkflowId": {
                        this.workflowObject.setWorkflowId(this.getText());
                        break;
                    }
                    case "State": {
                        this.workflowObject.setState(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.workflowObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        this.workflowObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "BucketId": {
                        this.workflowObject.setBucketId(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "MediaWorkflowList", "Topology", "Dependencies")) {
                Map<String, MediaWorkflowDependency> dependencyMap = this.workflowObject.getTopology().getMediaWorkflowDependency();
                MediaWorkflowDependency dependency = dependencyMap.get(name);
                if (dependency == null) {
                    dependency = new MediaWorkflowDependency();
                }
                dependency.setValue(this.getText());
                dependencyMap.put(name, dependency);
            }
            Map<String, MediaWorkflowNode> nodesMap = this.workflowObject.getTopology().getMediaWorkflowNodes();
            for (String key : nodesMap.keySet()) {
                MediaWorkflowNode workflowNode = nodesMap.get(key);
                if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes", key, "Operation")) {
                    if (!"TemplateId".equals(name)) continue;
                    workflowNode.getOperation().setTemplateId(this.getText());
                    continue;
                }
                if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes", key, "Operation", "Output")) {
                    MediaOutputObject output = workflowNode.getOperation().getOutput();
                    switch (name) {
                        case "Bucket": {
                            output.setBucket(this.getText());
                            return;
                        }
                        case "Object": {
                            output.setObject(this.getText());
                            return;
                        }
                        case "Region": {
                            output.setRegion(this.getText());
                            return;
                        }
                    }
                    return;
                }
                if (this.in("Response", "MediaWorkflowList", "Topology", "Nodes", key)) {
                    if (!"Type".equals(name)) continue;
                    workflowNode.setType(this.getText());
                    continue;
                }
                if (!this.in("Response", "MediaWorkflowList", "Topology", "Nodes", key, "Input")) continue;
                MediaWorkflowInput input = workflowNode.getInput();
                switch (name) {
                    case "ObjectPrefix": {
                        input.setObjectPrefix(this.getText());
                        return;
                    }
                    case "QueueId": {
                        input.setQueueId(this.getText());
                        return;
                    }
                }
                return;
            }
            if ("MediaWorkflowList".equals(name)) {
                this.response.getMediaWorkflowList().add(this.workflowObject);
            }
        }

        public MediaWorkflowListResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaWorkflowListResponse response) {
            this.response = response;
        }
    }

    public static class ListMediaBucketHandler
    extends AbstractHandler {
        private MediaBucketResponse response = new MediaBucketResponse();
        boolean isNew = true;
        MediaBucketObject bucketObject;

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("MediaBucketList".equals(name)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.bucketObject = new MediaBucketObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                switch (name) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "MediaBucketList")) {
                switch (name) {
                    case "BucketId": {
                        this.bucketObject.setBucketId(this.getText());
                        break;
                    }
                    case "Region": {
                        this.bucketObject.setRegion(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.bucketObject.setCreateTime(this.getText());
                        break;
                    }
                    case "Name": {
                        this.bucketObject.setName(this.getText());
                        break;
                    }
                    case "AliasBucketId": {
                        this.bucketObject.setAliasBucketId(this.getText());
                        break;
                    }
                }
            }
            if ("MediaBucketList".equals(name) && !this.isNew) {
                this.response.getMediaBucketList().add(this.bucketObject);
                this.bucketObject = null;
            }
        }

        public MediaBucketResponse getResponse() {
            return this.response;
        }
    }

    public static class DocListQueueHandler
    extends AbstractHandler {
        private DocListQueueResponse response = new DocListQueueResponse();
        boolean isNew = true;
        MediaQueueObject queueObject;

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("QueueList".equals(name)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.queueObject = new MediaQueueObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                switch (name) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList")) {
                switch (name) {
                    case "QueueId": {
                        this.queueObject.setQueueId(this.getText());
                        break;
                    }
                    case "Name": {
                        this.queueObject.setName(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.setState(this.getText());
                        break;
                    }
                    case "MaxSize": {
                        this.queueObject.setMaxSize(this.getText());
                        break;
                    }
                    case "MaxConcurrent": {
                        this.queueObject.setMaxConcurrent(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.queueObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        this.queueObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "Category": {
                        this.queueObject.setCategory(this.getText());
                        break;
                    }
                    case "BucketId": {
                        this.queueObject.setBucketId(this.getText());
                        break;
                    }
                    case "BucketName": {
                        this.queueObject.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList", "NotifyConfig")) {
                switch (name) {
                    case "Url": {
                        this.queueObject.getNotifyConfig().setUrl(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.getNotifyConfig().setState(this.getText());
                        break;
                    }
                    case "Type": {
                        this.queueObject.getNotifyConfig().setType(this.getText());
                        break;
                    }
                    case "Event": {
                        this.queueObject.getNotifyConfig().setEvent(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "NonExistPIDs") && "QueueID".equals(name)) {
                this.response.getNonExistPIDs().add(this.getText());
            }
            if ("QueueList".equals(name) && !this.isNew) {
                this.response.getQueueList().add(this.queueObject);
                this.queueObject = null;
            }
        }

        public DocListQueueResponse getResponse() {
            return this.response;
        }

        public void setResponse(DocListQueueResponse response) {
            this.response = response;
        }
    }

    public static class ListQueueHandler
    extends AbstractHandler {
        private MediaListQueueResponse response = new MediaListQueueResponse();
        boolean isNew = true;
        MediaQueueObject queueObject;

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if ("QueueList".equals(name)) {
                this.isNew = true;
            }
            if (this.isNew) {
                this.queueObject = new MediaQueueObject();
                this.isNew = false;
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Response")) {
                switch (name) {
                    case "RequestId": {
                        this.response.setRequestId(this.getText());
                        break;
                    }
                    case "TotalCount": {
                        this.response.setTotalCount(this.getText());
                        break;
                    }
                    case "PageNumber": {
                        this.response.setPageNumber(this.getText());
                        break;
                    }
                    case "PageSize": {
                        this.response.setPageSize(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList")) {
                switch (name) {
                    case "QueueId": {
                        this.queueObject.setQueueId(this.getText());
                        break;
                    }
                    case "Name": {
                        this.queueObject.setName(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.setState(this.getText());
                        break;
                    }
                    case "MaxSize": {
                        this.queueObject.setMaxSize(this.getText());
                        break;
                    }
                    case "MaxConcurrent": {
                        this.queueObject.setMaxConcurrent(this.getText());
                        break;
                    }
                    case "CreateTime": {
                        this.queueObject.setCreateTime(this.getText());
                        break;
                    }
                    case "UpdateTime": {
                        this.queueObject.setUpdateTime(this.getText());
                        break;
                    }
                    case "Category": {
                        this.queueObject.setCategory(this.getText());
                        break;
                    }
                    case "BucketId": {
                        this.queueObject.setBucketId(this.getText());
                        break;
                    }
                    case "BucketName": {
                        this.queueObject.setBucketName(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "QueueList", "NotifyConfig")) {
                switch (name) {
                    case "Url": {
                        this.queueObject.getNotifyConfig().setUrl(this.getText());
                        break;
                    }
                    case "State": {
                        this.queueObject.getNotifyConfig().setState(this.getText());
                        break;
                    }
                    case "Type": {
                        this.queueObject.getNotifyConfig().setType(this.getText());
                        break;
                    }
                    case "Event": {
                        this.queueObject.getNotifyConfig().setEvent(this.getText());
                        break;
                    }
                }
            } else if (this.in("Response", "NonExistPIDs") && "QueueID".equals(name)) {
                this.response.getNonExistPIDs().add(this.getText());
            }
            if ("QueueList".equals(name) && !this.isNew) {
                this.response.getQueueList().add(this.queueObject);
                this.queueObject = null;
            }
        }

        public MediaListQueueResponse getResponse() {
            return this.response;
        }

        public void setResponse(MediaListQueueResponse response) {
            this.response = response;
        }
    }

    public static class GetBucketIntelligentTierConfigurationHandler
    extends AbstractHandler {
        private final BucketIntelligentTierConfiguration configuration = new BucketIntelligentTierConfiguration();
        private BucketIntelligentTierConfiguration.Transition transition;

        public BucketIntelligentTierConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("IntelligentTieringConfiguration") && name.equals("Transition")) {
                this.configuration.setTransition(new BucketIntelligentTierConfiguration.Transition());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("IntelligentTieringConfiguration")) {
                if (name.equals("Status")) {
                    this.configuration.setStatus(this.getText());
                }
            } else if (this.in("IntelligentTieringConfiguration", "Transition") && name.equals("Days")) {
                this.configuration.getTransition().setDays(Integer.parseInt(this.getText()));
            }
        }
    }

    public static class GetObjectTaggingHandler
    extends AbstractHandler {
        private GetObjectTaggingResult getObjectTaggingResult;
        private List<Tag> tagSet;
        private String currentTagValue;
        private String currentTagKey;

        public GetObjectTaggingResult getResult() {
            return this.getObjectTaggingResult;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("Tagging") && name.equals("TagSet")) {
                this.tagSet = new ArrayList<Tag>();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Tagging") && name.equals("TagSet")) {
                this.getObjectTaggingResult = new GetObjectTaggingResult(this.tagSet);
                this.tagSet = null;
            }
            if (this.in("Tagging", "TagSet")) {
                if (name.equals("Tag")) {
                    this.tagSet.add(new Tag(this.currentTagKey, this.currentTagValue));
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("Tagging", "TagSet", "Tag")) {
                if (name.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (name.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class ListBucketInventoryConfigurationsHandler
    extends AbstractHandler {
        public static final String SSE_COS = "SSE-COS";
        private final ListBucketInventoryConfigurationsResult result = new ListBucketInventoryConfigurationsResult();
        private InventoryConfiguration currentConfiguration;
        private List<String> currentOptionalFieldsList;
        private InventoryDestination currentDestination;
        private InventoryFilter currentFilter;
        private InventoryCosBucketDestination currentCosBucketDestination;
        private InventorySchedule currentSchedule;

        public ListBucketInventoryConfigurationsResult getResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListInventoryConfigurationResult")) {
                if (name.equals("InventoryConfiguration")) {
                    this.currentConfiguration = new InventoryConfiguration();
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration")) {
                if (name.equals("Destination")) {
                    this.currentDestination = new InventoryDestination();
                } else if (name.equals("Filter")) {
                    this.currentFilter = new InventoryFilter();
                } else if (name.equals("Schedule")) {
                    this.currentSchedule = new InventorySchedule();
                } else if (name.equals("OptionalFields")) {
                    this.currentOptionalFieldsList = new ArrayList<String>();
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination") && name.equals("COSBucketDestination")) {
                this.currentCosBucketDestination = new InventoryCosBucketDestination();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListInventoryConfigurationResult")) {
                if (name.equals("InventoryConfiguration")) {
                    if (this.result.getInventoryConfigurationList() == null) {
                        this.result.setInventoryConfigurationList(new ArrayList<InventoryConfiguration>());
                    }
                    this.result.getInventoryConfigurationList().add(this.currentConfiguration);
                    this.currentConfiguration = null;
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated("true".equals(this.getText()));
                } else if (name.equals("ContinuationToken")) {
                    this.result.setContinuationToken(this.getText());
                } else if (name.equals("NextContinuationToken")) {
                    this.result.setNextContinuationToken(this.getText());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration")) {
                if (name.equals("Id")) {
                    this.currentConfiguration.setId(this.getText());
                } else if (name.equals("Destination")) {
                    this.currentConfiguration.setDestination(this.currentDestination);
                    this.currentDestination = null;
                } else if (name.equals("IsEnabled")) {
                    this.currentConfiguration.setEnabled("true".equals(this.getText()));
                } else if (name.equals("Filter")) {
                    this.currentConfiguration.setInventoryFilter(this.currentFilter);
                    this.currentFilter = null;
                } else if (name.equals("IncludedObjectVersions")) {
                    this.currentConfiguration.setIncludedObjectVersions(this.getText());
                } else if (name.equals("Schedule")) {
                    this.currentConfiguration.setSchedule(this.currentSchedule);
                    this.currentSchedule = null;
                } else if (name.equals("OptionalFields")) {
                    this.currentConfiguration.setOptionalFields(this.currentOptionalFieldsList);
                    this.currentOptionalFieldsList = null;
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination")) {
                if (name.equals("COSBucketDestination")) {
                    this.currentDestination.setCosBucketDestination(this.currentCosBucketDestination);
                    this.currentCosBucketDestination = null;
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination", "COSBucketDestination")) {
                if (name.equals("AccountId")) {
                    this.currentCosBucketDestination.setAccountId(this.getText());
                } else if (name.equals("Bucket")) {
                    this.currentCosBucketDestination.setBucketArn(this.getText());
                } else if (name.equals("Format")) {
                    this.currentCosBucketDestination.setFormat(this.getText());
                } else if (name.equals("Prefix")) {
                    this.currentCosBucketDestination.setPrefix(this.getText());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Destination", "COSBucketDestination", "Encryption")) {
                if (name.equals(SSE_COS)) {
                    this.currentCosBucketDestination.setEncryption(new ServerSideEncryptionCOS());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Filter")) {
                if (name.equals("Prefix")) {
                    this.currentFilter.setPredicate(new InventoryPrefixPredicate(this.getText()));
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "Schedule")) {
                if (name.equals("Frequency")) {
                    this.currentSchedule.setFrequency(this.getText());
                }
            } else if (this.in("ListInventoryConfigurationResult", "InventoryConfiguration", "OptionalFields") && name.equals("Field")) {
                this.currentOptionalFieldsList.add(this.getText());
            }
        }
    }

    public static class BucketTaggingConfigurationHandler
    extends AbstractHandler {
        private final BucketTaggingConfiguration configuration = new BucketTaggingConfiguration();
        private Map<String, String> currentTagSet;
        private String currentTagKey;
        private String currentTagValue;

        public BucketTaggingConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("Tagging") && name.equals("TagSet")) {
                this.currentTagSet = new LinkedHashMap<String, String>();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("Tagging")) {
                if (name.equals("TagSet")) {
                    this.configuration.getAllTagSets().add(new TagSet(this.currentTagSet));
                    this.currentTagSet = null;
                }
            } else if (this.in("Tagging", "TagSet")) {
                if (name.equals("Tag")) {
                    if (this.currentTagKey != null && this.currentTagValue != null) {
                        this.currentTagSet.put(this.currentTagKey, this.currentTagValue);
                    }
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("Tagging", "TagSet", "Tag")) {
                if (name.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (name.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class GetBucketInventoryConfigurationHandler
    extends AbstractHandler {
        public static final String SSE_COS = "SSE-COS";
        private final GetBucketInventoryConfigurationResult result = new GetBucketInventoryConfigurationResult();
        private final InventoryConfiguration configuration = new InventoryConfiguration();
        private List<String> optionalFields;
        private InventoryDestination inventoryDestination;
        private InventoryFilter filter;
        private InventoryCosBucketDestination cosBucketDestination;
        private InventorySchedule inventorySchedule;

        public GetBucketInventoryConfigurationResult getResult() {
            return this.result.withInventoryConfiguration(this.configuration);
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("InventoryConfiguration")) {
                if (name.equals("Destination")) {
                    this.inventoryDestination = new InventoryDestination();
                } else if (name.equals("Filter")) {
                    this.filter = new InventoryFilter();
                } else if (name.equals("Schedule")) {
                    this.inventorySchedule = new InventorySchedule();
                } else if (name.equals("OptionalFields")) {
                    this.optionalFields = new ArrayList<String>();
                }
            } else if (this.in("InventoryConfiguration", "Destination") && name.equals("COSBucketDestination")) {
                this.cosBucketDestination = new InventoryCosBucketDestination();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("InventoryConfiguration")) {
                if (name.equals("Id")) {
                    this.configuration.setId(this.getText());
                } else if (name.equals("Destination")) {
                    this.configuration.setDestination(this.inventoryDestination);
                    this.inventoryDestination = null;
                } else if (name.equals("IsEnabled")) {
                    this.configuration.setEnabled("true".equals(this.getText()));
                } else if (name.equals("Filter")) {
                    this.configuration.setInventoryFilter(this.filter);
                    this.filter = null;
                } else if (name.equals("IncludedObjectVersions")) {
                    this.configuration.setIncludedObjectVersions(this.getText());
                } else if (name.equals("Schedule")) {
                    this.configuration.setSchedule(this.inventorySchedule);
                    this.inventorySchedule = null;
                } else if (name.equals("OptionalFields")) {
                    this.configuration.setOptionalFields(this.optionalFields);
                    this.optionalFields = null;
                }
            } else if (this.in("InventoryConfiguration", "Destination")) {
                if (name.equals("COSBucketDestination")) {
                    this.inventoryDestination.setCosBucketDestination(this.cosBucketDestination);
                    this.cosBucketDestination = null;
                }
            } else if (this.in("InventoryConfiguration", "Destination", "COSBucketDestination")) {
                if (name.equals("AccountId")) {
                    this.cosBucketDestination.setAccountId(this.getText());
                } else if (name.equals("Bucket")) {
                    this.cosBucketDestination.setBucketArn(this.getText());
                } else if (name.equals("Format")) {
                    this.cosBucketDestination.setFormat(this.getText());
                } else if (name.equals("Prefix")) {
                    this.cosBucketDestination.setPrefix(this.getText());
                }
            } else if (this.in("InventoryConfiguration", "Destination", "COSBucketDestination", "Encryption")) {
                if (name.equals(SSE_COS)) {
                    this.cosBucketDestination.setEncryption(new ServerSideEncryptionCOS());
                }
            } else if (this.in("InventoryConfiguration", "Filter")) {
                if (name.equals("Prefix")) {
                    this.filter.setPredicate(new InventoryPrefixPredicate(this.getText()));
                }
            } else if (this.in("InventoryConfiguration", "Schedule")) {
                if (name.equals("Frequency")) {
                    this.inventorySchedule.setFrequency(this.getText());
                }
            } else if (this.in("InventoryConfiguration", "OptionalFields") && name.equals("Field")) {
                this.optionalFields.add(this.getText());
            }
        }
    }

    public static class BucketLoggingConfigurationHandler
    extends AbstractHandler {
        private final BucketLoggingConfiguration bucketLoggingConfiguration = new BucketLoggingConfiguration();

        public BucketLoggingConfiguration getBucketLoggingConfiguration() {
            return this.bucketLoggingConfiguration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("BucketLoggingStatus", "LoggingEnabled")) {
                if (name.equals("TargetBucket")) {
                    this.bucketLoggingConfiguration.setDestinationBucketName(this.getText());
                } else if (name.equals("TargetPrefix")) {
                    this.bucketLoggingConfiguration.setLogFilePrefix(this.getText());
                }
            }
        }
    }

    public static class BucketRefererConfigurationHandler
    extends AbstractHandler {
        private final BucketRefererConfiguration configuration = new BucketRefererConfiguration();

        public BucketRefererConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("RefererConfiguration")) {
                if (name.equals("Status")) {
                    this.configuration.setStatus(this.getText());
                } else if (name.equals("RefererType")) {
                    this.configuration.setRefererType(this.getText());
                } else if (name.equals("EmptyReferConfiguration")) {
                    this.configuration.setEmptyReferConfiguration(this.getText());
                }
            } else if (this.in("RefererConfiguration", "DomainList") && name.equals("Domain")) {
                this.configuration.addDomain(this.getText());
            }
        }
    }

    public static class BucketDomainCertificateHandler
    extends AbstractHandler {
        private final BucketGetDomainCertificate domainCertificate = new BucketGetDomainCertificate();

        public BucketGetDomainCertificate getBucketDomainCertificate() {
            return this.domainCertificate;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("DomainCertificate") && "Status".equals(name)) {
                this.domainCertificate.setStatus(this.getText());
            }
        }
    }

    public static class BucketDomainConfigurationHandler
    extends AbstractHandler {
        private final BucketDomainConfiguration configuration = new BucketDomainConfiguration();
        private DomainRule currentRule;
        private String status;
        private String mname;
        private String type;
        private String forcedReplacement;

        public BucketDomainConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("DomainConfiguration") && name.equals("DomainRule")) {
                this.currentRule = new DomainRule();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("DomainConfiguration")) {
                if (name.equals("DomainRule")) {
                    this.currentRule.setStatus(this.status);
                    this.currentRule.setName(this.mname);
                    this.currentRule.setType(this.type);
                    this.currentRule.setForcedReplacement(this.forcedReplacement);
                    this.configuration.getDomainRules().add(this.currentRule);
                    this.currentRule = null;
                    this.status = null;
                    this.mname = null;
                    this.type = null;
                    this.forcedReplacement = null;
                }
            } else if (this.in("DomainConfiguration", "DomainRule")) {
                if (name.equals("Status")) {
                    this.status = this.getText();
                } else if (name.equals("Name")) {
                    this.mname = this.getText();
                } else if (name.equals("Type")) {
                    this.type = this.getText();
                } else if (name.equals("ForcedReplacement")) {
                    this.forcedReplacement = this.getText();
                }
            }
        }
    }

    public static class BucketCrossOriginConfigurationHandler
    extends AbstractHandler {
        private final BucketCrossOriginConfiguration configuration = new BucketCrossOriginConfiguration(new ArrayList<CORSRule>());
        private CORSRule currentRule;
        private List<CORSRule.AllowedMethods> allowedMethods = null;
        private List<String> allowedOrigins = null;
        private List<String> exposedHeaders = null;
        private List<String> allowedHeaders = null;

        public BucketCrossOriginConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("CORSConfiguration")) {
                if (name.equals("CORSRule")) {
                    this.currentRule = new CORSRule();
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (name.equals("AllowedOrigin")) {
                    if (this.allowedOrigins == null) {
                        this.allowedOrigins = new ArrayList<String>();
                    }
                } else if (name.equals("AllowedMethod")) {
                    if (this.allowedMethods == null) {
                        this.allowedMethods = new ArrayList<CORSRule.AllowedMethods>();
                    }
                } else if (name.equals("ExposeHeader")) {
                    if (this.exposedHeaders == null) {
                        this.exposedHeaders = new ArrayList<String>();
                    }
                } else if (name.equals("AllowedHeader") && this.allowedHeaders == null) {
                    this.allowedHeaders = new LinkedList<String>();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("CORSConfiguration")) {
                if (name.equals("CORSRule")) {
                    this.currentRule.setAllowedHeaders(this.allowedHeaders);
                    this.currentRule.setAllowedMethods(this.allowedMethods);
                    this.currentRule.setAllowedOrigins(this.allowedOrigins);
                    this.currentRule.setExposedHeaders(this.exposedHeaders);
                    this.allowedHeaders = null;
                    this.allowedMethods = null;
                    this.allowedOrigins = null;
                    this.exposedHeaders = null;
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("CORSConfiguration", "CORSRule")) {
                if (name.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (name.equals("AllowedOrigin")) {
                    this.allowedOrigins.add(this.getText());
                } else if (name.equals("AllowedMethod")) {
                    this.allowedMethods.add(CORSRule.AllowedMethods.fromValue(this.getText()));
                } else if (name.equals("MaxAgeSeconds")) {
                    this.currentRule.setMaxAgeSeconds(Integer.parseInt(this.getText()));
                } else if (name.equals("ExposeHeader")) {
                    this.exposedHeaders.add(this.getText());
                } else if (name.equals("AllowedHeader")) {
                    this.allowedHeaders.add(this.getText());
                }
            }
        }
    }

    public static class BucketLifecycleConfigurationHandler
    extends AbstractHandler {
        private final BucketLifecycleConfiguration configuration = new BucketLifecycleConfiguration(new ArrayList<BucketLifecycleConfiguration.Rule>());
        private BucketLifecycleConfiguration.Rule currentRule;
        private BucketLifecycleConfiguration.Transition currentTransition;
        private BucketLifecycleConfiguration.NoncurrentVersionTransition currentNcvTransition;
        private AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;
        private LifecycleFilter currentFilter;
        private List<LifecycleFilterPredicate> andOperandsList;
        private String currentTagKey;
        private String currentTagValue;

        public BucketLifecycleConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("LifecycleConfiguration")) {
                if (name.equals("Rule")) {
                    this.currentRule = new BucketLifecycleConfiguration.Rule();
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (name.equals("Transition")) {
                    this.currentTransition = new BucketLifecycleConfiguration.Transition();
                } else if (name.equals("NoncurrentVersionTransition")) {
                    this.currentNcvTransition = new BucketLifecycleConfiguration.NoncurrentVersionTransition();
                } else if (name.equals("AbortIncompleteMultipartUpload")) {
                    this.abortIncompleteMultipartUpload = new AbortIncompleteMultipartUpload();
                } else if (name.equals("Filter")) {
                    this.currentFilter = new LifecycleFilter();
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter") && name.equals("And")) {
                this.andOperandsList = new ArrayList<LifecycleFilterPredicate>();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("LifecycleConfiguration")) {
                if (name.equals("Rule")) {
                    this.configuration.getRules().add(this.currentRule);
                    this.currentRule = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule")) {
                if (name.equals("ID")) {
                    this.currentRule.setId(this.getText());
                } else if (name.equals("Status")) {
                    this.currentRule.setStatus(this.getText());
                } else if (name.equals("Transition")) {
                    this.currentRule.addTransition(this.currentTransition);
                    this.currentTransition = null;
                } else if (name.equals("NoncurrentVersionTransition")) {
                    this.currentRule.addNoncurrentVersionTransition(this.currentNcvTransition);
                    this.currentNcvTransition = null;
                } else if (name.equals("AbortIncompleteMultipartUpload")) {
                    this.currentRule.setAbortIncompleteMultipartUpload(this.abortIncompleteMultipartUpload);
                    this.abortIncompleteMultipartUpload = null;
                } else if (name.equals("Filter")) {
                    this.currentRule.setFilter(this.currentFilter);
                    this.currentFilter = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Expiration")) {
                if (name.equals("Date")) {
                    this.currentRule.setExpirationDate(DateUtils.parseISO8601Date(this.getText()));
                } else if (name.equals("Days")) {
                    this.currentRule.setExpirationInDays(Integer.parseInt(this.getText()));
                } else if (name.equals("ExpiredObjectDeleteMarker") && "true".equals(this.getText())) {
                    this.currentRule.setExpiredObjectDeleteMarker(true);
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Transition")) {
                if (name.equals("StorageClass")) {
                    this.currentTransition.setStorageClass(this.getText());
                } else if (name.equals("Date")) {
                    this.currentTransition.setDate(DateUtils.parseISO8601Date(this.getText()));
                } else if (name.equals("Days")) {
                    this.currentTransition.setDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionExpiration")) {
                if (name.equals("NoncurrentDays")) {
                    this.currentRule.setNoncurrentVersionExpirationInDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "NoncurrentVersionTransition")) {
                if (name.equals("StorageClass")) {
                    this.currentNcvTransition.setStorageClass(this.getText());
                } else if (name.equals("NoncurrentDays")) {
                    this.currentNcvTransition.setDays(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "AbortIncompleteMultipartUpload")) {
                if (name.equals("DaysAfterInitiation")) {
                    this.abortIncompleteMultipartUpload.setDaysAfterInitiation(Integer.parseInt(this.getText()));
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter")) {
                if (name.equals("Prefix")) {
                    this.currentFilter.setPredicate(new LifecyclePrefixPredicate(this.getText()));
                } else if (name.equals("Tag")) {
                    this.currentFilter.setPredicate(new LifecycleTagPredicate(new Tag(this.currentTagKey, this.currentTagValue)));
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                } else if (name.equals("And")) {
                    this.currentFilter.setPredicate(new LifecycleAndOperator(this.andOperandsList));
                    this.andOperandsList = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter", "Tag")) {
                if (name.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (name.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter", "And")) {
                if (name.equals("Prefix")) {
                    this.andOperandsList.add(new LifecyclePrefixPredicate(this.getText()));
                } else if (name.equals("Tag")) {
                    this.andOperandsList.add(new LifecycleTagPredicate(new Tag(this.currentTagKey, this.currentTagValue)));
                    this.currentTagKey = null;
                    this.currentTagValue = null;
                }
            } else if (this.in("LifecycleConfiguration", "Rule", "Filter", "And", "Tag")) {
                if (name.equals("Key")) {
                    this.currentTagKey = this.getText();
                } else if (name.equals("Value")) {
                    this.currentTagValue = this.getText();
                }
            }
        }
    }

    public static class DeleteObjectsHandler
    extends AbstractHandler {
        private final DeleteObjectsResponse response = new DeleteObjectsResponse();
        private DeleteObjectsResult.DeletedObject currentDeletedObject = null;
        private MultiObjectDeleteException.DeleteError currentError = null;

        public DeleteObjectsResponse getDeleteObjectResult() {
            return this.response;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("DeleteResult")) {
                if (name.equals("Deleted")) {
                    this.currentDeletedObject = new DeleteObjectsResult.DeletedObject();
                } else if (name.equals("Error")) {
                    this.currentError = new MultiObjectDeleteException.DeleteError();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("DeleteResult")) {
                if (name.equals("Deleted")) {
                    this.response.getDeletedObjects().add(this.currentDeletedObject);
                    this.currentDeletedObject = null;
                } else if (name.equals("Error")) {
                    this.response.getErrors().add(this.currentError);
                    this.currentError = null;
                }
            } else if (this.in("DeleteResult", "Deleted")) {
                if (name.equals("Key")) {
                    this.currentDeletedObject.setKey(this.getText());
                } else if (name.equals("VersionId")) {
                    this.currentDeletedObject.setVersionId(this.getText());
                } else if (name.equals("DeleteMarker")) {
                    this.currentDeletedObject.setDeleteMarker(this.getText().equals("true"));
                } else if (name.equals("DeleteMarkerVersionId")) {
                    this.currentDeletedObject.setDeleteMarkerVersionId(this.getText());
                }
            } else if (this.in("DeleteResult", "Error")) {
                if (name.equals("Key")) {
                    this.currentError.setKey(this.getText());
                } else if (name.equals("VersionId")) {
                    this.currentError.setVersionId(this.getText());
                } else if (name.equals("Code")) {
                    this.currentError.setCode(this.getText());
                } else if (name.equals("Message")) {
                    this.currentError.setMessage(this.getText());
                }
            }
        }
    }

    public static class BucketReplicationConfigurationHandler
    extends AbstractHandler {
        private final BucketReplicationConfiguration bucketReplicationConfiguration = new BucketReplicationConfiguration();
        private ReplicationRule currentRule;
        private ReplicationDestinationConfig destinationConfig;
        private static final String REPLICATION_CONFIG = "ReplicationConfiguration";
        private static final String ROLE = "Role";
        private static final String RULE = "Rule";
        private static final String DESTINATION = "Destination";
        private static final String ID = "ID";
        private static final String PREFIX = "Prefix";
        private static final String STATUS = "Status";
        private static final String BUCKET = "Bucket";
        private static final String STORAGECLASS = "StorageClass";

        public BucketReplicationConfiguration getConfiguration() {
            return this.bucketReplicationConfiguration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in(REPLICATION_CONFIG)) {
                if (name.equals(RULE)) {
                    this.currentRule = new ReplicationRule();
                }
            } else if (this.in(REPLICATION_CONFIG, RULE) && name.equals(DESTINATION)) {
                this.destinationConfig = new ReplicationDestinationConfig();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in(REPLICATION_CONFIG)) {
                if (name.equals(RULE)) {
                    this.bucketReplicationConfiguration.addRule(this.currentRule);
                    this.currentRule = null;
                    this.destinationConfig = null;
                } else if (name.equals(ROLE)) {
                    this.bucketReplicationConfiguration.setRoleName(this.getText());
                }
            } else if (this.in(REPLICATION_CONFIG, RULE)) {
                if (name.equals(ID)) {
                    this.currentRule.setID(this.getText());
                } else if (name.equals(PREFIX)) {
                    this.currentRule.setPrefix(this.getText());
                } else if (name.equals(STATUS)) {
                    this.currentRule.setStatus(this.getText());
                } else if (name.equals(DESTINATION)) {
                    this.currentRule.setDestinationConfig(this.destinationConfig);
                }
            } else if (this.in(REPLICATION_CONFIG, RULE, DESTINATION)) {
                if (name.equals(BUCKET)) {
                    this.destinationConfig.setBucketQCS(this.getText());
                } else if (name.equals(STORAGECLASS)) {
                    this.destinationConfig.setStorageClass(this.getText());
                }
            }
        }
    }

    public static class BucketWebsiteConfigurationHandler
    extends AbstractHandler {
        private final BucketWebsiteConfiguration configuration = new BucketWebsiteConfiguration(null);
        private RoutingRuleCondition currentCondition = null;
        private RedirectRule currentRedirectRule = null;
        private RoutingRule currentRoutingRule = null;

        public BucketWebsiteConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("WebsiteConfiguration")) {
                if (name.equals("RedirectAllRequestsTo")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (name.equals("RoutingRule")) {
                    this.currentRoutingRule = new RoutingRule();
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (name.equals("Condition")) {
                    this.currentCondition = new RoutingRuleCondition();
                } else if (name.equals("Redirect")) {
                    this.currentRedirectRule = new RedirectRule();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("WebsiteConfiguration")) {
                if (name.equals("RedirectAllRequestsTo")) {
                    this.configuration.setRedirectAllRequestsTo(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "IndexDocument")) {
                if (name.equals("Suffix")) {
                    this.configuration.setIndexDocumentSuffix(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "ErrorDocument")) {
                if (name.equals("Key")) {
                    this.configuration.setErrorDocument(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules")) {
                if (name.equals("RoutingRule")) {
                    this.configuration.getRoutingRules().add(this.currentRoutingRule);
                    this.currentRoutingRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule")) {
                if (name.equals("Condition")) {
                    this.currentRoutingRule.setCondition(this.currentCondition);
                    this.currentCondition = null;
                } else if (name.equals("Redirect")) {
                    this.currentRoutingRule.setRedirect(this.currentRedirectRule);
                    this.currentRedirectRule = null;
                }
            } else if (this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Condition")) {
                if (name.equals("KeyPrefixEquals")) {
                    this.currentCondition.setKeyPrefixEquals(this.getText());
                } else if (name.equals("HttpErrorCodeReturnedEquals")) {
                    this.currentCondition.setHttpErrorCodeReturnedEquals(this.getText());
                }
            } else if (this.in("WebsiteConfiguration", "RedirectAllRequestsTo") || this.in("WebsiteConfiguration", "RoutingRules", "RoutingRule", "Redirect")) {
                if (name.equals("Protocol")) {
                    this.currentRedirectRule.setProtocol(this.getText());
                } else if (name.equals("HostName")) {
                    this.currentRedirectRule.setHostName(this.getText());
                } else if (name.equals("ReplaceKeyPrefixWith")) {
                    this.currentRedirectRule.setReplaceKeyPrefixWith(this.getText());
                } else if (name.equals("ReplaceKeyWith")) {
                    this.currentRedirectRule.setReplaceKeyWith(this.getText());
                } else if (name.equals("HttpRedirectCode")) {
                    this.currentRedirectRule.setHttpRedirectCode(this.getText());
                }
            }
        }
    }

    public static class ListPartsHandler
    extends AbstractHandler {
        private final PartListing result = new PartListing();
        private PartSummary currentPart;
        private Owner currentOwner;

        public PartListing getListPartsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListPartsResult")) {
                if (name.equals("Part")) {
                    this.currentPart = new PartSummary();
                } else if (name.equals("Owner") || name.equals("Initiator")) {
                    this.currentOwner = new Owner();
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListPartsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                } else if (name.equals("Owner")) {
                    this.result.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.result.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("StorageClass")) {
                    this.result.setStorageClass(this.getText());
                } else if (name.equals("PartNumberMarker")) {
                    this.result.setPartNumberMarker(this.parseInteger(this.getText()));
                } else if (name.equals("NextPartNumberMarker")) {
                    this.result.setNextPartNumberMarker(this.parseInteger(this.getText()));
                } else if (name.equals("MaxParts")) {
                    this.result.setMaxParts(this.parseInteger(this.getText()));
                } else if (name.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (name.equals("Part")) {
                    this.result.getParts().add(this.currentPart);
                    this.currentPart = null;
                }
            } else if (this.in("ListPartsResult", "Part")) {
                if (name.equals("PartNumber")) {
                    this.currentPart.setPartNumber(Integer.parseInt(this.getText()));
                } else if (name.equals("LastModified")) {
                    this.currentPart.setLastModified(DateUtils.parseISO8601Date(this.getText()));
                } else if (name.equals("ETag")) {
                    this.currentPart.setETag(StringUtils.removeQuotes(this.getText()));
                } else if (name.equals("Size")) {
                    this.currentPart.setSize(Long.parseLong(this.getText()));
                }
            } else if (this.in("ListPartsResult", "Owner") || this.in("ListPartsResult", "Initiator")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }

        private Integer parseInteger(String text) {
            text = XmlResponsesSaxParser.checkForEmptyString(this.getText());
            if (text == null) {
                return null;
            }
            return Integer.parseInt(text);
        }
    }

    public static class ListMultipartUploadsHandler
    extends AbstractHandler {
        private final MultipartUploadListing result = new MultipartUploadListing();
        private MultipartUpload currentMultipartUpload;
        private Owner currentOwner;

        public MultipartUploadListing getListMultipartUploadsResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListMultipartUploadsResult")) {
                if (name.equals("Upload")) {
                    this.currentMultipartUpload = new MultipartUpload();
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload") && (name.equals("Owner") || name.equals("Initiator"))) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListMultipartUploadsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("KeyMarker")) {
                    this.result.setKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("Delimiter")) {
                    this.result.setDelimiter(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("Prefix")) {
                    this.result.setPrefix(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("UploadIdMarker")) {
                    this.result.setUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("NextKeyMarker")) {
                    this.result.setNextKeyMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("NextUploadIdMarker")) {
                    this.result.setNextUploadIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("MaxUploads")) {
                    this.result.setMaxUploads(Integer.parseInt(this.getText()));
                } else if (name.equals("EncodingType")) {
                    this.result.setEncodingType(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.getText()));
                } else if (name.equals("Upload")) {
                    this.result.getMultipartUploads().add(this.currentMultipartUpload);
                    this.currentMultipartUpload = null;
                }
            } else if (this.in("ListMultipartUploadsResult", "CommonPrefixes")) {
                if (name.equals("Prefix")) {
                    this.result.getCommonPrefixes().add(this.getText());
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload")) {
                if (name.equals("Key")) {
                    this.currentMultipartUpload.setKey(this.getText());
                } else if (name.equals("UploadId")) {
                    this.currentMultipartUpload.setUploadId(this.getText());
                } else if (name.equals("Owner")) {
                    this.currentMultipartUpload.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.currentMultipartUpload.setInitiator(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiated")) {
                    this.currentMultipartUpload.setInitiated(DateUtils.parseISO8601Date(this.getText()));
                }
            } else if (this.in("ListMultipartUploadsResult", "Upload", "Owner") || this.in("ListMultipartUploadsResult", "Upload", "Initiator")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                }
            }
        }
    }

    public static class InitiateMultipartUploadHandler
    extends AbstractHandler {
        private final InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            return this.result;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("InitiateMultipartUploadResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.getText());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.getText());
                }
            }
        }
    }

    public static class CompleteMultipartUploadHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult,
    VIDResult {
        private CompleteMultipartUploadResult result;
        private CIUploadResult ciUploadResult = new CIUploadResult();
        private OriginalInfo originalInfo;
        private CIObject ciObject;
        private QRcodeInfo qRcodeInfo;
        private CosServiceException cse;
        private String traceId;
        private String requestId;
        private String errorCode;

        @Override
        public Date getExpirationTime() {
            return this.result == null ? null : this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date expirationTime) {
            if (this.result != null) {
                this.result.setExpirationTime(expirationTime);
            }
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result == null ? null : this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String expirationTimeRuleId) {
            if (this.result != null) {
                this.result.setExpirationTimeRuleId(expirationTimeRuleId);
            }
        }

        @Override
        public String getRequestId() {
            return this.result == null ? null : this.result.getRequestId();
        }

        @Override
        public void setRequestId(String requestId) {
            if (this.result != null) {
                this.result.setRequestId(requestId);
            }
        }

        @Override
        public String getDateStr() {
            return this.result == null ? null : this.result.getDateStr();
        }

        @Override
        public void setDateStr(String dateStr) {
            if (this.result != null) {
                this.result.setDateStr(dateStr);
            }
        }

        public CompleteMultipartUploadResult getCompleteMultipartUploadResult() {
            return this.result;
        }

        public CosServiceException getCOSException() {
            return this.cse;
        }

        public CIUploadResult getCiUploadResult() {
            return this.ciUploadResult;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.atTopLevel()) {
                if (name.equals("CompleteMultipartUploadResult")) {
                    this.result = new CompleteMultipartUploadResult();
                    this.originalInfo = new OriginalInfo();
                    this.ciUploadResult.setOriginalInfo(this.originalInfo);
                }
            } else if (this.in("CompleteMultipartUploadResult")) {
                if (name.equals("ImageInfo")) {
                    this.ciUploadResult.getOriginalInfo().setImageInfo(new ImageInfo());
                } else if (name.equals("ProcessResults")) {
                    this.ciUploadResult.setProcessResults(new ProcessResults());
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults")) {
                if (name.equals("Object")) {
                    this.ciObject = new CIObject();
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object")) {
                if (name.equals("QRcodeInfo")) {
                    this.qRcodeInfo = new QRcodeInfo();
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object", "QRcodeInfo") && name.equals("CodeLocation")) {
                this.qRcodeInfo.setCodeLocation(new CodeLocation());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.atTopLevel()) {
                if (name.equals("Error") && this.cse != null) {
                    this.cse.setErrorCode(this.errorCode);
                    this.cse.setRequestId(this.requestId);
                    this.cse.setTraceId(this.traceId);
                    this.cse.setStatusCode(200);
                }
            } else if (this.in("Error")) {
                if (name.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (name.equals("Message")) {
                    this.cse = new CosServiceException(this.getText());
                } else if (name.equals("RequestId")) {
                    this.requestId = this.getText();
                } else if (name.equals("HostId")) {
                    this.traceId = this.getText();
                }
            } else if (this.in("CompleteMultipartUploadResult")) {
                if (name.equals("Location")) {
                    this.result.setLocation(this.getText());
                    this.originalInfo.setLocation(this.getText());
                } else if (name.equals("Bucket")) {
                    this.result.setBucketName(this.getText());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.getText());
                    this.originalInfo.setKey(this.getText());
                } else if (name.equals("ETag")) {
                    this.result.setETag(StringUtils.removeQuotes(this.getText()));
                    this.originalInfo.setEtag(StringUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("CompleteMultipartUploadResult", "ImageInfo")) {
                ImageInfo imageInfo = this.ciUploadResult.getOriginalInfo().getImageInfo();
                if (name.equals("Format")) {
                    imageInfo.setFormat(this.getText());
                } else if (name.equals("Width")) {
                    imageInfo.setWidth(Integer.parseInt(this.getText()));
                } else if (name.equals("Height")) {
                    imageInfo.setHeight(Integer.parseInt(this.getText()));
                } else if (name.equals("Quality")) {
                    imageInfo.setQuality(Integer.parseInt(this.getText()));
                } else if (name.equals("Ave")) {
                    imageInfo.setAve(this.getText());
                } else if (name.equals("Orientation")) {
                    imageInfo.setOrientation(Integer.parseInt(this.getText()));
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults")) {
                if (name.equals("Object")) {
                    if (this.ciUploadResult.getProcessResults().getObjectList() == null) {
                        this.ciUploadResult.getProcessResults().setObjectList(new LinkedList<CIObject>());
                    }
                    this.ciUploadResult.getProcessResults().getObjectList().add(this.ciObject);
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object")) {
                if (name.equals("Key")) {
                    this.ciObject.setKey(this.getText());
                } else if (name.equals("Location")) {
                    this.ciObject.setLocation(this.getText());
                } else if (name.equals("Format")) {
                    this.ciObject.setFormat(this.getText());
                } else if (name.equals("Width")) {
                    this.ciObject.setWidth(Integer.parseInt(this.getText()));
                } else if (name.equals("Height")) {
                    this.ciObject.setHeight(Integer.parseInt(this.getText()));
                } else if (name.equals("Size")) {
                    this.ciObject.setSize(Integer.parseInt(this.getText()));
                } else if (name.equals("Quality")) {
                    this.ciObject.setQuality(Integer.parseInt(this.getText()));
                } else if (name.equals("ETag")) {
                    this.ciObject.setEtag(StringUtils.removeQuotes(this.getText()));
                } else if (name.equals("CodeStatus")) {
                    this.ciObject.setCodeStatus(Integer.parseInt(this.getText()));
                } else if (name.equals("QRcodeInfo")) {
                    if (this.ciObject.getQRcodeInfoList() == null) {
                        this.ciObject.setQRcodeInfoList(new LinkedList<QRcodeInfo>());
                    }
                    this.ciObject.getQRcodeInfoList().add(this.qRcodeInfo);
                } else if (name.equals("WatermarkStatus")) {
                    this.ciObject.setWatermarkStatus(Integer.parseInt(this.getText()));
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object", "QRcodeInfo")) {
                if (name.equals("CodeUrl")) {
                    this.qRcodeInfo.setCodeUrl(this.getText());
                }
            } else if (this.in("CompleteMultipartUploadResult", "ProcessResults", "Object", "QRcodeInfo", "CodeLocation")) {
                CodeLocation codeLocation = this.qRcodeInfo.getCodeLocation();
                if (codeLocation.getPoints() == null) {
                    codeLocation.setPoints(new LinkedList<String>());
                }
                if (name.equals("Point")) {
                    codeLocation.getPoints().add(this.getText());
                }
            }
        }

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }
    }

    public static class BucketVersioningConfigurationHandler
    extends AbstractHandler {
        private final BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();

        public BucketVersioningConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("VersioningConfiguration") && name.equals("Status")) {
                this.configuration.setStatus(this.getText());
            }
        }
    }

    public static class ListVersionsHandler
    extends AbstractHandler {
        private final VersionListing versionListing = new VersionListing();
        private final boolean shouldSDKDecodeResponse;
        private COSVersionSummary currentVersionSummary;
        private Owner currentOwner;

        public ListVersionsHandler(boolean shouldSDKDecodeResponse) {
            this.shouldSDKDecodeResponse = shouldSDKDecodeResponse;
        }

        public VersionListing getListing() {
            return this.versionListing;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListVersionsResult")) {
                if (name.equals("Version")) {
                    this.currentVersionSummary = new COSVersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                } else if (name.equals("DeleteMarker")) {
                    this.currentVersionSummary = new COSVersionSummary();
                    this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                    this.currentVersionSummary.setIsDeleteMarker(true);
                }
            } else if ((this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) && name.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListVersionsResult")) {
                if (name.equals("Name")) {
                    this.versionListing.setBucketName(this.getText());
                } else if (name.equals("Prefix")) {
                    this.versionListing.setPrefix(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (name.equals("KeyMarker")) {
                    this.versionListing.setKeyMarker(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (name.equals("VersionIdMarker")) {
                    this.versionListing.setVersionIdMarker(XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("MaxKeys")) {
                    this.versionListing.setMaxKeys(Integer.parseInt(this.getText()));
                } else if (name.equals("Delimiter")) {
                    this.versionListing.setDelimiter(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (name.equals("EncodingType")) {
                    this.versionListing.setEncodingType(this.shouldSDKDecodeResponse ? null : XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                } else if (name.equals("NextKeyMarker")) {
                    this.versionListing.setNextKeyMarker(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                } else if (name.equals("NextVersionIdMarker")) {
                    this.versionListing.setNextVersionIdMarker(this.getText());
                } else if (name.equals("IsTruncated")) {
                    this.versionListing.setTruncated("true".equals(this.getText()));
                } else if (name.equals("Version") || name.equals("DeleteMarker")) {
                    this.versionListing.getVersionSummaries().add(this.currentVersionSummary);
                    this.currentVersionSummary = null;
                }
            } else if (this.in("ListVersionsResult", "CommonPrefixes")) {
                if (name.equals("Prefix")) {
                    String commonPrefix = XmlResponsesSaxParser.checkForEmptyString(this.getText());
                    this.versionListing.getCommonPrefixes().add(this.shouldSDKDecodeResponse ? UrlEncoderUtils.urlDecode(commonPrefix) : commonPrefix);
                }
            } else if (this.in("ListVersionsResult", "Version") || this.in("ListVersionsResult", "DeleteMarker")) {
                if (name.equals("Key")) {
                    this.currentVersionSummary.setKey(XmlResponsesSaxParser.decodeIfSpecified(this.getText(), this.shouldSDKDecodeResponse));
                } else if (name.equals("VersionId")) {
                    this.currentVersionSummary.setVersionId(this.getText());
                } else if (name.equals("IsLatest")) {
                    this.currentVersionSummary.setIsLatest("true".equals(this.getText()));
                } else if (name.equals("LastModified")) {
                    this.currentVersionSummary.setLastModified(DateUtils.parseISO8601Date(this.getText()));
                } else if (name.equals("ETag")) {
                    this.currentVersionSummary.setETag(StringUtils.removeQuotes(this.getText()));
                } else if (name.equals("Size")) {
                    this.currentVersionSummary.setSize(Long.parseLong(this.getText()));
                } else if (name.equals("Owner")) {
                    this.currentVersionSummary.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("StorageClass")) {
                    this.currentVersionSummary.setStorageClass(this.getText());
                }
            } else if (this.in("ListVersionsResult", "Version", "Owner") || this.in("ListVersionsResult", "DeleteMarker", "Owner")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                } else if (name.equals("DisplayName")) {
                    this.currentOwner.setDisplayName(this.getText());
                }
            }
        }
    }

    public static class CopyObjectResultHandler
    extends AbstractSSEHandler
    implements ObjectExpirationResult,
    VIDResult {
        private final CopyObjectResult result = new CopyObjectResult();
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private String crc64Ecma;
        private boolean receivedErrorResponse = false;

        @Override
        public void setDateStr(String dateStr) {
            this.result.setDateStr(dateStr);
        }

        @Override
        public String getDateStr() {
            return this.result.getDateStr();
        }

        @Override
        public void setRequestId(String requestId) {
            this.result.setRequestId(requestId);
        }

        @Override
        public String getRequestId() {
            return this.result.getRequestId();
        }

        @Override
        protected ServerSideEncryptionResult sseResult() {
            return this.result;
        }

        public Date getLastModified() {
            return this.result.getLastModifiedDate();
        }

        public String getVersionId() {
            return this.result.getVersionId();
        }

        public void setVersionId(String versionId) {
            this.result.setVersionId(versionId);
        }

        public String getCrc64Ecma() {
            return this.result.getCrc64Ecma();
        }

        public void setCrc64Ecma(String crc64Ecma) {
            this.result.setCrc64Ecma(crc64Ecma);
        }

        @Override
        public Date getExpirationTime() {
            return this.result.getExpirationTime();
        }

        @Override
        public void setExpirationTime(Date expirationTime) {
            this.result.setExpirationTime(expirationTime);
        }

        @Override
        public String getExpirationTimeRuleId() {
            return this.result.getExpirationTimeRuleId();
        }

        @Override
        public void setExpirationTimeRuleId(String expirationTimeRuleId) {
            this.result.setExpirationTimeRuleId(expirationTimeRuleId);
        }

        public String getETag() {
            return this.result.getETag();
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.atTopLevel()) {
                if (name.equals("CopyObjectResult") || name.equals("CopyPartResult")) {
                    this.receivedErrorResponse = false;
                } else if (name.equals("Error")) {
                    this.receivedErrorResponse = true;
                }
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("CopyObjectResult") || this.in("CopyPartResult")) {
                if (!name.equals("LastModified")) {
                    if (name.equals("ETag")) {
                        this.result.setETag(StringUtils.removeQuotes(this.getText()));
                    } else if (name.equals("VersionId")) {
                        this.result.setVersionId(this.getText());
                    } else if (name.equals("CRC64")) {
                        this.result.setCrc64Ecma(this.getText());
                    }
                }
            } else if (this.in("Error")) {
                if (name.equals("Code")) {
                    this.errorCode = this.getText();
                } else if (name.equals("Message")) {
                    this.errorMessage = this.getText();
                } else if (name.equals("RequestId")) {
                    this.errorRequestId = this.getText();
                } else if (name.equals("HostId")) {
                    this.errorHostId = this.getText();
                }
            }
        }
    }

    public static class BucketLocationHandler
    extends AbstractHandler {
        private String location = null;

        public String getLocation() {
            return this.location;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.atTopLevel() && name.equals("LocationConstraint")) {
                String elementText = this.getText();
                this.location = elementText.length() == 0 ? null : elementText;
            }
        }
    }

    public static class AccessControlListHandler
    extends AbstractHandler {
        private final AccessControlList accessControlList = new AccessControlList();
        private Grantee currentGrantee = null;
        private Permission currentPermission = null;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            String type;
            if (this.in("AccessControlPolicy")) {
                if (name.equals("Owner")) {
                    this.accessControlList.setOwner(new Owner());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant") && name.equals("Grantee") && !"Group".equals(type = XmlResponsesSaxParser.findAttributeValue("xsi:type", attrs)) && "CanonicalUser".equals(type)) {
                this.currentGrantee = new UinGrantee(null);
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("AccessControlPolicy", "Owner")) {
                if (name.equals("ID")) {
                    this.accessControlList.getOwner().setId(this.getText());
                } else if (name.equals("DisplayName")) {
                    this.accessControlList.getOwner().setDisplayName(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList")) {
                if (name.equals("Grant")) {
                    this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                    this.currentGrantee = null;
                    this.currentPermission = null;
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant")) {
                if (name.equals("Permission")) {
                    this.currentPermission = Permission.parsePermission(this.getText());
                }
            } else if (this.in("AccessControlPolicy", "AccessControlList", "Grant", "Grantee")) {
                if (name.equals("ID")) {
                    this.currentGrantee.setIdentifier(this.getText());
                } else if (name.equals("URI")) {
                    this.currentGrantee = GroupGrantee.parseGroupGrantee(this.getText());
                } else if (name.equals("DisplayName")) {
                    ((UinGrantee)this.currentGrantee).setDisplayName(this.getText());
                }
            }
        }
    }

    public static class ImagePersistenceHandler
    extends AbstractHandler {
        private final CIUploadResult ciUploadResult = new CIUploadResult();
        private CIObject ciObject;
        private QRcodeInfo qRcodeInfo;

        public CIUploadResult getCiUploadResult() {
            return this.ciUploadResult;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("UploadResult")) {
                if (name.equals("OriginalInfo")) {
                    this.ciUploadResult.setOriginalInfo(new OriginalInfo());
                } else if (name.equals("ProcessResults")) {
                    this.ciUploadResult.setProcessResults(new ProcessResults());
                }
            } else if (this.in("UploadResult", "OriginalInfo")) {
                if (name.equals("ImageInfo")) {
                    this.ciUploadResult.getOriginalInfo().setImageInfo(new ImageInfo());
                }
            } else if (this.in("UploadResult", "ProcessResults")) {
                if (name.equals("Object")) {
                    this.ciObject = new CIObject();
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object")) {
                if (name.equals("QRcodeInfo")) {
                    this.qRcodeInfo = new QRcodeInfo();
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object", "QRcodeInfo") && name.equals("CodeLocation")) {
                this.qRcodeInfo.setCodeLocation(new CodeLocation());
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("UploadResult", "OriginalInfo")) {
                OriginalInfo originalInfo = this.ciUploadResult.getOriginalInfo();
                if (name.equals("Key")) {
                    originalInfo.setKey(this.getText());
                } else if (name.equals("Location")) {
                    originalInfo.setLocation(this.getText());
                } else if (name.equals("ETag")) {
                    originalInfo.setEtag(StringUtils.removeQuotes(this.getText()));
                }
            } else if (this.in("UploadResult", "OriginalInfo", "ImageInfo")) {
                ImageInfo imageInfo = this.ciUploadResult.getOriginalInfo().getImageInfo();
                if (name.equals("Format")) {
                    imageInfo.setFormat(this.getText());
                } else if (name.equals("Width")) {
                    imageInfo.setWidth(Integer.parseInt(this.getText()));
                } else if (name.equals("Height")) {
                    imageInfo.setHeight(Integer.parseInt(this.getText()));
                } else if (name.equals("Quality")) {
                    imageInfo.setQuality(Integer.parseInt(this.getText()));
                } else if (name.equals("Ave")) {
                    imageInfo.setAve(this.getText());
                } else if (name.equals("Orientation")) {
                    imageInfo.setOrientation(Integer.parseInt(this.getText()));
                }
            } else if (this.in("UploadResult", "ProcessResults")) {
                if (name.equals("Object")) {
                    if (this.ciUploadResult.getProcessResults().getObjectList() == null) {
                        this.ciUploadResult.getProcessResults().setObjectList(new LinkedList<CIObject>());
                    }
                    this.ciUploadResult.getProcessResults().getObjectList().add(this.ciObject);
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object")) {
                if (name.equals("Key")) {
                    this.ciObject.setKey(this.getText());
                } else if (name.equals("Location")) {
                    this.ciObject.setLocation(this.getText());
                } else if (name.equals("Format")) {
                    this.ciObject.setFormat(this.getText());
                } else if (name.equals("Width")) {
                    this.ciObject.setWidth(Integer.parseInt(this.getText()));
                } else if (name.equals("Height")) {
                    this.ciObject.setHeight(Integer.parseInt(this.getText()));
                } else if (name.equals("Size")) {
                    this.ciObject.setSize(Integer.parseInt(this.getText()));
                } else if (name.equals("Quality")) {
                    this.ciObject.setQuality(Integer.parseInt(this.getText()));
                } else if (name.equals("ETag")) {
                    this.ciObject.setEtag(StringUtils.removeQuotes(this.getText()));
                } else if (name.equals("CodeStatus")) {
                    this.ciObject.setCodeStatus(Integer.parseInt(this.getText()));
                } else if (name.equals("QRcodeInfo")) {
                    if (this.ciObject.getQRcodeInfoList() == null) {
                        this.ciObject.setQRcodeInfoList(new LinkedList<QRcodeInfo>());
                    }
                    this.ciObject.getQRcodeInfoList().add(this.qRcodeInfo);
                } else if (name.equals("WatermarkStatus")) {
                    this.ciObject.setWatermarkStatus(Integer.parseInt(this.getText()));
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object", "QRcodeInfo")) {
                if (name.equals("CodeUrl")) {
                    this.qRcodeInfo.setCodeUrl(this.getText());
                }
            } else if (this.in("UploadResult", "ProcessResults", "Object", "QRcodeInfo", "CodeLocation")) {
                CodeLocation codeLocation = this.qRcodeInfo.getCodeLocation();
                if (codeLocation.getPoints() == null) {
                    codeLocation.setPoints(new LinkedList<String>());
                }
                if (name.equals("Point")) {
                    codeLocation.getPoints().add(this.getText());
                }
            }
        }
    }

    public static class ListAllMyBucketsHandler
    extends AbstractHandler {
        private final List<Bucket> buckets = new ArrayList<Bucket>();
        private Owner bucketsOwner = null;
        private Bucket currentBucket = null;

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListAllMyBucketsResult")) {
                if (name.equals("Owner")) {
                    this.bucketsOwner = new Owner();
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets") && name.equals("Bucket")) {
                this.currentBucket = new Bucket();
                this.currentBucket.setOwner(this.bucketsOwner);
            }
        }

        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.in("ListAllMyBucketsResult", "Owner")) {
                if (name.equals("ID")) {
                    this.bucketsOwner.setId(this.getText());
                } else if (name.equals("DisplayName")) {
                    this.bucketsOwner.setDisplayName(this.getText());
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets")) {
                if (name.equals("Bucket")) {
                    this.buckets.add(this.currentBucket);
                    this.currentBucket = null;
                }
            } else if (this.in("ListAllMyBucketsResult", "Buckets", "Bucket")) {
                if (name.equals("Name")) {
                    this.currentBucket.setName(this.getText());
                } else if (name.equals("CreationDate")) {
                    Date creationDate = DateUtils.parseISO8601Date(this.getText());
                    this.currentBucket.setCreationDate(creationDate);
                } else if (name.equals("CreateDate")) {
                    Date creationDate = DateUtils.parseISO8601Date(this.getText());
                    this.currentBucket.setCreationDate(creationDate);
                } else if (name.equals("Location")) {
                    this.currentBucket.setLocation(this.getText());
                } else if (name.equals("BucketType")) {
                    this.currentBucket.setBucketType(this.getText());
                } else if (name.equals("Type")) {
                    this.currentBucket.setType(this.getText());
                }
            }
        }
    }

    public static class ListBucketHandler
    extends AbstractHandler {
        private final ObjectListing objectListing = new ObjectListing();
        private final boolean shouldSDKDecodeResponse;
        private COSObjectSummary currentObject = null;
        private Owner currentOwner = null;
        private String lastKey = null;

        public ListBucketHandler(boolean shouldSDKDecodeResponse) {
            this.shouldSDKDecodeResponse = shouldSDKDecodeResponse;
        }

        public ObjectListing getObjectListing() {
            return this.objectListing;
        }

        @Override
        protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
            if (this.in("ListBucketResult")) {
                if (name.equals("Contents")) {
                    this.currentObject = new COSObjectSummary();
                    this.currentObject.setBucketName(this.objectListing.getBucketName());
                }
            } else if (this.in("ListBucketResult", "Contents") && name.equals("Owner")) {
                this.currentOwner = new Owner();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void doEndElement(String uri, String name, String qName) {
            if (this.atTopLevel()) {
                if (!name.equals("ListBucketResult") || !this.objectListing.isTruncated() || this.objectListing.getNextMarker() != null) return;
                String nextMarker = null;
                if (!this.objectListing.getObjectSummaries().isEmpty()) {
                    nextMarker = this.objectListing.getObjectSummaries().get(this.objectListing.getObjectSummaries().size() - 1).getKey();
                } else if (!this.objectListing.getCommonPrefixes().isEmpty()) {
                    nextMarker = this.objectListing.getCommonPrefixes().get(this.objectListing.getCommonPrefixes().size() - 1);
                } else {
                    log.error("COS response indicates truncated results, but contains no object summaries or common prefixes.");
                }
                this.objectListing.setNextMarker(nextMarker);
                return;
            } else if (this.in("ListBucketResult")) {
                if (name.equals("Name")) {
                    this.objectListing.setBucketName(this.getText());
                    if (!log.isDebugEnabled()) return;
                    log.debug("Examining listing for bucket: " + this.objectListing.getBucketName());
                    return;
                } else if (name.equals("Prefix")) {
                    this.objectListing.setPrefix(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                    return;
                } else if (name.equals("Marker")) {
                    this.objectListing.setMarker(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                    return;
                } else if (name.equals("NextMarker")) {
                    this.objectListing.setNextMarker(XmlResponsesSaxParser.decodeIfSpecified(this.getText(), this.shouldSDKDecodeResponse));
                    return;
                } else if (name.equals("MaxKeys")) {
                    this.objectListing.setMaxKeys(XmlResponsesSaxParser.parseInt(this.getText()));
                    return;
                } else if (name.equals("Delimiter")) {
                    this.objectListing.setDelimiter(XmlResponsesSaxParser.decodeIfSpecified(XmlResponsesSaxParser.checkForEmptyString(this.getText()), this.shouldSDKDecodeResponse));
                    return;
                } else if (name.equals("EncodingType")) {
                    this.objectListing.setEncodingType(this.shouldSDKDecodeResponse ? null : XmlResponsesSaxParser.checkForEmptyString(this.getText()));
                    return;
                } else if (name.equals("IsTruncated")) {
                    String isTruncatedStr = this.getText();
                    if (isTruncatedStr.startsWith("false")) {
                        this.objectListing.setTruncated(false);
                        return;
                    } else {
                        if (!isTruncatedStr.startsWith("true")) throw new IllegalStateException("Invalid value for IsTruncated field: " + isTruncatedStr);
                        this.objectListing.setTruncated(true);
                    }
                    return;
                } else {
                    if (!name.equals("Contents")) return;
                    this.objectListing.getObjectSummaries().add(this.currentObject);
                    this.currentObject = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents")) {
                if (name.equals("Key")) {
                    this.lastKey = this.getText();
                    this.currentObject.setKey(XmlResponsesSaxParser.decodeIfSpecified(this.lastKey, this.shouldSDKDecodeResponse));
                    return;
                } else if (name.equals("LastModified")) {
                    this.currentObject.setLastModified(DateUtils.parseISO8601Date(this.getText()));
                    return;
                } else if (name.equals("ETag")) {
                    this.currentObject.setETag(StringUtils.removeQuotes(this.getText()));
                    return;
                } else if (name.equals("Size")) {
                    this.currentObject.setSize(XmlResponsesSaxParser.parseLong(this.getText()));
                    return;
                } else if (name.equals("StorageClass")) {
                    this.currentObject.setStorageClass(this.getText());
                    return;
                } else {
                    if (!name.equals("Owner")) return;
                    this.currentObject.setOwner(this.currentOwner);
                    this.currentOwner = null;
                }
                return;
            } else if (this.in("ListBucketResult", "Contents", "Owner")) {
                if (name.equals("ID")) {
                    this.currentOwner.setId(this.getText());
                    return;
                } else {
                    if (!name.equals("DisplayName")) return;
                    this.currentOwner.setDisplayName(this.getText());
                }
                return;
            } else {
                if (!this.in("ListBucketResult", "CommonPrefixes") || !name.equals("Prefix")) return;
                this.objectListing.getCommonPrefixes().add(XmlResponsesSaxParser.decodeIfSpecified(this.getText(), this.shouldSDKDecodeResponse));
            }
        }
    }
}

