/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.region.Region;
import java.util.ArrayList;
import java.util.List;

public class DelFileDemo {
    private static String secretId = "AKIDXXXXXXXX";
    private static String secretKey = "1A2Z3YYYYYYYYYY";
    private static String bucketName = "examplebucket-12500000000";
    private static String region = "ap-guangzhou";
    private static COSClient cosClient = DelFileDemo.createCli();

    public static void main(String[] args) {
        DelFileDemo.delSingleFile();
        if (cosClient != null) {
            cosClient.shutdown();
        }
    }

    private static COSClient createCli() {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        COSClient cosclient = new COSClient(cred, clientConfig);
        return cosclient;
    }

    private static void delSingleFile() {
        try {
            String key = "aaa/bbb.txt";
            cosClient.deleteObject(bucketName, key);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    private static void batchDelFile() {
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
        ArrayList<DeleteObjectsRequest.KeyVersion> keyList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        keyList.add(new DeleteObjectsRequest.KeyVersion("aaa.txt"));
        keyList.add(new DeleteObjectsRequest.KeyVersion("bbb.mp4"));
        keyList.add(new DeleteObjectsRequest.KeyVersion("ccc/ddd.jpg"));
        deleteObjectsRequest.setKeys(keyList);
        try {
            DeleteObjectsResult deleteObjectsResult = cosClient.deleteObjects(deleteObjectsRequest);
            List<DeleteObjectsResult.DeletedObject> list = deleteObjectsResult.getDeletedObjects();
        }
        catch (MultiObjectDeleteException mde) {
            List<DeleteObjectsResult.DeletedObject> deleteObjects = mde.getDeletedObjects();
            List<MultiObjectDeleteException.DeleteError> list = mde.getErrors();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }

    private static void batchDelFileWithVersion() {
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(bucketName);
        ArrayList<DeleteObjectsRequest.KeyVersion> keyList = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        keyList.add(new DeleteObjectsRequest.KeyVersion("aaa.txt", "axbefagagaxxfafa"));
        keyList.add(new DeleteObjectsRequest.KeyVersion("bbb.mp4", "awcafa1faxg0lx"));
        keyList.add(new DeleteObjectsRequest.KeyVersion("ccc/ddd.jpg", "kafa1kxxaa2ymh"));
        deleteObjectsRequest.setKeys(keyList);
        try {
            DeleteObjectsResult deleteObjectsResult = cosClient.deleteObjects(deleteObjectsRequest);
            List<DeleteObjectsResult.DeletedObject> list = deleteObjectsResult.getDeletedObjects();
        }
        catch (MultiObjectDeleteException mde) {
            List<DeleteObjectsResult.DeletedObject> deleteObjects = mde.getDeletedObjects();
            List<MultiObjectDeleteException.DeleteError> list = mde.getErrors();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
    }
}

