/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.common.MediaVod;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.v2.GetPlayListRequest;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.utils.Jackson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class GeneratePlayListDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        GeneratePlayListDemo.getPlayList(client);
    }

    public static void generatePlayList(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setTag("GeneratePlayList");
        MediaVod vod = request.getInput().getVod();
        vod.setFileId("1397757888244478755");
        vod.setSubAppId("1251704708");
        MediaContainerObject container = request.getOperation().getTranscode().getContainer();
        container.setFormat("hls");
        container.getClipConfig().setDuration("5");
        MediaTransConfigObject transConfig = request.getOperation().getTranscode().getTransConfig();
        transConfig.setCosTag("DemoTag=demo1&DemoTag2=demo2");
        transConfig.getHlsEncrypt().setIsHlsEncrypt("true");
        MediaTranscodeVideoObject video = request.getOperation().getTranscode().getVideo();
        video.setCodec("H.264");
        video.setWidth("1280");
        video.setHeight("960");
        request.getOperation().getOutput().setBucket("demo-1234567890");
        request.getOperation().getOutput().setRegion("ap-beijing");
        request.getOperation().getOutput().setObject("output/media/test.m3u8");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setJobId("j8b360cd0142511efac6425779c0*****");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(Jackson.toJsonString(response));
    }

    public static void getPlayList(COSClient client) {
        GetPlayListRequest request = new GetPlayListRequest();
        request.setBucketName("demo-1234567890");
        request.setObject("output/media/test.m3u8");
        request.setExpires("3600");
        try {
            InputStream response = client.getPlayList(request);
            System.out.println(GeneratePlayListDemo.inputStreamToString(response));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        String line;
        if (inputStream == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((line = bufferedReader.readLine()) != null) {
            stringBuilder.append(line);
        }
        bufferedReader.close();
        inputStreamReader.close();
        inputStream.close();
        return stringBuilder.toString();
    }
}

