/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.SetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.lifecycle.LifecycleFilter;
import com.qcloud.cos.model.lifecycle.LifecyclePrefixPredicate;
import com.qcloud.cos.region.Region;
import java.util.ArrayList;
import java.util.List;

public class BucketLifecycleDemo {
    private static String secretId = "AKIDXXXXXXXX";
    private static String secretKey = "1A2Z3YYYYYYYYYY";
    private static String cosRegion = "ap-guangzhou";
    private static String bucketName = "example-12500000000";
    private static COSClient cosClient = BucketLifecycleDemo.COSBuilder();

    public static void main(String[] args) throws InterruptedException {
        BucketLifecycleDemo.deletedAllLifeCycle();
        BucketLifecycleDemo.addLifeCycle("warehouse-ods-apx", "warehouse/ods/apx/");
        BucketLifecycleDemo.addLifeCycle("warehouse-ods-apx2", "warehouse/ods/apx2/");
        BucketLifecycleDemo.queryPath();
        cosClient.shutdown();
    }

    private static COSClient COSBuilder() {
        BasicCOSCredentials cred = new BasicCOSCredentials(secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(cosRegion));
        return new COSClient(cred, clientConfig);
    }

    private static void addLifeCycle(String id, String path) {
        ArrayList<BucketLifecycleConfiguration.Rule> rules = new ArrayList<BucketLifecycleConfiguration.Rule>();
        BucketLifecycleConfiguration.Rule deletePrefixRule = new BucketLifecycleConfiguration.Rule();
        deletePrefixRule.setId(id);
        deletePrefixRule.setFilter(new LifecycleFilter(new LifecyclePrefixPredicate(path)));
        deletePrefixRule.setExpirationInDays(7);
        deletePrefixRule.setStatus("Enabled");
        BucketLifecycleConfiguration.Rule standardIaRule = new BucketLifecycleConfiguration.Rule();
        standardIaRule.setId(id + System.currentTimeMillis());
        standardIaRule.setFilter(new LifecycleFilter(new LifecyclePrefixPredicate(path)));
        ArrayList<BucketLifecycleConfiguration.Transition> standardIaTransitions = new ArrayList<BucketLifecycleConfiguration.Transition>();
        BucketLifecycleConfiguration.Transition standardTransition = new BucketLifecycleConfiguration.Transition();
        standardTransition.setDays(20);
        standardTransition.setStorageClass(StorageClass.Standard_IA.toString());
        standardIaTransitions.add(standardTransition);
        standardIaRule.setTransitions(standardIaTransitions);
        standardIaRule.setStatus("Enabled");
        standardIaRule.setExpirationInDays(30);
        rules.add(deletePrefixRule);
        BucketLifecycleConfiguration bucketLifecycleConfiguration = new BucketLifecycleConfiguration();
        bucketLifecycleConfiguration.setRules(rules);
        SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest = new SetBucketLifecycleConfigurationRequest(bucketName, bucketLifecycleConfiguration);
        cosClient.setBucketLifecycleConfiguration(setBucketLifecycleConfigurationRequest);
    }

    private static void queryPath() {
        BucketLifecycleConfiguration queryLifeCycleRet = cosClient.getBucketLifecycleConfiguration(bucketName);
        if (queryLifeCycleRet == null) {
            return;
        }
        List<BucketLifecycleConfiguration.Rule> ruleLists = queryLifeCycleRet.getRules();
        for (BucketLifecycleConfiguration.Rule next : ruleLists) {
            System.out.println("path:" + next.getId());
        }
    }

    private static void deletedAllLifeCycle() {
        cosClient.deleteBucketLifecycleConfiguration(bucketName);
        System.out.println("finish delete all LifeCycle");
    }
}

