/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.qcloud.cos.COS;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.auth.COSSessionCredentials;
import com.qcloud.cos.auth.COSSigner;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.endpoint.CIPicRegionEndpointBuilder;
import com.qcloud.cos.endpoint.CIRegionEndpointBuilder;
import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.endpoint.RegionEndpointBuilder;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.MultiObjectDeleteException;
import com.qcloud.cos.exception.Throwables;
import com.qcloud.cos.http.CosHttpClient;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.DefaultCosHttpClient;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.internal.BucketNameUtils;
import com.qcloud.cos.internal.CIGetResponseHandler;
import com.qcloud.cos.internal.CIGetSnapshotResponseHandler;
import com.qcloud.cos.internal.CIPicServiceRequest;
import com.qcloud.cos.internal.CIServiceRequest;
import com.qcloud.cos.internal.CIWorkflowServiceRequest;
import com.qcloud.cos.internal.COSDefaultAclHeaderHandler;
import com.qcloud.cos.internal.COSObjectResponseHandler;
import com.qcloud.cos.internal.COSStringResponseHandler;
import com.qcloud.cos.internal.COSVersionHeaderHandler;
import com.qcloud.cos.internal.COSXmlResponseHandler;
import com.qcloud.cos.internal.CosMetadataResponseHandler;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.DeleteObjectTaggingHeaderHandler;
import com.qcloud.cos.internal.DeleteObjectsResponse;
import com.qcloud.cos.internal.DigestValidationInputStream;
import com.qcloud.cos.internal.GetObjectTaggingResponseHeaderHandler;
import com.qcloud.cos.internal.HeaderHandler;
import com.qcloud.cos.internal.InputSubstream;
import com.qcloud.cos.internal.LengthCheckInputStream;
import com.qcloud.cos.internal.MD5DigestCalculatingInputStream;
import com.qcloud.cos.internal.MultiObjectDeleteXmlFactory;
import com.qcloud.cos.internal.ObjectExpirationHeaderHandler;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.RequestXmlFactory;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.ResponseHeaderHandlerChain;
import com.qcloud.cos.internal.ServerSideEncryptionHeaderHandler;
import com.qcloud.cos.internal.ServiceClientHolderInputStream;
import com.qcloud.cos.internal.SetObjectTaggingResponseHeaderHandler;
import com.qcloud.cos.internal.SkipMd5CheckStrategy;
import com.qcloud.cos.internal.Unmarshaller;
import com.qcloud.cos.internal.Unmarshallers;
import com.qcloud.cos.internal.VIDResultHandler;
import com.qcloud.cos.internal.VoidCosResponseHandler;
import com.qcloud.cos.internal.XmlResponsesSaxParser;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.AclXmlFactory;
import com.qcloud.cos.model.AppendObjectRequest;
import com.qcloud.cos.model.AppendObjectResult;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.model.BucketConfigurationXmlFactory;
import com.qcloud.cos.model.BucketCrossOriginConfiguration;
import com.qcloud.cos.model.BucketDomainConfiguration;
import com.qcloud.cos.model.BucketEncryptionConfiguration;
import com.qcloud.cos.model.BucketGetMetadataResult;
import com.qcloud.cos.model.BucketIntelligentTierConfiguration;
import com.qcloud.cos.model.BucketLifecycleConfiguration;
import com.qcloud.cos.model.BucketLoggingConfiguration;
import com.qcloud.cos.model.BucketObjectLockConfiguration;
import com.qcloud.cos.model.BucketPolicy;
import com.qcloud.cos.model.BucketRefererConfiguration;
import com.qcloud.cos.model.BucketReplicationConfiguration;
import com.qcloud.cos.model.BucketTaggingConfiguration;
import com.qcloud.cos.model.BucketVersioningConfiguration;
import com.qcloud.cos.model.BucketWebsiteConfiguration;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.CosDataSource;
import com.qcloud.cos.model.CreateBucketRequest;
import com.qcloud.cos.model.DecompressionRequest;
import com.qcloud.cos.model.DecompressionResult;
import com.qcloud.cos.model.DeleteBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketDomainConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketInventoryConfigurationResult;
import com.qcloud.cos.model.DeleteBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketPolicyRequest;
import com.qcloud.cos.model.DeleteBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketRequest;
import com.qcloud.cos.model.DeleteBucketTaggingConfigurationRequest;
import com.qcloud.cos.model.DeleteBucketWebsiteConfigurationRequest;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.DeleteObjectTaggingRequest;
import com.qcloud.cos.model.DeleteObjectTaggingResult;
import com.qcloud.cos.model.DeleteObjectsRequest;
import com.qcloud.cos.model.DeleteObjectsResult;
import com.qcloud.cos.model.DeleteVersionRequest;
import com.qcloud.cos.model.GeneratePresignedUrlRequest;
import com.qcloud.cos.model.GenericBucketRequest;
import com.qcloud.cos.model.GetBucketAclRequest;
import com.qcloud.cos.model.GetBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.GetBucketDomainConfigurationRequest;
import com.qcloud.cos.model.GetBucketIntelligentTierConfigurationRequest;
import com.qcloud.cos.model.GetBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.GetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.GetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.GetBucketLocationRequest;
import com.qcloud.cos.model.GetBucketLoggingConfigurationRequest;
import com.qcloud.cos.model.GetBucketPolicyRequest;
import com.qcloud.cos.model.GetBucketRefererConfigurationRequest;
import com.qcloud.cos.model.GetBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.GetBucketTaggingConfigurationRequest;
import com.qcloud.cos.model.GetBucketVersioningConfigurationRequest;
import com.qcloud.cos.model.GetBucketWebsiteConfigurationRequest;
import com.qcloud.cos.model.GetObjectAclRequest;
import com.qcloud.cos.model.GetObjectMetadataRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.GetObjectTaggingRequest;
import com.qcloud.cos.model.GetObjectTaggingResult;
import com.qcloud.cos.model.GetSymlinkRequest;
import com.qcloud.cos.model.GetSymlinkResult;
import com.qcloud.cos.model.GetSymlinkResultHandler;
import com.qcloud.cos.model.Grant;
import com.qcloud.cos.model.Grantee;
import com.qcloud.cos.model.HeadBucketRequest;
import com.qcloud.cos.model.HeadBucketResult;
import com.qcloud.cos.model.HeadBucketResultHandler;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.IntelligentTiering.BucketIntelligentTieringConfiguration;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsRequest;
import com.qcloud.cos.model.ListBucketInventoryConfigurationsResult;
import com.qcloud.cos.model.ListBucketsRequest;
import com.qcloud.cos.model.ListBucketsResult;
import com.qcloud.cos.model.ListJobsResult;
import com.qcloud.cos.model.ListMultipartUploadsRequest;
import com.qcloud.cos.model.ListNextBatchOfObjectsRequest;
import com.qcloud.cos.model.ListNextBatchOfVersionsRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.ListVersionsRequest;
import com.qcloud.cos.model.MultipartUploadListing;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.Permission;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.PutSymlinkRequest;
import com.qcloud.cos.model.PutSymlinkResult;
import com.qcloud.cos.model.PutSymlinkResultHandler;
import com.qcloud.cos.model.RenameRequest;
import com.qcloud.cos.model.ResponseHeaderOverrides;
import com.qcloud.cos.model.RestoreObjectRequest;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.SelectObjectContentEventStream;
import com.qcloud.cos.model.SelectObjectContentRequest;
import com.qcloud.cos.model.SelectObjectContentResult;
import com.qcloud.cos.model.SetBucketAclRequest;
import com.qcloud.cos.model.SetBucketCrossOriginConfigurationRequest;
import com.qcloud.cos.model.SetBucketDomainConfigurationRequest;
import com.qcloud.cos.model.SetBucketIntelligentTierConfigurationRequest;
import com.qcloud.cos.model.SetBucketInventoryConfigurationRequest;
import com.qcloud.cos.model.SetBucketInventoryConfigurationResult;
import com.qcloud.cos.model.SetBucketLifecycleConfigurationRequest;
import com.qcloud.cos.model.SetBucketLoggingConfigurationRequest;
import com.qcloud.cos.model.SetBucketPolicyRequest;
import com.qcloud.cos.model.SetBucketRefererConfigurationRequest;
import com.qcloud.cos.model.SetBucketReplicationConfigurationRequest;
import com.qcloud.cos.model.SetBucketTaggingConfigurationRequest;
import com.qcloud.cos.model.SetBucketVersioningConfigurationRequest;
import com.qcloud.cos.model.SetBucketWebsiteConfigurationRequest;
import com.qcloud.cos.model.SetObjectAclRequest;
import com.qcloud.cos.model.SetObjectTaggingRequest;
import com.qcloud.cos.model.SetObjectTaggingResult;
import com.qcloud.cos.model.UploadMode;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.model.VersionListing;
import com.qcloud.cos.model.bucketcertificate.BucketDomainCertificateRequest;
import com.qcloud.cos.model.bucketcertificate.BucketGetDomainCertificate;
import com.qcloud.cos.model.bucketcertificate.BucketPutDomainCertificate;
import com.qcloud.cos.model.bucketcertificate.SetBucketDomainCertificateRequest;
import com.qcloud.cos.model.ciModel.ai.AddPersonFaceRequest;
import com.qcloud.cos.model.ciModel.ai.AddPersonFaceResponse;
import com.qcloud.cos.model.ciModel.ai.CreatePersonRequest;
import com.qcloud.cos.model.ciModel.ai.CreatePersonResponse;
import com.qcloud.cos.model.ciModel.ai.DeletePersonFaceRequest;
import com.qcloud.cos.model.ciModel.ai.FaceSearchBucketRequest;
import com.qcloud.cos.model.ciModel.ai.GoodsMattingRequest;
import com.qcloud.cos.model.ciModel.ai.GoodsMattingResponse;
import com.qcloud.cos.model.ciModel.ai.ImageOCRRequest;
import com.qcloud.cos.model.ciModel.ai.ImageOCRResponse;
import com.qcloud.cos.model.ciModel.ai.RecognizeLogoRequest;
import com.qcloud.cos.model.ciModel.ai.RecognizeLogoResponse;
import com.qcloud.cos.model.ciModel.ai.SearchPersonFaceRequest;
import com.qcloud.cos.model.ciModel.ai.SearchPersonFaceResponse;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.AuditingKeywordRequest;
import com.qcloud.cos.model.ciModel.auditing.AuditingKeywordResponse;
import com.qcloud.cos.model.ciModel.auditing.AuditingStrategyListResponse;
import com.qcloud.cos.model.ciModel.auditing.AuditingStrategyRequest;
import com.qcloud.cos.model.ciModel.auditing.AuditingStrategyResponse;
import com.qcloud.cos.model.ciModel.auditing.AuditingTextLibRequest;
import com.qcloud.cos.model.ciModel.auditing.AuditingTextLibResponse;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.DescribeImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.ReportBadCaseRequest;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingResponse;
import com.qcloud.cos.model.ciModel.bucket.DocBucketRequest;
import com.qcloud.cos.model.ciModel.bucket.DocBucketResponse;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketRequest;
import com.qcloud.cos.model.ciModel.bucket.MediaBucketResponse;
import com.qcloud.cos.model.ciModel.common.CImageProcessRequest;
import com.qcloud.cos.model.ciModel.common.ImageProcessRequest;
import com.qcloud.cos.model.ciModel.hls.CreateHLSPlayKeyRequest;
import com.qcloud.cos.model.ciModel.hls.CreateHLSPlayKeyResponse;
import com.qcloud.cos.model.ciModel.hls.GetHLSPlayKeyRequest;
import com.qcloud.cos.model.ciModel.hls.GetHLSPlayKeyResponse;
import com.qcloud.cos.model.ciModel.hls.UpdataHLSPlayKeyRequest;
import com.qcloud.cos.model.ciModel.hls.UpdataHLSPlayKeyResponse;
import com.qcloud.cos.model.ciModel.image.AIImageColoringRequest;
import com.qcloud.cos.model.ciModel.image.AutoTranslationBlockRequest;
import com.qcloud.cos.model.ciModel.image.AutoTranslationBlockResponse;
import com.qcloud.cos.model.ciModel.image.DetectFaceRequest;
import com.qcloud.cos.model.ciModel.image.DetectFaceResponse;
import com.qcloud.cos.model.ciModel.image.GenerateQrcodeRequest;
import com.qcloud.cos.model.ciModel.image.ImageInspectRequest;
import com.qcloud.cos.model.ciModel.image.ImageInspectResponse;
import com.qcloud.cos.model.ciModel.image.ImageLabelRequest;
import com.qcloud.cos.model.ciModel.image.ImageLabelResponse;
import com.qcloud.cos.model.ciModel.image.ImageLabelV2Request;
import com.qcloud.cos.model.ciModel.image.ImageLabelV2Response;
import com.qcloud.cos.model.ciModel.image.ImageSearchRequest;
import com.qcloud.cos.model.ciModel.image.ImageSearchResponse;
import com.qcloud.cos.model.ciModel.image.ImageStyleRequest;
import com.qcloud.cos.model.ciModel.image.ImageStyleResponse;
import com.qcloud.cos.model.ciModel.image.OpenImageSearchRequest;
import com.qcloud.cos.model.ciModel.job.BatchJobRequest;
import com.qcloud.cos.model.ciModel.job.BatchJobResponse;
import com.qcloud.cos.model.ciModel.job.DocHtmlRequest;
import com.qcloud.cos.model.ciModel.job.DocJobListRequest;
import com.qcloud.cos.model.ciModel.job.DocJobListResponse;
import com.qcloud.cos.model.ciModel.job.DocJobRequest;
import com.qcloud.cos.model.ciModel.job.DocJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessJobResponse;
import com.qcloud.cos.model.ciModel.job.FileProcessRequest;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.PostSpeechRecognitionRequest;
import com.qcloud.cos.model.ciModel.job.PostSpeechRecognitionResponse;
import com.qcloud.cos.model.ciModel.job.ZipPreviewRequest;
import com.qcloud.cos.model.ciModel.job.ZipPreviewResponse;
import com.qcloud.cos.model.ciModel.job.v2.DNADbConfigsRequest;
import com.qcloud.cos.model.ciModel.job.v2.DNADbConfigsResponse;
import com.qcloud.cos.model.ciModel.job.v2.DNADbFilesRequest;
import com.qcloud.cos.model.ciModel.job.v2.DNADbFilesResponse;
import com.qcloud.cos.model.ciModel.job.v2.GetPlayListRequest;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaTemplateRequestV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaTemplateResponseV2;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoRequest;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoResponse;
import com.qcloud.cos.model.ciModel.metaInsight.CreateDatasetBindingRequest;
import com.qcloud.cos.model.ciModel.metaInsight.CreateDatasetBindingResponse;
import com.qcloud.cos.model.ciModel.metaInsight.CreateDatasetRequest;
import com.qcloud.cos.model.ciModel.metaInsight.CreateDatasetResponse;
import com.qcloud.cos.model.ciModel.metaInsight.CreateFileMetaIndexRequest;
import com.qcloud.cos.model.ciModel.metaInsight.CreateFileMetaIndexResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DatasetFaceSearchRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DatasetFaceSearchResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DatasetSimpleQueryRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DatasetSimpleQueryResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DeleteDatasetBindingRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DeleteDatasetBindingResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DeleteDatasetRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DeleteDatasetResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DeleteFileMetaIndexRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DeleteFileMetaIndexResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetBindingRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetBindingResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetBindingsRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetBindingsResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetsRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeDatasetsResponse;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeFileMetaIndexRequest;
import com.qcloud.cos.model.ciModel.metaInsight.DescribeFileMetaIndexResponse;
import com.qcloud.cos.model.ciModel.metaInsight.SearchImageRequest;
import com.qcloud.cos.model.ciModel.metaInsight.SearchImageResponse;
import com.qcloud.cos.model.ciModel.metaInsight.UpdateDatasetRequest;
import com.qcloud.cos.model.ciModel.metaInsight.UpdateDatasetResponse;
import com.qcloud.cos.model.ciModel.metaInsight.UpdateFileMetaIndexRequest;
import com.qcloud.cos.model.ciModel.metaInsight.UpdateFileMetaIndexResponse;
import com.qcloud.cos.model.ciModel.persistence.AIGameRecResponse;
import com.qcloud.cos.model.ciModel.persistence.AIRecRequest;
import com.qcloud.cos.model.ciModel.persistence.CIUploadResult;
import com.qcloud.cos.model.ciModel.persistence.DetectCarResponse;
import com.qcloud.cos.model.ciModel.queue.DocListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.DocQueueRequest;
import com.qcloud.cos.model.ciModel.queue.MediaListQueueResponse;
import com.qcloud.cos.model.ciModel.queue.MediaQueueRequest;
import com.qcloud.cos.model.ciModel.queue.MediaQueueResponse;
import com.qcloud.cos.model.ciModel.snapshot.CosSnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.PrivateM3U8Request;
import com.qcloud.cos.model.ciModel.snapshot.PrivateM3U8Response;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotRequest;
import com.qcloud.cos.model.ciModel.snapshot.SnapshotResponse;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaTemplateResponse;
import com.qcloud.cos.model.ciModel.utils.CICheckUtils;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowExecutionsResponse;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowListRequest;
import com.qcloud.cos.model.ciModel.workflow.MediaWorkflowListResponse;
import com.qcloud.cos.model.ciModel.xml.CIAuditingXmlFactory;
import com.qcloud.cos.model.ciModel.xml.CIAuditingXmlFactoryV2;
import com.qcloud.cos.model.ciModel.xml.CIMediaXmlFactory;
import com.qcloud.cos.model.ciModel.xml.CImageXmlFactory;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskRequest;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskResult;
import com.qcloud.cos.model.fetch.GetAsyncFetchTaskResultHandler;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskRequest;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskResult;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskResultHandler;
import com.qcloud.cos.model.fetch.PutAsyncFetchTaskSerializer;
import com.qcloud.cos.model.inventory.InventoryConfiguration;
import com.qcloud.cos.model.transform.ObjectTaggingXmlFactory;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.retry.RetryUtils;
import com.qcloud.cos.utils.Base64;
import com.qcloud.cos.utils.BinaryUtils;
import com.qcloud.cos.utils.CIJackson;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.Jackson;
import com.qcloud.cos.utils.Md5Utils;
import com.qcloud.cos.utils.ServiceUtils;
import com.qcloud.cos.utils.StringUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.DecoderException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSClient
implements COS {
    private static final Logger log = LoggerFactory.getLogger(COSClient.class);
    private final SkipMd5CheckStrategy skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
    private final VoidCosResponseHandler voidCosResponseHandler = new VoidCosResponseHandler();
    private volatile COSCredentialsProvider credProvider;
    protected ClientConfig clientConfig;
    private CosHttpClient cosHttpClient;
    private ConcurrentHashMap<String, Long> preflightBuckets = new ConcurrentHashMap();

    public COSClient(COSCredentials cred, ClientConfig clientConfig) {
        this(new COSStaticCredentialsProvider(cred), clientConfig);
    }

    public COSClient(COSCredentialsProvider credProvider, ClientConfig clientConfig) {
        this.credProvider = credProvider;
        this.clientConfig = clientConfig;
        this.cosHttpClient = new DefaultCosHttpClient(clientConfig);
    }

    public void shutdown() {
        this.cosHttpClient.shutdown();
    }

    public void setCOSCredentials(COSCredentials cred) {
        this.rejectNull(cred, "cred must not be null");
        this.credProvider = new COSStaticCredentialsProvider(cred);
    }

    public void setCOSCredentialsProvider(COSCredentialsProvider credProvider) {
        this.rejectNull(credProvider, "credProvider must not be null");
        this.credProvider = credProvider;
    }

    @Override
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    private COSCredentials fetchCredential() throws CosClientException {
        if (this.credProvider == null) {
            throw new CosClientException("credentials Provider is null, you must set legal Credentials info when init cosClient.");
        }
        COSCredentials cred = this.credProvider.getCredentials();
        if (cred == null) {
            throw new CosClientException("credentials from Provider is null. please check your credentials provider");
        }
        return cred;
    }

    private void rejectNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void rejectEmpty(String parameterValue, String errorMessage) {
        if (parameterValue.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void rejectEmpty(Map parameterValue, String errorMessage) {
        if (parameterValue.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private void rejectStartWith(String value, String startStr, String errorMessage) {
        if (value != null && !value.isEmpty() && startStr != null && !value.startsWith(startStr)) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    protected <X extends CosServiceRequest> CosHttpRequest<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod) {
        CosHttpRequest<X> httpRequest = new CosHttpRequest<X>(originalRequest);
        httpRequest.setHttpMethod(httpMethod);
        httpRequest.addHeader("User-Agent", this.clientConfig.getUserAgent());
        if (originalRequest.getCustomRequestHeaders() != null && originalRequest.getCustomRequestHeaders().containsKey("Pic-Operations")) {
            httpRequest.addHeader("Pic-Operations", originalRequest.getCustomRequestHeaders().get("Pic-Operations"));
        }
        if (originalRequest instanceof ListBucketsRequest) {
            this.buildUrlAndHost(httpRequest, bucketName, key, true);
        } else {
            this.rejectNull(this.clientConfig.getRegion(), "region is missing, you must set region when init clientConfig for the api.");
            this.buildUrlAndHost(httpRequest, bucketName, key, false);
        }
        httpRequest.setProgressListener(originalRequest.getGeneralProgressListener());
        httpRequest.setBucketName(bucketName);
        return httpRequest;
    }

    private void addAclHeaders(CosHttpRequest<? extends CosServiceRequest> request, AccessControlList acl) {
        List<Grant> grants = acl.getGrantsAsList();
        HashMap grantsByPermission = new HashMap();
        for (Grant grant : grants) {
            if (!grantsByPermission.containsKey((Object)grant.getPermission())) {
                grantsByPermission.put(grant.getPermission(), new LinkedList());
            }
            ((Collection)grantsByPermission.get((Object)grant.getPermission())).add(grant.getGrantee());
        }
        for (Permission permission : Permission.values()) {
            if (!grantsByPermission.containsKey((Object)permission)) continue;
            Collection grantees = (Collection)grantsByPermission.get((Object)permission);
            boolean seenOne = false;
            StringBuilder granteeString = new StringBuilder();
            for (Grantee grantee : grantees) {
                if (!seenOne) {
                    seenOne = true;
                } else {
                    granteeString.append(", ");
                }
                granteeString.append(grantee.getTypeIdentifier()).append("=").append("\"").append(grantee.getIdentifier()).append("\"");
            }
            request.addHeader(permission.getHeaderName(), granteeString.toString());
        }
    }

    protected static void populateRequestMetadata(CosHttpRequest<?> request, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Date httpExpiresDate;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((httpExpiresDate = metadata.getHttpExpiresDate()) != null) {
            request.addHeader("Expires", DateUtils.formatRFC822Date(httpExpiresDate));
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                request.addHeader("x-cos-meta-" + key, value);
            }
        }
    }

    private void populateRequestWithCopyObjectParameters(CosHttpRequest<? extends CosServiceRequest> request, CopyObjectRequest copyObjectRequest) {
        Region sourceRegion = copyObjectRequest.getSourceBucketRegion();
        EndpointBuilder srcEndpointBuilder = null;
        srcEndpointBuilder = sourceRegion == null ? this.clientConfig.getEndpointBuilder() : new RegionEndpointBuilder(sourceRegion);
        if (copyObjectRequest.getSourceEndpointBuilder() != null) {
            srcEndpointBuilder = copyObjectRequest.getSourceEndpointBuilder();
        }
        String sourceKey = this.formatKey(copyObjectRequest.getSourceKey());
        String sourceBucket = this.formatBucket(copyObjectRequest.getSourceBucketName(), copyObjectRequest.getSourceAppid() != null ? copyObjectRequest.getSourceAppid() : this.fetchCredential().getCOSAppId());
        String copySourceHeader = String.format("%s%s", srcEndpointBuilder.buildGeneralApiEndpoint(sourceBucket), UrlEncoderUtils.encodeEscapeDelimiter(sourceKey));
        if (copyObjectRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-cos-copy-source", copySourceHeader);
        COSClient.addDateHeader(request, "x-cos-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(request, "x-cos-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            this.addAclHeaders(request, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-cos-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-cos-storage-class", copyObjectRequest.getStorageClass());
        }
        if (copyObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-cos-website-redirect-location", copyObjectRequest.getRedirectLocation());
        }
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (copyObjectRequest.getMetadataDirective() != null) {
            request.addHeader("x-cos-metadata-directive", copyObjectRequest.getMetadataDirective());
        } else if (newObjectMetadata != null) {
            request.addHeader("x-cos-metadata-directive", "REPLACE");
        }
        if (newObjectMetadata != null) {
            COSClient.populateRequestMetadata(request, newObjectMetadata);
        }
        COSClient.populateSSE_C(request, copyObjectRequest.getDestinationSSECustomerKey());
        COSClient.populateSourceSSE_C(request, copyObjectRequest.getSourceSSECustomerKey());
        COSClient.populateSSE_KMS(request, copyObjectRequest.getSSECOSKeyManagementParams());
    }

    private void populateRequestWithCopyPartParameters(CosHttpRequest<? extends CosServiceRequest> request, CopyPartRequest copyPartRequest) {
        Region sourceRegion = copyPartRequest.getSourceBucketRegion();
        EndpointBuilder srcEndpointBuilder = null;
        srcEndpointBuilder = sourceRegion == null ? this.clientConfig.getEndpointBuilder() : new RegionEndpointBuilder(sourceRegion);
        if (copyPartRequest.getSourceEndpointBuilder() != null) {
            srcEndpointBuilder = copyPartRequest.getSourceEndpointBuilder();
        }
        String sourceKey = this.formatKey(copyPartRequest.getSourceKey());
        String sourceBucket = this.formatBucket(copyPartRequest.getSourceBucketName(), copyPartRequest.getSourceAppid() != null ? copyPartRequest.getSourceAppid() : this.fetchCredential().getCOSAppId());
        String copySourceHeader = String.format("%s%s", srcEndpointBuilder.buildGeneralApiEndpoint(sourceBucket), UrlEncoderUtils.encodeEscapeDelimiter(sourceKey));
        if (copyPartRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyPartRequest.getSourceVersionId();
        }
        request.addHeader("x-cos-copy-source", copySourceHeader);
        COSClient.addDateHeader(request, "x-cos-copy-source-if-modified-since", copyPartRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(request, "x-cos-copy-source-if-unmodified-since", copyPartRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-match", copyPartRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(request, "x-cos-copy-source-if-none-match", copyPartRequest.getNonmatchingETagConstraints());
        if (copyPartRequest.getFirstByte() != null && copyPartRequest.getLastByte() != null) {
            String range = "bytes=" + copyPartRequest.getFirstByte() + "-" + copyPartRequest.getLastByte();
            request.addHeader("x-cos-copy-source-range", range);
        }
        COSClient.populateSSE_C(request, copyPartRequest.getDestinationSSECustomerKey());
        COSClient.populateSourceSSE_C(request, copyPartRequest.getSourceSSECustomerKey());
    }

    private String formatKey(String key) {
        if (key == null) {
            return "/";
        }
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        return key;
    }

    private String leftStripPathDelimiter(String path) {
        if (path == null) {
            return path;
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    private String formatBucket(String bucketName, String appid) throws CosClientException {
        BucketNameUtils.validateBucketName(bucketName);
        if (appid == null) {
            if (!bucketName.trim().isEmpty()) {
                return bucketName;
            }
            throw new CosClientException("please make sure bucket name must contain legal appid when appid is missing. example: music-1251122334");
        }
        String appidSuffix = "-" + appid;
        if (bucketName.endsWith(appidSuffix)) {
            return bucketName;
        }
        return bucketName + appidSuffix;
    }

    private <X extends CosServiceRequest> void buildUrlAndHost(CosHttpRequest<X> request, String bucket, String key, boolean isServiceRequest) throws CosClientException {
        boolean isCIRequest = request.getOriginalRequest() instanceof CIServiceRequest;
        key = this.formatKey(key);
        request.setResourcePath(key);
        String endpoint = "";
        String endpointAddr = "";
        if (isServiceRequest) {
            endpoint = this.clientConfig.getEndpointBuilder().buildGetServiceApiEndpoint();
            endpointAddr = this.clientConfig.getEndpointResolver().resolveGetServiceApiEndpoint(endpoint);
        } else {
            bucket = this.formatBucket(bucket, this.fetchCredential().getCOSAppId());
            endpoint = request.getOriginalRequest() instanceof CIPicServiceRequest ? new CIPicRegionEndpointBuilder(this.clientConfig.getRegion()).buildGeneralApiEndpoint(bucket) : (isCIRequest ? new CIRegionEndpointBuilder(this.clientConfig.getRegion()).buildGeneralApiEndpoint(bucket) : this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(bucket));
            endpointAddr = this.clientConfig.getEndpointResolver().resolveGeneralApiEndpoint(endpoint);
        }
        if (endpoint == null) {
            throw new CosClientException("endpoint is null, please check your endpoint builder");
        }
        if (endpointAddr == null) {
            throw new CosClientException("endpointAddr is null, please check your endpoint resolver");
        }
        if (this.clientConfig.getIsDistinguishHost()) {
            String host = String.format("%s.%s.myqcloud.com", bucket, Region.formatRegion(this.clientConfig.getRegion()));
            request.addHeader("Host", host);
        } else {
            request.addHeader("Host", endpoint);
        }
        if (isCIRequest && !this.clientConfig.getCiSpecialRequest()) {
            request.setProtocol(HttpProtocol.https);
        } else {
            request.setProtocol(this.clientConfig.getHttpProtocol());
        }
        String fixedEndpointAddr = ((CosServiceRequest)request.getOriginalRequest()).getFixedEndpointAddr();
        if (fixedEndpointAddr != null) {
            request.setEndpoint(fixedEndpointAddr);
        } else {
            request.setEndpoint(endpointAddr);
        }
        request.setResourcePath(key);
    }

    private <X, Y extends CosServiceRequest> X invoke(CosHttpRequest<Y> request, Unmarshaller<X, InputStream> unmarshaller) throws CosClientException, CosServiceException {
        return this.invoke(request, new COSXmlResponseHandler<X>(unmarshaller));
    }

    private <X, Y extends CosServiceRequest> X invoke(CosHttpRequest<Y> request, HttpResponseHandler<CosServiceResponse<X>> responseHandler) throws CosClientException, CosServiceException {
        COSCredentials cosCredentials;
        COSSigner cosSigner = this.clientConfig.getCosSigner();
        Y cosServiceRequest = request.getOriginalRequest();
        if (cosServiceRequest != null && ((CosServiceRequest)cosServiceRequest).getCosCredentials() != null) {
            cosCredentials = ((CosServiceRequest)cosServiceRequest).getCosCredentials();
            request.setCosCredentials(cosCredentials);
        } else {
            cosCredentials = this.fetchCredential();
            request.setCosCredentials(cosCredentials);
        }
        Date expiredTime = new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L);
        boolean isCIWorkflowRequest = cosServiceRequest instanceof CIWorkflowServiceRequest;
        cosSigner.setCIWorkflowRequest(isCIWorkflowRequest);
        cosSigner.sign(request, cosCredentials, expiredTime);
        return this.cosHttpClient.exeute(request, responseHandler);
    }

    private static PutObjectResult createPutObjectResult(ObjectMetadata metadata) {
        PutObjectResult result = new PutObjectResult();
        result.setRequestId((String)metadata.getRawMetadataValue("x-cos-request-id"));
        result.setDateStr((String)metadata.getRawMetadataValue("Date"));
        result.setVersionId(metadata.getVersionId());
        result.setETag(metadata.getETag());
        result.setExpirationTime(metadata.getExpirationTime());
        result.setSSEAlgorithm(metadata.getSSEAlgorithm());
        result.setSSECustomerAlgorithm(metadata.getSSECustomerAlgorithm());
        result.setSSECustomerKeyMd5(metadata.getSSECustomerKeyMd5());
        result.setCrc64Ecma(metadata.getCrc64Ecma());
        result.setMetadata(metadata);
        result.setCiUploadResult(metadata.getCiUploadResult());
        return result;
    }

    private static AppendObjectResult createAppendObjectResult(ObjectMetadata metadata) {
        AppendObjectResult result = new AppendObjectResult();
        result.setNextAppendPosition(Long.valueOf((String)metadata.getRawMetadataValue("x-cos-next-append-position")));
        result.setMetadata(metadata);
        return result;
    }

    private static void addParameterIfNotNull(CosHttpRequest<?> request, String paramName, String paramValue) {
        if (paramValue != null) {
            request.addParameter(paramName, paramValue);
        }
    }

    private static void addParameterIfNotNull(CosHttpRequest<?> request, String paramName, Integer value) {
        if (value != null) {
            request.addParameter(paramName, String.valueOf(value));
        }
    }

    private static void addHeaderIfNotNull(CosHttpRequest<?> request, String header, String value) {
        if (value != null) {
            request.addHeader(header, value);
        }
    }

    private static void addDateHeader(CosHttpRequest<?> request, String header, Date value) {
        if (value != null) {
            request.addHeader(header, DateUtils.formatRFC822Date(value));
        }
    }

    private static void addStringListHeader(CosHttpRequest<?> request, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            request.addHeader(header, StringUtils.join(values));
        }
    }

    private void setZeroContentLength(CosHttpRequest<?> req) {
        req.addHeader("Content-Length", String.valueOf(0));
    }

    private boolean shouldRetryCompleteMultipartUpload(CosServiceRequest originalRequest, CosClientException exception, int retriesAttempted) {
        return false;
    }

    private static void addResponseHeaderParameters(CosHttpRequest<?> request, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaders.getContentLanguage());
            }
            if (responseHeaders.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                request.addParameter("response-expires", responseHeaders.getExpires());
            }
        }
    }

    private static void populateSSE_C(CosHttpRequest<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-customer-key", sseKey.getKey());
        COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode(encryptionKey_b64);
            request.addHeader("x-cos-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(encryptionKey));
        }
    }

    private static void populateTrafficLimit(CosHttpRequest<?> request, int trafficLimit) {
        if (trafficLimit > 0) {
            request.addHeader("x-cos-traffic-limit", String.valueOf(trafficLimit));
        }
    }

    private static void populateSourceSSE_C(CosHttpRequest<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        COSClient.addHeaderIfNotNull(request, "x-cos-copy-source-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        COSClient.addHeaderIfNotNull(request, "x-cos-copy-source-server-side-encryption-customer-key", sseKey.getKey());
        COSClient.addHeaderIfNotNull(request, "x-cos-copy-source-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode(encryptionKey_b64);
            request.addHeader("x-cos-copy-source-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64(encryptionKey));
        }
    }

    private static void populateSSE_KMS(CosHttpRequest<?> request, SSECOSKeyManagementParams sseParams) {
        if (sseParams != null) {
            COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption", sseParams.getEncryption());
            COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-cos-kms-key-id", sseParams.getCOSKmsKeyId());
            COSClient.addHeaderIfNotNull(request, "x-cos-server-side-encryption-context", sseParams.getEncryptionContext());
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws CosClientException, CosServiceException {
        ObjectMetadata returnedMetadata = this.uploadObjectInternal(UploadMode.PUT_OBJECT, putObjectRequest);
        PutObjectResult result = COSClient.createPutObjectResult(returnedMetadata);
        result.setContentMd5(returnedMetadata.getETag());
        return result;
    }

    @Override
    public AppendObjectResult appendObject(AppendObjectRequest appendObjectRequest) throws CosServiceException, CosClientException {
        this.rejectNull(appendObjectRequest, "The append object request must be specified");
        this.rejectNull(appendObjectRequest.getPosition(), "The position parameter must be specified");
        ObjectMetadata returnedMetadata = this.uploadObjectInternal(UploadMode.APPEND_OBJECT, appendObjectRequest);
        return COSClient.createAppendObjectResult(returnedMetadata);
    }

    @Override
    public void rename(RenameRequest renameRequest) throws CosServiceException, CosClientException {
        this.rejectNull(renameRequest, "The request must not be null");
        this.rejectNull(renameRequest.getBucketName(), "The bucket name parameter must be specified when rename");
        this.rejectNull(renameRequest.getSrcObject(), "The src object parameter must be specified when rename");
        this.rejectNull(renameRequest.getDstObject(), "The dst object parameter must be specified when rename");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when rename");
        this.rejectEmpty(renameRequest.getSrcObject(), "The length of the src key must be greater than 0");
        this.rejectEmpty(renameRequest.getDstObject(), "The length of the dst key must be greater than 0");
        CosHttpRequest<RenameRequest> request = this.createRequest(renameRequest.getBucketName(), renameRequest.getDstObject(), renameRequest, HttpMethodName.PUT);
        request.addParameter("rename", null);
        request.addHeader("x-cos-rename-source", UrlEncoderUtils.encodeEscapeDelimiter(renameRequest.getSrcObject()));
        this.invoke(request, this.voidCosResponseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <UploadObjectRequest extends PutObjectRequest> ObjectMetadata uploadObjectInternal(UploadMode uploadMode, UploadObjectRequest uploadObjectRequest) throws CosClientException, CosServiceException {
        String reqMsg;
        Long currentTime;
        ObjectMetadata returnedMetadata;
        this.rejectNull(uploadObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when uploading an object");
        File file = uploadObjectRequest.getFile();
        InputStream isOrig = uploadObjectRequest.getInputStream();
        String bucketName = uploadObjectRequest.getBucketName();
        String key = uploadObjectRequest.getKey();
        ObjectMetadata metadata = uploadObjectRequest.getMetadata();
        InputStream input = isOrig;
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.rejectNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        this.rejectNull(key, "The key parameter must be specified when uploading an object");
        try {
            this.preflightObj(uploadObjectRequest);
        }
        catch (CosServiceException cse) {
            String msg = String.format("fail to do the preflight request due to the service exception[statusCode:%s, requestId:%s], will not do the upload obj request", cse.getStatusCode(), cse.getRequestId());
            log.warn(msg);
            throw cse;
        }
        catch (CosClientException cce) {
            log.warn("fail to do the preflight request due to the client exception, will not do the upload obj request", (Throwable)cce);
            throw cce;
        }
        if (file == null) {
            if (input != null) {
                input = ReleasableInputStream.wrap(input);
            }
        } else {
            boolean calculateMD5;
            metadata.setContentLength(file.length());
            long maxAllowdSingleFileSize = 0x140000000L;
            if (file.length() > 0x140000000L) {
                throw new CosClientException("max size 5GB is allowed by putObject Method, your filesize is " + file.length() + ", please use transferManager to upload big file!");
            }
            boolean bl = calculateMD5 = metadata.getContentMD5() == null;
            if (calculateMD5 && !this.skipMd5CheckStrategy.skipServerSideValidation(uploadObjectRequest)) {
                try {
                    String contentMd5_b64 = Md5Utils.md5AsBase64(file);
                    metadata.setContentMD5(contentMd5_b64);
                }
                catch (Exception e) {
                    throw new CosClientException("Unable to calculate MD5 hash: " + e.getMessage(), e);
                }
            }
            input = ResettableInputStream.newResettableInputStream(file, "Unable to find file to upload");
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        try {
            CosHttpRequest<UploadObjectRequest> request = null;
            if (uploadMode.equals((Object)UploadMode.PUT_OBJECT)) {
                request = this.createRequest(bucketName, key, uploadObjectRequest, HttpMethodName.PUT);
            } else if (uploadMode.equals((Object)UploadMode.APPEND_OBJECT)) {
                request = this.createRequest(bucketName, key, uploadObjectRequest, HttpMethodName.POST);
                AppendObjectRequest appendObjectRequest = (AppendObjectRequest)uploadObjectRequest;
                String positionStr = String.valueOf(appendObjectRequest.getPosition());
                request.addParameter("append", null);
                request.addParameter("position", positionStr);
            }
            if (uploadObjectRequest.getAccessControlList() != null) {
                this.addAclHeaders(request, uploadObjectRequest.getAccessControlList());
            } else if (uploadObjectRequest.getCannedAcl() != null) {
                request.addHeader("x-cos-acl", uploadObjectRequest.getCannedAcl().toString());
            }
            if (uploadObjectRequest.getStorageClass() != null) {
                request.addHeader("x-cos-storage-class", uploadObjectRequest.getStorageClass());
            }
            if (uploadObjectRequest.getRedirectLocation() != null) {
                request.addHeader("x-cos-website-redirect-location", uploadObjectRequest.getRedirectLocation());
                if (input == null) {
                    input = new ByteArrayInputStream(new byte[0]);
                }
            }
            COSClient.populateSSE_C(request, uploadObjectRequest.getSSECustomerKey());
            COSClient.populateSSE_KMS(request, uploadObjectRequest.getSSECOSKeyManagementParams());
            COSClient.populateTrafficLimit(request, uploadObjectRequest.getTrafficLimit());
            Long contentLength = (Long)metadata.getRawMetadataValue("Content-Length");
            if (contentLength == null) {
                log.warn("No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
            } else {
                long expectedLength = contentLength;
                long maxAllowdSingleFileSize = 0x140000000L;
                if (expectedLength > 0x140000000L) {
                    throw new CosClientException("max size 5GB is allowed by putObject Method, your filesize is " + expectedLength + ", please use transferManager to upload big file!");
                }
                if (expectedLength >= 0L) {
                    LengthCheckInputStream lcis = new LengthCheckInputStream(input, expectedLength, false);
                    input = lcis;
                }
            }
            if (metadata.getContentMD5() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(uploadObjectRequest)) {
                md5DigestStream = new MD5DigestCalculatingInputStream(input);
                input = md5DigestStream;
            }
            COSClient.populateRequestMetadata(request, metadata);
            request.setContent(input);
            try {
                if (uploadObjectRequest.getPicOperations() != null || uploadObjectRequest.getCustomRequestHeaders() != null && uploadObjectRequest.getCustomRequestHeaders().containsKey("Pic-Operations")) {
                    if (uploadObjectRequest.getCustomRequestHeaders() == null || !uploadObjectRequest.getCustomRequestHeaders().containsKey("Pic-Operations")) {
                        request.addHeader("Pic-Operations", Jackson.toJsonString(uploadObjectRequest.getPicOperations()));
                    }
                    returnedMetadata = (ObjectMetadata)this.invoke(request, new ResponseHeaderHandlerChain<ObjectMetadata>(new Unmarshallers.ImagePersistenceUnmarshaller(), new CosMetadataResponseHandler()));
                } else {
                    returnedMetadata = this.invoke(request, new CosMetadataResponseHandler());
                }
            }
            catch (Throwable t) {
                throw Throwables.failure(t);
            }
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(uploadObjectRequest, file, isOrig, input, log);
        }
        if (returnedMetadata.isNeedPreflight()) {
            currentTime = System.currentTimeMillis();
            if (this.preflightBuckets.get(bucketName) == null || currentTime - this.preflightBuckets.get(bucketName) > this.clientConfig.getPreflightStatusUpdateInterval()) {
                reqMsg = String.format("will update preflight status, bucket[%s]", bucketName);
                log.info(reqMsg);
                this.preflightBuckets.put(bucketName, currentTime);
            }
        } else {
            currentTime = System.currentTimeMillis();
            if (this.preflightBuckets.get(bucketName) != null && currentTime - this.preflightBuckets.get(bucketName) > this.clientConfig.getPreflightStatusUpdateInterval()) {
                reqMsg = String.format("will remove bucket[%s] from preflight lists", bucketName);
                log.info(reqMsg);
                this.preflightBuckets.remove(bucketName);
            }
        }
        String contentMd5 = metadata.getContentMD5();
        if (md5DigestStream != null) {
            contentMd5 = Base64.encodeAsString(md5DigestStream.getMd5Digest());
        }
        String etag = returnedMetadata.getETag();
        if (contentMd5 != null && uploadMode.equals((Object)UploadMode.PUT_OBJECT) && !this.skipMd5CheckStrategy.skipClientSideValidationPerPutResponse(returnedMetadata) && !CICheckUtils.isCoverImageRequest(uploadObjectRequest)) {
            byte[] clientSideHash = BinaryUtils.fromBase64(contentMd5);
            byte[] serverSideHash = null;
            try {
                serverSideHash = BinaryUtils.fromHex(etag);
            }
            catch (DecoderException e) {
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + contentMd5 + " in base 64) didn't match hash (etag: " + etag + " in hex) calculated by COS .  You may need to delete the data stored in COS . (metadata.contentMD5: " + metadata.getContentMD5() + ", bucketName: " + bucketName + ", key: " + key + ")");
            }
            if (!Arrays.equals(clientSideHash, serverSideHash)) {
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + contentMd5 + " in base 64) didn't match hash (etag: " + etag + " in hex) calculated by COS .  You may need to delete the data stored in COS . (metadata.contentMD5: " + metadata.getContentMD5() + ", bucketName: " + bucketName + ", key: " + key + ")");
            }
        }
        return returnedMetadata;
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) throws CosClientException, CosServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws CosClientException, CosServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, String content) throws CosClientException, CosServiceException {
        this.rejectNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        this.rejectNull(key, "The key parameter must be specified when uploading an object");
        this.rejectNull(content, "The content with utf-8 encoding must be specified when uploading an object");
        byte[] contentByteArray = content.getBytes(StringUtils.UTF8);
        String contentMd5 = Md5Utils.md5AsBase64(contentByteArray);
        ByteArrayInputStream contentInput = new ByteArrayInputStream(contentByteArray);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("text/plain");
        metadata.setContentLength(contentByteArray.length);
        metadata.setContentMD5(contentMd5);
        return this.putObject(new PutObjectRequest(bucketName, key, contentInput, metadata));
    }

    @Override
    public COSObject getObject(String bucketName, String key) throws CosClientException, CosServiceException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public COSObject getObject(GetObjectRequest getObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.rejectNull(getObjectRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object");
        this.rejectNull(getObjectRequest.getKey(), "The key parameter must be specified when requesting an object");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object");
        if (this.clientConfig.isCheckRequestPath() && StringUtils.isRequestPathInvalid(getObjectRequest.getKey())) {
            throw new IllegalArgumentException("The key you specified is invalid");
        }
        CosHttpRequest<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "versionId", getObjectRequest.getVersionId());
        long[] range = getObjectRequest.getRange();
        if (range != null) {
            if (range[0] == -1L) {
                request.addHeader("Range", "bytes=-" + Long.toString(range[1]));
            } else if (range[1] == -1L) {
                request.addHeader("Range", "bytes=" + Long.toString(range[0]) + "-");
            } else {
                request.addHeader("Range", "bytes=" + Long.toString(range[0]) + "-" + Long.toString(range[1]));
            }
        }
        COSClient.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        COSClient.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        COSClient.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        COSClient.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        COSClient.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        COSClient.populateSSE_C(request, getObjectRequest.getSSECustomerKey());
        COSClient.populateTrafficLimit(request, getObjectRequest.getTrafficLimit());
        try {
            COSObject cosObject = this.invoke(request, new COSObjectResponseHandler());
            cosObject.setBucketName(getObjectRequest.getBucketName());
            cosObject.setKey(getObjectRequest.getKey());
            FilterInputStream is = cosObject.getObjectContent();
            HttpRequestBase httpRequest = cosObject.getObjectContent().getHttpRequest();
            is = new ServiceClientHolderInputStream(is, this);
            if (!this.skipMd5CheckStrategy.skipClientSideValidation(getObjectRequest, cosObject.getObjectMetadata())) {
                try {
                    byte[] serverSideHash = BinaryUtils.fromHex(cosObject.getObjectMetadata().getETag());
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    is = new DigestValidationInputStream(is, digest, serverSideHash);
                }
                catch (NoSuchAlgorithmException e) {
                    log.warn("No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
                }
                catch (DecoderException e) {
                    log.warn("BinaryUtils.fromHex error. Unable to calculate checksum and verify data integrity. etag:" + cosObject.getObjectMetadata().getETag(), (Throwable)e);
                }
            } else {
                is = new LengthCheckInputStream(is, cosObject.getObjectMetadata().getContentLength(), true);
            }
            cosObject.setObjectContent(new COSObjectInputStream(is, httpRequest));
            return cosObject;
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 412 || cse.getStatusCode() == 304) {
                return null;
            }
            throw cse;
        }
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File destinationFile) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectRequest, "The GetObjectRequest parameter must be specified when requesting an object");
        this.rejectNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when downloading an object directly to a file");
        COSObject cosObject = ServiceUtils.retryableDownloadCOSObjectToFile(destinationFile, new ServiceUtils.RetryableCOSDownloadTask(){

            @Override
            public boolean needIntegrityCheck() {
                return !COSClient.this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(getObjectRequest);
            }

            @Override
            public COSObject getCOSObjectStream() {
                return COSClient.this.getObject(getObjectRequest);
            }
        }, false);
        if (cosObject == null) {
            return null;
        }
        return cosObject.getObjectMetadata();
    }

    @Override
    public PutSymlinkResult putSymlink(PutSymlinkRequest putSymlinkRequest) {
        this.rejectNull(putSymlinkRequest, "The request must not be null.");
        this.rejectNull(putSymlinkRequest.getBucketName(), "The bucket name parameter must be specified when create symlink.");
        this.rejectNull(putSymlinkRequest.getSymlink(), "The symlink name must be specified when create symlink");
        this.rejectNull(putSymlinkRequest.getTarget(), "The target object must be specified when create symlink");
        CosHttpRequest<PutSymlinkRequest> request = this.createRequest(putSymlinkRequest.getBucketName(), putSymlinkRequest.getSymlink(), putSymlinkRequest, HttpMethodName.PUT);
        request.addParameter("symlink", null);
        request.addHeader("x-cos-symlink-target", putSymlinkRequest.getTarget());
        return this.invoke(request, new PutSymlinkResultHandler());
    }

    @Override
    public GetSymlinkResult getSymlink(GetSymlinkRequest getSymlinkRequest) {
        this.rejectNull(getSymlinkRequest, "The request must not be null.");
        this.rejectNull(getSymlinkRequest.getBucketName(), "The bucket name parameter must be specified when getting symlink.");
        this.rejectNull(getSymlinkRequest.getSymlink(), "The requested symbolic link must be specified.");
        CosHttpRequest<GetSymlinkRequest> request = this.createRequest(getSymlinkRequest.getBucketName(), getSymlinkRequest.getSymlink(), getSymlinkRequest, HttpMethodName.GET);
        request.addParameter("symlink", null);
        COSClient.addParameterIfNotNull(request, "versionId", getSymlinkRequest.getVersionId());
        return this.invoke(request, new GetSymlinkResultHandler());
    }

    @Override
    public boolean doesObjectExist(String bucketName, String objectName) throws CosClientException, CosServiceException {
        try {
            this.getObjectMetadata(bucketName, objectName);
            return true;
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 404) {
                return false;
            }
            throw cse;
        }
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws CosClientException, CosServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object's metadata");
        String bucketName = getObjectMetadataRequest.getBucketName();
        String key = getObjectMetadataRequest.getKey();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(key, "The key parameter must be specified when requesting an object's metadata");
        CosHttpRequest<GetObjectMetadataRequest> request = this.createRequest(bucketName, key, getObjectMetadataRequest, HttpMethodName.HEAD);
        COSClient.addParameterIfNotNull(request, "versionId", getObjectMetadataRequest.getVersionId());
        COSClient.populateSSE_C(request, getObjectMetadataRequest.getSSECustomerKey());
        return this.invoke(request, new CosMetadataResponseHandler());
    }

    @Override
    public void deleteObject(String bucketName, String key) throws CosClientException, CosServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        this.rejectEmpty(deleteObjectRequest.getKey(), "The length of the key must be greater than 0");
        if (Objects.equals(deleteObjectRequest.getKey(), "/")) {
            throw new IllegalArgumentException("The specified key should not be /");
        }
        CosHttpRequest<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        if (deleteObjectRequest.isRecursive()) {
            request.addParameter("recursive", null);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws MultiObjectDeleteException, CosClientException, CosServiceException {
        this.rejectNull(deleteObjectsRequest, "The DeleteObjectsRequest parameter must be specified when deleting objects");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting objects");
        CosHttpRequest<DeleteObjectsRequest> request = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        request.addParameter("delete", null);
        byte[] content = new MultiObjectDeleteXmlFactory().convertToXmlByteArray(deleteObjectsRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        ResponseHeaderHandlerChain<DeleteObjectsResponse> responseHandler = new ResponseHeaderHandlerChain<DeleteObjectsResponse>(new Unmarshallers.DeleteObjectsResultUnmarshaller(), new HeaderHandler[0]);
        DeleteObjectsResponse response = (DeleteObjectsResponse)this.invoke(request, responseHandler);
        if (!response.getErrors().isEmpty()) {
            Map<String, String> headers = responseHandler.getResponseHeaders();
            MultiObjectDeleteException ex = new MultiObjectDeleteException(response.getErrors(), response.getDeletedObjects());
            ex.setStatusCode(200);
            ex.setRequestId(headers.get("x-cos-request-id"));
            throw ex;
        }
        DeleteObjectsResult result = new DeleteObjectsResult(response.getDeletedObjects());
        return result;
    }

    @Override
    public void deleteVersion(String bucketName, String key, String versionId) throws CosClientException, CosServiceException {
        this.deleteVersion(new DeleteVersionRequest(bucketName, key, versionId));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteVersionRequest, "The DeleteVersionRequest parameter must be specified when deleting a version");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting a version");
        String bucketName = deleteVersionRequest.getBucketName();
        String key = deleteVersionRequest.getKey();
        String versionId = deleteVersionRequest.getVersionId();
        this.rejectNull(bucketName, "The bucket name must be specified when deleting a version");
        this.rejectNull(key, "The key must be specified when deleting a version");
        this.rejectNull(versionId, "The version ID must be specified when deleting a version");
        CosHttpRequest<DeleteVersionRequest> request = this.createRequest(bucketName, key, deleteVersionRequest, HttpMethodName.DELETE);
        request.addParameter("versionId", versionId);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public Bucket createBucket(String bucketName) throws CosClientException, CosServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when creating a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when creating a bucket");
        bucketName = bucketName.trim();
        BucketNameUtils.validateBucketName(bucketName);
        CosHttpRequest<CreateBucketRequest> request = this.createRequest(bucketName, "/", createBucketRequest, HttpMethodName.PUT);
        if (createBucketRequest.getAccessControlList() != null) {
            this.addAclHeaders(request, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-cos-acl", createBucketRequest.getCannedAcl().toString());
        }
        this.invoke(request, this.voidCosResponseHandler);
        return new Bucket(bucketName);
    }

    public Bucket createMAZBucket(CreateBucketRequest createBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when creating a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when creating a bucket");
        bucketName = bucketName.trim();
        BucketNameUtils.validateBucketName(bucketName);
        CosHttpRequest<CreateBucketRequest> request = this.createRequest(bucketName, "/", createBucketRequest, HttpMethodName.PUT);
        if (createBucketRequest.getAccessControlList() != null) {
            this.addAclHeaders(request, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-cos-acl", createBucketRequest.getCannedAcl().toString());
        }
        ObjectMetadata metadata = new ObjectMetadata();
        String MAZStr = "<CreateBucketConfiguration>\n    <BucketAZConfig>MAZ</BucketAZConfig>\n</CreateBucketConfiguration>";
        byte[] contentByteArray = MAZStr.getBytes(StringUtils.UTF8);
        String contentMd5 = Md5Utils.md5AsBase64(contentByteArray);
        ByteArrayInputStream contentInput = new ByteArrayInputStream(contentByteArray);
        metadata.setContentType("application/xml");
        metadata.setContentLength(contentByteArray.length);
        metadata.setContentMD5(contentMd5);
        MD5DigestCalculatingInputStream md5DigestStream = null;
        md5DigestStream = new MD5DigestCalculatingInputStream(contentInput);
        COSClient.populateRequestMetadata(request, metadata);
        request.setContent(md5DigestStream);
        try {
            this.invoke(request, this.voidCosResponseHandler);
        }
        catch (Throwable t) {
            throw Throwables.failure(t);
        }
        finally {
            try {
                ((InputStream)contentInput).close();
                md5DigestStream.close();
            }
            catch (IOException e) {
                throw new CosClientException(e.getMessage(), e);
            }
        }
        return new Bucket(bucketName);
    }

    @Override
    public void deleteBucket(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String bucketName = deleteBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting a bucket");
        CosHttpRequest<DeleteBucketRequest> request = this.createRequest(bucketName, "/", deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws CosClientException, CosServiceException {
        try {
            this.headBucket(new HeadBucketRequest(bucketName));
            return true;
        }
        catch (CosServiceException cse) {
            if (cse.getStatusCode() == 404) {
                return false;
            }
            throw cse;
        }
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest headBucketRequest) throws CosClientException, CosServiceException {
        this.rejectNull(headBucketRequest, "The HeadBucketRequest parameter must be specified when head a bucket");
        String bucketName = headBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucketName parameter must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when querying a bucket");
        CosHttpRequest<HeadBucketRequest> request = this.createRequest(bucketName, null, headBucketRequest, HttpMethodName.HEAD);
        return this.invoke(request, new HeadBucketResultHandler());
    }

    @Override
    public List<Bucket> listBuckets() throws CosClientException, CosServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws CosClientException, CosServiceException {
        ListBucketsResult result = this.getService(listBucketsRequest);
        return result.getBuckets();
    }

    public ListBucketsResult getService(ListBucketsRequest listBucketsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listBucketsRequest, "The request object parameter listBucketsRequest must be specified.");
        CosHttpRequest<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        if (!listBucketsRequest.getMarker().isEmpty()) {
            request.addParameter("marker", listBucketsRequest.getMarker());
        }
        if (listBucketsRequest.getMaxKeys() != null && listBucketsRequest.getMaxKeys() > 0) {
            request.addParameter("max-keys", listBucketsRequest.getMaxKeys().toString());
        }
        return this.invoke(request, new Unmarshallers.GetServiceUnmarshaller());
    }

    @Override
    public String getBucketLocation(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketLocation(new GetBucketLocationRequest(bucketName));
    }

    @Override
    public String getBucketLocation(GetBucketLocationRequest getBucketLocationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketLocationRequest, "The request parameter must be specified when requesting a bucket's location");
        String bucketName = getBucketLocationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's location");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting a bucket's location");
        CosHttpRequest<GetBucketLocationRequest> request = this.createRequest(bucketName, null, getBucketLocationRequest, HttpMethodName.GET);
        request.addParameter("location", null);
        return this.invoke(request, new Unmarshallers.BucketLocationUnmarshaller());
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws CosClientException, CosServiceException {
        this.rejectNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when initiating a multipart upload");
        CosHttpRequest<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            request.addHeader("x-cos-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getRedirectLocation() != null) {
            request.addHeader("x-cos-website-redirect-location", initiateMultipartUploadRequest.getRedirectLocation());
        }
        if (initiateMultipartUploadRequest.getAccessControlList() != null) {
            this.addAclHeaders(request, initiateMultipartUploadRequest.getAccessControlList());
        } else if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-cos-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            COSClient.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        COSClient.populateSSE_C(request, initiateMultipartUploadRequest.getSSECustomerKey());
        COSClient.populateSSE_KMS(request, initiateMultipartUploadRequest.getSSECOSKeyManagementParams());
        request.addHeader("Content-Length", String.valueOf(0));
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHandler = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new VIDResultHandler());
        return (InitiateMultipartUploadResult)this.invoke(request, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws CosClientException, CosServiceException {
        this.rejectNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        File fileOrig = uploadPartRequest.getFile();
        InputStream isOrig = uploadPartRequest.getInputStream();
        String bucketName = uploadPartRequest.getBucketName();
        String key = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        int partNumber = uploadPartRequest.getPartNumber();
        long partSize = uploadPartRequest.getPartSize();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when uploading a part");
        this.rejectNull(key, "The key parameter must be specified when uploading a part");
        this.rejectNull(uploadId, "The upload ID parameter must be specified when uploading a part");
        this.rejectNull(partNumber, "The part number parameter must be specified when uploading a part");
        this.rejectNull(partSize, "The part size parameter must be specified when uploading a part");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when uploading a part");
        CosHttpRequest<UploadPartRequest> request = this.createRequest(bucketName, key, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", uploadId);
        request.addParameter("partNumber", Integer.toString(partNumber));
        ObjectMetadata objectMetadata = uploadPartRequest.getObjectMetadata();
        if (objectMetadata != null) {
            COSClient.populateRequestMetadata(request, objectMetadata);
        }
        COSClient.addHeaderIfNotNull(request, "Content-MD5", uploadPartRequest.getMd5Digest());
        request.addHeader("Content-Length", Long.toString(partSize));
        COSClient.populateSSE_C(request, uploadPartRequest.getSSECustomerKey());
        COSClient.populateTrafficLimit(request, uploadPartRequest.getTrafficLimit());
        InputStream isCurr = isOrig;
        try {
            if (fileOrig == null) {
                if (isOrig == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                isCurr = ReleasableInputStream.wrap(isCurr);
            } else {
                try {
                    isCurr = new ResettableInputStream(fileOrig);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to open file " + fileOrig, e);
                }
            }
            isCurr = new InputSubstream(isCurr, uploadPartRequest.getFileOffset(), partSize, uploadPartRequest.isLastPart());
            MD5DigestCalculatingInputStream md5DigestStream = null;
            if (uploadPartRequest.getMd5Digest() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(uploadPartRequest)) {
                md5DigestStream = new MD5DigestCalculatingInputStream(isCurr);
                isCurr = md5DigestStream;
            }
            UploadPartResult uploadPartResult = this.doUploadPart(bucketName, key, uploadId, partNumber, partSize, request, isCurr, md5DigestStream);
            return uploadPartResult;
        }
        finally {
            CosDataSource.Utils.cleanupDataSource(uploadPartRequest, fileOrig, isOrig, isCurr, log);
        }
    }

    private UploadPartResult doUploadPart(String bucketName, String key, String uploadId, int partNumber, long partSize, CosHttpRequest<UploadPartRequest> request, InputStream inputStream, MD5DigestCalculatingInputStream md5DigestStream) {
        try {
            byte[] serverSideHash;
            byte[] clientSideHash;
            request.setContent(inputStream);
            ObjectMetadata metadata = this.invoke(request, new CosMetadataResponseHandler());
            String etag = metadata.getETag();
            if (md5DigestStream != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerUploadPartResponse(metadata) && !Arrays.equals(clientSideHash = md5DigestStream.getMd5Digest(), serverSideHash = BinaryUtils.fromHex(etag))) {
                String info = "bucketName: " + bucketName + ", key: " + key + ", uploadId: " + uploadId + ", partNumber: " + partNumber + ", partSize: " + partSize;
                throw new CosClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + BinaryUtils.toHex(clientSideHash) + " in hex) didn't match hash (etag: " + etag + " in hex) calculated by Qcloud COS.  You may need to delete the data stored in Qcloud COS. (" + info + ")");
            }
            UploadPartResult result = new UploadPartResult();
            result.setETag(etag);
            result.setPartNumber(partNumber);
            result.setSSEAlgorithm(metadata.getSSEAlgorithm());
            result.setSSECustomerAlgorithm(metadata.getSSECustomerAlgorithm());
            result.setSSECustomerKeyMd5(metadata.getSSECustomerKeyMd5());
            result.setCrc64Ecma(metadata.getCrc64Ecma());
            result.setRequestId(metadata.getRequestId());
            return result;
        }
        catch (Throwable t) {
            throw Throwables.failure(t);
        }
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listPartsRequest, "The request parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing parts");
        CosHttpRequest<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listPartsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListPartsResultUnmarshaller());
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws CosClientException, CosServiceException {
        this.rejectNull(abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when aborting a multipart uploads");
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String key = abortMultipartUploadRequest.getKey();
        CosHttpRequest<AbortMultipartUploadRequest> request = this.createRequest(bucketName, key, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws CosClientException, CosServiceException {
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler;
        this.rejectNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String key = completeMultipartUploadRequest.getKey();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when completing a multipart upload");
        this.rejectNull(key, "The key parameter must be specified when completing a multipart upload");
        this.rejectNull(uploadId, "The upload ID parameter must be specified when completing a multipart upload");
        this.rejectNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when completing a multipart uploads");
        int retries = 0;
        do {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHandler;
            CosHttpRequest<CompleteMultipartUploadRequest> request = this.createRequest(bucketName, key, completeMultipartUploadRequest, HttpMethodName.POST);
            request.addParameter("uploadId", uploadId);
            byte[] xml = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
            request.addHeader("Content-Type", "application/xml");
            request.addHeader("Content-Length", String.valueOf(xml.length));
            ObjectMetadata objectMetadata = completeMultipartUploadRequest.getObjectMetadata();
            if (objectMetadata != null) {
                COSClient.populateRequestMetadata(request, objectMetadata);
            }
            request.setContent(new ByteArrayInputStream(xml));
            if (completeMultipartUploadRequest.getPicOperations() != null) {
                request.addHeader("Pic-Operations", Jackson.toJsonString(completeMultipartUploadRequest.getPicOperations()));
            }
            if ((handler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(request, responseHandler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new VIDResultHandler()))).getCompleteMultipartUploadResult() == null) continue;
            Map<String, String> responseHeaders = responseHandler.getResponseHeaders();
            String versionId = responseHeaders.get("x-cos-version-id");
            String crc64Ecma = responseHeaders.get("x-cos-hash-crc64ecma");
            handler.getCompleteMultipartUploadResult().setVersionId(versionId);
            handler.getCompleteMultipartUploadResult().setCrc64Ecma(crc64Ecma);
            if (completeMultipartUploadRequest.getPicOperations() != null) {
                handler.getCompleteMultipartUploadResult().setCiUploadResult(handler.getCiUploadResult());
            }
            return handler.getCompleteMultipartUploadResult();
        } while (this.shouldRetryCompleteMultipartUpload(completeMultipartUploadRequest, handler.getCOSException(), retries++));
        throw handler.getCOSException();
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        this.rejectNull(listMultipartUploadsRequest.getBucketName(), "The bucket name parameter must be specified when listing multipart uploads");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing multipart uploads");
        CosHttpRequest<ListMultipartUploadsRequest> request = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            request.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            request.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
        return this.invoke(request, new Unmarshallers.ListMultipartUploadsResultUnmarshaller());
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws CosClientException, CosServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) throws CosClientException, CosServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listObjectsRequest, "The ListObjectsRequest parameter must be specified when listing objects in a bucket");
        this.rejectNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing objects in a bucket");
        boolean shouldSDKDecodeResponse = listObjectsRequest.getEncodingType() == null;
        CosHttpRequest<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), "/", listObjectsRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "prefix", this.leftStripPathDelimiter(listObjectsRequest.getPrefix()));
        COSClient.addParameterIfNotNull(request, "marker", listObjectsRequest.getMarker());
        COSClient.addParameterIfNotNull(request, "delimiter", listObjectsRequest.getDelimiter());
        request.addParameter("encoding-type", shouldSDKDecodeResponse ? "url" : listObjectsRequest.getEncodingType());
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        COSXmlResponseHandler<ObjectListing> handler = new COSXmlResponseHandler<ObjectListing>(new Unmarshallers.ListObjectsUnmarshaller(shouldSDKDecodeResponse));
        return (ObjectListing)this.invoke(request, handler);
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws CosClientException, CosServiceException {
        return this.listNextBatchOfObjects(new ListNextBatchOfObjectsRequest(previousObjectListing));
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listNextBatchOfObjectsRequest, "The request object parameter must be specified when listing the next batch of objects in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing the next batch of objects  in a bucket");
        ObjectListing previousObjectListing = listNextBatchOfObjectsRequest.getPreviousObjectListing();
        if (!previousObjectListing.isTruncated()) {
            ObjectListing emptyListing = new ObjectListing();
            emptyListing.setBucketName(previousObjectListing.getBucketName());
            emptyListing.setDelimiter(previousObjectListing.getDelimiter());
            emptyListing.setMarker(previousObjectListing.getNextMarker());
            emptyListing.setMaxKeys(previousObjectListing.getMaxKeys());
            emptyListing.setPrefix(previousObjectListing.getPrefix());
            emptyListing.setEncodingType(previousObjectListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listObjects(listNextBatchOfObjectsRequest.toListObjectsRequest());
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix) throws CosClientException, CosServiceException {
        return this.listVersions(new ListVersionsRequest(bucketName, prefix, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxResults) throws CosClientException, CosServiceException {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(bucketName).withPrefix(prefix).withDelimiter(delimiter).withKeyMarker(keyMarker).withVersionIdMarker(versionIdMarker).withMaxResults(maxResults);
        return this.listVersions(request);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listVersionsRequest, "The ListVersionsRequest parameter must be specified when listing versions in a bucket");
        this.rejectNull(listVersionsRequest.getBucketName(), "The bucket name parameter must be specified when listing versions in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing versions in a bucket");
        boolean shouldSDKDecodeResponse = listVersionsRequest.getEncodingType() == null;
        CosHttpRequest<ListVersionsRequest> request = this.createRequest(listVersionsRequest.getBucketName(), null, listVersionsRequest, HttpMethodName.GET);
        request.addParameter("versions", null);
        COSClient.addParameterIfNotNull(request, "prefix", listVersionsRequest.getPrefix());
        COSClient.addParameterIfNotNull(request, "key-marker", listVersionsRequest.getKeyMarker());
        COSClient.addParameterIfNotNull(request, "version-id-marker", listVersionsRequest.getVersionIdMarker());
        COSClient.addParameterIfNotNull(request, "delimiter", listVersionsRequest.getDelimiter());
        request.addParameter("encoding-type", shouldSDKDecodeResponse ? "url" : listVersionsRequest.getEncodingType());
        if (listVersionsRequest.getMaxResults() != null && listVersionsRequest.getMaxResults() >= 0) {
            request.addParameter("max-keys", listVersionsRequest.getMaxResults().toString());
        }
        return this.invoke(request, new Unmarshallers.VersionListUnmarshaller(shouldSDKDecodeResponse));
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) throws CosClientException, CosServiceException {
        return this.listNextBatchOfVersions(new ListNextBatchOfVersionsRequest(previousVersionListing));
    }

    @Override
    public VersionListing listNextBatchOfVersions(ListNextBatchOfVersionsRequest listNextBatchOfVersionsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listNextBatchOfVersionsRequest, "The request object parameter must be specified when listing the next batch of versions in a bucket");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when listing the next batch of versions in a bucket");
        VersionListing previousVersionListing = listNextBatchOfVersionsRequest.getPreviousVersionListing();
        if (!previousVersionListing.isTruncated()) {
            VersionListing emptyListing = new VersionListing();
            emptyListing.setBucketName(previousVersionListing.getBucketName());
            emptyListing.setDelimiter(previousVersionListing.getDelimiter());
            emptyListing.setKeyMarker(previousVersionListing.getNextKeyMarker());
            emptyListing.setVersionIdMarker(previousVersionListing.getNextVersionIdMarker());
            emptyListing.setMaxKeys(previousVersionListing.getMaxKeys());
            emptyListing.setPrefix(previousVersionListing.getPrefix());
            emptyListing.setEncodingType(previousVersionListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listVersions(listNextBatchOfVersionsRequest.toListVersionsRequest());
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws CosClientException, CosServiceException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws CosClientException, CosServiceException {
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler;
        block4: {
            CosServiceException cse;
            this.rejectNull(copyObjectRequest, "The CopyObjectRequest parameter must be specified when copying an object");
            this.rejectNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
            this.rejectNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
            this.rejectNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
            this.rejectNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
            this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when copying an object");
            String destinationKey = copyObjectRequest.getDestinationKey();
            String destinationBucketName = copyObjectRequest.getDestinationBucketName();
            CosHttpRequest<CopyObjectRequest> request = this.createRequest(destinationBucketName, destinationKey, copyObjectRequest, HttpMethodName.PUT);
            this.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
            int retryIndex = 0;
            while (true) {
                this.setZeroContentLength(request);
                copyObjectResultHandler = null;
                try {
                    ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new VIDResultHandler());
                    copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler);
                }
                catch (CosServiceException cse2) {
                    if (cse2.getStatusCode() == 412) {
                        return null;
                    }
                    throw cse2;
                }
                if (copyObjectResultHandler.getErrorCode() == null) break block4;
                String errorCode = copyObjectResultHandler.getErrorCode();
                String errorMessage = copyObjectResultHandler.getErrorMessage();
                String requestId = copyObjectResultHandler.getErrorRequestId();
                cse = new CosServiceException(errorMessage);
                cse.setErrorCode(errorCode);
                cse.setRequestId(requestId);
                cse.setStatusCode(200);
                String errorMsg = String.format("failed to execute http request, due to service exception: %s httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", cse.getMessage(), request, retryIndex, this.clientConfig.getMaxErrorRetryForCopyRequest());
                log.debug(errorMsg);
                if (retryIndex >= this.clientConfig.getMaxErrorRetryForCopyRequest() || !RetryUtils.shouldRetryCopyRequest(cse)) break;
                ++retryIndex;
            }
            throw cse;
        }
        CopyObjectResult copyObjectResult = new CopyObjectResult();
        copyObjectResult.setETag(copyObjectResultHandler.getETag());
        copyObjectResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyObjectResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyObjectResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyObjectResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyObjectResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        copyObjectResult.setExpirationTime(copyObjectResultHandler.getExpirationTime());
        copyObjectResult.setExpirationTimeRuleId(copyObjectResultHandler.getExpirationTimeRuleId());
        copyObjectResult.setDateStr(copyObjectResultHandler.getDateStr());
        copyObjectResult.setCrc64Ecma(copyObjectResultHandler.getCrc64Ecma());
        copyObjectResult.setRequestId(copyObjectResultHandler.getRequestId());
        return copyObjectResult;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) throws CosClientException, CosServiceException {
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler;
        block4: {
            CosServiceException cse;
            this.rejectNull(copyPartRequest, "The CopyPartRequest parameter must be specified when copying a part");
            this.rejectNull(copyPartRequest.getSourceBucketName(), "The source bucket name must be specified when copying a part");
            this.rejectNull(copyPartRequest.getSourceKey(), "The source object key must be specified when copying a part");
            this.rejectNull(copyPartRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying a part");
            this.rejectNull(copyPartRequest.getUploadId(), "The upload id must be specified when copying a part");
            this.rejectNull(copyPartRequest.getDestinationKey(), "The destination object key must be specified when copying a part");
            this.rejectNull(copyPartRequest.getPartNumber(), "The part number must be specified when copying a part");
            this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when copying a part");
            String destinationKey = copyPartRequest.getDestinationKey();
            String destinationBucketName = copyPartRequest.getDestinationBucketName();
            CosHttpRequest<CopyPartRequest> request = this.createRequest(destinationBucketName, destinationKey, copyPartRequest, HttpMethodName.PUT);
            this.populateRequestWithCopyPartParameters(request, copyPartRequest);
            request.addParameter("uploadId", copyPartRequest.getUploadId());
            request.addParameter("partNumber", Integer.toString(copyPartRequest.getPartNumber()));
            int retryIndex = 0;
            while (true) {
                this.setZeroContentLength(request);
                copyObjectResultHandler = null;
                try {
                    ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new COSVersionHeaderHandler(), new VIDResultHandler());
                    copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler);
                }
                catch (CosServiceException cse2) {
                    if (cse2.getStatusCode() == 412) {
                        return null;
                    }
                    throw cse2;
                }
                if (copyObjectResultHandler.getErrorCode() == null) break block4;
                String errorCode = copyObjectResultHandler.getErrorCode();
                String errorMessage = copyObjectResultHandler.getErrorMessage();
                String requestId = copyObjectResultHandler.getErrorRequestId();
                cse = new CosServiceException(errorMessage);
                cse.setErrorCode(errorCode);
                cse.setErrorType(CosServiceException.ErrorType.Service);
                cse.setRequestId(requestId);
                cse.setStatusCode(200);
                String errorMsg = String.format("failed to execute http request, due to service exception: %s httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", cse.getMessage(), request, retryIndex, this.clientConfig.getMaxErrorRetryForCopyRequest());
                log.debug(errorMsg);
                if (retryIndex >= this.clientConfig.getMaxErrorRetryForCopyRequest() || !RetryUtils.shouldRetryCopyRequest(cse)) break;
                ++retryIndex;
            }
            throw cse;
        }
        CopyPartResult copyPartResult = new CopyPartResult();
        copyPartResult.setETag(copyObjectResultHandler.getETag());
        copyPartResult.setPartNumber(copyPartRequest.getPartNumber());
        copyPartResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyPartResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyPartResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyPartResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyPartResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        copyPartResult.setCrc64Ecma(copyObjectResultHandler.getCrc64Ecma());
        copyPartResult.setRequestId(copyObjectResultHandler.getRequestId());
        return copyPartResult;
    }

    @Override
    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration bucketLifecycleConfiguration) throws CosClientException, CosServiceException {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(bucketName, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketLifecycleConfigurationRequest, "The set bucket lifecycle configuration request object must be specified.");
        String bucketName = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        this.rejectNull(bucketLifecycleConfiguration, "The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting bucket lifecycle configuration");
        CosHttpRequest<SetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("lifecycle", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLifecycleConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketLifecycleConfiguration(new GetBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        this.rejectNull(getBucketLifecycleConfigurationRequest, "The request object pamameter getBucketLifecycleConfigurationRequest must be specified.");
        String bucketName = getBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specifed when retrieving the bucket lifecycle configuration.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when retrieving lifecycle configuration");
        CosHttpRequest<GetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, getBucketLifecycleConfigurationRequest, HttpMethodName.GET);
        request.addParameter("lifecycle", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketLifecycleConfiguration(new DeleteBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketLifecycleConfigurationRequest, "The delete bucket lifecycle configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting lifecycle configuration");
        String bucketName = deleteBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        CosHttpRequest<DeleteBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketLifecycleConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("lifecycle", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketVersioningConfigurationRequest, "The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String bucketName = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration versioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting versioning configuration");
        this.rejectNull(versioningConfiguration, "The bucket versioning parameter must be specified when setting versioning configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting versioning configuration");
        CosHttpRequest<SetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("versioning", null);
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(versioningConfiguration);
        request.setContent(new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketVersioningConfiguration(new GetBucketVersioningConfigurationRequest(bucketName));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest getBucketVersioningConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketVersioningConfigurationRequest, "The request object parameter getBucketVersioningConfigurationRequest must be specified.");
        String bucketName = getBucketVersioningConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when querying versioning configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when querying versioning configuration");
        CosHttpRequest<GetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, getBucketVersioningConfigurationRequest, HttpMethodName.GET);
        request.addParameter("versioning", null);
        return this.invoke(request, new Unmarshallers.BucketVersioningConfigurationUnmarshaller());
    }

    @Override
    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws CosClientException, CosServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, acl));
    }

    @Override
    public void setObjectAcl(String bucketName, String key, CannedAccessControlList acl) throws CosClientException, CosServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, acl));
    }

    @Override
    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setObjectAclRequest, "The request must not be null.");
        this.rejectNull(setObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when setting an object's ACL");
        this.rejectNull(setObjectAclRequest.getKey(), "The key parameter must be specified when setting an object's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting an object acl");
        if (setObjectAclRequest.getAcl() != null && setObjectAclRequest.getCannedAcl() != null) {
            throw new IllegalArgumentException("Only one of the ACL and CannedACL parameters can be specified, not both.");
        }
        if (setObjectAclRequest.getAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), null, setObjectAclRequest.getAcl(), (CosServiceRequest)setObjectAclRequest);
        } else if (setObjectAclRequest.getCannedAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getCannedAcl(), (CosServiceRequest)setObjectAclRequest);
        } else {
            throw new IllegalArgumentException("At least one of the ACL and CannedACL parameters should be specified");
        }
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key) throws CosClientException, CosServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, key));
    }

    @Override
    public AccessControlList getObjectAcl(GetObjectAclRequest getObjectAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getObjectAclRequest, "The request parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getKey(), "The key parameter must be specified when requesting an object's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object acl");
        return this.getAcl(getObjectAclRequest.getBucketName(), getObjectAclRequest.getKey(), getObjectAclRequest.getVersionId(), getObjectAclRequest);
    }

    @Override
    public void setBucketAcl(String bucketName, AccessControlList acl) throws CosClientException, CosServiceException {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAccessControlList acl) throws CosClientException, CosServiceException {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketAclRequest, "The SetBucketAclRequest parameter must be specified when setting a bucket's ACL");
        String bucketName = setBucketAclRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting a bucket acl");
        AccessControlList acl = setBucketAclRequest.getAcl();
        CannedAccessControlList cannedAcl = setBucketAclRequest.getCannedAcl();
        if (acl == null && cannedAcl == null) {
            throw new IllegalArgumentException("The ACL parameter must be specified when setting a bucket's ACL");
        }
        if (acl != null && cannedAcl != null) {
            throw new IllegalArgumentException("Only one of the acl and cannedAcl parameter can be specified, not both.");
        }
        if (acl != null) {
            this.setAcl(bucketName, null, null, acl, (CosServiceRequest)setBucketAclRequest);
        } else {
            this.setAcl(bucketName, null, null, cannedAcl, (CosServiceRequest)setBucketAclRequest);
        }
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketAcl(new GetBucketAclRequest(bucketName));
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketAclRequest, "The bucket name parameter must be specified when requesting a bucket's ACL");
        String bucketName = getBucketAclRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting a bucket acl");
        return this.getAcl(bucketName, null, null, getBucketAclRequest);
    }

    private AccessControlList getAcl(String bucketName, String key, String versionId, CosServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        ResponseHeaderHandlerChain<AccessControlList> responseHandler = new ResponseHeaderHandlerChain<AccessControlList>(new Unmarshallers.AccessControlListUnmarshaller(), new COSDefaultAclHeaderHandler());
        return (AccessControlList)this.invoke(request, responseHandler);
    }

    private void setAcl(String bucketName, String key, String versionId, AccessControlList acl, CosServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        byte[] aclAsXml = new AclXmlFactory().convertToXmlByteArray(acl);
        request.addHeader("Content-Type", "application/xml");
        request.addHeader("Content-Length", String.valueOf(aclAsXml.length));
        request.setContent(new ByteArrayInputStream(aclAsXml));
        this.invoke(request, this.voidCosResponseHandler);
    }

    private void setAcl(String bucketName, String key, String versionId, CannedAccessControlList cannedAcl, CosServiceRequest originalRequest) throws CosClientException, CosServiceException {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        request.addHeader("x-cos-acl", cannedAcl.toString());
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketCrossOriginConfiguration(new GetBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(GetBucketCrossOriginConfigurationRequest getBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketCrossOriginConfigurationRequest, "The request object parameter getBucketCrossOriginConfigurationRequest must be specified.");
        String bucketName = getBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket cross origin configuration.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when retrieving the bucket cross origin configuration");
        CosHttpRequest<GetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, getBucketCrossOriginConfigurationRequest, HttpMethodName.GET);
        request.addParameter("cors", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketCrossOriginConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public void setBucketCrossOriginConfiguration(String bucketName, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) throws CosClientException, CosServiceException {
        this.setBucketCrossOriginConfiguration(new SetBucketCrossOriginConfigurationRequest(bucketName, bucketCrossOriginConfiguration));
    }

    @Override
    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketCrossOriginConfigurationRequest, "The set bucket cross origin configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting bucket cross origin configuration");
        String bucketName = setBucketCrossOriginConfigurationRequest.getBucketName();
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = setBucketCrossOriginConfigurationRequest.getCrossOriginConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket cross origin configuration.");
        this.rejectNull(bucketCrossOriginConfiguration, "The cross origin configuration parameter must be specified when setting bucket cross origin configuration.");
        CosHttpRequest<SetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, setBucketCrossOriginConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("cors", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketCrossOriginConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketCrossOriginConfiguration(new DeleteBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketCrossOriginConfigurationRequest, "The delete bucket cross origin configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting bucket cross origin configuration");
        String bucketName = deleteBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket cross origin configuration.");
        CosHttpRequest<DeleteBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketCrossOriginConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("cors", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketReplicationConfiguration(String bucketName, BucketReplicationConfiguration configuration) throws CosClientException, CosServiceException {
        this.setBucketReplicationConfiguration(new SetBucketReplicationConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketReplicationConfiguration(SetBucketReplicationConfigurationRequest setBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketReplicationConfigurationRequest, "The set bucket replication configuration request object must be specified.");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when setting bucket replication configuration");
        String bucketName = setBucketReplicationConfigurationRequest.getBucketName();
        BucketReplicationConfiguration bucketReplicationConfiguration = setBucketReplicationConfigurationRequest.getReplicationConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting replication configuration.");
        this.rejectNull(bucketReplicationConfiguration, "The replication configuration parameter must be specified when setting replication configuration.");
        CosHttpRequest<SetBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, setBucketReplicationConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("replication", null);
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketReplicationConfiguration);
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(bytes));
        try {
            request.addHeader("Content-MD5", BinaryUtils.toBase64(Md5Utils.computeMD5Hash(bytes)));
        }
        catch (Exception e) {
            throw new CosClientException("Not able to compute MD5 of the replication rule configuration. Exception Message : " + e.getMessage(), e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketReplicationConfiguration(new GetBucketReplicationConfigurationRequest(bucketName));
    }

    @Override
    public BucketReplicationConfiguration getBucketReplicationConfiguration(GetBucketReplicationConfigurationRequest getBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketReplicationConfigurationRequest, "The bucket request parameter must be specified when retrieving replication configuration");
        String bucketName = getBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket request must specify a bucket name when retrieving replication configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when retrieving replication configuration");
        CosHttpRequest<GetBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, getBucketReplicationConfigurationRequest, HttpMethodName.GET);
        request.addParameter("replication", null);
        return this.invoke(request, new Unmarshallers.BucketReplicationConfigurationUnmarshaller());
    }

    @Override
    public void deleteBucketReplicationConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketReplicationConfiguration(new DeleteBucketReplicationConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketReplicationConfiguration(DeleteBucketReplicationConfigurationRequest deleteBucketReplicationConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketReplicationConfigurationRequest, "The DeleteBucketReplicationConfigurationRequest parameter must be specified when deleting replication configuration");
        String bucketName = deleteBucketReplicationConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting replication configuration");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when deleting replication configuration");
        CosHttpRequest<DeleteBucketReplicationConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketReplicationConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("replication", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws CosClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethodName.GET);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethodName method) throws CosClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, method, new HashMap<String, String>(), new HashMap<String, String>(), false, true);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethodName method, Map<String, String> headers, Map<String, String> params) throws CosClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, method, headers, params, false, true);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethodName method, Map<String, String> headers, Map<String, String> params, Boolean signPrefixMode, Boolean signHost) throws CosClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expiration);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            request.addRequestParameter(entry.getKey(), entry.getValue());
        }
        if (signHost.booleanValue()) {
            request.putCustomRequestHeader("Host", this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(bucketName));
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            request.putCustomRequestHeader(entry.getKey(), entry.getValue());
        }
        request.setSignPrefixMode(signPrefixMode);
        return this.generatePresignedUrl(request, signHost);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest req) throws CosClientException {
        return this.generatePresignedUrl(req, true);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest req, Boolean signHost) throws CosClientException {
        Map<String, String> map;
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when generating a pre-signed URL");
        this.rejectNull(req, "The request parameter must be specified when generating a pre-signed URL");
        req.rejectIllegalArguments();
        String bucketName = req.getBucketName();
        String key = req.getKey();
        this.rejectEmpty(key, "The filepath must be specified when generating a pre-signed URL");
        if (req.getExpiration() == null) {
            req.setExpiration(new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L));
        }
        HttpMethodName httpMethod = req.getMethod();
        CosHttpRequest<GeneratePresignedUrlRequest> request = this.createRequest(bucketName, key, req, httpMethod);
        COSClient.addParameterIfNotNull(request, "versionId", req.getVersionId());
        for (Map.Entry<String, String> entry : req.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        COSClient.addHeaderIfNotNull(request, "Content-Type", req.getContentType());
        COSClient.addHeaderIfNotNull(request, "Content-MD5", req.getContentMd5());
        Map<String, String> customHeaders = req.getCustomRequestHeaders();
        if (customHeaders != null) {
            for (Map.Entry<String, String> entry : customHeaders.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!signHost.booleanValue() && (map = request.getHeaders()).containsKey("Host")) {
            map.remove("Host");
        }
        COSClient.addResponseHeaderParameters(request, req.getResponseHeaders());
        COSSigner cOSSigner = new COSSigner();
        COSCredentials cOSCredentials = this.fetchCredential();
        String authStr = cOSSigner.buildAuthorizationStr(request.getHttpMethod(), request.getResourcePath(), request.getHeaders(), request.getParameters(), cOSCredentials, req.getExpiration(), signHost);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.clientConfig.getHttpProtocol().toString()).append("://");
        strBuilder.append(this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(this.formatBucket(bucketName, cOSCredentials.getCOSAppId())));
        strBuilder.append(UrlEncoderUtils.encodeUrlPath(this.formatKey(key)));
        boolean hasAppendFirstParameter = false;
        if (authStr != null) {
            if (req.isSignPrefixMode()) {
                strBuilder.append("?sign=").append(UrlEncoderUtils.encode(authStr));
            } else {
                String[] authParts = authStr.split("&");
                String[] stringArray = new String[authParts.length];
                for (int i = 0; i < authParts.length; ++i) {
                    String[] kv = authParts[i].split("=", 2);
                    if (kv.length == 2) {
                        stringArray[i] = StringUtils.join("=", UrlEncoderUtils.encode(kv[0]), UrlEncoderUtils.encode(kv[1]));
                        continue;
                    }
                    if (kv.length != 1) continue;
                    stringArray[i] = StringUtils.join("=", UrlEncoderUtils.encode(kv[0]));
                }
                authStr = StringUtils.join("&", stringArray);
                strBuilder.append("?").append(authStr);
            }
            if (cOSCredentials instanceof COSSessionCredentials) {
                strBuilder.append("&").append("x-cos-security-token").append("=").append(UrlEncoderUtils.encode(((COSSessionCredentials)cOSCredentials).getSessionToken()));
            }
            hasAppendFirstParameter = true;
        }
        for (Map.Entry entry : request.getParameters().entrySet()) {
            String paramKey = (String)entry.getKey();
            String paramValue = (String)entry.getValue();
            if (!hasAppendFirstParameter) {
                strBuilder.append("?");
                hasAppendFirstParameter = true;
            } else {
                strBuilder.append("&");
            }
            strBuilder.append(UrlEncoderUtils.encode(paramKey));
            if (paramValue == null) continue;
            strBuilder.append("=").append(UrlEncoderUtils.encode(paramValue));
        }
        try {
            return new URL(strBuilder.toString());
        }
        catch (MalformedURLException e) {
            throw new CosClientException(e.toString());
        }
    }

    @Override
    public void restoreObject(String bucketName, String key, int expirationInDays) throws CosClientException, CosServiceException {
        this.restoreObject(new RestoreObjectRequest(bucketName, key, expirationInDays));
    }

    @Override
    public void restoreObject(RestoreObjectRequest restoreObjectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(restoreObjectRequest, "The RestoreObjectRequest parameter must be specified when restore a object.");
        String bucketName = restoreObjectRequest.getBucketName();
        String key = restoreObjectRequest.getKey();
        String versionId = restoreObjectRequest.getVersionId();
        int expirationIndays = restoreObjectRequest.getExpirationInDays();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when copying a cas object");
        this.rejectNull(key, "The key parameter must be specified when copying a cas object");
        if (expirationIndays == -1) {
            throw new IllegalArgumentException("The expiration in days parameter must be specified when copying a cas object");
        }
        CosHttpRequest<RestoreObjectRequest> request = this.createRequest(bucketName, key, restoreObjectRequest, HttpMethodName.POST);
        request.addParameter("restore", null);
        COSClient.addParameterIfNotNull(request, "versionId", versionId);
        byte[] content = RequestXmlFactory.convertToXmlByteArray(restoreObjectRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void updateObjectMetaData(String bucketName, String key, ObjectMetadata objectMetadata) throws CosClientException, CosServiceException {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(bucketName, key, bucketName, key);
        copyObjectRequest.setNewObjectMetadata(objectMetadata);
        this.copyObject(copyObjectRequest);
    }

    @Override
    public void setBucketPolicy(String bucketName, String policyText) throws CosClientException, CosServiceException {
        this.setBucketPolicy(new SetBucketPolicyRequest(bucketName, policyText));
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketLoggingConfiguration(new GetBucketLoggingConfigurationRequest(bucketName));
    }

    @Override
    public BucketLoggingConfiguration getBucketLoggingConfiguration(GetBucketLoggingConfigurationRequest getBucketLoggingConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketLoggingConfigurationRequest, "The request object parameter getBucketLoggingConfigurationRequest must be specifed.");
        String bucketName = getBucketLoggingConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's logging status");
        CosHttpRequest<GetBucketLoggingConfigurationRequest> request = this.createRequest(bucketName, null, getBucketLoggingConfigurationRequest, HttpMethodName.GET);
        request.addParameter("logging", null);
        return this.invoke(request, new Unmarshallers.BucketLoggingConfigurationnmarshaller());
    }

    @Override
    public void setBucketLoggingConfiguration(SetBucketLoggingConfigurationRequest setBucketLoggingConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketLoggingConfigurationRequest, "The set bucket logging configuration request object must be specified when enabling server access logging");
        String bucketName = setBucketLoggingConfigurationRequest.getBucketName();
        BucketLoggingConfiguration loggingConfiguration = setBucketLoggingConfigurationRequest.getLoggingConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when enabling server access logging");
        this.rejectNull(loggingConfiguration, "The logging configuration parameter must be specified when enabling server access logging");
        CosHttpRequest<SetBucketLoggingConfigurationRequest> request = this.createRequest(bucketName, null, setBucketLoggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("logging", null);
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(loggingConfiguration);
        request.setContent(new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketPolicy(SetBucketPolicyRequest setBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketPolicyRequest, "The request object must be specified when setting a bucket policy");
        String bucketName = setBucketPolicyRequest.getBucketName();
        String policyText = setBucketPolicyRequest.getPolicyText();
        this.rejectNull(bucketName, "The bucket name must be specified when setting a bucket policy");
        this.rejectNull(policyText, "The policy text must be specified when setting a bucket policy");
        CosHttpRequest<SetBucketPolicyRequest> request = this.createRequest(bucketName, null, setBucketPolicyRequest, HttpMethodName.PUT);
        request.addParameter("policy", null);
        request.setContent(new ByteArrayInputStream(policyText.getBytes(StringUtils.UTF8)));
        request.addHeader("Content-Length", String.valueOf(policyText.length()));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketPolicy getBucketPolicy(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketPolicy(new GetBucketPolicyRequest(bucketName));
    }

    @Override
    public BucketPolicy getBucketPolicy(GetBucketPolicyRequest getBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketPolicyRequest, "The request object must be specified when getting a bucket policy");
        String bucketName = getBucketPolicyRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when getting a bucket policy");
        CosHttpRequest<GetBucketPolicyRequest> request = this.createRequest(bucketName, null, getBucketPolicyRequest, HttpMethodName.GET);
        request.addParameter("policy", null);
        BucketPolicy result = new BucketPolicy();
        try {
            String policyText = this.invoke(request, new COSStringResponseHandler());
            result.setPolicyText(policyText);
            return result;
        }
        catch (CosServiceException cse) {
            if (cse.getErrorCode().equals("NoSuchBucketPolicy")) {
                return result;
            }
            throw cse;
        }
    }

    @Override
    public void deleteBucketPolicy(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketPolicy(new DeleteBucketPolicyRequest(bucketName));
    }

    @Override
    public void deleteBucketPolicy(DeleteBucketPolicyRequest deleteBucketPolicyRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketPolicyRequest, "The request object must be specified when deleting a bucket policy");
        String bucketName = deleteBucketPolicyRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when deleting a bucket policy");
        CosHttpRequest<DeleteBucketPolicyRequest> request = this.createRequest(bucketName, null, deleteBucketPolicyRequest, HttpMethodName.DELETE);
        request.addParameter("policy", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketWebsiteConfiguration(new GetBucketWebsiteConfigurationRequest(bucketName));
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(GetBucketWebsiteConfigurationRequest getBucketWebsiteConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketWebsiteConfigurationRequest, "The request object parameter getBucketWebsiteConfigurationRequest must be specified.");
        String bucketName = getBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's website configuration");
        CosHttpRequest<GetBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, getBucketWebsiteConfigurationRequest, HttpMethodName.GET);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        try {
            return this.invoke(request, new Unmarshallers.BucketWebsiteConfigurationUnmarshaller());
        }
        catch (CosServiceException ase) {
            if (ase.getStatusCode() == 404) {
                return null;
            }
            throw ase;
        }
    }

    @Override
    public void setBucketWebsiteConfiguration(String bucketName, BucketWebsiteConfiguration configuration) throws CosClientException, CosServiceException {
        this.setBucketWebsiteConfiguration(new SetBucketWebsiteConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketWebsiteConfiguration(SetBucketWebsiteConfigurationRequest setBucketWebsiteConfigurationRequest) throws CosClientException, CosServiceException {
        String bucketName = setBucketWebsiteConfigurationRequest.getBucketName();
        BucketWebsiteConfiguration configuration = setBucketWebsiteConfigurationRequest.getConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's website configuration");
        this.rejectNull(configuration, "The bucket website configuration parameter must be specified when setting a bucket's website configuration");
        if (configuration.getRedirectAllRequestsTo() == null) {
            this.rejectNull(configuration.getIndexDocumentSuffix(), "The bucket website configuration parameter must specify the index document suffix when setting a bucket's website configuration");
        }
        CosHttpRequest<SetBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, setBucketWebsiteConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(configuration);
        request.setContent(new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketWebsiteConfiguration(new DeleteBucketWebsiteConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketWebsiteConfiguration(DeleteBucketWebsiteConfigurationRequest deleteBucketWebsiteConfigurationRequest) throws CosClientException, CosServiceException {
        String bucketName = deleteBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting a bucket's website configuration");
        CosHttpRequest<DeleteBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketWebsiteConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketDomainConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.deleteBucketDomainConfiguration(new DeleteBucketDomainConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketDomainConfiguration(DeleteBucketDomainConfigurationRequest deleteBucketDomainConfigurationRequest) {
        String bucketName = deleteBucketDomainConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting a bucket's domain configuration");
        CosHttpRequest<DeleteBucketDomainConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketDomainConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("domain", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketDomainConfiguration(String bucketName, BucketDomainConfiguration configuration) throws CosClientException, CosServiceException {
        this.setBucketDomainConfiguration(new SetBucketDomainConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketDomainConfiguration(SetBucketDomainConfigurationRequest setBucketDomainConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketDomainConfigurationRequest, "The request object parameter setBucketDomainConfigurationRequest must be specified.");
        String bucketName = setBucketDomainConfigurationRequest.getBucketName();
        BucketDomainConfiguration configuration = setBucketDomainConfigurationRequest.getConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's domain configuration");
        this.rejectNull(configuration, "The bucket domain configuration parameter must be specified when setting a bucket's domain configuration");
        this.rejectNull(configuration.getDomainRules(), "The bucket domain rules must specify the index document suffix when setting a bucket's domain configuration");
        CosHttpRequest<SetBucketDomainConfigurationRequest> request = this.createRequest(bucketName, null, setBucketDomainConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("domain", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(configuration);
        request.setContent(new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketDomainConfiguration getBucketDomainConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketDomainConfiguration(new GetBucketDomainConfigurationRequest(bucketName));
    }

    @Override
    public BucketDomainConfiguration getBucketDomainConfiguration(GetBucketDomainConfigurationRequest getBucketDomainConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketDomainConfigurationRequest, "The request object parameter getBucketDomainConfigurationRequest must be specified.");
        String bucketName = getBucketDomainConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket domain configuration.");
        CosHttpRequest<GetBucketDomainConfigurationRequest> request = this.createRequest(bucketName, null, getBucketDomainConfigurationRequest, HttpMethodName.GET);
        request.addParameter("domain", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketDomainConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public void setBucketDomainCertificate(String bucketName, BucketPutDomainCertificate domainCertificate) throws CosClientException, CosServiceException {
        this.setBucketDomainCertificate(new SetBucketDomainCertificateRequest(bucketName, domainCertificate));
    }

    @Override
    public void setBucketDomainCertificate(SetBucketDomainCertificateRequest setBucketDomainCertificateRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketDomainCertificateRequest, "The request object parameter setBucketDomainCertificateRequest must be specified.");
        String bucketName = setBucketDomainCertificateRequest.getBucketName();
        BucketPutDomainCertificate domainCertificate = setBucketDomainCertificateRequest.getBucketPutDomainCertificate();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's domain certificate");
        this.rejectNull(domainCertificate, "The bucket domain certificate parameter must be specified when setting a bucket's domain certificate");
        this.rejectNull(domainCertificate.getBucketDomainCertificateInfo(), "The bucket domain certificate parameter must be specified when setting a bucket's domain certificate");
        this.rejectNull(domainCertificate.getDomainList(), "The bucket domain lists must specify the index document suffix when setting a bucket's domain certificate");
        CosHttpRequest<SetBucketDomainCertificateRequest> request = this.createRequest(bucketName, null, setBucketDomainCertificateRequest, HttpMethodName.PUT);
        request.addParameter("domaincertificate", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(domainCertificate);
        request.setContent(new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketGetDomainCertificate getBucketDomainCertificate(String bucketName, String domainName) throws CosClientException, CosServiceException {
        BucketDomainCertificateRequest getBucketDomainCertificateRequest = new BucketDomainCertificateRequest(bucketName);
        getBucketDomainCertificateRequest.setDomainName(domainName);
        return this.getBucketDomainCertificate(getBucketDomainCertificateRequest);
    }

    @Override
    public BucketGetDomainCertificate getBucketDomainCertificate(BucketDomainCertificateRequest getBucketDomainCertificateRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketDomainCertificateRequest, "The request object parameter getBucketDomainCertificateRequest must be specified.");
        String bucketName = getBucketDomainCertificateRequest.getBucketName();
        String domainName = getBucketDomainCertificateRequest.getDomainName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket domain Certificate.");
        this.rejectNull(domainName, "The domain name must be specified when retrieving the bucket domain Certificate.");
        CosHttpRequest<BucketDomainCertificateRequest> request = this.createRequest(bucketName, null, getBucketDomainCertificateRequest, HttpMethodName.GET);
        request.addParameter("domaincertificate", null);
        request.addParameter("domainname", domainName);
        try {
            return this.invoke(request, new Unmarshallers.BucketDomainCertificateUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public void deleteBucketDomainCertificate(String bucketName, String domainName) throws CosClientException, CosServiceException {
        BucketDomainCertificateRequest deleteBucketDomainCertificateRequest = new BucketDomainCertificateRequest(bucketName);
        deleteBucketDomainCertificateRequest.setDomainName(domainName);
        this.deleteBucketDomainCertificate(deleteBucketDomainCertificateRequest);
    }

    @Override
    public void deleteBucketDomainCertificate(BucketDomainCertificateRequest deleteBucketDomainCertificateRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketDomainCertificateRequest, "The request object parameter deleteBucketDomainCertificateRequest must be specified.");
        String bucketName = deleteBucketDomainCertificateRequest.getBucketName();
        String domainName = deleteBucketDomainCertificateRequest.getDomainName();
        this.rejectNull(bucketName, "The bucket name must be specified when removing the bucket domain Certificate.");
        this.rejectNull(domainName, "The domain name must be specified when removing the bucket domain Certificate.");
        CosHttpRequest<BucketDomainCertificateRequest> request = this.createRequest(bucketName, null, deleteBucketDomainCertificateRequest, HttpMethodName.DELETE);
        request.addParameter("domaincertificate", null);
        request.addParameter("domainname", domainName);
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void setBucketRefererConfiguration(String bucketName, BucketRefererConfiguration configuration) throws CosClientException, CosServiceException {
        this.setBucketRefererConfiguration(new SetBucketRefererConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketRefererConfiguration(SetBucketRefererConfigurationRequest setBucketRefererConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketRefererConfigurationRequest, "The request object parameter setBucketRefererConfigurationRequest must be specified.");
        String bucketName = setBucketRefererConfigurationRequest.getBucketName();
        BucketRefererConfiguration configuration = setBucketRefererConfigurationRequest.getConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's referer configuration");
        this.rejectNull(configuration, "The bucket domain configuration parameter must be specified when setting a bucket's referer configuration");
        CosHttpRequest<SetBucketRefererConfigurationRequest> request = this.createRequest(bucketName, null, setBucketRefererConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("referer", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(configuration);
        request.setContent(new ByteArrayInputStream(bytes));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(bytes);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public BucketRefererConfiguration getBucketRefererConfiguration(String bucketName) throws CosClientException, CosServiceException {
        return this.getBucketRefererConfiguration(new GetBucketRefererConfigurationRequest(bucketName));
    }

    @Override
    public BucketRefererConfiguration getBucketRefererConfiguration(GetBucketRefererConfigurationRequest getBucketRefererConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketRefererConfigurationRequest, "The request object parameter getBucketRefererConfigurationRequest must be specified.");
        String bucketName = getBucketRefererConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket domain configuration.");
        CosHttpRequest<GetBucketRefererConfigurationRequest> request = this.createRequest(bucketName, null, getBucketRefererConfigurationRequest, HttpMethodName.GET);
        request.addParameter("referer", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketRefererConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(String bucketName, String id) throws CosClientException, CosServiceException {
        return this.deleteBucketInventoryConfiguration(new DeleteBucketInventoryConfigurationRequest(bucketName, id));
    }

    @Override
    public DeleteBucketInventoryConfigurationResult deleteBucketInventoryConfiguration(DeleteBucketInventoryConfigurationRequest deleteBucketInventoryConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(deleteBucketInventoryConfigurationRequest, "The request cannot be null");
        this.rejectNull(deleteBucketInventoryConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        this.rejectNull(deleteBucketInventoryConfigurationRequest.getId(), "The id cannot be null");
        String bucketName = deleteBucketInventoryConfigurationRequest.getBucketName();
        String id = deleteBucketInventoryConfigurationRequest.getId();
        CosHttpRequest<DeleteBucketInventoryConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketInventoryConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("inventory", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.DeleteBucketInventoryConfigurationUnmarshaller());
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(String bucketName, String id) throws CosClientException, CosServiceException {
        return this.getBucketInventoryConfiguration(new GetBucketInventoryConfigurationRequest(bucketName, id));
    }

    @Override
    public GetBucketInventoryConfigurationResult getBucketInventoryConfiguration(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(getBucketInventoryConfigurationRequest, "The request cannot be null");
        this.rejectNull(getBucketInventoryConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        this.rejectNull(getBucketInventoryConfigurationRequest.getId(), "The id cannot be null");
        String bucketName = getBucketInventoryConfigurationRequest.getBucketName();
        String id = getBucketInventoryConfigurationRequest.getId();
        CosHttpRequest<GetBucketInventoryConfigurationRequest> request = this.createRequest(bucketName, null, getBucketInventoryConfigurationRequest, HttpMethodName.GET);
        request.addParameter("inventory", null);
        request.addParameter("id", id);
        return this.invoke(request, new Unmarshallers.GetBucketInventoryConfigurationUnmarshaller());
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(String bucketName, InventoryConfiguration inventoryConfiguration) throws CosClientException, CosServiceException {
        return this.setBucketInventoryConfiguration(new SetBucketInventoryConfigurationRequest(bucketName, inventoryConfiguration));
    }

    @Override
    public SetBucketInventoryConfigurationResult setBucketInventoryConfiguration(SetBucketInventoryConfigurationRequest setBucketInventoryConfigurationRequest) throws CosClientException, CosServiceException {
        this.rejectNull(setBucketInventoryConfigurationRequest, "The request cannot be null");
        this.rejectNull(setBucketInventoryConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        this.rejectNull(setBucketInventoryConfigurationRequest.getInventoryConfiguration(), "The inventoryConfiguration cannot be null");
        this.rejectNull(setBucketInventoryConfigurationRequest.getInventoryConfiguration().getId(), "The inventoryConfiguration.id cannot be null");
        String bucketName = setBucketInventoryConfigurationRequest.getBucketName();
        InventoryConfiguration inventoryConfiguration = setBucketInventoryConfigurationRequest.getInventoryConfiguration();
        String id = inventoryConfiguration.getId();
        CosHttpRequest<SetBucketInventoryConfigurationRequest> request = this.createRequest(bucketName, null, setBucketInventoryConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("inventory", null);
        request.addParameter("id", id);
        if (!setBucketInventoryConfigurationRequest.IsUseInventoryText()) {
            byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(inventoryConfiguration);
            request.addHeader("Content-Length", String.valueOf(bytes.length));
            request.addHeader("Content-Type", "application/xml");
            request.setContent(new ByteArrayInputStream(bytes));
        } else {
            String contentStr = setBucketInventoryConfigurationRequest.getInventoryText();
            if (contentStr == null || contentStr.length() <= 0) {
                throw new IllegalArgumentException("The inventory text should be specified");
            }
            request.addHeader("Content-Length", String.valueOf(contentStr.length()));
            request.addHeader("Content-Type", "application/xml");
            request.setContent(new ByteArrayInputStream(contentStr.getBytes(StringUtils.UTF8)));
        }
        return this.invoke(request, new Unmarshallers.SetBucketInventoryConfigurationUnmarshaller());
    }

    @Override
    public ListBucketInventoryConfigurationsResult listBucketInventoryConfigurations(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) throws CosClientException, CosServiceException {
        this.rejectNull(listBucketInventoryConfigurationsRequest, "The request cannot be null");
        this.rejectNull(listBucketInventoryConfigurationsRequest.getBucketName(), "The bucketName cannot be null");
        String bucketName = listBucketInventoryConfigurationsRequest.getBucketName();
        CosHttpRequest<ListBucketInventoryConfigurationsRequest> request = this.createRequest(bucketName, null, listBucketInventoryConfigurationsRequest, HttpMethodName.GET);
        request.addParameter("inventory", null);
        COSClient.addParameterIfNotNull(request, "continuation-token", listBucketInventoryConfigurationsRequest.getContinuationToken());
        return this.invoke(request, new Unmarshallers.ListBucketInventoryConfigurationsUnmarshaller());
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(String bucketName) {
        return this.getBucketTaggingConfiguration(new GetBucketTaggingConfigurationRequest(bucketName));
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(GetBucketTaggingConfigurationRequest getBucketTaggingConfigurationRequest) {
        this.rejectNull(getBucketTaggingConfigurationRequest, "The request object parameter getBucketTaggingConfigurationRequest must be specifed.");
        String bucketName = getBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket tagging configuration.");
        CosHttpRequest<GetBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, getBucketTaggingConfigurationRequest, HttpMethodName.GET);
        request.addParameter("tagging", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketTaggingConfigurationUnmarshaller());
        }
        catch (CosServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void setBucketTaggingConfiguration(String bucketName, BucketTaggingConfiguration bucketTaggingConfiguration) {
        this.setBucketTaggingConfiguration(new SetBucketTaggingConfigurationRequest(bucketName, bucketTaggingConfiguration));
    }

    @Override
    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest) {
        this.rejectNull(setBucketTaggingConfigurationRequest, "The set bucket tagging configuration request object must be specified.");
        String bucketName = setBucketTaggingConfigurationRequest.getBucketName();
        BucketTaggingConfiguration bucketTaggingConfiguration = setBucketTaggingConfigurationRequest.getTaggingConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket tagging configuration.");
        this.rejectNull(bucketTaggingConfiguration, "The tagging configuration parameter must be specified when setting bucket tagging configuration.");
        CosHttpRequest<SetBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, setBucketTaggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("tagging", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketTaggingConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash(content);
            String md5Base64 = BinaryUtils.toBase64(md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new CosClientException("Couldn't compute md5 sum", e);
        }
        this.invoke(request, this.voidCosResponseHandler);
    }

    @Override
    public void deleteBucketTaggingConfiguration(String bucketName) {
        this.deleteBucketTaggingConfiguration(new DeleteBucketTaggingConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest deleteBucketTaggingConfigurationRequest) {
        this.rejectNull(deleteBucketTaggingConfigurationRequest, "The delete bucket tagging configuration request object must be specified.");
        String bucketName = deleteBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket tagging configuration.");
        CosHttpRequest<DeleteBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketTaggingConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("tagging", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    private void setContent(CosHttpRequest<?> request, byte[] content, String contentType, boolean setMd5) {
        request.setContent(new ByteArrayInputStream(content));
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", contentType);
        if (setMd5) {
            try {
                byte[] md5 = Md5Utils.computeMD5Hash(content);
                String md5Base64 = BinaryUtils.toBase64(md5);
                request.addHeader("Content-MD5", md5Base64);
            }
            catch (Exception e) {
                throw new CosClientException("Couldn't compute md5 sum", e);
            }
        }
    }

    @Override
    public SelectObjectContentResult selectObjectContent(SelectObjectContentRequest selectRequest) throws CosClientException, CosServiceException {
        this.rejectNull(selectRequest, "The request parameter must be specified");
        this.rejectNull(selectRequest.getBucketName(), "The bucket name parameter must be specified when selecting object content.");
        this.rejectNull(selectRequest.getKey(), "The key parameter must be specified when selecting object content.");
        CosHttpRequest<SelectObjectContentRequest> request = this.createRequest(selectRequest.getBucketName(), selectRequest.getKey(), selectRequest, HttpMethodName.POST);
        request.addParameter("select", null);
        request.addParameter("select-type", "2");
        COSClient.populateSSE_C(request, selectRequest.getSSECustomerKey());
        this.setContent(request, RequestXmlFactory.convertToXmlByteArray(selectRequest), ContentType.APPLICATION_XML.toString(), true);
        COSObject result = this.invoke(request, new COSObjectResponseHandler());
        ServiceClientHolderInputStream resultStream = new ServiceClientHolderInputStream(result.getObjectContent(), this);
        return new SelectObjectContentResult().withPayload(new SelectObjectContentEventStream(resultStream));
    }

    @Override
    public GetObjectTaggingResult getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        this.rejectNull(getObjectTaggingRequest, "The request parameter must be specified when getting the object tags");
        this.rejectNull(getObjectTaggingRequest.getBucketName(), "The request bucketName must be specified when getting the object tags");
        this.rejectNull(getObjectTaggingRequest.getKey(), "The request key must be specified when getting the object tags");
        CosHttpRequest<GetObjectTaggingRequest> request = this.createRequest(getObjectTaggingRequest.getBucketName(), getObjectTaggingRequest.getKey(), getObjectTaggingRequest, HttpMethodName.GET);
        request.addParameter("tagging", null);
        COSClient.addParameterIfNotNull(request, "versionId", getObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<GetObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<GetObjectTaggingResult>(new Unmarshallers.GetObjectTaggingResponseUnmarshaller(), new GetObjectTaggingResponseHeaderHandler());
        return (GetObjectTaggingResult)this.invoke(request, handlerChain);
    }

    @Override
    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) {
        this.rejectNull(setObjectTaggingRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(setObjectTaggingRequest.getBucketName(), "The request bucketName must be specified setting the object tags");
        this.rejectNull(setObjectTaggingRequest.getKey(), "The request key must be specified setting the object tags");
        this.rejectNull(setObjectTaggingRequest.getTagging(), "The request tagging must be specified setting the object tags");
        CosHttpRequest<SetObjectTaggingRequest> request = this.createRequest(setObjectTaggingRequest.getBucketName(), setObjectTaggingRequest.getKey(), setObjectTaggingRequest, HttpMethodName.PUT);
        request.addParameter("tagging", null);
        COSClient.addParameterIfNotNull(request, "versionId", setObjectTaggingRequest.getVersionId());
        byte[] content = new ObjectTaggingXmlFactory().convertToXmlByteArray(setObjectTaggingRequest.getTagging());
        this.setContent(request, content, "application/xml", true);
        ResponseHeaderHandlerChain<SetObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<SetObjectTaggingResult>(new Unmarshallers.SetObjectTaggingResponseUnmarshaller(), new SetObjectTaggingResponseHeaderHandler());
        return (SetObjectTaggingResult)this.invoke(request, handlerChain);
    }

    @Override
    public DeleteObjectTaggingResult deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        this.rejectNull(deleteObjectTaggingRequest, "The request parameter must be specified when delete the object tags");
        this.rejectNull(deleteObjectTaggingRequest.getBucketName(), "The request bucketName must be specified setting the object tags");
        this.rejectNull(deleteObjectTaggingRequest.getKey(), "The request key must be specified setting the object tags");
        CosHttpRequest<DeleteObjectTaggingRequest> request = this.createRequest(deleteObjectTaggingRequest.getBucketName(), deleteObjectTaggingRequest.getKey(), deleteObjectTaggingRequest, HttpMethodName.DELETE);
        request.addParameter("tagging", null);
        COSClient.addParameterIfNotNull(request, "versionId", deleteObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<DeleteObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<DeleteObjectTaggingResult>(new Unmarshallers.DeleteObjectTaggingResponseUnmarshaller(), new DeleteObjectTaggingHeaderHandler());
        return (DeleteObjectTaggingResult)this.invoke(request, handlerChain);
    }

    @Override
    public BucketIntelligentTierConfiguration getBucketIntelligentTierConfiguration(GetBucketIntelligentTierConfigurationRequest getBucketIntelligentTierConfigurationRequest) {
        this.rejectNull(getBucketIntelligentTierConfigurationRequest, "The request cannot be null");
        this.rejectNull(getBucketIntelligentTierConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        String bucketName = getBucketIntelligentTierConfigurationRequest.getBucketName();
        CosHttpRequest<GetBucketIntelligentTierConfigurationRequest> request = this.createRequest(bucketName, null, getBucketIntelligentTierConfigurationRequest, HttpMethodName.GET);
        request.addParameter("intelligenttiering", null);
        return this.invoke(request, new Unmarshallers.GetBucketIntelligentTierConfigurationsUnmarshaller());
    }

    @Override
    public BucketIntelligentTierConfiguration getBucketIntelligentTierConfiguration(String bucketName) {
        return this.getBucketIntelligentTierConfiguration(new GetBucketIntelligentTierConfigurationRequest(bucketName));
    }

    @Override
    public void setBucketIntelligentTieringConfiguration(SetBucketIntelligentTierConfigurationRequest setBucketIntelligentTierConfigurationRequest) {
        this.rejectNull(setBucketIntelligentTierConfigurationRequest, "The request cannot be null");
        this.rejectNull(setBucketIntelligentTierConfigurationRequest.getBucketName(), "The bucketName cannot be null");
        BucketIntelligentTierConfiguration bucketIntelligentTierConfiguration = setBucketIntelligentTierConfigurationRequest.getBucketIntelligentTierConfiguration();
        this.rejectNull(bucketIntelligentTierConfiguration, "Bucket intelligent tier configuration cannot be null");
        String bucketName = setBucketIntelligentTierConfigurationRequest.getBucketName();
        CosHttpRequest<SetBucketIntelligentTierConfigurationRequest> request = this.createRequest(bucketName, null, setBucketIntelligentTierConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("intelligenttiering", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketIntelligentTierConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        this.invoke(request, this.voidCosResponseHandler);
    }

    public List<BucketIntelligentTieringConfiguration> listBucketIntelligentTieringConfiguration(String bucketName) throws CosServiceException, CosClientException {
        this.rejectEmpty(bucketName, "The bucket name parameter must be specified when listing bucket IntelligentTieringConfiguration");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, null, new CosServiceRequest(), HttpMethodName.GET);
        request.addParameter("intelligent-tiering", null);
        try {
            return this.invoke(request, new Unmarshallers.ListBucketTieringConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    @Override
    public MediaJobResponse createMediaJobs(MediaJobsRequest req) {
        this.rejectStartWith(req.getCallBack(), "http", "The CallBack parameter mush start with http or https");
        CosHttpRequest<MediaJobsRequest> request = this.createRequest(req.getBucketName(), "/jobs", req, HttpMethodName.POST);
        this.setContent(request, CIMediaXmlFactory.convertToXmlByteArray(req), "application/xml", false);
        return this.invoke(request, new Unmarshallers.JobCreatUnmarshaller());
    }

    @Override
    public MediaJobResponseV2 createMediaJobsV2(MediaJobsRequestV2 req) {
        CosHttpRequest<MediaJobsRequestV2> request = this.createRequest(req.getBucketName(), "/jobs", req, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(req), "application/xml", false);
        return (MediaJobResponseV2)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<MediaJobResponseV2>(MediaJobResponseV2.class));
    }

    @Override
    public Boolean cancelMediaJob(MediaJobsRequest req) {
        this.checkCIRequestCommon(req);
        this.rejectNull(req.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<MediaJobsRequest> request = this.createRequest(req.getBucketName(), "/jobs/" + req.getJobId(), req, HttpMethodName.PUT);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public MediaJobResponse describeMediaJob(MediaJobsRequest req) {
        this.checkCIRequestCommon(req);
        this.rejectNull(req.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<MediaJobsRequest> request = this.createRequest(req.getBucketName(), "/jobs/" + req.getJobId(), req, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.JobUnmarshaller());
    }

    @Override
    public MediaListJobResponse describeMediaJobs(MediaJobsRequest req) {
        this.checkCIRequestCommon(req);
        CosHttpRequest<MediaJobsRequest> request = this.createRequest(req.getBucketName(), "/jobs", req, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "queueId", req.getQueueId());
        COSClient.addParameterIfNotNull(request, "tag", req.getTag());
        COSClient.addParameterIfNotNull(request, "orderByTime", req.getOrderByTime());
        COSClient.addParameterIfNotNull(request, "nextToken", req.getNextToken());
        COSClient.addParameterIfNotNull(request, "size", req.getSize().toString());
        COSClient.addParameterIfNotNull(request, "states", req.getStates());
        COSClient.addParameterIfNotNull(request, "startCreationTime", req.getStartCreationTime());
        COSClient.addParameterIfNotNull(request, "endCreationTime", req.getEndCreationTime());
        MediaListJobResponse response = this.invoke(request, new Unmarshallers.ListJobUnmarshaller());
        this.checkMediaListJobResponse(response);
        return response;
    }

    @Override
    public MediaListQueueResponse describeMediaQueues(MediaQueueRequest req) {
        this.checkCIRequestCommon(req);
        CosHttpRequest<MediaQueueRequest> request = this.createRequest(req.getBucketName(), "/queue", req, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "queueIds", req.getQueueId());
        COSClient.addParameterIfNotNull(request, "state", req.getState());
        COSClient.addParameterIfNotNull(request, "pageNumber", req.getPageNumber());
        COSClient.addParameterIfNotNull(request, "pageSize", req.getPageSize());
        return this.invoke(request, new Unmarshallers.ListQueueUnmarshaller());
    }

    @Override
    public MediaQueueResponse updateMediaQueue(MediaQueueRequest mediaQueueRequest) {
        CosHttpRequest<MediaQueueRequest> request = this.createRequest(mediaQueueRequest.getBucketName(), "/queue/" + mediaQueueRequest.getQueueId(), mediaQueueRequest, HttpMethodName.PUT);
        this.setContent(request, RequestXmlFactory.convertToXmlByteArray(mediaQueueRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.QueueUnmarshaller());
    }

    @Override
    public MediaBucketResponse describeMediaBuckets(MediaBucketRequest mediaBucketRequest) {
        this.checkCIRequestCommon(mediaBucketRequest);
        CosHttpRequest<MediaBucketRequest> request = this.createRequest(mediaBucketRequest.getBucketName(), "/mediabucket", mediaBucketRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "regions", mediaBucketRequest.getRegions());
        COSClient.addParameterIfNotNull(request, "bucketNames", mediaBucketRequest.getBucketNames());
        COSClient.addParameterIfNotNull(request, "bucketName", mediaBucketRequest.getBucketName());
        COSClient.addParameterIfNotNull(request, "pageNumber", mediaBucketRequest.getPageNumber());
        COSClient.addParameterIfNotNull(request, "pageSize", mediaBucketRequest.getPageSize());
        return this.invoke(request, new Unmarshallers.ListBucketUnmarshaller());
    }

    @Override
    public MediaTemplateResponse createMediaTemplate(MediaTemplateRequest templateRequest) {
        this.rejectNull(templateRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<MediaTemplateRequest> request = this.createRequest(templateRequest.getBucketName(), "/template", templateRequest, HttpMethodName.POST);
        this.setContent(request, CIMediaXmlFactory.convertToXmlByteArray(templateRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.TemplateUnmarshaller());
    }

    @Override
    public Boolean deleteMediaTemplate(MediaTemplateRequest request) {
        this.checkCIRequestCommon(request);
        this.rejectNull(request.getTemplateId(), "The templateId parameter must be specified setting the object tags");
        CosHttpRequest<MediaTemplateRequest> httpRequest = this.createRequest(request.getBucketName(), "/template/" + request.getTemplateId(), request, HttpMethodName.DELETE);
        this.invoke(httpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public MediaListTemplateResponse describeMediaTemplates(MediaTemplateRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<MediaTemplateRequest> httpRequest = this.createRequest(request.getBucketName(), "/template", request, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(httpRequest, "tag", request.getTag());
        COSClient.addParameterIfNotNull(httpRequest, "category", request.getCategory());
        COSClient.addParameterIfNotNull(httpRequest, "ids", request.getIds());
        COSClient.addParameterIfNotNull(httpRequest, "name", request.getName());
        COSClient.addParameterIfNotNull(httpRequest, "pageNumber", request.getPageNumber());
        COSClient.addParameterIfNotNull(httpRequest, "pageSize", request.getPageSize());
        return this.invoke(httpRequest, new Unmarshallers.ListTemplateUnmarshaller());
    }

    @Override
    public Boolean updateMediaTemplate(MediaTemplateRequest request) {
        this.checkCIRequestCommon(request);
        this.rejectNull(request.getTag(), "The tag parameter must be specified setting the object tags");
        this.rejectNull(request.getName(), "The name parameter must be specified setting the object tags");
        CosHttpRequest<MediaTemplateRequest> httpRequest = this.createRequest(request.getBucketName(), "/template/" + request.getTemplateId(), request, HttpMethodName.PUT);
        this.setContent(httpRequest, RequestXmlFactory.convertToXmlByteArray(request), "application/xml", false);
        this.invoke(httpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public SnapshotResponse generateSnapshot(SnapshotRequest request) {
        this.checkCIRequestCommon(request);
        this.rejectNull(request.getTime(), "The time parameter must be specified setting the object tags");
        this.rejectNull(request.getInput().getObject(), "The input.object parameter must be specified setting the object tags");
        CosHttpRequest<SnapshotRequest> httpRequest = this.createRequest(request.getBucketName(), "/snapshot", request, HttpMethodName.POST);
        this.setContent(httpRequest, RequestXmlFactory.convertToXmlByteArray(request), "application/xml", false);
        return this.invoke(httpRequest, new Unmarshallers.SnapshotUnmarshaller());
    }

    @Override
    public MediaInfoResponse generateMediainfo(MediaInfoRequest request) {
        this.checkCIRequestCommon(request);
        this.rejectNull(request.getInput().getObject(), "The input.object parameter must be specified setting the object tags");
        CosHttpRequest<MediaInfoRequest> httpRequest = this.createRequest(request.getBucketName(), "/mediainfo", request, HttpMethodName.POST);
        this.setContent(httpRequest, CIAuditingXmlFactoryV2.convertToXmlByteArray(request), "application/xml", false);
        return (MediaInfoResponse)this.invoke(httpRequest, new Unmarshallers.CICommonUnmarshaller<MediaInfoResponse>(MediaInfoResponse.class));
    }

    @Override
    public Boolean deleteWorkflow(MediaWorkflowListRequest request) {
        this.checkCIRequestCommon(request);
        this.rejectNull(request.getWorkflowId(), "The request parameter must be specified when delete the object tags");
        CosHttpRequest<MediaWorkflowListRequest> httpRequest = this.createRequest(request.getBucketName(), "/workflow/" + request.getWorkflowId(), request, HttpMethodName.DELETE);
        this.invoke(httpRequest, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public MediaWorkflowListResponse describeWorkflow(MediaWorkflowListRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<MediaWorkflowListRequest> httpRequest = this.createRequest(request.getBucketName(), "/workflow", request, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(httpRequest, "ids", request.getIds());
        COSClient.addParameterIfNotNull(httpRequest, "name", request.getName());
        COSClient.addParameterIfNotNull(httpRequest, "pageNumber", request.getPageNumber());
        COSClient.addParameterIfNotNull(httpRequest, "pageSize", request.getPageSize());
        return this.invoke(httpRequest, new Unmarshallers.WorkflowListUnmarshaller());
    }

    @Override
    public MediaWorkflowExecutionResponse describeWorkflowExecution(MediaWorkflowListRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<MediaWorkflowListRequest> httpRequest = this.createRequest(request.getBucketName(), "/workflowexecution/" + request.getRunId(), request, HttpMethodName.GET);
        return this.invoke(httpRequest, new Unmarshallers.WorkflowExecutionUnmarshaller());
    }

    @Override
    public MediaWorkflowExecutionsResponse describeWorkflowExecutions(MediaWorkflowListRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<MediaWorkflowListRequest> httpRequest = this.createRequest(request.getBucketName(), "/workflowexecution", request, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(httpRequest, "workflowId", request.getWorkflowId());
        COSClient.addParameterIfNotNull(httpRequest, "name", request.getName());
        COSClient.addParameterIfNotNull(httpRequest, "orderByTime", request.getOrderByTime());
        COSClient.addParameterIfNotNull(httpRequest, "size", request.getSize());
        COSClient.addParameterIfNotNull(httpRequest, "states", request.getStates());
        COSClient.addParameterIfNotNull(httpRequest, "startCreationTime", request.getStartCreationTime());
        COSClient.addParameterIfNotNull(httpRequest, "endCreationTime", request.getEndCreationTime());
        COSClient.addParameterIfNotNull(httpRequest, "nextToken", request.getNextToken());
        return this.invoke(httpRequest, new Unmarshallers.WorkflowExecutionsUnmarshaller());
    }

    @Override
    public DocJobResponse createDocProcessJobs(DocJobRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<DocJobRequest> httpRequest = this.createRequest(request.getBucketName(), "/doc_jobs", request, HttpMethodName.POST);
        this.setContent(httpRequest, RequestXmlFactory.convertToXmlByteArray(request), "application/xml", false);
        return this.invoke(httpRequest, new Unmarshallers.DocProcessJobUnmarshaller());
    }

    @Override
    public DocJobResponse describeDocProcessJob(DocJobRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<DocJobRequest> httpRequest = this.createRequest(request.getBucketName(), "/doc_jobs/" + request.getJobId(), request, HttpMethodName.GET);
        return this.invoke(httpRequest, new Unmarshallers.DescribeDocJobUnmarshaller());
    }

    @Override
    public DocJobListResponse describeDocProcessJobs(DocJobListRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<DocJobListRequest> httpRequest = this.createRequest(request.getBucketName(), "/doc_jobs", request, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(httpRequest, "queueId", request.getQueueId());
        COSClient.addParameterIfNotNull(httpRequest, "tag", request.getTag());
        COSClient.addParameterIfNotNull(httpRequest, "orderByTime", request.getOrderByTime());
        COSClient.addParameterIfNotNull(httpRequest, "nextToken", request.getNextToken());
        COSClient.addParameterIfNotNull(httpRequest, "size", request.getSize().toString());
        COSClient.addParameterIfNotNull(httpRequest, "states", request.getStates());
        COSClient.addParameterIfNotNull(httpRequest, "startCreationTime", request.getStartCreationTime());
        COSClient.addParameterIfNotNull(httpRequest, "endCreationTime", request.getEndCreationTime());
        return this.invoke(httpRequest, new Unmarshallers.DescribeDocJobsUnmarshaller());
    }

    @Override
    public DocListQueueResponse describeDocProcessQueues(DocQueueRequest docRequest) {
        this.checkCIRequestCommon(docRequest);
        CosHttpRequest<DocQueueRequest> request = this.createRequest(docRequest.getBucketName(), "/docqueue", docRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "queueIds", docRequest.getQueueId());
        COSClient.addParameterIfNotNull(request, "state", docRequest.getState());
        COSClient.addParameterIfNotNull(request, "pageNumber", docRequest.getPageNumber());
        COSClient.addParameterIfNotNull(request, "pageSize", docRequest.getPageSize());
        return this.invoke(request, new Unmarshallers.DocListQueueUnmarshaller());
    }

    @Override
    public boolean updateDocProcessQueue(DocQueueRequest docRequest) {
        this.checkCIRequestCommon(docRequest);
        CosHttpRequest<DocQueueRequest> request = this.createRequest(docRequest.getBucketName(), "/docqueue/" + docRequest.getQueueId(), docRequest, HttpMethodName.PUT);
        this.setContent(request, RequestXmlFactory.convertToXmlByteArray(docRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public DocBucketResponse describeDocProcessBuckets(DocBucketRequest docRequest) {
        this.checkCIRequestCommon(docRequest);
        CosHttpRequest<DocBucketRequest> request = this.createRequest(docRequest.getBucketName(), "/docbucket", docRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "regions", docRequest.getRegions());
        COSClient.addParameterIfNotNull(request, "bucketNames", docRequest.getBucketNames());
        COSClient.addParameterIfNotNull(request, "pageNumber", docRequest.getPageNumber());
        COSClient.addParameterIfNotNull(request, "pageSize", docRequest.getPageSize());
        return this.invoke(request, new Unmarshallers.DocListBucketUnmarshaller());
    }

    @Override
    public CIUploadResult processImage(ImageProcessRequest imageProcessRequest) {
        ObjectMetadata returnedMetadata;
        this.rejectNull(imageProcessRequest, "The ImageProcessRequest parameter must be specified when requesting an object's metadata");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object's metadata");
        String bucketName = imageProcessRequest.getBucketName();
        String key = imageProcessRequest.getKey();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(key, "The key parameter must be specified when requesting an object's metadata");
        CosHttpRequest<ImageProcessRequest> request = this.createRequest(bucketName, key, imageProcessRequest, HttpMethodName.POST);
        request.addParameter("image_process", null);
        request.addHeader("Pic-Operations", Jackson.toJsonString(imageProcessRequest.getPicOperations()));
        Map<String, String> customRequestHeader = imageProcessRequest.getCustomRequestHeader();
        if (customRequestHeader != null) {
            for (String headerKey : customRequestHeader.keySet()) {
                request.addHeader(headerKey, customRequestHeader.get(headerKey));
            }
        }
        if ((returnedMetadata = (ObjectMetadata)this.invoke(request, new ResponseHeaderHandlerChain<ObjectMetadata>(new Unmarshallers.ImagePersistenceUnmarshaller(), new CosMetadataResponseHandler()))).getRequestId() != null) {
            returnedMetadata.getCiUploadResult().setRequestId(returnedMetadata.getRequestId());
        }
        return returnedMetadata.getCiUploadResult();
    }

    @Override
    public ImageAuditingResponse imageAuditing(ImageAuditingRequest imageAuditingRequest) {
        this.rejectNull(imageAuditingRequest, "The imageAuditingRequest parameter must be specified setting the object tags");
        this.rejectNull(imageAuditingRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageAuditingRequest> request = this.createRequest(imageAuditingRequest.getBucketName(), imageAuditingRequest.getObjectKey(), imageAuditingRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "sensitive-content-recognition");
        String detectType = imageAuditingRequest.getDetectType();
        if (!"all".equalsIgnoreCase(detectType)) {
            COSClient.addParameterIfNotNull(request, "detect-type", detectType);
        }
        COSClient.addParameterIfNotNull(request, "interval", Integer.toString(imageAuditingRequest.getInterval()));
        COSClient.addParameterIfNotNull(request, "max-frames", Integer.toString(imageAuditingRequest.getMaxFrames()));
        COSClient.addParameterIfNotNull(request, "biz-type", imageAuditingRequest.getBizType());
        COSClient.addParameterIfNotNull(request, "detect-url", imageAuditingRequest.getDetectUrl());
        COSClient.addParameterIfNotNull(request, "large-image-detect", imageAuditingRequest.getLargeImageDetect());
        COSClient.addParameterIfNotNull(request, "dataid", imageAuditingRequest.getDataId());
        COSClient.addParameterIfNotNull(request, "async", imageAuditingRequest.getAsync());
        COSClient.addParameterIfNotNull(request, "callback", imageAuditingRequest.getCallback());
        return this.invoke(request, new Unmarshallers.ImageAuditingUnmarshaller());
    }

    @Override
    public VideoAuditingResponse createVideoAuditingJob(VideoAuditingRequest videoAuditingRequest) {
        this.checkCIRequestCommon(videoAuditingRequest);
        this.rejectStartWith(videoAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<VideoAuditingRequest> request = this.createRequest(videoAuditingRequest.getBucketName(), "/video/auditing", videoAuditingRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactory.convertToXmlByteArray(videoAuditingRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.VideoAuditingUnmarshaller());
    }

    @Override
    public VideoAuditingResponse describeAuditingJob(VideoAuditingRequest videoAuditingRequest) {
        this.checkCIRequestCommon(videoAuditingRequest);
        this.rejectNull(videoAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<VideoAuditingRequest> request = this.createRequest(videoAuditingRequest.getBucketName(), "/video/auditing/" + videoAuditingRequest.getJobId(), videoAuditingRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.VideoAuditingJobUnmarshaller());
    }

    @Override
    public AudioAuditingResponse createAudioAuditingJobs(AudioAuditingRequest audioAuditingRequest) {
        this.checkCIRequestCommon(audioAuditingRequest);
        this.rejectStartWith(audioAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<AudioAuditingRequest> request = this.createRequest(audioAuditingRequest.getBucketName(), "/audio/auditing", audioAuditingRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactory.convertToXmlByteArray(audioAuditingRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.AudioAuditingUnmarshaller());
    }

    @Override
    public AudioAuditingResponse describeAudioAuditingJob(AudioAuditingRequest audioAuditingRequest) {
        this.checkCIRequestCommon(audioAuditingRequest);
        this.rejectNull(audioAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<AudioAuditingRequest> request = this.createRequest(audioAuditingRequest.getBucketName(), "/audio/auditing/" + audioAuditingRequest.getJobId(), audioAuditingRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.AudioAuditingJobUnmarshaller());
    }

    @Override
    public ImageLabelResponse getImageLabel(ImageLabelRequest imageLabelRequest) {
        this.rejectNull(imageLabelRequest, "The imageLabelRequest parameter must be specified setting the object tags");
        this.rejectNull(imageLabelRequest.getBucketName(), "The imageLabelRequest.bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageLabelRequest> request = this.createRequest(imageLabelRequest.getBucketName(), imageLabelRequest.getObjectKey(), imageLabelRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "detect-label");
        COSClient.addParameterIfNotNull(request, "detect-url", imageLabelRequest.getDetectUrl());
        COSClient.addParameterIfNotNull(request, "scenes", imageLabelRequest.getScenes());
        return this.invoke(request, new Unmarshallers.ImageLabelUnmarshaller());
    }

    @Override
    public ImageLabelV2Response getImageLabelV2(ImageLabelV2Request imageLabelV2Request) {
        this.rejectNull(imageLabelV2Request, "The imageAuditingRequest parameter must be specified setting the object tags");
        this.rejectNull(imageLabelV2Request.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageLabelV2Request> request = this.createRequest(imageLabelV2Request.getBucketName(), imageLabelV2Request.getObjectKey(), imageLabelV2Request, HttpMethodName.GET);
        request.addParameter("ci-process", "content-analysis");
        COSClient.addParameterIfNotNull(request, "scenes", imageLabelV2Request.getScenes());
        System.out.println(request.getEndpoint());
        return this.invoke(request, new Unmarshallers.ImageLabelV2Unmarshaller());
    }

    @Override
    public TextAuditingResponse createAuditingTextJobs(TextAuditingRequest textAuditingRequest) {
        this.checkCIRequestCommon(textAuditingRequest);
        this.rejectStartWith(textAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<TextAuditingRequest> request = this.createRequest(textAuditingRequest.getBucketName(), "/text/auditing", textAuditingRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactory.convertToXmlByteArray(textAuditingRequest), "application/xml", false);
        return (TextAuditingResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<TextAuditingResponse>(TextAuditingResponse.class));
    }

    @Override
    public TextAuditingResponse describeAuditingTextJob(TextAuditingRequest textAuditingRequest) {
        this.checkCIRequestCommon(textAuditingRequest);
        this.rejectNull(textAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<TextAuditingRequest> request = this.createRequest(textAuditingRequest.getBucketName(), "/text/auditing/" + textAuditingRequest.getJobId(), textAuditingRequest, HttpMethodName.GET);
        return (TextAuditingResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<TextAuditingResponse>(TextAuditingResponse.class));
    }

    @Override
    public DocumentAuditingResponse createAuditingDocumentJobs(DocumentAuditingRequest documentAuditingRequest) {
        this.checkCIRequestCommon(documentAuditingRequest);
        this.rejectStartWith(documentAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<DocumentAuditingRequest> request = this.createRequest(documentAuditingRequest.getBucketName(), "/document/auditing", documentAuditingRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactory.convertToXmlByteArray(documentAuditingRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.DocumentAuditingJobUnmarshaller());
    }

    @Override
    public DocumentAuditingResponse describeAuditingDocumentJob(DocumentAuditingRequest documentAuditingRequest) {
        this.checkCIRequestCommon(documentAuditingRequest);
        this.rejectNull(documentAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<DocumentAuditingRequest> request = this.createRequest(documentAuditingRequest.getBucketName(), "/document/auditing/" + documentAuditingRequest.getJobId(), documentAuditingRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.DocumentAuditingDescribeJobUnmarshaller());
    }

    @Override
    public BatchImageAuditingResponse batchImageAuditing(BatchImageAuditingRequest batchImageAuditingRequest) {
        this.checkCIRequestCommon(batchImageAuditingRequest);
        this.rejectStartWith(batchImageAuditingRequest.getConf().getCallback(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<BatchImageAuditingRequest> request = this.createRequest(batchImageAuditingRequest.getBucketName(), "/image/auditing", batchImageAuditingRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactory.convertToXmlByteArray(batchImageAuditingRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.BatchImageAuditingJobUnmarshaller());
    }

    @Override
    public Boolean createDocProcessBucket(DocBucketRequest docBucketRequest) {
        this.checkCIRequestCommon(docBucketRequest);
        CosHttpRequest<DocBucketRequest> request = this.createRequest(docBucketRequest.getBucketName(), "/docbucket", docBucketRequest, HttpMethodName.POST);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public Boolean createMediaProcessBucket(MediaBucketRequest mediaBucketRequest) {
        this.checkCIRequestCommon(mediaBucketRequest);
        CosHttpRequest<MediaBucketRequest> request = this.createRequest(mediaBucketRequest.getBucketName(), "/mediabucket", mediaBucketRequest, HttpMethodName.POST);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    public String GenerateDocPreviewUrl(DocHtmlRequest docJobRequest) throws URISyntaxException {
        return this.generateDocPreviewUrl(docJobRequest);
    }

    @Override
    public String generateDocPreviewUrl(DocHtmlRequest docJobRequest) throws URISyntaxException {
        this.rejectNull(docJobRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(docJobRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        this.rejectNull(docJobRequest.getObjectKey(), "The objectKey parameter must be specified setting the object tags");
        CosHttpRequest<DocHtmlRequest> request = this.createRequest(docJobRequest.getBucketName(), docJobRequest.getObjectKey(), docJobRequest, HttpMethodName.GET);
        return this.buildDocPreview(request);
    }

    @Override
    public WebpageAuditingResponse createWebpageAuditingJob(WebpageAuditingRequest webpageAuditingRequest) {
        this.checkCIRequestCommon(webpageAuditingRequest);
        this.rejectStartWith(webpageAuditingRequest.getInput().getUrl(), "http", "The Conf.CallBack parameter mush start with http or https");
        CosHttpRequest<WebpageAuditingRequest> request = this.createRequest(webpageAuditingRequest.getBucketName(), "/webpage/auditing", webpageAuditingRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactory.convertToXmlByteArray(webpageAuditingRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.WebpageAuditingJobUnmarshaller());
    }

    @Override
    public WebpageAuditingResponse describeWebpageAuditingJob(WebpageAuditingRequest webpageAuditingRequest) {
        this.checkCIRequestCommon(webpageAuditingRequest);
        this.rejectNull(webpageAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<WebpageAuditingRequest> request = this.createRequest(webpageAuditingRequest.getBucketName(), "/webpage/auditing/" + webpageAuditingRequest.getJobId(), webpageAuditingRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.WebpageAuditingDescribeJobUnmarshaller());
    }

    @Override
    public String reportBadCase(ReportBadCaseRequest reportBadCaseRequest) {
        this.checkCIRequestCommon(reportBadCaseRequest);
        CosHttpRequest<ReportBadCaseRequest> request = this.createRequest(reportBadCaseRequest.getBucketName(), "/report/badcase", reportBadCaseRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactory.convertToXmlByteArray(reportBadCaseRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.ReportBadCaseUnmarshaller());
    }

    private String buildDocPreview(CosHttpRequest<DocHtmlRequest> request) throws URISyntaxException {
        Date expiredTime = new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ci-process", "doc-preview");
        DocHtmlRequest originalRequest = request.getOriginalRequest();
        this.putIfNotNull(params, "dstType", originalRequest.getDstType().toString());
        this.putIfNotNull(params, "srcType", originalRequest.getSrcType());
        this.putIfNotNull(params, "page", originalRequest.getPage());
        this.putIfNotNull(params, "ImageParams", originalRequest.getImageParams());
        this.putIfNotNull(params, "sheet", originalRequest.getSheet());
        this.putIfNotNull(params, "password", originalRequest.getPassword());
        this.putIfNotNull(params, "comment", originalRequest.getComment());
        this.putIfNotNull(params, "excelPaperDirection", originalRequest.getExcelPaperDirection());
        this.putIfNotNull(params, "excelPaperSize", originalRequest.getExcelPaperSize());
        this.putIfNotNull(params, "quality", originalRequest.getQuality());
        this.putIfNotNull(params, "scale", originalRequest.getScale());
        this.putIfNotNull(params, "imageDpi", originalRequest.getImageDpi());
        URL url = this.generatePresignedUrl(request.getBucketName(), request.getResourcePath(), expiredTime, HttpMethodName.GET, new HashMap<String, String>(), params, false, false);
        return url.toString();
    }

    private void putIfNotNull(HashMap<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private void checkCIRequestCommon(CIServiceRequest request) {
        this.rejectNull(request, "The request parameter must be specified setting the object tags");
        this.rejectNull(request.getBucketName(), "The bucketName parameter must be specified setting the object tags");
    }

    private void checkMediaListJobResponse(MediaListJobResponse response) {
        MediaJobObject mediaJobObject;
        List<MediaJobObject> jobsDetailList = response.getJobsDetailList();
        if (jobsDetailList.size() == 1 && (mediaJobObject = jobsDetailList.get(0)).getQueueId() == null && mediaJobObject.getJobId() == null && mediaJobObject.getCode() == null) {
            jobsDetailList.clear();
        }
    }

    public URL getObjectUrl(String bucketName, String key) {
        return this.getObjectUrl(new GetObjectRequest(bucketName, key));
    }

    public URL getObjectUrl(String bucketName, String key, String versionId) {
        return this.getObjectUrl(new GetObjectRequest(bucketName, key, versionId));
    }

    public URL getObjectUrl(GetObjectRequest getObjectRequest) {
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when generating a pre-signed URL");
        this.rejectNull(getObjectRequest, "The request parameter must be specified when generating a pre-signed URL");
        String bucketName = getObjectRequest.getBucketName();
        String key = getObjectRequest.getKey();
        CosHttpRequest<GetObjectRequest> request = this.createRequest(bucketName, key, getObjectRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "versionId", getObjectRequest.getVersionId());
        COSCredentials cred = this.fetchCredential();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.clientConfig.getHttpProtocol().toString()).append("://");
        strBuilder.append(this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(this.formatBucket(bucketName, cred.getCOSAppId())));
        strBuilder.append(UrlEncoderUtils.encodeUrlPath(this.formatKey(key)));
        boolean hasAppendFirstParameter = false;
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            String paramKey = entry.getKey();
            String paramValue = entry.getValue();
            if (!hasAppendFirstParameter) {
                strBuilder.append("?");
                hasAppendFirstParameter = true;
            } else {
                strBuilder.append("&");
            }
            strBuilder.append(UrlEncoderUtils.encode(paramKey));
            if (paramValue == null) continue;
            strBuilder.append("=").append(UrlEncoderUtils.encode(paramValue));
        }
        try {
            return new URL(strBuilder.toString());
        }
        catch (MalformedURLException e) {
            throw new CosClientException(e.toString());
        }
    }

    @Override
    @Deprecated
    public PutAsyncFetchTaskResult putAsyncFetchTask(PutAsyncFetchTaskRequest putAsyncFetchTaskRequest) {
        CosHttpRequest<PutAsyncFetchTaskRequest> request = this.createRequest(putAsyncFetchTaskRequest.getBucketName(), String.format("/%s/", putAsyncFetchTaskRequest.getBucketName()), putAsyncFetchTaskRequest, HttpMethodName.POST);
        PutAsyncFetchTaskSerializer serializer = new PutAsyncFetchTaskSerializer(PutAsyncFetchTaskRequest.class);
        SimpleModule module = new SimpleModule("PutAsyncFetchTaskSerializer", new Version(1, 0, 0, null, null, null));
        module.addSerializer(PutAsyncFetchTaskRequest.class, (JsonSerializer)serializer);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)module);
        String body = null;
        try {
            body = objectMapper.writeValueAsString((Object)putAsyncFetchTaskRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setContent(request, body.getBytes(), "application/json", false);
        return this.invoke(request, new PutAsyncFetchTaskResultHandler());
    }

    @Override
    @Deprecated
    public GetAsyncFetchTaskResult getAsyncFetchTask(GetAsyncFetchTaskRequest getAsyncFetchTaskRequest) {
        CosHttpRequest<GetAsyncFetchTaskRequest> request = this.createRequest(getAsyncFetchTaskRequest.getBucketName(), String.format("/%s/%s", getAsyncFetchTaskRequest.getBucketName(), getAsyncFetchTaskRequest.getTaskId()), getAsyncFetchTaskRequest, HttpMethodName.GET);
        return this.invoke(request, new GetAsyncFetchTaskResultHandler());
    }

    @Override
    public ImageAuditingResponse describeAuditingImageJob(DescribeImageAuditingRequest imageAuditingRequest) {
        this.rejectNull(imageAuditingRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        this.rejectNull(imageAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<DescribeImageAuditingRequest> request = this.createRequest(imageAuditingRequest.getBucketName(), "/image/auditing/" + imageAuditingRequest.getJobId(), imageAuditingRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ImageAuditingDescribeJobUnmarshaller());
    }

    @Override
    public PrivateM3U8Response getPrivateM3U8(PrivateM3U8Request privateM3U8Request) {
        this.rejectNull(privateM3U8Request.getExpires(), "The expires parameter must be specified setting the object tags , must satisfy the interval [3600, 43200]");
        this.rejectNull(privateM3U8Request.getBucketName(), "The privateM3U8Request.bucketName parameter must be specified setting the object tags");
        CosHttpRequest<PrivateM3U8Request> request = this.createRequest(privateM3U8Request.getBucketName(), privateM3U8Request.getObject(), privateM3U8Request, HttpMethodName.GET);
        request.addParameter("ci-process", "pm3u8");
        request.addParameter("expires", privateM3U8Request.getExpires());
        return this.invoke(request, new Unmarshallers.PrivateM3U8Unmarshaller());
    }

    @Override
    public DetectCarResponse detectCar(AIRecRequest AIRecRequest2) {
        this.rejectNull(AIRecRequest2.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AIRecRequest> request = this.createRequest(AIRecRequest2.getBucketName(), AIRecRequest2.getObjectKey(), AIRecRequest2, HttpMethodName.GET);
        request.addParameter("ci-process", "DetectCar");
        COSClient.addParameterIfNotNull(request, "detect-url", AIRecRequest2.getDetectUrl());
        return this.invoke(request, new Unmarshallers.DetectCarUnmarshaller());
    }

    @Override
    public boolean openImageSearch(OpenImageSearchRequest imageSearchRequest) {
        this.rejectNull(imageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<OpenImageSearchRequest> request = this.createRequest(imageSearchRequest.getBucketName(), "/ImageSearchBucket", imageSearchRequest, HttpMethodName.POST);
        this.setContent(request, CImageXmlFactory.convertToXmlByteArray(imageSearchRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public boolean addGalleryImages(ImageSearchRequest imageSearchRequest) {
        this.rejectNull(imageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageSearchRequest> request = this.createRequest(imageSearchRequest.getBucketName(), imageSearchRequest.getObjectKey(), imageSearchRequest, HttpMethodName.POST);
        request.addParameter("ci-process", "ImageSearch");
        request.addParameter("action", "AddImage");
        this.setContent(request, CImageXmlFactory.convertToXmlByteArray(imageSearchRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public boolean deleteGalleryImages(ImageSearchRequest imageSearchRequest) {
        this.rejectNull(imageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageSearchRequest> request = this.createRequest(imageSearchRequest.getBucketName(), imageSearchRequest.getObjectKey(), imageSearchRequest, HttpMethodName.POST);
        request.addParameter("ci-process", "ImageSearch");
        request.addParameter("action", "DeleteImage");
        this.setContent(request, CImageXmlFactory.convertToXmlByteArray(imageSearchRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public ImageSearchResponse searchGalleryImages(ImageSearchRequest imageSearchRequest) {
        this.rejectNull(imageSearchRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageSearchRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageSearchRequest> request = this.createRequest(imageSearchRequest.getBucketName(), imageSearchRequest.getObjectKey(), imageSearchRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "ImageSearch");
        request.addParameter("action", "SearchImage");
        COSClient.addParameterIfNotNull(request, "MatchThreshold", imageSearchRequest.getMatchThreshold());
        COSClient.addParameterIfNotNull(request, "Offset", imageSearchRequest.getOffset());
        COSClient.addParameterIfNotNull(request, "Limit", imageSearchRequest.getLimit());
        COSClient.addParameterIfNotNull(request, "Filter", imageSearchRequest.getFilter());
        return this.invoke(request, new Unmarshallers.SearchImagesUnmarshaller());
    }

    @Override
    public MediaWorkflowListResponse triggerWorkflowList(MediaWorkflowListRequest mediaWorkflowListRequest) {
        this.rejectNull(mediaWorkflowListRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(mediaWorkflowListRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<MediaWorkflowListRequest> request = this.createRequest(mediaWorkflowListRequest.getBucketName(), "triggerworkflow", mediaWorkflowListRequest, HttpMethodName.POST);
        COSClient.addParameterIfNotNull(request, "workflowId", mediaWorkflowListRequest.getWorkflowId());
        COSClient.addParameterIfNotNull(request, "object", mediaWorkflowListRequest.getObject());
        COSClient.addParameterIfNotNull(request, "name", mediaWorkflowListRequest.getName());
        if (mediaWorkflowListRequest.getAttachParam() != null) {
            request.addParameter("attachParam", null);
            this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(mediaWorkflowListRequest), "application/xml", false);
        }
        return this.invoke(request, new Unmarshallers.triggerWorkflowListUnmarshaller());
    }

    @Override
    public InputStream getSnapshot(CosSnapshotRequest snapshotRequest) {
        this.rejectNull(snapshotRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(snapshotRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        this.rejectNull(snapshotRequest.getObjectKey(), "The objectKey parameter must be specified setting the object tags");
        CosHttpRequest<CosSnapshotRequest> request = this.createRequest(snapshotRequest.getBucketName(), snapshotRequest.getObjectKey(), snapshotRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "ci-process", "snapshot");
        COSClient.addParameterIfNotNull(request, "time", snapshotRequest.getTime());
        COSClient.addParameterIfNotNull(request, "width", snapshotRequest.getWidth());
        COSClient.addParameterIfNotNull(request, "height", snapshotRequest.getHeight());
        COSClient.addParameterIfNotNull(request, "format", snapshotRequest.getFormat());
        COSClient.addParameterIfNotNull(request, "rotate", snapshotRequest.getRotate());
        COSClient.addParameterIfNotNull(request, "mode", snapshotRequest.getMode());
        return this.invoke(request, new CIGetSnapshotResponseHandler());
    }

    @Override
    public String generateQrcode(GenerateQrcodeRequest generateQrcodeRequest) {
        this.rejectNull(generateQrcodeRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(generateQrcodeRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<GenerateQrcodeRequest> request = this.createRequest(generateQrcodeRequest.getBucketName(), "/", generateQrcodeRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "ci-process", "qrcode-generate");
        COSClient.addParameterIfNotNull(request, "qrcode-content", generateQrcodeRequest.getQrcodeContent());
        COSClient.addParameterIfNotNull(request, "mode", generateQrcodeRequest.getMode());
        COSClient.addParameterIfNotNull(request, "width", generateQrcodeRequest.getWidth());
        return this.invoke(request, new Unmarshallers.GenerateQrcodeUnmarshaller());
    }

    @Override
    public Boolean addImageStyle(ImageStyleRequest imageStyleRequest) {
        this.rejectNull(imageStyleRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageStyleRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageStyleRequest> request = this.createRequest(imageStyleRequest.getBucketName(), "/", imageStyleRequest, HttpMethodName.PUT);
        request.addParameter("style", "");
        this.setContent(request, CImageXmlFactory.addStyleConvertToXmlByteArray(imageStyleRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public ImageStyleResponse getImageStyle(ImageStyleRequest imageStyleRequest) {
        this.rejectNull(imageStyleRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageStyleRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageStyleRequest> request = this.createRequest(imageStyleRequest.getBucketName(), "/", imageStyleRequest, HttpMethodName.GET);
        request.addParameter("style", "");
        this.setContent(request, CImageXmlFactory.getStyleConvertToXmlByteArray(imageStyleRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.getImageStyleUnmarshaller());
    }

    @Override
    public Boolean deleteImageStyle(ImageStyleRequest imageStyleRequest) {
        this.rejectNull(imageStyleRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(imageStyleRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<ImageStyleRequest> request = this.createRequest(imageStyleRequest.getBucketName(), "/", imageStyleRequest, HttpMethodName.DELETE);
        request.addParameter("style", "");
        this.setContent(request, CImageXmlFactory.deleteStyleConvertToXmlByteArray(imageStyleRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public String getObjectDecompressionStatus(String bucketName, String objectKey) {
        this.rejectNull(bucketName, "The bucketName parameter must be specified getting object decompression status");
        this.rejectNull(objectKey, "The objectKey parameter must be specified getting object decompression status");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, objectKey, new CosServiceRequest(), HttpMethodName.GET);
        request.addParameter("decompression", null);
        request.addParameter("jobId", objectKey);
        return this.invoke(request, new COSStringResponseHandler());
    }

    @Override
    public DecompressionResult postObjectDecompression(DecompressionRequest decompressionRequest) {
        this.rejectNull(decompressionRequest.getSourceBucketName(), "The sourceBucketName parameter must be specified post object decompression");
        this.rejectNull(decompressionRequest, "The decompressionRequest parameter must be specified post object decompression");
        this.rejectNull(decompressionRequest.getTargetBucketName(), "The decompressionRequest parameter must be specified post object decompression");
        this.rejectNull(decompressionRequest.getResourcesPrefix(), "The decompressionRequest parameter must be specified post object decompression");
        if (decompressionRequest.getPrefixReplaced()) {
            this.rejectNull(decompressionRequest.getTargetKeyPrefix(), "The targetKeyPrefix parameter must be specified post object decompression when prefixReplaced is true");
        }
        CosHttpRequest<DecompressionRequest> request = this.createRequest(decompressionRequest.getSourceBucketName(), decompressionRequest.getObjectKey(), decompressionRequest, HttpMethodName.POST);
        request.addParameter("decompression", null);
        byte[] content = DecompressionRequest.convertToByteArray(decompressionRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent(new ByteArrayInputStream(content));
        return (DecompressionResult)this.invoke(request, new COSXmlResponseHandler<DecompressionResult>(new Unmarshallers.DecompressionResultUnmarshaller()));
    }

    @Override
    public DecompressionResult getObjectDecompressionStatus(String bucketName, String objectKey, String jobId) {
        this.rejectNull(bucketName, "The bucketName parameter must be specified getting object decompression status");
        this.rejectNull(objectKey, "The objectKey parameter must be specified getting object decompression status");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, objectKey, new CosServiceRequest(), HttpMethodName.GET);
        if (jobId != null) {
            request.addParameter("jobId", jobId);
        }
        request.addParameter("decompression", null);
        return (DecompressionResult)this.invoke(request, new COSXmlResponseHandler<DecompressionResult>(new Unmarshallers.DecompressionResultUnmarshaller()));
    }

    @Override
    public ListJobsResult listObjectDecompressionJobs(String bucketName, String jobStatus, String sortBy, String maxResults, String nextToken) {
        this.rejectNull(bucketName, "The bucketName parameter must be specified list object decompression status");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, "/", new CosServiceRequest(), HttpMethodName.GET);
        request.addParameter("decompression", null);
        if (jobStatus != null) {
            request.addParameter("jobStatus", jobStatus);
        }
        if (sortBy != null) {
            request.addParameter("sortBy", sortBy);
        }
        if (maxResults != null) {
            request.addParameter("maxResults", maxResults);
        }
        if (nextToken != null) {
            request.addParameter("nextToken", nextToken);
        }
        return (ListJobsResult)this.invoke(request, new COSXmlResponseHandler<ListJobsResult>(new Unmarshallers.ListJobsResultUnmarshaller()));
    }

    @Override
    public MediaJobResponse createPicProcessJob(MediaJobsRequest req) {
        this.checkCIRequestCommon(req);
        this.rejectStartWith(req.getCallBack(), "http", "The CallBack parameter mush start with http or https");
        CosHttpRequest<MediaJobsRequest> request = this.createRequest(req.getBucketName(), "/pic_jobs", req, HttpMethodName.POST);
        this.setContent(request, CIMediaXmlFactory.convertToXmlByteArray(req), "application/xml", false);
        return this.invoke(request, new Unmarshallers.JobCreatUnmarshaller());
    }

    @Override
    public MediaListQueueResponse describePicProcessQueues(MediaQueueRequest req) {
        this.checkCIRequestCommon(req);
        CosHttpRequest<MediaQueueRequest> request = this.createRequest(req.getBucketName(), "/picqueue", req, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "queueIds", req.getQueueId());
        COSClient.addParameterIfNotNull(request, "state", req.getState());
        COSClient.addParameterIfNotNull(request, "pageNumber", req.getPageNumber());
        COSClient.addParameterIfNotNull(request, "pageSize", req.getPageSize());
        return this.invoke(request, new Unmarshallers.ListQueueUnmarshaller());
    }

    @Override
    public boolean processImage2(CImageProcessRequest imageProcessRequest) {
        Map<String, String> queryParams;
        this.rejectNull(imageProcessRequest, "The ImageProcessRequest parameter must be specified when requesting an object's metadata");
        this.rejectNull(this.clientConfig.getRegion(), "region is null, region in clientConfig must be specified when requesting an object's metadata");
        String bucketName = imageProcessRequest.getBucketName();
        String key = imageProcessRequest.getKey();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(key, "The key parameter must be specified when requesting an object's metadata");
        CosHttpRequest<CImageProcessRequest> request = this.createRequest(bucketName, key, imageProcessRequest, HttpMethodName.POST);
        if (imageProcessRequest.getPicOperations() != null) {
            request.addHeader("Pic-Operations", Jackson.toJsonString(imageProcessRequest.getPicOperations()));
        }
        if ((queryParams = imageProcessRequest.getQueryParams()) != null && !queryParams.isEmpty()) {
            for (String qName : queryParams.keySet()) {
                request.addParameter(qName, queryParams.get(qName));
            }
        }
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public FileProcessJobResponse createFileProcessJob(FileProcessRequest req) {
        this.rejectStartWith(req.getCallBack(), "http", "The CallBack parameter mush start with http or https");
        CosHttpRequest<FileProcessRequest> request = this.createRequest(req.getBucketName(), "/file_jobs", req, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(req), "application/xml", false);
        return this.invoke(request, new Unmarshallers.FileProcessUnmarshaller());
    }

    @Override
    public FileProcessJobResponse describeFileProcessJob(FileProcessRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<FileProcessRequest> httpRequest = this.createRequest(request.getBucketName(), "/file_jobs/" + request.getJobId(), request, HttpMethodName.GET);
        return (FileProcessJobResponse)this.invoke(httpRequest, new Unmarshallers.CICommonUnmarshaller<FileProcessJobResponse>(FileProcessJobResponse.class));
    }

    @Override
    public BatchJobResponse createInventoryTriggerJob(BatchJobRequest req) {
        CosHttpRequest<BatchJobRequest> request = this.createRequest(req.getBucketName(), "/inventorytriggerjob", req, HttpMethodName.POST);
        this.setContent(request, CIMediaXmlFactory.convertToXmlByteArray(req), "application/xml", false);
        return this.invoke(request, new Unmarshallers.BatchJobUnmarshaller());
    }

    @Override
    public BatchJobResponse describeInventoryTriggerJob(BatchJobRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<BatchJobRequest> httpRequest = this.createRequest(request.getBucketName(), "/inventorytriggerjob/" + request.getJobId(), request, HttpMethodName.GET);
        return this.invoke(httpRequest, new Unmarshallers.BatchJobUnmarshaller());
    }

    @Override
    public AutoTranslationBlockResponse autoTranslationBlock(AutoTranslationBlockRequest translationBlockRequest) {
        this.rejectNull(translationBlockRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(translationBlockRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AutoTranslationBlockRequest> request = this.createRequest(translationBlockRequest.getBucketName(), "/", translationBlockRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "AutoTranslationBlock");
        COSClient.addParameterIfNotNull(request, "InputText", translationBlockRequest.getInputText());
        COSClient.addParameterIfNotNull(request, "SourceLang", translationBlockRequest.getSourceLang());
        COSClient.addParameterIfNotNull(request, "TargetLang", translationBlockRequest.getTargetLang());
        COSClient.addParameterIfNotNull(request, "TextDomain", translationBlockRequest.getTextDomain());
        COSClient.addParameterIfNotNull(request, "TextStyle", translationBlockRequest.getTextStyle());
        return this.invoke(request, new Unmarshallers.AutoTranslationBlockUnmarshaller());
    }

    @Override
    public DetectFaceResponse detectFace(DetectFaceRequest detectFaceRequest) {
        this.rejectNull(detectFaceRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(detectFaceRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<DetectFaceRequest> request = this.createRequest(detectFaceRequest.getBucketName(), detectFaceRequest.getObjectKey(), detectFaceRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "DetectFace");
        COSClient.addParameterIfNotNull(request, "max-face-num", detectFaceRequest.getMaxFaceNum());
        COSClient.addParameterIfNotNull(request, "detect-url", detectFaceRequest.getDetectUrl());
        return this.invoke(request, new Unmarshallers.DetectFaceUnmarshaller());
    }

    @Override
    public AIGameRecResponse aiGameRec(AIRecRequest aiRecRequest) {
        this.rejectNull(aiRecRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(aiRecRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AIRecRequest> request = this.createRequest(aiRecRequest.getBucketName(), aiRecRequest.getObjectKey(), aiRecRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "AIGameRec");
        COSClient.addParameterIfNotNull(request, "detect-url", aiRecRequest.getDetectUrl());
        return this.invoke(request, new Unmarshallers.AIGameRecUnmarshaller());
    }

    @Override
    public Boolean cancelLiveAuditing(VideoAuditingRequest videoAuditingRequest) {
        this.rejectNull(videoAuditingRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(videoAuditingRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        this.rejectNull(videoAuditingRequest.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<VideoAuditingRequest> request = this.createRequest(videoAuditingRequest.getBucketName(), "/video/cancel_auditing/" + videoAuditingRequest.getJobId(), videoAuditingRequest, HttpMethodName.POST);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public AuditingStrategyResponse addAuditingStrategy(AuditingStrategyRequest auditingStrategyRequest) {
        this.rejectNull(auditingStrategyRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(auditingStrategyRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AuditingStrategyRequest> request = this.createRequest(auditingStrategyRequest.getBucketName(), "/audit/strategy", auditingStrategyRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(auditingStrategyRequest), "application/xml", false);
        COSClient.addParameterIfNotNull(request, "service", auditingStrategyRequest.getService());
        return this.invoke(request, new Unmarshallers.AuditingStrategyUnmarshaller());
    }

    @Override
    public AuditingStrategyResponse updateAuditingStrategy(AuditingStrategyRequest auditingStrategyRequest) {
        this.rejectNull(auditingStrategyRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(auditingStrategyRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AuditingStrategyRequest> request = this.createRequest(auditingStrategyRequest.getBucketName(), "/audit/strategy/" + auditingStrategyRequest.getBizType(), auditingStrategyRequest, HttpMethodName.PUT);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(auditingStrategyRequest), "application/xml", false);
        COSClient.addParameterIfNotNull(request, "service", auditingStrategyRequest.getService());
        return this.invoke(request, new Unmarshallers.AuditingStrategyUnmarshaller());
    }

    @Override
    public AuditingStrategyResponse describeAuditingStrategy(AuditingStrategyRequest auditingStrategyRequest) {
        this.rejectNull(auditingStrategyRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(auditingStrategyRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AuditingStrategyRequest> request = this.createRequest(auditingStrategyRequest.getBucketName(), "/audit/strategy/" + auditingStrategyRequest.getBizType(), auditingStrategyRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "service", auditingStrategyRequest.getService());
        return this.invoke(request, new Unmarshallers.AuditingStrategyUnmarshaller());
    }

    @Override
    public AuditingStrategyListResponse describeAuditingStrategyList(AuditingStrategyRequest auditingStrategyRequest) {
        this.rejectNull(auditingStrategyRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(auditingStrategyRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AuditingStrategyRequest> request = this.createRequest(auditingStrategyRequest.getBucketName(), "/audit/strategy", auditingStrategyRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "service", auditingStrategyRequest.getService());
        COSClient.addParameterIfNotNull(request, "offset", auditingStrategyRequest.getOffset());
        COSClient.addParameterIfNotNull(request, "limit", auditingStrategyRequest.getLimit());
        return this.invoke(request, new Unmarshallers.AuditingStrategyListUnmarshaller());
    }

    @Override
    public AuditingTextLibResponse addAuditingTextLib(AuditingTextLibRequest libRequest) {
        this.rejectNull(libRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(libRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AuditingTextLibRequest> request = this.createRequest(libRequest.getBucketName(), "/audit/textlib", libRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(libRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.AuditingTextLibUnmarshaller());
    }

    @Override
    public AuditingTextLibResponse describeAuditingTextLib(AuditingTextLibRequest libRequest) {
        this.rejectNull(libRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(libRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AuditingTextLibRequest> request = this.createRequest(libRequest.getBucketName(), "/audit/textlib", libRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "libid", libRequest.getLibid());
        COSClient.addParameterIfNotNull(request, "offset", libRequest.getOffset());
        COSClient.addParameterIfNotNull(request, "limit", libRequest.getLimit());
        return this.invoke(request, new Unmarshallers.AuditingTextLibUnmarshaller());
    }

    @Override
    public AuditingTextLibResponse updateAuditingTextLib(AuditingTextLibRequest libRequest) {
        this.rejectNull(libRequest, "The request parameter must be specified setting the object tags");
        this.rejectNull(libRequest.getBucketName(), "The bucketName parameter must be specified setting the object tags");
        CosHttpRequest<AuditingTextLibRequest> request = this.createRequest(libRequest.getBucketName(), "/audit/textlib/" + libRequest.getLibid(), libRequest, HttpMethodName.PUT);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(libRequest), "application/xml", false);
        return this.invoke(request, new Unmarshallers.AuditingTextLibUnmarshaller());
    }

    @Override
    public AuditingTextLibResponse deleteAuditingTextLib(AuditingTextLibRequest libRequest) {
        this.rejectNull(libRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<AuditingTextLibRequest> request = this.createRequest(libRequest.getBucketName(), "/audit/textlib/" + libRequest.getLibid(), libRequest, HttpMethodName.DELETE);
        return this.invoke(request, new Unmarshallers.AuditingTextLibUnmarshaller());
    }

    @Override
    public AuditingKeywordResponse addAuditingLibKeyWord(AuditingKeywordRequest keywordRequest) {
        this.rejectNull(keywordRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<AuditingKeywordRequest> request = this.createRequest(keywordRequest.getBucketName(), "/audit/textlib/" + keywordRequest.getLibId() + "/keyword", keywordRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(keywordRequest), "application/xml", false);
        return (AuditingKeywordResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<AuditingKeywordResponse>(AuditingKeywordResponse.class));
    }

    @Override
    public AuditingKeywordResponse describeAuditingKeyWordList(AuditingKeywordRequest keywordRequest) {
        this.rejectNull(keywordRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<AuditingKeywordRequest> request = this.createRequest(keywordRequest.getBucketName(), "/audit/textlib/" + keywordRequest.getLibId() + "/keyword", keywordRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "content", keywordRequest.getContent());
        COSClient.addParameterIfNotNull(request, "label", keywordRequest.getLabel());
        COSClient.addParameterIfNotNull(request, "offset", keywordRequest.getOffset());
        COSClient.addParameterIfNotNull(request, "limit", keywordRequest.getLimit());
        return (AuditingKeywordResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<AuditingKeywordResponse>(AuditingKeywordResponse.class));
    }

    @Override
    public AuditingKeywordResponse deleteAuditingKeyWord(AuditingKeywordRequest keywordRequest) {
        this.rejectNull(keywordRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<AuditingKeywordRequest> request = this.createRequest(keywordRequest.getBucketName(), "/audit/textlib/" + keywordRequest.getLibId() + "/deletekeyword", keywordRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(keywordRequest), "application/xml", false);
        return (AuditingKeywordResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<AuditingKeywordResponse>(AuditingKeywordResponse.class));
    }

    @Override
    public ImageInspectResponse getImageInspect(ImageInspectRequest inspectRequest) {
        this.rejectNull(inspectRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<ImageInspectRequest> request = this.createRequest(inspectRequest.getBucketName(), inspectRequest.getObjectKey(), inspectRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "ImageInspect");
        return (ImageInspectResponse)this.invoke(request, new Unmarshallers.CIJsonUnmarshaller<ImageInspectResponse>(ImageInspectResponse.class));
    }

    @Override
    public MediaJobResponseV2 describeMediaJobV2(MediaJobsRequestV2 req) {
        this.rejectNull(req.getJobId(), "The jobId parameter must be specified setting the object tags");
        CosHttpRequest<MediaJobsRequestV2> request = this.createRequest(req.getBucketName(), "/jobs/" + req.getJobId(), req, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "queueId", req.getQueueId());
        COSClient.addParameterIfNotNull(request, "tag", req.getTag());
        COSClient.addParameterIfNotNull(request, "orderByTime", req.getOrderByTime());
        COSClient.addParameterIfNotNull(request, "nextToken", req.getNextToken());
        COSClient.addParameterIfNotNull(request, "size", req.getSize().toString());
        COSClient.addParameterIfNotNull(request, "states", req.getStates());
        COSClient.addParameterIfNotNull(request, "startCreationTime", req.getStartCreationTime());
        COSClient.addParameterIfNotNull(request, "endCreationTime", req.getEndCreationTime());
        return (MediaJobResponseV2)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<MediaJobResponseV2>(MediaJobResponseV2.class));
    }

    @Override
    public InputStream aIImageColoring(AIImageColoringRequest aIImageColoringRequest) {
        CosHttpRequest<AIImageColoringRequest> request = this.createRequest(aIImageColoringRequest.getBucket(), "/" + aIImageColoringRequest.getObjectKey(), aIImageColoringRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "ci-process", aIImageColoringRequest.getCiProcess());
        COSClient.addParameterIfNotNull(request, "detect-url", aIImageColoringRequest.getDetectUrl());
        return this.invoke(request, new CIGetSnapshotResponseHandler());
    }

    @Override
    public PostSpeechRecognitionResponse postSpeechRecognition(PostSpeechRecognitionRequest postSpeechRecognitionRequest) {
        this.rejectNull(postSpeechRecognitionRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<PostSpeechRecognitionRequest> request = this.createRequest(postSpeechRecognitionRequest.getBucketName(), "/jobs", postSpeechRecognitionRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(postSpeechRecognitionRequest), "application/xml", false);
        return (PostSpeechRecognitionResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<PostSpeechRecognitionResponse>(PostSpeechRecognitionResponse.class));
    }

    @Override
    public boolean faceSearchBucket(FaceSearchBucketRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<FaceSearchBucketRequest> request = this.createRequest(customRequest.getBucketName(), "/FaceSearchBucket", customRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(customRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public CreatePersonResponse createPerson(CreatePersonRequest createPersonRequest) {
        this.rejectNull(createPersonRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<CreatePersonRequest> request = this.createRequest(createPersonRequest.getBucketName(), "/" + createPersonRequest.getObjectKey(), createPersonRequest, HttpMethodName.POST);
        request.addParameter("ci-process", "FaceSearch");
        request.addParameter("action", "CreatePerson");
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(createPersonRequest), "application/xml", false);
        return (CreatePersonResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<CreatePersonResponse>(CreatePersonResponse.class));
    }

    @Override
    public AddPersonFaceResponse addPersonFace(AddPersonFaceRequest addPersonFaceRequest) {
        this.rejectNull(addPersonFaceRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<AddPersonFaceRequest> request = this.createRequest(addPersonFaceRequest.getBucketName(), "/" + addPersonFaceRequest.getObjectKey(), addPersonFaceRequest, HttpMethodName.POST);
        request.addParameter("ci-process", "FaceSearch");
        request.addParameter("action", "AddPersonFace");
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(addPersonFaceRequest), "application/xml", false);
        return (AddPersonFaceResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<AddPersonFaceResponse>(AddPersonFaceResponse.class));
    }

    @Override
    public SearchPersonFaceResponse searchPersonFace(SearchPersonFaceRequest customRequest) {
        CosHttpRequest<SearchPersonFaceRequest> request = this.createRequest(customRequest.getBucketName(), "/" + customRequest.getObjectKey(), customRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "FaceSearch");
        request.addParameter("action", "SearchPersonFace");
        COSClient.addParameterIfNotNull(request, "ObjectKey", customRequest.getObjectKey());
        COSClient.addParameterIfNotNull(request, "FaceMatchThreshold", customRequest.getFaceMatchThreshold());
        COSClient.addParameterIfNotNull(request, "NeedPersonInfo", customRequest.getNeedPersonInfo());
        COSClient.addParameterIfNotNull(request, "QualityControl", customRequest.getQualityControl());
        COSClient.addParameterIfNotNull(request, "NeedRotateDetection", customRequest.getNeedRotateDetection());
        return (SearchPersonFaceResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<SearchPersonFaceResponse>(SearchPersonFaceResponse.class));
    }

    @Override
    public boolean deletePersonFace(DeletePersonFaceRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DeletePersonFaceRequest> request = this.createRequest(customRequest.getBucketName(), "/" + customRequest.getObjectKey(), customRequest, HttpMethodName.POST);
        request.addParameter("ci-process", "FaceSearch");
        request.addParameter("action", "DeletePersonFace");
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(customRequest), "application/xml", false);
        this.invoke(request, this.voidCosResponseHandler);
        return true;
    }

    @Override
    public DNADbFilesResponse describeMediaDnaDbFiles(DNADbFilesRequest dnaDbFilesRequest) {
        this.rejectNull(dnaDbFilesRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DNADbFilesRequest> request = this.createRequest(dnaDbFilesRequest.getBucketName(), "/dnadb_files", dnaDbFilesRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "object", dnaDbFilesRequest.getObject());
        COSClient.addParameterIfNotNull(request, "dnaDbId", dnaDbFilesRequest.getDnaDbId());
        COSClient.addParameterIfNotNull(request, "pageNumber", dnaDbFilesRequest.getPageNumber());
        COSClient.addParameterIfNotNull(request, "pageSize", dnaDbFilesRequest.getPageSize());
        return (DNADbFilesResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<DNADbFilesResponse>(DNADbFilesResponse.class));
    }

    @Override
    public DNADbConfigsResponse describeMediaDnaDbs(DNADbConfigsRequest dnaDbConfigsRequest) {
        this.rejectNull(dnaDbConfigsRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DNADbConfigsRequest> request = this.createRequest(dnaDbConfigsRequest.getBucketName(), "/dnadb", dnaDbConfigsRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "ids", dnaDbConfigsRequest.getIds());
        COSClient.addParameterIfNotNull(request, "pageNumber", dnaDbConfigsRequest.getPageNumber());
        COSClient.addParameterIfNotNull(request, "pageSize", dnaDbConfigsRequest.getPageSize());
        return (DNADbConfigsResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<DNADbConfigsResponse>(DNADbConfigsResponse.class));
    }

    @Override
    public ZipPreviewResponse zipPreview(ZipPreviewRequest zipPreviewRequest) {
        this.rejectNull(zipPreviewRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<ZipPreviewRequest> request = this.createRequest(zipPreviewRequest.getBucketName(), zipPreviewRequest.getObjectKey(), zipPreviewRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "zippreview");
        COSClient.addParameterIfNotNull(request, "uncompress-key", zipPreviewRequest.getUncompressKey());
        return (ZipPreviewResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<ZipPreviewResponse>(ZipPreviewResponse.class));
    }

    @Override
    public GoodsMattingResponse goodsMatting(GoodsMattingRequest customRequest) {
        CosHttpRequest<GoodsMattingRequest> request = this.createRequest(customRequest.getBucketName(), "/" + customRequest.getObjectKey(), customRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "GoodsMatting");
        COSClient.addParameterIfNotNull(request, "detect-url", customRequest.getDetectUrl());
        this.invoke(request, new CIGetResponseHandler());
        return null;
    }

    @Override
    public CreateHLSPlayKeyResponse createHLSPlayKey(CreateHLSPlayKeyRequest customRequest) {
        CosHttpRequest<CreateHLSPlayKeyRequest> request = this.createRequest(customRequest.getBucketName(), "/playKey", customRequest, HttpMethodName.POST);
        return (CreateHLSPlayKeyResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<CreateHLSPlayKeyResponse>(CreateHLSPlayKeyResponse.class));
    }

    @Override
    public GetHLSPlayKeyResponse getHLSPlayKey(GetHLSPlayKeyRequest customRequest) {
        CosHttpRequest<GetHLSPlayKeyRequest> request = this.createRequest(customRequest.getBucketName(), "/playKey", customRequest, HttpMethodName.GET);
        return (GetHLSPlayKeyResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<GetHLSPlayKeyResponse>(GetHLSPlayKeyResponse.class));
    }

    @Override
    public UpdataHLSPlayKeyResponse updataHLSPlayKey(UpdataHLSPlayKeyRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<UpdataHLSPlayKeyRequest> request = this.createRequest(customRequest.getBucketName(), "/playKey", customRequest, HttpMethodName.PUT);
        COSClient.addParameterIfNotNull(request, "masterPlayKey", customRequest.getMasterPlayKey());
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(request), "application/xml", false);
        return (UpdataHLSPlayKeyResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<UpdataHLSPlayKeyResponse>(UpdataHLSPlayKeyResponse.class));
    }

    @Override
    public MediaListTemplateResponse describeMediaTemplatesV2(MediaTemplateRequest request) {
        this.checkCIRequestCommon(request);
        CosHttpRequest<MediaTemplateRequest> httpRequest = this.createRequest(request.getBucketName(), "/template", request, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(httpRequest, "tag", request.getTag());
        COSClient.addParameterIfNotNull(httpRequest, "category", request.getCategory());
        COSClient.addParameterIfNotNull(httpRequest, "ids", request.getIds());
        COSClient.addParameterIfNotNull(httpRequest, "name", request.getName());
        COSClient.addParameterIfNotNull(httpRequest, "pageNumber", request.getPageNumber());
        COSClient.addParameterIfNotNull(httpRequest, "pageSize", request.getPageSize());
        return (MediaListTemplateResponse)this.invoke(httpRequest, new Unmarshallers.CICommonUnmarshaller<MediaListTemplateResponse>(MediaListTemplateResponse.class));
    }

    @Override
    public InputStream getPlayList(GetPlayListRequest getPlayListRequest) {
        CosHttpRequest<GetPlayListRequest> request = this.createRequest(getPlayListRequest.getBucketName(), "/getplaylist", getPlayListRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "object", getPlayListRequest.getObject());
        COSClient.addParameterIfNotNull(request, "expires", getPlayListRequest.getExpires());
        return this.invoke(request, new CIGetSnapshotResponseHandler());
    }

    @Override
    public RecognizeLogoResponse recognizeLogo(RecognizeLogoRequest customRequest) {
        CosHttpRequest<RecognizeLogoRequest> request = this.createRequest(customRequest.getBucketName(), "/", customRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "ci-process", customRequest.getCiProcess());
        COSClient.addParameterIfNotNull(request, "detect-url", customRequest.getDetectUrl());
        return (RecognizeLogoResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<RecognizeLogoResponse>(RecognizeLogoResponse.class));
    }

    @Override
    public CreateDatasetResponse createDataset(CreateDatasetRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<CreateDatasetRequest> request = this.createRequest(customRequest.getAppId(), "/dataset", customRequest, HttpMethodName.POST);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (CreateDatasetResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<CreateDatasetResponse>(CreateDatasetResponse.class));
    }

    @Override
    public CreateDatasetBindingResponse createDatasetBinding(CreateDatasetBindingRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<CreateDatasetBindingRequest> request = this.createRequest(customRequest.getAppId(), "/datasetbinding", customRequest, HttpMethodName.POST);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (CreateDatasetBindingResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<CreateDatasetBindingResponse>(CreateDatasetBindingResponse.class));
    }

    @Override
    public CreateFileMetaIndexResponse createFileMetaIndex(CreateFileMetaIndexRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<CreateFileMetaIndexRequest> request = this.createRequest(customRequest.getAppId(), "/filemeta", customRequest, HttpMethodName.POST);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (CreateFileMetaIndexResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<CreateFileMetaIndexResponse>(CreateFileMetaIndexResponse.class));
    }

    @Override
    public DatasetFaceSearchResponse datasetFaceSearch(DatasetFaceSearchRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DatasetFaceSearchRequest> request = this.createRequest(customRequest.getAppId(), "/datasetquery/facesearch", customRequest, HttpMethodName.POST);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (DatasetFaceSearchResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DatasetFaceSearchResponse>(DatasetFaceSearchResponse.class));
    }

    @Override
    public DatasetSimpleQueryResponse datasetSimpleQuery(DatasetSimpleQueryRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DatasetSimpleQueryRequest> request = this.createRequest(customRequest.getAppId(), "/datasetquery/simple", customRequest, HttpMethodName.POST);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (DatasetSimpleQueryResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DatasetSimpleQueryResponse>(DatasetSimpleQueryResponse.class));
    }

    @Override
    public DeleteDatasetResponse deleteDataset(DeleteDatasetRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DeleteDatasetRequest> request = this.createRequest(customRequest.getAppId(), "/dataset", customRequest, HttpMethodName.DELETE);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (DeleteDatasetResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DeleteDatasetResponse>(DeleteDatasetResponse.class));
    }

    @Override
    public DeleteDatasetBindingResponse deleteDatasetBinding(DeleteDatasetBindingRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DeleteDatasetBindingRequest> request = this.createRequest(customRequest.getAppId(), "/datasetbinding", customRequest, HttpMethodName.DELETE);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (DeleteDatasetBindingResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DeleteDatasetBindingResponse>(DeleteDatasetBindingResponse.class));
    }

    @Override
    public DeleteFileMetaIndexResponse deleteFileMetaIndex(DeleteFileMetaIndexRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<DeleteFileMetaIndexRequest> request = this.createRequest(customRequest.getAppId(), "/filemeta", customRequest, HttpMethodName.DELETE);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (DeleteFileMetaIndexResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DeleteFileMetaIndexResponse>(DeleteFileMetaIndexResponse.class));
    }

    @Override
    public DescribeDatasetResponse describeDataset(DescribeDatasetRequest customRequest) {
        CosHttpRequest<DescribeDatasetRequest> request = this.createRequest(customRequest.getAppId(), "/dataset", customRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "datasetname", customRequest.getDatasetname());
        COSClient.addParameterIfNotNull(request, "statistics", String.valueOf(customRequest.getStatistics()));
        request.addHeader("Accept", "application/json");
        return (DescribeDatasetResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DescribeDatasetResponse>(DescribeDatasetResponse.class));
    }

    @Override
    public DescribeDatasetBindingResponse describeDatasetBinding(DescribeDatasetBindingRequest customRequest) {
        CosHttpRequest<DescribeDatasetBindingRequest> request = this.createRequest(customRequest.getAppId(), "/datasetbinding", customRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "datasetname", customRequest.getDatasetname());
        COSClient.addParameterIfNotNull(request, "uri", customRequest.getUri());
        request.addHeader("Accept", "application/json");
        return (DescribeDatasetBindingResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DescribeDatasetBindingResponse>(DescribeDatasetBindingResponse.class));
    }

    @Override
    public DescribeDatasetBindingsResponse describeDatasetBindings(DescribeDatasetBindingsRequest customRequest) {
        CosHttpRequest<DescribeDatasetBindingsRequest> request = this.createRequest(customRequest.getAppId(), "/datasetbindings", customRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "datasetname", customRequest.getDatasetname());
        COSClient.addParameterIfNotNull(request, "maxresults", customRequest.getMaxresults());
        COSClient.addParameterIfNotNull(request, "nexttoken", customRequest.getNexttoken());
        request.addHeader("Accept", "application/json");
        return (DescribeDatasetBindingsResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DescribeDatasetBindingsResponse>(DescribeDatasetBindingsResponse.class));
    }

    @Override
    public DescribeDatasetsResponse describeDatasets(DescribeDatasetsRequest customRequest) {
        CosHttpRequest<DescribeDatasetsRequest> request = this.createRequest(customRequest.getAppId(), "/datasets", customRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "maxresults", customRequest.getMaxresults());
        COSClient.addParameterIfNotNull(request, "nexttoken", customRequest.getNexttoken());
        COSClient.addParameterIfNotNull(request, "prefix", customRequest.getPrefix());
        request.addHeader("Accept", "application/json");
        return (DescribeDatasetsResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DescribeDatasetsResponse>(DescribeDatasetsResponse.class));
    }

    @Override
    public DescribeFileMetaIndexResponse describeFileMetaIndex(DescribeFileMetaIndexRequest customRequest) {
        CosHttpRequest<DescribeFileMetaIndexRequest> request = this.createRequest(customRequest.getAppId(), "/filemeta", customRequest, HttpMethodName.GET);
        COSClient.addParameterIfNotNull(request, "datasetname", customRequest.getDatasetname());
        COSClient.addParameterIfNotNull(request, "uri", customRequest.getUri());
        request.addHeader("Accept", "application/json");
        return (DescribeFileMetaIndexResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<DescribeFileMetaIndexResponse>(DescribeFileMetaIndexResponse.class));
    }

    @Override
    public SearchImageResponse searchImage(SearchImageRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<SearchImageRequest> request = this.createRequest(customRequest.getAppId(), "/datasetquery/imagesearch", customRequest, HttpMethodName.POST);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (SearchImageResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<SearchImageResponse>(SearchImageResponse.class));
    }

    @Override
    public UpdateDatasetResponse updateDataset(UpdateDatasetRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<UpdateDatasetRequest> request = this.createRequest(customRequest.getAppId(), "/dataset", customRequest, HttpMethodName.PUT);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (UpdateDatasetResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<UpdateDatasetResponse>(UpdateDatasetResponse.class));
    }

    @Override
    public UpdateFileMetaIndexResponse updateFileMetaIndex(UpdateFileMetaIndexRequest customRequest) {
        this.rejectNull(customRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<UpdateFileMetaIndexRequest> request = this.createRequest(customRequest.getAppId(), "/filemeta", customRequest, HttpMethodName.PUT);
        request.addHeader("Accept", "application/json");
        this.setContent(request, CIJackson.toJsonBytes(customRequest), "application/json", false);
        return (UpdateFileMetaIndexResponse)this.invoke(request, new Unmarshallers.CICommonJsonUnmarshaller<UpdateFileMetaIndexResponse>(UpdateFileMetaIndexResponse.class));
    }

    @Override
    public MediaTemplateResponseV2 createMediaTemplateV2(MediaTemplateRequestV2 templateRequest) {
        this.rejectNull(templateRequest, "The request parameter must be specified setting the object tags");
        CosHttpRequest<MediaTemplateRequestV2> request = this.createRequest(templateRequest.getBucketName(), "/template", templateRequest, HttpMethodName.POST);
        this.setContent(request, CIAuditingXmlFactoryV2.convertToXmlByteArray(templateRequest), "application/xml", false);
        return (MediaTemplateResponseV2)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<MediaTemplateResponseV2>(MediaTemplateResponseV2.class));
    }

    @Override
    public ImageOCRResponse imageOCR(ImageOCRRequest ocrRequest) {
        CosHttpRequest<ImageOCRRequest> request = this.createRequest(ocrRequest.getBucketName(), ocrRequest.getObjectKey(), ocrRequest, HttpMethodName.GET);
        request.addParameter("ci-process", "OCR");
        COSClient.addParameterIfNotNull(request, "detect-url", ocrRequest.getDetectUrl());
        COSClient.addParameterIfNotNull(request, "type", ocrRequest.getType());
        COSClient.addParameterIfNotNull(request, "language-type", ocrRequest.getLanguageType());
        COSClient.addParameterIfNotNull(request, "ispdf", String.valueOf(ocrRequest.getPdf()));
        COSClient.addParameterIfNotNull(request, "pdf-pagenumber", ocrRequest.getPdfPageNumber());
        COSClient.addParameterIfNotNull(request, "isword", String.valueOf(ocrRequest.getWord()));
        COSClient.addParameterIfNotNull(request, "enable-word-polygon", String.valueOf(ocrRequest.getEnableWordPolygon()));
        return (ImageOCRResponse)this.invoke(request, new Unmarshallers.CICommonUnmarshaller<ImageOCRResponse>(ImageOCRResponse.class));
    }

    public String generateCosDomainPrivateM3U8Url(PrivateM3U8Request privateM3U8Request) {
        CosHttpRequest<PrivateM3U8Request> request = this.createRequest(privateM3U8Request.getBucketName(), privateM3U8Request.getObject(), privateM3U8Request, HttpMethodName.GET);
        request.addParameter("ci-process", "pm3u8");
        COSClient.addParameterIfNotNull(request, "expires", privateM3U8Request.getExpires());
        COSClient.addParameterIfNotNull(request, "tokenType", privateM3U8Request.getTokenType());
        COSClient.addParameterIfNotNull(request, "token", privateM3U8Request.getToken());
        return this.buildPrivateM3U8Url(request);
    }

    private String buildPrivateM3U8Url(CosHttpRequest<PrivateM3U8Request> request) {
        Date expiredTime = new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ci-process", "pm3u8");
        PrivateM3U8Request originalRequest = request.getOriginalRequest();
        this.putIfNotNull(params, "expires", originalRequest.getExpires());
        this.putIfNotNull(params, "tokenType", originalRequest.getTokenType());
        this.putIfNotNull(params, "token", originalRequest.getToken());
        URL url = this.generatePresignedUrl(request.getBucketName(), request.getResourcePath(), expiredTime, HttpMethodName.GET, new HashMap<String, String>(), params, false, false);
        return url.toString();
    }

    public void putBucketEncryptionConfiguration(String bucketName, BucketEncryptionConfiguration bucketEncryptionConfiguration) throws CosClientException, CosServiceException {
        this.rejectEmpty(bucketName, "The bucket name parameter must be specified when putting bucket encryption");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, null, new CosServiceRequest(), HttpMethodName.PUT);
        request.addParameter("encryption", null);
        this.rejectEmpty(bucketEncryptionConfiguration.getSseAlgorithm(), "The SseAlgorithm parameter must be specified when putting bucket encryption");
        byte[] bytes = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketEncryptionConfiguration);
        request.setContent(new ByteArrayInputStream(bytes));
        request.addHeader("Content-Length", String.valueOf(bytes.length));
        this.invoke(request, this.voidCosResponseHandler);
    }

    public BucketEncryptionConfiguration getBucketEncryptionConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.rejectEmpty(bucketName, "The bucket name parameter must be specified when getting bucket encryption");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, null, new CosServiceRequest(), HttpMethodName.GET);
        request.addParameter("encryption", null);
        return this.invoke(request, new Unmarshallers.BucketEncryptionConfigurationUnmarshaller());
    }

    public void deleteBucketEncryptionConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.rejectEmpty(bucketName, "The bucket name parameter must be specified when deleting bucket encryption");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, null, new CosServiceRequest(), HttpMethodName.DELETE);
        request.addParameter("encryption", null);
        this.invoke(request, this.voidCosResponseHandler);
    }

    public BucketObjectLockConfiguration getBucketObjectLockConfiguration(String bucketName) throws CosClientException, CosServiceException {
        this.rejectEmpty(bucketName, "The bucket name parameter must be specified when getting bucket object lock configuration");
        CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, null, new CosServiceRequest(), HttpMethodName.GET);
        request.addParameter("object-lock", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketObjectLockConfigurationUnmarshaller());
        }
        catch (CosServiceException cse) {
            switch (cse.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw cse;
        }
    }

    public BucketGetMetadataResult getBucketMetadata(String bucketName) throws CosClientException, CosServiceException {
        BucketGetMetadataResult result;
        block5: {
            block4: {
                this.rejectEmpty(bucketName, "The bucket name parameter must be specified when getting bucket metadata");
                result = new BucketGetMetadataResult();
                HeadBucketResult headBucketResult = this.headBucket(new HeadBucketRequest(bucketName));
                result.bucketName = bucketName;
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append(this.clientConfig.getHttpProtocol().toString()).append("://");
                strBuilder.append(this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(this.formatBucket(bucketName, null)));
                result.bucketUrl = strBuilder.toString();
                result.isMaz = headBucketResult.isMazBucket();
                result.isOFS = headBucketResult.isMergeBucket();
                result.location = headBucketResult.getBucketRegion();
                try {
                    BucketEncryptionConfiguration encryptionConfiguration;
                    result.encryptionConfiguration = encryptionConfiguration = this.getBucketEncryptionConfiguration(bucketName);
                }
                catch (CosServiceException cse) {
                    if (cse.getStatusCode() == 404) break block4;
                    throw cse;
                }
            }
            result.accessControlList = this.getBucketAcl(bucketName);
            result.websiteConfiguration = this.getBucketWebsiteConfiguration(bucketName);
            result.loggingConfiguration = this.getBucketLoggingConfiguration(bucketName);
            result.crossOriginConfiguration = this.getBucketCrossOriginConfiguration(bucketName);
            result.versioningConfiguration = this.getBucketVersioningConfiguration(bucketName);
            result.lifecycleConfiguration = this.getBucketLifecycleConfiguration(bucketName);
            try {
                result.replicationConfiguration = this.getBucketReplicationConfiguration(bucketName);
            }
            catch (CosServiceException cse) {
                if (cse.getStatusCode() == 404) break block5;
                throw cse;
            }
        }
        result.taggingConfiguration = this.getBucketTaggingConfiguration(bucketName);
        result.tieringConfigurations = this.listBucketIntelligentTieringConfiguration(bucketName);
        result.bucketObjectLockConfiguration = this.getBucketObjectLockConfiguration(bucketName);
        return result;
    }

    private void preflightObj(PutObjectRequest putObjectRequest) throws CosClientException, CosServiceException {
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        this.rejectEmpty(bucketName, "The bucket name parameter must be specified when doing preflight request");
        this.rejectEmpty(key, "The key parameter must be specified when doing preflight request");
        if (this.clientConfig.isCheckPreflightStatus() && this.preflightBuckets.containsKey(bucketName)) {
            String reqMsg = String.format("will do preflight request for put object[%s] to the bucket[%s]", key, bucketName);
            log.debug(reqMsg);
            putObjectRequest.setHasDonePreflight(true);
            CosServiceRequest serviceRequest = new CosServiceRequest();
            Map<String, String> customHeaders = putObjectRequest.getCustomRequestHeaders();
            if (customHeaders != null) {
                for (Map.Entry<String, String> e : customHeaders.entrySet()) {
                    serviceRequest.putCustomRequestHeader(e.getKey(), e.getValue());
                }
            }
            CosHttpRequest<CosServiceRequest> request = this.createRequest(bucketName, key, serviceRequest, HttpMethodName.HEAD);
            if (putObjectRequest.getFixedEndpointAddr() != null) {
                request.setEndpoint(putObjectRequest.getFixedEndpointAddr());
            }
            request.addParameter("preflight", null);
            ObjectMetadata metadata = putObjectRequest.getMetadata();
            if (metadata != null) {
                COSClient.populateRequestMetadata(request, metadata);
            }
            request.addHeader("x-cos-next-action", "PutObject");
            this.invoke(request, this.voidCosResponseHandler);
        }
    }
}

