/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionMonitor
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(IdleConnectionMonitor.class);
    private static final Map<HttpClientConnectionManager, Long> connectionManagers = new ConcurrentHashMap<HttpClientConnectionManager, Long>();
    private static final int PERIOD_MILLISECONDS = 60000;
    private static volatile IdleConnectionMonitor instance;
    private volatile boolean shuttingDown;

    private IdleConnectionMonitor() {
        super("cos-java-sdk-http-connection-monitor");
        this.setDaemon(true);
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean registerConnectionManager(HttpClientConnectionManager connectionManager, long maxIdleInMs) {
        if (instance == null) {
            Class<IdleConnectionMonitor> clazz = IdleConnectionMonitor.class;
            // MONITORENTER : com.qcloud.cos.http.IdleConnectionMonitor.class
            if (instance == null) {
                instance = new IdleConnectionMonitor();
                instance.start();
            }
            // MONITOREXIT : clazz
        }
        if (connectionManagers.put(connectionManager, maxIdleInMs) != null) return false;
        return true;
    }

    public static boolean removeConnectionManager(HttpClientConnectionManager connectionManager) {
        boolean wasRemoved;
        boolean bl = wasRemoved = connectionManagers.remove(connectionManager) != null;
        if (connectionManagers.isEmpty()) {
            IdleConnectionMonitor.shutdown();
        }
        return wasRemoved;
    }

    public static List<HttpClientConnectionManager> getRegisteredConnectionManagers() {
        return new ArrayList<HttpClientConnectionManager>(connectionManagers.keySet());
    }

    public static synchronized boolean shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        while (!this.shuttingDown) {
            try {
                for (Map.Entry<HttpClientConnectionManager, Long> entry : connectionManagers.entrySet()) {
                    try {
                        entry.getKey().closeExpiredConnections();
                        entry.getKey().closeIdleConnections(entry.getValue().longValue(), TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        log.warn("Unable to closeExpiredConnections and closeIdleConnections, ", (Throwable)e);
                    }
                }
                Thread.sleep(60000L);
            }
            catch (Throwable t) {
                log.error("error occurred when closeExpiredConnections and closeIdleConnections, err:", t);
            }
        }
        log.debug("Shutting down reaper thread.");
    }
}

