/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.internal.CosClientAbortTask;
import com.qcloud.cos.internal.CosClientAbortTaskMonitor;
import java.util.concurrent.ScheduledFuture;
import org.apache.http.client.methods.HttpRequestBase;

public class CosClientAbortTaskMonitorImpl
implements CosClientAbortTaskMonitor {
    private final CosClientAbortTask abortTask;
    private final ScheduledFuture<?> scheduledFuture;

    public CosClientAbortTaskMonitorImpl(CosClientAbortTask task, ScheduledFuture<?> future) {
        if (task == null) {
            throw new IllegalArgumentException("CosClientAbortTask should not be null");
        }
        this.abortTask = task;
        if (future == null) {
            throw new IllegalArgumentException("ScheduledFuture should not be null");
        }
        this.scheduledFuture = future;
    }

    @Override
    public void setCurrentHttpRequest(HttpRequestBase newRequest) {
        this.abortTask.setCurrentHttpRequest(newRequest);
    }

    @Override
    public boolean hasTimeoutExpired() {
        return this.abortTask.hasClientExecutionAborted();
    }

    @Override
    public boolean isEnabled() {
        return this.abortTask.isEnabled();
    }

    @Override
    public void cancelTask() {
        this.scheduledFuture.cancel(false);
        this.abortTask.cancel();
    }
}

