/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaListJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class JobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        JobDemo.createMediaJobs(client);
    }

    public static void createMediaJobs(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-123456789");
        request.setTag("Transcode");
        request.getInput().setObject("1.mp4");
        request.getOperation().setTemplateId("t0e09a9456d4124542b1f0e44d501*****");
        request.getOperation().getOutput().setBucket("demo-123456789");
        request.getOperation().getOutput().setRegion("ap-chongqing");
        request.getOperation().getOutput().setObject("2.mp4");
        request.setCallBack("https://cloud.tencent.com/xxx");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(response);
    }

    public static void createMediaJobs2(COSClient client) throws UnsupportedEncodingException {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-123456789");
        request.setTag("Transcode");
        request.getInput().setObject("2.mp4");
        MediaJobOperation operation = request.getOperation();
        MediaTranscodeObject transcode = operation.getTranscode();
        MediaContainerObject container = transcode.getContainer();
        container.setFormat("mp4");
        MediaTranscodeVideoObject video = transcode.getVideo();
        video.setCodec("H.264");
        video.setProfile("high");
        video.setBitrate("1000");
        video.setWidth("1280");
        video.setFps("30");
        video.setPreset("medium");
        video.setBufSize("0");
        video.setMaxrate("50000");
        MediaAudioObject audio = transcode.getAudio();
        audio.setCodec("aac");
        audio.setSamplerate("44100");
        audio.setBitrate("128");
        audio.setChannels("4");
        MediaTimeIntervalObject timeInterval = transcode.getTimeInterval();
        timeInterval.setStart("0");
        timeInterval.setDuration("60");
        MediaTransConfigObject transConfig = transcode.getTransConfig();
        transConfig.setAdjDarMethod("scale");
        transConfig.setIsCheckAudioBitrate("false");
        transConfig.setResoAdjMethod("1");
        List<MediaRemoveWaterMark> removeWatermarkList = operation.getRemoveWatermarkList();
        MediaRemoveWaterMark removeWaterMark = new MediaRemoveWaterMark();
        removeWaterMark.setDx("1");
        removeWaterMark.setDy("2");
        removeWaterMark.setWidth("10");
        removeWaterMark.setHeight("10");
        removeWaterMark.setStartTime("0");
        removeWaterMark.setEndTime("1");
        removeWatermarkList.add(removeWaterMark);
        removeWaterMark = new MediaRemoveWaterMark();
        removeWaterMark.setDx("2");
        removeWaterMark.setDy("3");
        removeWaterMark.setWidth("10");
        removeWaterMark.setHeight("10");
        removeWaterMark.setStartTime("1");
        removeWaterMark.setEndTime("3");
        removeWatermarkList.add(removeWaterMark);
        operation.getOutput().setBucket("demo-1234567890");
        operation.getOutput().setRegion("ap-chongqing");
        operation.getOutput().setObject("result.mp4");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(response.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-1234567890");
        request.setJobId("j3f4cb81a0ed811f0a970b306b67*****");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(response);
    }

    public static void describeMediaJobs(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-123456789");
        request.setTag("Transcode");
        MediaListJobResponse response = client.describeMediaJobs(request);
        List<MediaJobObject> jobsDetail = response.getJobsDetailList();
        for (MediaJobObject mediaJobObject : jobsDetail) {
            System.out.println(mediaJobObject.getOperation().getTranscode());
        }
    }

    public static void cancelMediaJob(COSClient client) {
        MediaJobsRequest request = new MediaJobsRequest();
        request.setBucketName("demo-123456789");
        request.setJobId("jbfb0d02a092111ebb3167781d*****");
        Boolean response = client.cancelMediaJob(request);
        System.out.println(response);
    }
}

