/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSSigner;
import com.qcloud.cos.endpoint.CIPicRegionEndpointBuilder;
import com.qcloud.cos.endpoint.CIRegionEndpointBuilder;
import com.qcloud.cos.event.ProgressInputStream;
import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.exception.AbortedException;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.ExceptionLogDetail;
import com.qcloud.cos.exception.ResponseNotCompleteException;
import com.qcloud.cos.http.CosHttpClient;
import com.qcloud.cos.http.CosHttpClientTimer;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HandlerAfterProcess;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.http.IdleConnectionMonitor;
import com.qcloud.cos.http.IdleConnectionMonitorThread;
import com.qcloud.cos.internal.CIPicServiceRequest;
import com.qcloud.cos.internal.CIServiceRequest;
import com.qcloud.cos.internal.CIWorkflowServiceRequest;
import com.qcloud.cos.internal.CosClientAbortTaskMonitor;
import com.qcloud.cos.internal.CosErrorResponseHandler;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.SdkBufferedInputStream;
import com.qcloud.cos.internal.cihandler.HttpEntityEnclosingDelete;
import com.qcloud.cos.model.ListBucketsRequest;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.retry.BackoffStrategy;
import com.qcloud.cos.retry.RetryPolicy;
import com.qcloud.cos.utils.CodecUtils;
import com.qcloud.cos.utils.ExceptionUtils;
import com.qcloud.cos.utils.UrlEncoderUtils;
import com.qcloud.cos.utils.ValidationUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosHttpClient
implements CosHttpClient {
    protected ClientConfig clientConfig;
    private RequestConfig requestConfig;
    protected HttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;
    private IdleConnectionMonitorThread idleConnectionMonitorThread;
    private int maxErrorRetry;
    private RetryPolicy retryPolicy;
    private BackoffStrategy backoffStrategy;
    private CosErrorResponseHandler errorResponseHandler = new CosErrorResponseHandler();
    private HandlerAfterProcess handlerAfterProcess;
    private final CosHttpClientTimer cosHttpClientTimer;
    private static final Logger log = LoggerFactory.getLogger(DefaultCosHttpClient.class);

    public DefaultCosHttpClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.handlerAfterProcess = clientConfig.getHandlerAfterProcess();
        DnsResolver dnsResolver = new DnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                InetAddress[] addresses = InetAddress.getAllByName(host);
                ArrayList<InetAddress> addressList = new ArrayList<InetAddress>(Arrays.asList(addresses));
                Collections.shuffle(addressList);
                InetAddress[] newAddresses = addressList.toArray(new InetAddress[0]);
                return newAddresses;
            }
        };
        if (clientConfig.isCheckSSLCertificate()) {
            if (clientConfig.isUseDefaultDnsResolver()) {
                this.connectionManager = new PoolingHttpClientConnectionManager();
            } else {
                Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
                this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, dnsResolver);
            }
        } else {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
                this.connectionManager = clientConfig.isUseDefaultDnsResolver() ? new PoolingHttpClientConnectionManager(socketFactoryRegistry) : new PoolingHttpClientConnectionManager(socketFactoryRegistry, dnsResolver);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("fail to init http client: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                log.error("fail to init http client: ", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                log.error("fail to init http client: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.maxErrorRetry = clientConfig.getMaxErrorRetry();
        this.retryPolicy = ValidationUtils.assertNotNull(clientConfig.getRetryPolicy(), "retry policy");
        this.retryPolicy.setRetryAfterPreflight(clientConfig.isRetryAfterPreflight());
        this.backoffStrategy = ValidationUtils.assertNotNull(clientConfig.getBackoffStrategy(), "backoff strategy");
        this.cosHttpClientTimer = new CosHttpClientTimer();
        this.initHttpClient();
    }

    private void initHttpClient() {
        this.connectionManager.setMaxTotal(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setValidateAfterInactivity(1);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.clientConfig.getHttpProxyIp() != null && this.clientConfig.getHttpProxyPort() != 0) {
            HttpHost proxy = new HttpHost(this.clientConfig.getHttpProxyIp(), this.clientConfig.getHttpProxyPort());
            httpClientBuilder.setProxy(proxy);
        }
        this.httpClient = httpClientBuilder.build();
        this.requestConfig = RequestConfig.custom().setContentCompressionEnabled(false).setConnectionRequestTimeout(this.clientConfig.getConnectionRequestTimeout()).setConnectTimeout(this.clientConfig.getConnectionTimeout()).setSocketTimeout(this.clientConfig.getSocketTimeout()).setRedirectsEnabled(this.clientConfig.isRedirectsEnabled()).build();
        if (this.clientConfig.isUseConnectionMonitor()) {
            IdleConnectionMonitor.registerConnectionManager((HttpClientConnectionManager)this.connectionManager, this.clientConfig.getConnectionMaxIdleMillis());
        } else {
            this.idleConnectionMonitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)this.connectionManager);
            this.idleConnectionMonitorThread.setIdleAliveMS(this.clientConfig.getIdleConnectionAlive());
            this.idleConnectionMonitorThread.setDaemon(true);
            this.idleConnectionMonitorThread.start();
        }
    }

    @Override
    public void shutdown() {
        if (this.clientConfig.isPrintShutdownStackTrace()) {
            StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
            StringBuilder trace = new StringBuilder("shutdown stackTrace:");
            for (int i = 1; i < stackTraces.length; ++i) {
                trace.append("\n");
                StackTraceElement element = stackTraces[i];
                String stackTrace = "Class: " + element.getClassName() + ", Method: " + element.getMethodName() + ", Line: " + element.getLineNumber();
                trace.append(stackTrace);
            }
            log.info(trace.toString());
        }
        this.cosHttpClientTimer.shutdown();
        if (this.clientConfig.isUseConnectionMonitor()) {
            IdleConnectionMonitor.removeConnectionManager((HttpClientConnectionManager)this.connectionManager);
            this.connectionManager.shutdown();
        } else {
            this.idleConnectionMonitorThread.shutdown();
        }
    }

    private <X extends CosServiceRequest> URI buildUri(CosHttpRequest<X> request) {
        String paramKey;
        StringBuffer urlBuffer = new StringBuffer();
        urlBuffer.append(request.getProtocol().toString()).append("://").append(request.getEndpoint());
        String encodedPath = UrlEncoderUtils.encodeUrlPath(request.getResourcePath());
        urlBuffer.append(encodedPath);
        StringBuffer paramBuffer = new StringBuffer();
        boolean seeOne = false;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.putAll(request.getParameters());
        Map<String, List<String>> customParamsList = ((CosServiceRequest)request.getOriginalRequest()).getCustomQueryParameters();
        if (customParamsList != null) {
            for (Map.Entry<String, List<String>> entry : customParamsList.entrySet()) {
                paramKey = entry.getKey();
                List<String> paramValueList = entry.getValue();
                int paramValueNum = paramValueList.size();
                for (int paramValueIndex = 0; paramValueIndex < paramValueNum; ++paramValueIndex) {
                    requestParams.put(paramKey, paramValueList.get(paramValueIndex));
                }
            }
        }
        for (Map.Entry<String, List<String>> entry : requestParams.entrySet()) {
            String paramValue;
            paramKey = entry.getKey();
            if (paramKey == null) continue;
            if (seeOne) {
                paramBuffer.append("&");
            }
            paramBuffer.append(UrlEncoderUtils.encode(paramKey));
            if (!seeOne) {
                seeOne = true;
            }
            if ((paramValue = (String)((Object)entry.getValue())) == null) continue;
            paramBuffer.append("=");
            paramBuffer.append(UrlEncoderUtils.encode(paramValue));
        }
        String paramStr = paramBuffer.toString();
        if (!paramStr.isEmpty()) {
            urlBuffer.append("?").append(paramStr);
            if (request.getCiSpecialEndParameter() != null) {
                urlBuffer.append("&").append(request.getCiSpecialEndParameter());
            }
        } else if (request.getCiSpecialEndParameter() != null) {
            urlBuffer.append("?").append(request.getCiSpecialEndParameter());
        }
        try {
            URI uRI = new URI(urlBuffer.toString());
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CosClientException("build uri error! url: " + urlBuffer.toString() + ", CosHttpRequest: " + request.toString(), uRISyntaxException);
        }
    }

    private <X extends CosServiceRequest> HttpRequestBase buildHttpRequest(CosHttpRequest<X> request) throws CosClientException {
        Object httpRequestBase = null;
        HttpMethodName httpMethodName = request.getHttpMethod();
        if (httpMethodName.equals((Object)HttpMethodName.PUT)) {
            httpRequestBase = new HttpPut();
        } else if (httpMethodName.equals((Object)HttpMethodName.GET)) {
            httpRequestBase = new HttpGet();
        } else if (httpMethodName.equals((Object)HttpMethodName.DELETE)) {
            httpRequestBase = request.getOriginalRequest() instanceof CIServiceRequest ? new HttpEntityEnclosingDelete() : new HttpDelete();
        } else if (httpMethodName.equals((Object)HttpMethodName.POST)) {
            httpRequestBase = new HttpPost();
        } else if (httpMethodName.equals((Object)HttpMethodName.HEAD)) {
            httpRequestBase = new HttpHead();
        } else {
            throw new CosClientException("unsupported http method " + (Object)((Object)httpMethodName));
        }
        httpRequestBase.setURI(this.buildUri(request));
        long contentLength = -1L;
        Map<String, String> requestHeaders = request.getHeaders();
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            String string = entry.getKey();
            String headerValue = entry.getValue();
            if (string.equals("Content-Length")) {
                contentLength = Long.parseLong(headerValue);
                continue;
            }
            headerValue = CodecUtils.convertFromUtf8ToIso88591(headerValue);
            httpRequestBase.addHeader(string, headerValue);
        }
        Map<String, String> customRequestHeaders = ((CosServiceRequest)request.getOriginalRequest()).getCustomRequestHeaders();
        if (customRequestHeaders != null) {
            for (Map.Entry<String, String> entry : customRequestHeaders.entrySet()) {
                String headerKey = entry.getKey();
                String headerValue = entry.getValue();
                if (headerKey.equals("Content-Length")) {
                    contentLength = Long.parseLong(headerValue);
                    continue;
                }
                headerValue = CodecUtils.convertFromUtf8ToIso88591(headerValue);
                httpRequestBase.addHeader(headerKey, headerValue);
            }
        }
        if (this.clientConfig.isAddLogDebugHeader()) {
            if (log.isDebugEnabled()) {
                httpRequestBase.addHeader("x-cos-sdk-log-debug", "on");
            } else {
                httpRequestBase.addHeader("x-cos-sdk-log-debug", "off");
            }
        }
        if (this.clientConfig.isShortConnection()) {
            httpRequestBase.addHeader("Connection", "close");
        }
        if (request.getContent() != null) {
            InputStreamEntity inputStreamEntity = new InputStreamEntity(request.getContent(), contentLength);
            if (httpMethodName.equals((Object)HttpMethodName.PUT) || httpMethodName.equals((Object)HttpMethodName.POST)) {
                HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = (HttpEntityEnclosingRequestBase)httpRequestBase;
                httpEntityEnclosingRequestBase.setEntity((HttpEntity)inputStreamEntity);
            } else if (httpMethodName.equals((Object)HttpMethodName.DELETE) && request.getOriginalRequest() instanceof CIServiceRequest) {
                HttpEntityEnclosingDelete httpEntityEnclosingDelete = (HttpEntityEnclosingDelete)((Object)httpRequestBase);
                httpEntityEnclosingDelete.setEntity((HttpEntity)inputStreamEntity);
            }
        }
        httpRequestBase.setConfig(this.requestConfig);
        if (this.clientConfig.useBasicAuth()) {
            this.setBasicProxyAuthorization((HttpRequestBase)httpRequestBase);
        }
        return httpRequestBase;
    }

    private boolean isRequestSuccessful(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = -1;
        if (statusLine != null) {
            statusCode = statusLine.getStatusCode();
        }
        return statusCode / 100 == 2;
    }

    private <X extends CosServiceRequest> CosHttpResponse createResponse(HttpRequestBase httpRequestBase, CosHttpRequest<X> request, HttpResponse apacheHttpResponse) throws IOException {
        ProgressListener progressListener = request.getProgressListener();
        CosHttpResponse httpResponse = new CosHttpResponse(request, httpRequestBase);
        if (apacheHttpResponse.getEntity() != null) {
            InputStream oriIn = apacheHttpResponse.getEntity().getContent();
            InputStream progressIn = null;
            if (oriIn != null) {
                progressIn = ProgressInputStream.inputStreamForResponse(oriIn, progressListener);
                httpResponse.setContent(progressIn);
            }
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            String value = CodecUtils.convertFromIso88591ToUtf8(header.getValue());
            httpResponse.addHeader(header.getName(), value);
        }
        return httpResponse;
    }

    private <X extends CosServiceRequest> CosServiceException handlerErrorMessage(CosHttpRequest<X> request, HttpRequestBase httpRequestBase, HttpResponse apacheHttpResponse) throws IOException {
        String reasonPhrase;
        int statusCode;
        StatusLine statusLine = apacheHttpResponse.getStatusLine();
        if (statusLine == null) {
            statusCode = -1;
            reasonPhrase = null;
        } else {
            statusCode = statusLine.getStatusCode();
            reasonPhrase = statusLine.getReasonPhrase();
        }
        CosHttpResponse response = this.createResponse(httpRequestBase, request, apacheHttpResponse);
        CosServiceException exception = null;
        try {
            exception = this.errorResponseHandler.handle(response);
            log.debug("Received error response: " + exception);
        }
        catch (Exception e) {
            if (statusCode == 413) {
                exception = new CosServiceException("Request entity too large");
                exception.setStatusCode(statusCode);
                exception.setErrorType(CosServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (statusCode == 503 && "Service Unavailable".equalsIgnoreCase(reasonPhrase)) {
                exception = new CosServiceException("Service unavailable");
                exception.setStatusCode(statusCode);
                exception.setErrorType(CosServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + "). Response Code: " + (statusLine == null ? "None" : Integer.valueOf(statusCode)) + ", Response Text: " + reasonPhrase;
            throw new CosClientException(errorMessage, e);
        }
        exception.setStatusCode(statusCode);
        exception.fillInStackTrace();
        return exception;
    }

    private <X extends CosServiceRequest> void bufferAndResetAbleContent(CosHttpRequest<X> request) {
        InputStream origContent = request.getContent();
        if (origContent != null) {
            InputStream toBeClosed = this.buffer(this.makeResettable(origContent));
            InputStream notCloseable = toBeClosed == null ? null : (InputStream)ReleasableInputStream.wrap(toBeClosed).disableClose();
            request.setContent(notCloseable);
        }
    }

    private InputStream monitorStreamProgress(ProgressListener listener, InputStream content) {
        return ProgressInputStream.inputStreamForRequest(content, listener);
    }

    private void setBasicProxyAuthorization(HttpRequestBase httpRequest) {
        String auth = this.clientConfig.getProxyUsername() + ":" + this.clientConfig.getProxyPassword();
        String authHeader = "Basic " + new String(Base64.encodeBase64((byte[])auth.getBytes()));
        httpRequest.addHeader("Proxy-Authorization", authHeader);
    }

    private <X extends CosServiceRequest> void checkResponse(CosHttpRequest<X> request, HttpRequestBase httpRequest, HttpResponse httpResponse) {
        if (!this.isRequestSuccessful(httpResponse)) {
            try {
                try {
                    throw this.handlerErrorMessage(request, httpRequest, httpResponse);
                }
                catch (IOException ioe) {
                    String errorMsg = "Unable to execute HTTP request: " + ioe.getMessage();
                    log.error(errorMsg, (Throwable)ioe);
                    CosServiceException cse = new CosServiceException(errorMsg, ioe);
                    throw cse;
                }
            }
            catch (Throwable throwable) {
                httpRequest.abort();
                throw throwable;
            }
        }
    }

    private <X extends CosServiceRequest> boolean isRetryableRequest(CosHttpRequest<X> request) {
        if (request.getContent() == null || request.getContent().markSupported()) {
            return true;
        }
        log.info("The content of the request is not null and not markSupported, the request is not retryable");
        return false;
    }

    private <X extends CosServiceRequest> boolean shouldRetry(CosHttpRequest<X> request, HttpResponse response, Exception exception, int retryIndex, RetryPolicy retryPolicy) {
        if (retryIndex >= this.maxErrorRetry) {
            return false;
        }
        if (!this.isRetryableRequest(request)) {
            return false;
        }
        if (exception instanceof CosServiceException && (((CosServiceException)exception).getStatusCode() == 301 || ((CosServiceException)exception).getStatusCode() == 302 || ((CosServiceException)exception).getStatusCode() == 307)) {
            return this.shouldRetry3xxException(request, (CosServiceException)exception);
        }
        return retryPolicy.shouldRetry(request, response, exception, retryIndex);
    }

    private <X extends CosServiceRequest> boolean shouldRetry3xxException(CosHttpRequest<X> request, CosServiceException cse) {
        if (!this.clientConfig.isChangeEndpointRetry() || cse.getRequestId() != null && !cse.getRequestId().isEmpty()) {
            return false;
        }
        Map<String, String> reqHeaders = request.getHeaders();
        if (!reqHeaders.isEmpty() && reqHeaders.containsKey("Host")) {
            String lastEndpoint = request.getEndpoint();
            String lastHost = reqHeaders.get("Host");
            return this.isCosDefaultHost(lastHost, lastEndpoint);
        }
        return false;
    }

    protected HttpResponse executeOneRequest(HttpContext context, HttpRequestBase httpRequest) throws Exception {
        return this.httpClient.execute((HttpUriRequest)httpRequest, context);
    }

    private void closeHttpResponseStream(HttpResponse httpResponse) {
        try {
            if (httpResponse != null && httpResponse.getEntity() != null && httpResponse.getEntity().getContent() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
        catch (IOException e) {
            log.error("exception occur:", (Throwable)e);
        }
    }

    @Override
    public <X, Y extends CosServiceRequest> X exeute(CosHttpRequest<Y> request, HttpResponseHandler<CosServiceResponse<X>> responseHandler) throws CosClientException, CosServiceException {
        String errorMsg;
        HttpResponse httpResponse = null;
        HttpRequestBase httpRequest = null;
        this.bufferAndResetAbleContent(request);
        ProgressListener progressListener = request.getProgressListener();
        InputStream originalContent = request.getContent();
        if (originalContent != null) {
            request.setContent(this.monitorStreamProgress(progressListener, originalContent));
        }
        if (originalContent != null && originalContent.markSupported() && !(originalContent instanceof BufferedInputStream)) {
            int readLimit = this.clientConfig.getReadLimit();
            originalContent.mark(readLimit);
        }
        long startTime = 0L;
        long endTime = 0L;
        int response_status = 0;
        int retryIndex = 0;
        while (true) {
            try {
                this.checkInterrupted();
                if (originalContent instanceof BufferedInputStream && originalContent.markSupported()) {
                    int readLimit = this.clientConfig.getReadLimit();
                    originalContent.mark(readLimit);
                }
                if (retryIndex != 0 && originalContent != null) {
                    originalContent.reset();
                }
                if (retryIndex != 0) {
                    response_status = 0;
                    if (this.clientConfig.IsRefreshEndpointAddr()) {
                        this.refreshEndpointAddr(request);
                    }
                    long delay = this.backoffStrategy.computeDelayBeforeNextRetry(retryIndex);
                    request.addHeader("x-cos-sdk-retry", "true");
                    Thread.sleep(delay);
                }
                HttpClientContext context = HttpClientContext.create();
                httpRequest = this.buildHttpRequest(request);
                httpResponse = null;
                startTime = System.currentTimeMillis();
                httpResponse = this.clientConfig.getRequestTimeOutEnable() ? this.executeRequestWithTimeout((HttpContext)context, httpRequest, request) : this.executeRequest((HttpContext)context, httpRequest);
                this.checkResponse(request, httpRequest, httpResponse);
            }
            catch (CosServiceException cse) {
                response_status = -1;
                this.closeHttpResponseStream(httpResponse);
                errorMsg = String.format("failed to execute http request due to service exception, request timeStamp %d, httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", System.currentTimeMillis(), request, retryIndex, this.maxErrorRetry);
                request.addLogDetails(new ExceptionLogDetail(cse, errorMsg));
                if (!this.shouldRetry(request, httpResponse, cse, retryIndex, this.retryPolicy)) {
                    int status_code_thresh = this.clientConfig.getErrorLogStatusCodeThresh();
                    if (status_code_thresh < 0) {
                        status_code_thresh = 500;
                    }
                    if (cse.getStatusCode() >= status_code_thresh) {
                        this.handleLog(request);
                    }
                    throw cse;
                }
                this.changeEndpointForRetry(request, httpResponse, retryIndex);
                continue;
            }
            catch (CosClientException cce) {
                response_status = -1;
                this.closeHttpResponseStream(httpResponse);
                errorMsg = String.format("failed to execute http request due to client exception, request timeStamp %d, httpRequest: %s, retryIdx:%d, maxErrorRetry:%d", System.currentTimeMillis(), request, retryIndex, this.maxErrorRetry);
                request.addLogDetails(new ExceptionLogDetail(cce, errorMsg));
                if (!this.shouldRetry(request, httpResponse, cce, retryIndex, this.retryPolicy)) {
                    this.handleLog(request);
                    throw cce;
                }
                this.changeEndpointForRetry(request, httpResponse, retryIndex);
                continue;
            }
            catch (Exception exp) {
                response_status = -1;
                String expName = exp.getClass().getName();
                String errorMsg2 = String.format("httpClient execute occur an unknown exception:%s, httpRequest: %s", expName, request);
                this.closeHttpResponseStream(httpResponse);
                log.error(errorMsg2, (Throwable)exp);
                throw new CosClientException(errorMsg2, exp);
            }
            catch (Error e) {
                errorMsg = String.format("httpClient execute occur an error, httpRequest: %s", request);
                this.closeHttpResponseStream(httpResponse);
                log.error(errorMsg, (Throwable)e);
                throw e;
            }
            finally {
                endTime = System.currentTimeMillis();
                this.handlerAfterProcess.handle(response_status, endTime - startTime);
                ++retryIndex;
                continue;
            }
            break;
        }
        try {
            CosHttpResponse cosHttpResponse = this.createResponse(httpRequest, request, httpResponse);
            errorMsg = responseHandler.handle(cosHttpResponse).getResult();
            return (X)errorMsg;
        }
        catch (Exception e) {
            if (e.getMessage().equals("Premature end of chunk coded message body: closing chunk expected")) {
                throw new ResponseNotCompleteException("response chunk not complete", e);
            }
            errorMsg = "Unable to execute response handle: " + e.getMessage();
            log.info(errorMsg, (Throwable)e);
            CosClientException cce = new CosClientException(errorMsg, e);
            throw cce;
        }
        finally {
            if (!responseHandler.needsConnectionLeftOpen()) {
                httpRequest.releaseConnection();
            }
        }
    }

    private InputStream makeResettable(InputStream content) {
        block3: {
            if (!content.markSupported() && content instanceof FileInputStream) {
                try {
                    return new ResettableInputStream((FileInputStream)content);
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("For the record; ignore otherwise", (Throwable)e);
                }
            }
        }
        return content;
    }

    private InputStream buffer(InputStream content) {
        if (!content.markSupported()) {
            content = new SdkBufferedInputStream(content);
        }
        return content;
    }

    private void checkInterrupted() throws CosClientException {
        if (Thread.interrupted()) {
            throw new CosClientException("operation has been interrupted!");
        }
    }

    private HttpResponse executeRequest(HttpContext context, HttpRequestBase httpRequest) throws Exception {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.executeOneRequest(context, httpRequest);
        }
        catch (IOException e) {
            httpRequest.abort();
            throw ExceptionUtils.createClientException(e);
        }
        catch (InterruptedException e) {
            httpRequest.abort();
            throw new CosClientException(e.getMessage(), e);
        }
        catch (TimeoutException e) {
            httpRequest.abort();
            String errorMsg = "ExecutorService: time out after waiting  " + this.clientConfig.getRequestTimeout() / 1000 + " seconds";
            throw new CosClientException(errorMsg, "RequestTimeout", e);
        }
        catch (ExecutionException e) {
            httpRequest.abort();
            if (e.getCause() instanceof IOException) {
                throw ExceptionUtils.createClientException((IOException)e.getCause());
            }
            throw new CosServiceException(e.getMessage(), e);
        }
        return httpResponse;
    }

    private <Y extends CosServiceRequest> HttpResponse executeRequestWithTimer(HttpContext context, HttpRequestBase httpRequest, CosHttpRequest<Y> originRequest) throws Exception {
        CosClientAbortTaskMonitor abortTaskMonitor = this.cosHttpClientTimer.startTimer(this.clientConfig.getRequestTimeout());
        abortTaskMonitor.setCurrentHttpRequest(httpRequest);
        HttpResponse httpResponse = null;
        try {
            originRequest.setClientAbortTaskMonitor(abortTaskMonitor);
            httpResponse = this.executeOneRequest(context, httpRequest);
        }
        catch (IOException ie) {
            if (originRequest.getClientAbortTaskMonitor().hasTimeoutExpired()) {
                Thread.interrupted();
                String errorMsg = String.format("catch IOException when executing http request[%s], and execution aborted task has been done, exp:", originRequest);
                log.error(errorMsg, (Throwable)ie);
                throw new InterruptedException();
            }
            throw ie;
        }
        finally {
            originRequest.getClientAbortTaskMonitor().cancelTask();
        }
        return httpResponse;
    }

    private <Y extends CosServiceRequest> HttpResponse executeRequestWithTimeout(HttpContext context, HttpRequestBase httpRequest, CosHttpRequest<Y> originRequest) throws Exception {
        try {
            HttpResponse httpResponse = this.executeRequestWithTimer(context, httpRequest, originRequest);
            return httpResponse;
        }
        catch (InterruptedException ie) {
            if (originRequest.getClientAbortTaskMonitor().hasTimeoutExpired()) {
                Thread.interrupted();
                String errorMsg = "InterruptedException: time out after waiting  " + this.clientConfig.getRequestTimeout() / 1000 + " seconds";
                throw new CosClientException(errorMsg, "RequestTimeout", ie);
            }
            if (!httpRequest.isAborted()) {
                httpRequest.abort();
            }
            throw ie;
        }
        catch (AbortedException ae) {
            if (originRequest.getClientAbortTaskMonitor().hasTimeoutExpired()) {
                Thread.interrupted();
                String errorMsg = "AbortedException: time out after waiting  " + this.clientConfig.getRequestTimeout() / 1000 + " seconds";
                throw new CosClientException(errorMsg, "RequestTimeout", ae);
            }
            if (!httpRequest.isAborted()) {
                httpRequest.abort();
            }
            throw ae;
        }
        catch (IOException ie) {
            if (!httpRequest.isAborted()) {
                httpRequest.abort();
            }
            throw ExceptionUtils.createClientException(ie);
        }
        finally {
            if (originRequest.getClientAbortTaskMonitor().hasTimeoutExpired()) {
                Thread.interrupted();
            }
        }
    }

    private <Y extends CosServiceRequest> void handleLog(CosHttpRequest<Y> request) {
        for (ExceptionLogDetail logDetail : request.getExceptionsLogDetails()) {
            log.error(logDetail.getErrMsg(), logDetail.getException());
        }
    }

    private <Y extends CosServiceRequest> void changeEndpointForRetry(CosHttpRequest<Y> request, HttpResponse httpResponse, int retryIndex) {
        Map<String, String> reqHeaders;
        if (httpResponse != null) {
            Header[] statusLine = httpResponse.getStatusLine();
            int statusCode = -1;
            if (statusLine != null) {
                statusCode = statusLine.getStatusCode();
            }
            if (statusCode == 301 || statusCode == 302 || statusCode == 307) {
                this.changeRequestHost(request);
                return;
            }
        }
        if (!this.clientConfig.isChangeEndpointRetry() || retryIndex != this.maxErrorRetry - 1) {
            return;
        }
        if (httpResponse != null) {
            for (Header header : httpResponse.getAllHeaders()) {
                String value;
                if (!Objects.equals(header.getName(), "x-cos-request-id") || (value = CodecUtils.convertFromIso88591ToUtf8(header.getValue())) == null || value.isEmpty()) continue;
                return;
            }
        }
        if (!(reqHeaders = request.getHeaders()).isEmpty() && reqHeaders.containsKey("Host")) {
            String lastEndpoint = request.getEndpoint();
            String lastHost = reqHeaders.get("Host");
            if (this.isCosDefaultHost(lastHost, lastEndpoint)) {
                this.changeRequestHost(request);
            }
        }
    }

    private <X extends CosServiceRequest> void refreshEndpointAddr(CosHttpRequest<X> request) throws CosClientException {
        boolean isCIRequest = request.getOriginalRequest() instanceof CIServiceRequest;
        boolean isServiceRequest = request.getOriginalRequest() instanceof ListBucketsRequest;
        String endpoint = "";
        String endpointAddr = "";
        if (isServiceRequest) {
            endpoint = this.clientConfig.getEndpointBuilder().buildGetServiceApiEndpoint();
            endpointAddr = this.clientConfig.getEndpointResolver().resolveGetServiceApiEndpoint(endpoint);
        } else {
            endpoint = request.getOriginalRequest() instanceof CIPicServiceRequest ? new CIPicRegionEndpointBuilder(this.clientConfig.getRegion()).buildGeneralApiEndpoint(request.getBucketName()) : (isCIRequest ? new CIRegionEndpointBuilder(this.clientConfig.getRegion()).buildGeneralApiEndpoint(request.getBucketName()) : this.clientConfig.getEndpointBuilder().buildGeneralApiEndpoint(request.getBucketName()));
            endpointAddr = this.clientConfig.getEndpointResolver().resolveGeneralApiEndpoint(endpoint);
        }
        if (endpoint == null) {
            throw new CosClientException("endpoint is null, please check your endpoint builder");
        }
        if (endpointAddr == null) {
            throw new CosClientException("endpointAddr is null, please check your endpoint resolver");
        }
        String fixedEndpointAddr = ((CosServiceRequest)request.getOriginalRequest()).getFixedEndpointAddr();
        if (fixedEndpointAddr != null) {
            request.setEndpoint(fixedEndpointAddr);
        } else {
            request.setEndpoint(endpointAddr);
        }
    }

    private boolean isCosDefaultHost(String host, String endPoint) {
        String regex = ".+-\\d+\\.cos\\..+\\.myqcloud\\.com";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcherEndpoint = pattern.matcher(endPoint);
        Matcher matcherHost = pattern.matcher(host);
        boolean isAccEndpoint = endPoint.endsWith("cos.accelerate.myqcloud.com");
        boolean isAccHost = host.endsWith("cos.accelerate.myqcloud.com");
        return matcherEndpoint.matches() && matcherHost.matches() && !isAccEndpoint && !isAccHost;
    }

    private <Y extends CosServiceRequest> void changeRequestHost(CosHttpRequest<Y> request) {
        String retryEndpoint = String.format("%s.%s.tencentcos.cn", request.getBucketName(), Region.formatRegion(this.clientConfig.getRegion()));
        request.addHeader("Host", retryEndpoint);
        COSSigner cosSigner = this.clientConfig.getCosSigner();
        COSCredentials cosCredentials = request.getCosCredentials();
        Y cosServiceRequest = request.getOriginalRequest();
        Date expiredTime = new Date(System.currentTimeMillis() + this.clientConfig.getSignExpired() * 1000L);
        boolean isCIWorkflowRequest = cosServiceRequest instanceof CIWorkflowServiceRequest;
        cosSigner.setCIWorkflowRequest(isCIWorkflowRequest);
        cosSigner.sign(request, cosCredentials, expiredTime);
        String endpointAddr = this.clientConfig.getEndpointResolver().resolveGeneralApiEndpoint(retryEndpoint);
        String fixedEndpointAddr = ((CosServiceRequest)request.getOriginalRequest()).getFixedEndpointAddr();
        if (fixedEndpointAddr != null) {
            request.setEndpoint(fixedEndpointAddr);
        } else {
            request.setEndpoint(endpointAddr);
        }
    }
}

